/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.launch.processes;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.hyades.execution.core.ExecutionComponentStateChangeEvent;
import org.eclipse.hyades.execution.core.IDataProcessor;
import org.eclipse.hyades.execution.core.IExecutionComponentStateChangeListener;
import org.eclipse.hyades.execution.core.IExecutor;
import org.eclipse.hyades.execution.harness.IExecutionHarnessDataProcessor;
import org.eclipse.hyades.execution.local.ExecutorStub;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.launch.extensions.LaunchConfigurationExtensionsManager;
import org.eclipse.hyades.test.ui.internal.launch.processes.TestExecutionProcess;
import org.eclipse.hyades.test.ui.launch.configurations.TestLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.extensions.IRunHandler;

public class TestExecutionProcess
implements IProcess {
    private IExecutor executor;
    private ILaunch launch;
    private boolean terminated = false;
    private TPFTest test;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestExecutionProcess(IExecutor iExecutor, ILaunch iLaunch) throws CoreException {
        this.executor = iExecutor;
        this.launch = iLaunch;
        this.test = TestLaunchConfigurationFacade.getTest(iLaunch.getLaunchConfiguration());
        IExecutor iExecutor2 = iExecutor;
        synchronized (iExecutor2) {
            if (iExecutor.getState() == 4) {
                this.onTerminate();
            } else {
                this.executor.addExecutionComponentStateChangeListener(new IExecutionComponentStateChangeListener(){

                    public void stateChanged(ExecutionComponentStateChangeEvent executionComponentStateChangeEvent) {
                        TestExecutionProcess.this.onTerminate();
                    }
                });
            }
            this.setupExecutorStateMonitoring(iExecutor);
        }
    }

    private void setupExecutorStateMonitoring(IExecutor iExecutor) {
        IExecutionHarnessDataProcessor iExecutionHarnessDataProcessor;
        Agent agent;
        ExecutorStub executorStub;
        IDataProcessor[] iDataProcessorArray;
        if (iExecutor != null && iExecutor instanceof ExecutorStub && (iDataProcessorArray = (executorStub = (ExecutorStub)iExecutor).getDataProcessors()).length > 0 && iDataProcessorArray[0] instanceof IExecutionHarnessDataProcessor && (agent = (iExecutionHarnessDataProcessor = (IExecutionHarnessDataProcessor)iDataProcessorArray[0]).getControlAgent()) != null) {
            class ControlAgentListener
            implements AgentListener {
                private final /* synthetic */ TestExecutionProcess this$0;

                ControlAgentListener(TestExecutionProcess testExecutionProcess) {
                    this.this$0 = testExecutionProcess;
                }

                public void agentActive(Agent agent) {
                }

                public void agentInactive(Agent agent) {
                    this.this$0.onTerminate();
                }

                public void error(Agent agent, String string, String string2) {
                    System.out.println("Error from tester agent: id=" + string + ", " + string2);
                }

                public void handleCommand(Agent agent, CommandElement commandElement) {
                }
            }
            agent.addAgentListener((AgentListener)new ControlAgentListener(this));
        }
    }

    public String getLabel() {
        return TestUIPlugin.getString("TestExecutionProcess.testProcess") + " [" + this.test.getName() + "]";
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public IStreamsProxy getStreamsProxy() {
        return null;
    }

    public void setAttribute(String string, String string2) {
    }

    public String getAttribute(String string) {
        return null;
    }

    public int getExitValue() {
        return 0;
    }

    public Object getAdapter(Class clazz) {
        return null;
    }

    public boolean canTerminate() {
        return true;
    }

    public synchronized boolean isTerminated() {
        return this.terminated || this.executor.getState() == 4;
    }

    public void terminate() throws DebugException {
        throw new DebugException((IStatus)new Status(4, TestUIPlugin.getID(), 5011, "Operation not supported", null));
    }

    protected synchronized void onTerminate() {
        if (!this.terminated) {
            IRunHandler iRunHandler = LaunchConfigurationExtensionsManager.getInstance().getRunHandler(this.test);
            if (iRunHandler != null) {
                iRunHandler.postRun(this.launch);
            }
            this.terminated = true;
            DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this, 8)});
        }
    }
}

