/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.launch.providers;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.IHyadesTestNavigatorConverter;
import org.eclipse.hyades.test.ui.IHyadesTestNavigatorProvider;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.launch.extensions.LaunchConfigurationExtensionsManager;
import org.eclipse.hyades.test.ui.internal.model.ui.ITypeProviderFactory;
import org.eclipse.hyades.test.ui.internal.navigator.TestCaseHTNProvider;
import org.eclipse.hyades.test.ui.internal.navigator.TestSuiteHTNConverter;
import org.eclipse.hyades.test.ui.internal.navigator.TestSuiteHTNProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class TestProvider
extends LabelProvider
implements ITreeContentProvider {
    private IHyadesTestNavigatorConverter testSuiteConverter = new TestSuiteHTNConverter();
    private IHyadesTestNavigatorProvider testSuiteProvider = new TestSuiteHTNProvider(emptyTypeProviderFactory);
    private IHyadesTestNavigatorProvider testCaseProvider = new TestCaseHTNProvider(emptyTypeProviderFactory);
    private String mode;
    private String launchConfigurationType;
    private static ITypeProviderFactory emptyTypeProviderFactory = new ITypeProviderFactory(){

        public IHyadesTestNavigatorProvider getProvider(String string) {
            return null;
        }
    };
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;

    public TestProvider(String string, String string2) {
        this.mode = string;
        this.launchConfigurationType = string2;
    }

    public Object[] getChildren(Object object) {
        if (object instanceof IContainer) {
            try {
                IContainer iContainer = (IContainer)object;
                IResource[] iResourceArray = iContainer.members();
                ArrayList<Object> arrayList = new ArrayList<Object>(iResourceArray.length);
                int n = 0;
                while (n < iResourceArray.length) {
                    Object object2;
                    if (iResourceArray[n] instanceof IContainer) {
                        arrayList.add(iResourceArray[n]);
                    } else if (iResourceArray[n] instanceof IFile && (object2 = this.testSuiteConverter.getObjectFromResource(iResourceArray[n])) != null && object2 instanceof TPFTestSuite && this.isLaunchable((TPFTest)((TPFTestSuite)object2))) {
                        arrayList.add(object2);
                    }
                    ++n;
                }
                return arrayList.toArray();
            }
            catch (CoreException coreException) {
                TestUIPlugin.logError(coreException);
                return new Object[0];
            }
        }
        if (object instanceof TPFTestSuite) {
            Object[] objectArray = this.testSuiteProvider.getChildren(object);
            ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] instanceof TPFTestCase && this.isLaunchable((TPFTest)((TPFTestCase)objectArray[n]))) {
                    arrayList.add(objectArray[n]);
                }
                ++n;
            }
            return arrayList.toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object object) {
        if (object instanceof IResource) {
            return ((IResource)object).getParent();
        }
        if (object instanceof TPFTestSuite) {
            return this.testSuiteProvider.getParent(object);
        }
        if (object instanceof TPFTestCase) {
            return this.testCaseProvider.getParent(object);
        }
        return null;
    }

    public boolean hasChildren(Object object) {
        return this.getChildren(object).length > 0;
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
    }

    public Image getImage(Object object) {
        if (object instanceof IContainer) {
            ImageDescriptor imageDescriptor;
            IWorkbenchAdapter iWorkbenchAdapter = this.getWorkbenchAdapter(object);
            if (iWorkbenchAdapter != null && (imageDescriptor = iWorkbenchAdapter.getImageDescriptor(object)) != null) {
                return imageDescriptor.createImage();
            }
        } else {
            if (object instanceof TPFTestSuite) {
                return this.testSuiteProvider.getImage(object);
            }
            if (object instanceof TPFTestCase) {
                return this.testCaseProvider.getImage(object);
            }
        }
        return null;
    }

    public String getText(Object object) {
        if (object instanceof IContainer) {
            IWorkbenchAdapter iWorkbenchAdapter = this.getWorkbenchAdapter(object);
            if (iWorkbenchAdapter != null) {
                return iWorkbenchAdapter.getLabel(object);
            }
        } else {
            if (object instanceof TPFTestSuite) {
                return this.testSuiteProvider.getText(object);
            }
            if (object instanceof TPFTestCase) {
                return this.testCaseProvider.getText(object);
            }
        }
        return null;
    }

    private boolean isLaunchable(TPFTest tPFTest) {
        return LaunchConfigurationExtensionsManager.getInstance().isLaunchableElement(tPFTest, this.mode, this.launchConfigurationType);
    }

    private IWorkbenchAdapter getWorkbenchAdapter(Object object) {
        IWorkbenchAdapter iWorkbenchAdapter = (IWorkbenchAdapter)Platform.getAdapterManager().getAdapter(object, class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = TestProvider.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter);
        if (iWorkbenchAdapter == this) {
            return null;
        }
        return iWorkbenchAdapter;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

