/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.launch.tabs;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.launch.extensions.LaunchConfigurationExtensionsManager;
import org.eclipse.hyades.test.ui.internal.launch.providers.DeploymentProvider;
import org.eclipse.hyades.test.ui.internal.launch.providers.TestProvider;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.launch.configurations.DeploymentLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.configurations.TestLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.extensions.IDeploymentsProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.IWorkbenchPage;

public class TestAndDeploymentTab
extends AbstractLaunchConfigurationTab {
    protected TreeViewer testTreeViewer;
    protected ListViewer deploymentListViewer;
    private String mode;
    private String launchConfigurationType;

    public TestAndDeploymentTab(String string, String string2) {
        this.mode = string;
        this.launchConfigurationType = string2;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 25;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.setFont(composite.getFont());
        Label label = new Label(composite2, 0);
        GridData gridData = new GridData(32);
        label.setLayoutData((Object)gridData);
        label.setText(TestUIPlugin.getString("TestAndDeploymentTab.selectTestPrompt"));
        Label label2 = new Label(composite2, 0);
        GridData gridData2 = new GridData(32);
        label2.setLayoutData((Object)gridData2);
        label2.setText(TestUIPlugin.getString("TestAndDeploymentTab.selectDeploymentPrompt"));
        this.createTestSelector(composite2);
        this.createDeploymentSelector(composite2);
        this.setControl((Control)composite2);
    }

    private void createTestSelector(Composite composite) {
        GridData gridData = new GridData(1808);
        gridData.widthHint = 250;
        gridData.heightHint = 150;
        this.testTreeViewer = new TreeViewer(composite);
        this.testTreeViewer.getControl().setLayoutData((Object)gridData);
        TestProvider testProvider = new TestProvider(this.mode, this.launchConfigurationType);
        this.testTreeViewer.setContentProvider((IContentProvider)testProvider);
        this.testTreeViewer.setLabelProvider((IBaseLabelProvider)testProvider);
        this.testTreeViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.testTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                TPFTestSuite tPFTestSuite = TestAndDeploymentTab.this.fillDeploymentsList(TestAndDeploymentTab.this.getSelectedTest());
                IDeploymentsProvider iDeploymentsProvider = LaunchConfigurationExtensionsManager.getInstance().getDeploymentsProvider(tPFTestSuite);
                TPFDeployment tPFDeployment = iDeploymentsProvider.getDefaultDeployment(tPFTestSuite);
                StructuredSelection structuredSelection = tPFDeployment != null ? new StructuredSelection((Object)tPFDeployment) : new StructuredSelection();
                TestAndDeploymentTab.this.deploymentListViewer.setSelection((ISelection)structuredSelection);
                TestAndDeploymentTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createDeploymentSelector(Composite composite) {
        GridData gridData = new GridData(1808);
        gridData.widthHint = 250;
        gridData.heightHint = 150;
        this.deploymentListViewer = new ListViewer(composite);
        this.deploymentListViewer.getControl().setLayoutData((Object)gridData);
        DeploymentProvider deploymentProvider = new DeploymentProvider();
        this.deploymentListViewer.setContentProvider((IContentProvider)deploymentProvider);
        this.deploymentListViewer.setLabelProvider((IBaseLabelProvider)deploymentProvider);
        this.deploymentListViewer.setComparer((IElementComparer)deploymentProvider);
        this.deploymentListViewer.setInput(null);
        this.deploymentListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                TestAndDeploymentTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected TPFTestSuite fillDeploymentsList(TPFTest tPFTest) {
        TPFTestSuite tPFTestSuite = null;
        if (tPFTest != null) {
            if (tPFTest instanceof TPFTestSuite) {
                tPFTestSuite = (TPFTestSuite)tPFTest;
            } else if (tPFTest instanceof TPFTestCase) {
                tPFTestSuite = ((TPFTestCase)tPFTest).getTestSuite();
            }
        }
        this.deploymentListViewer.setInput(tPFTestSuite);
        return tPFTestSuite;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        TestLaunchConfigurationFacade.setTest(iLaunchConfigurationWorkingCopy, TestAndDeploymentTab.getContext());
    }

    protected TPFTest getSelectedTest() {
        Object object;
        ISelection iSelection = this.testTreeViewer.getSelection();
        if (!iSelection.isEmpty() && iSelection instanceof IStructuredSelection && (object = ((IStructuredSelection)iSelection).getFirstElement()) instanceof TPFTest) {
            return (TPFTest)object;
        }
        return null;
    }

    protected TPFDeployment getSelectedDeployment() {
        Object object;
        ISelection iSelection = this.deploymentListViewer.getSelection();
        if (!iSelection.isEmpty() && iSelection instanceof IStructuredSelection && (object = ((IStructuredSelection)iSelection).getFirstElement()) instanceof TPFDeployment) {
            return (TPFDeployment)object;
        }
        return null;
    }

    private void setDeploymentSelection(TPFDeployment tPFDeployment) {
        List list = this.deploymentListViewer.getList();
        list.deselectAll();
        if (tPFDeployment == null) {
            return;
        }
        int n = list.getItemCount();
        IElementComparer iElementComparer = this.deploymentListViewer.getComparer();
        int n2 = 0;
        while (n2 < n) {
            if (iElementComparer.equals((Object)tPFDeployment, this.deploymentListViewer.getElementAt(n2))) {
                list.select(n2);
                return;
            }
            ++n2;
        }
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        block3: {
            try {
                TPFTest tPFTest = TestLaunchConfigurationFacade.getTest(iLaunchConfiguration);
                if (tPFTest != null) {
                    this.testTreeViewer.setSelection((ISelection)new StructuredSelection((Object)tPFTest), true);
                    this.fillDeploymentsList(tPFTest);
                    TPFDeployment tPFDeployment = DeploymentLaunchConfigurationFacade.getDeployment(iLaunchConfiguration);
                    this.setDeploymentSelection(tPFDeployment);
                    break block3;
                }
                this.testTreeViewer.setSelection((ISelection)new StructuredSelection());
                this.deploymentListViewer.setSelection((ISelection)new StructuredSelection());
            }
            catch (CoreException coreException) {
                TestUIPlugin.logError(coreException);
            }
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        TPFTest tPFTest = this.getSelectedTest();
        TestLaunchConfigurationFacade.setTest(iLaunchConfigurationWorkingCopy, tPFTest);
        TPFDeployment tPFDeployment = this.getSelectedDeployment();
        DeploymentLaunchConfigurationFacade.setDeployment(iLaunchConfigurationWorkingCopy, tPFDeployment);
    }

    public String getName() {
        return TestUIPlugin.getString("TestAndDeploymentTab.testTabName");
    }

    public Image getImage() {
        return TestUIImages.INSTANCE.getImage("launch_testtab.gif");
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        TPFDeployment tPFDeployment;
        TPFTest tPFTest;
        this.setErrorMessage(null);
        try {
            tPFTest = TestLaunchConfigurationFacade.getTest(iLaunchConfiguration);
        }
        catch (CoreException coreException) {
            tPFTest = null;
        }
        if (tPFTest == null) {
            this.setErrorMessage(TestUIPlugin.getString("TestAndDeploymentTab.noTestError"));
            return false;
        }
        if (this.deploymentListViewer.getList().getItemCount() == 0) {
            this.setErrorMessage("There are no Deployments available for the selected Test.");
            return false;
        }
        try {
            tPFDeployment = DeploymentLaunchConfigurationFacade.getDeployment(iLaunchConfiguration);
        }
        catch (CoreException coreException) {
            tPFDeployment = null;
        }
        if (tPFDeployment == null) {
            this.setErrorMessage(TestUIPlugin.getString("TestAndDeploymentTab.noDeploymentError"));
            return false;
        }
        return true;
    }

    public static TPFTest getContext() {
        block4: {
            try {
                IFile iFile;
                IStructuredSelection iStructuredSelection;
                Object object;
                ISelection iSelection;
                IWorkbenchPage iWorkbenchPage = TestUIPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (iWorkbenchPage == null || !((iSelection = iWorkbenchPage.getSelection()) instanceof IStructuredSelection) || (object = (iStructuredSelection = (IStructuredSelection)iSelection).getFirstElement()) == null) break block4;
                if (object instanceof TPFTest) {
                    return (TPFTest)object;
                }
                if (object instanceof IFile && "testsuite".equals((iFile = (IFile)object).getFileExtension())) {
                    return TestAndDeploymentTab.loadTestSuite(iFile);
                }
            }
            catch (Throwable throwable) {
                TestUIPlugin.logError(throwable);
            }
        }
        return null;
    }

    private static TPFTestSuite loadTestSuite(IFile iFile) {
        EObject[] eObjectArray = EMFUtil.load(null, iFile);
        int n = 0;
        while (n < eObjectArray.length) {
            if (eObjectArray[n] instanceof TPFTestSuite) {
                return (TPFTestSuite)eObjectArray[n];
            }
            ++n;
        }
        return null;
    }

    public void activated(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
    }
}

