/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.launch.tabs;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.launch.extensions.LaunchConfigurationExtensionsManager;
import org.eclipse.hyades.test.ui.internal.launch.providers.DeploymentProvider;
import org.eclipse.hyades.test.ui.internal.launch.providers.TestComponentProvider;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.launch.configurations.DeploymentLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.configurations.TestComponentLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.extensions.IDeploymentsProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.IWorkbenchPage;

public class TestComponentAndDeploymentTab
extends AbstractLaunchConfigurationTab {
    protected TreeViewer componentTreeViewer;
    protected ListViewer deploymentListViewer;
    private String mode;
    private String launchConfigurationType;

    public TestComponentAndDeploymentTab(String string, String string2) {
        this.mode = string;
        this.launchConfigurationType = string2;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 25;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.setFont(composite.getFont());
        Label label = new Label(composite2, 0);
        GridData gridData = new GridData(32);
        label.setLayoutData((Object)gridData);
        label.setText(TestUIPlugin.getString("TestComponentTab.selectTestComponentPrompt"));
        Label label2 = new Label(composite2, 0);
        GridData gridData2 = new GridData(32);
        label2.setLayoutData((Object)gridData2);
        label2.setText(TestUIPlugin.getString("TestComponentTab.selectDeploymentPrompt"));
        this.createTestComponentSelector(composite2);
        this.createDeploymentSelector(composite2);
        this.setControl((Control)composite2);
    }

    private void createTestComponentSelector(Composite composite) {
        GridData gridData = new GridData(1808);
        gridData.widthHint = 250;
        gridData.heightHint = 150;
        this.componentTreeViewer = new TreeViewer(composite);
        this.componentTreeViewer.getControl().setLayoutData((Object)gridData);
        TestComponentProvider testComponentProvider = new TestComponentProvider(this.mode, this.launchConfigurationType);
        this.componentTreeViewer.setContentProvider((IContentProvider)testComponentProvider);
        this.componentTreeViewer.setLabelProvider((IBaseLabelProvider)testComponentProvider);
        this.componentTreeViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.componentTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                TPFTestComponent tPFTestComponent = TestComponentAndDeploymentTab.this.fillDeploymentList(TestComponentAndDeploymentTab.this.getSelectedTestComponent());
                IDeploymentsProvider iDeploymentsProvider = LaunchConfigurationExtensionsManager.getInstance().getDeploymentsProvider(tPFTestComponent);
                TPFDeployment tPFDeployment = iDeploymentsProvider.getDefaultDeployment(tPFTestComponent);
                StructuredSelection structuredSelection = tPFDeployment != null ? new StructuredSelection((Object)tPFDeployment) : new StructuredSelection();
                TestComponentAndDeploymentTab.this.deploymentListViewer.setSelection((ISelection)structuredSelection);
                TestComponentAndDeploymentTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createDeploymentSelector(Composite composite) {
        GridData gridData = new GridData(1808);
        gridData.widthHint = 250;
        gridData.heightHint = 150;
        this.deploymentListViewer = new ListViewer(composite);
        this.deploymentListViewer.getControl().setLayoutData((Object)gridData);
        DeploymentProvider deploymentProvider = new DeploymentProvider();
        this.deploymentListViewer.setContentProvider((IContentProvider)deploymentProvider);
        this.deploymentListViewer.setLabelProvider((IBaseLabelProvider)deploymentProvider);
        this.deploymentListViewer.setComparer((IElementComparer)deploymentProvider);
        this.deploymentListViewer.setInput(null);
        this.deploymentListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                TestComponentAndDeploymentTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected TPFTestComponent fillDeploymentList(TPFTestComponent tPFTestComponent) {
        this.deploymentListViewer.setInput((Object)tPFTestComponent);
        return tPFTestComponent;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        TestComponentLaunchConfigurationFacade.setTestComponent(iLaunchConfigurationWorkingCopy, TestComponentAndDeploymentTab.getContext());
    }

    protected TPFTestComponent getSelectedTestComponent() {
        Object object;
        ISelection iSelection = this.componentTreeViewer.getSelection();
        if (!iSelection.isEmpty() && iSelection instanceof IStructuredSelection && (object = ((IStructuredSelection)iSelection).getFirstElement()) instanceof TPFTestComponent) {
            return (TPFTestComponent)object;
        }
        return null;
    }

    protected TPFDeployment getSelectedDeployment() {
        Object object;
        ISelection iSelection = this.deploymentListViewer.getSelection();
        if (!iSelection.isEmpty() && iSelection instanceof IStructuredSelection && (object = ((IStructuredSelection)iSelection).getFirstElement()) instanceof TPFDeployment) {
            return (TPFDeployment)object;
        }
        return null;
    }

    private void setDeploymentSelection(TPFDeployment tPFDeployment) {
        List list = this.deploymentListViewer.getList();
        list.deselectAll();
        if (tPFDeployment == null) {
            return;
        }
        int n = list.getItemCount();
        IElementComparer iElementComparer = this.deploymentListViewer.getComparer();
        int n2 = 0;
        while (n2 < n) {
            if (iElementComparer.equals((Object)tPFDeployment, this.deploymentListViewer.getElementAt(n2))) {
                list.select(n2);
                return;
            }
            ++n2;
        }
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        block3: {
            try {
                TPFTestComponent tPFTestComponent = TestComponentLaunchConfigurationFacade.getTestComponent(iLaunchConfiguration);
                if (tPFTestComponent != null) {
                    this.componentTreeViewer.setSelection((ISelection)new StructuredSelection((Object)tPFTestComponent), true);
                    this.fillDeploymentList(tPFTestComponent);
                    TPFDeployment tPFDeployment = DeploymentLaunchConfigurationFacade.getDeployment(iLaunchConfiguration);
                    this.setDeploymentSelection(tPFDeployment);
                    break block3;
                }
                this.componentTreeViewer.setSelection((ISelection)new StructuredSelection());
                this.deploymentListViewer.setSelection((ISelection)new StructuredSelection());
            }
            catch (CoreException coreException) {
                TestUIPlugin.logError(coreException);
            }
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        System.out.println("Tab.performApply called");
        TPFTestComponent tPFTestComponent = this.getSelectedTestComponent();
        TestComponentLaunchConfigurationFacade.setTestComponent(iLaunchConfigurationWorkingCopy, tPFTestComponent);
        TPFDeployment tPFDeployment = this.getSelectedDeployment();
        DeploymentLaunchConfigurationFacade.setDeployment(iLaunchConfigurationWorkingCopy, tPFDeployment);
    }

    public String getName() {
        return TestUIPlugin.getString("TestComponentTab.tabName");
    }

    public Image getImage() {
        return TestUIImages.INSTANCE.getImage("launch_tcomponenttab.gif");
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        TPFDeployment tPFDeployment;
        TPFTestComponent tPFTestComponent;
        this.setErrorMessage(null);
        try {
            tPFTestComponent = TestComponentLaunchConfigurationFacade.getTestComponent(iLaunchConfiguration);
        }
        catch (CoreException coreException) {
            tPFTestComponent = null;
        }
        if (tPFTestComponent == null) {
            this.setErrorMessage(TestUIPlugin.getString("TestComponentTab.noComponentError"));
            return false;
        }
        try {
            tPFDeployment = DeploymentLaunchConfigurationFacade.getDeployment(iLaunchConfiguration);
        }
        catch (CoreException coreException) {
            tPFDeployment = null;
        }
        if (tPFDeployment == null) {
            this.setErrorMessage(TestUIPlugin.getString("TestComponentTab.noDeploymentError"));
            return false;
        }
        return true;
    }

    public static TPFTestComponent getContext() {
        block4: {
            try {
                IFile iFile;
                IStructuredSelection iStructuredSelection;
                Object object;
                ISelection iSelection;
                IWorkbenchPage iWorkbenchPage = TestUIPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (iWorkbenchPage == null || !((iSelection = iWorkbenchPage.getSelection()) instanceof IStructuredSelection) || (object = (iStructuredSelection = (IStructuredSelection)iSelection).getFirstElement()) == null) break block4;
                if (object instanceof TPFTestComponent) {
                    return (TPFTestComponent)object;
                }
                if (object instanceof IFile && "testcomponent".equals((iFile = (IFile)object).getFileExtension())) {
                    return TestComponentAndDeploymentTab.loadTestComponent(iFile);
                }
            }
            catch (Throwable throwable) {
                TestUIPlugin.logError(throwable);
            }
        }
        return null;
    }

    private static TPFTestComponent loadTestComponent(IFile iFile) {
        EObject[] eObjectArray = EMFUtil.load(null, iFile);
        int n = 0;
        while (n < eObjectArray.length) {
            if (eObjectArray[n] instanceof TPFTestComponent) {
                return (TPFTestComponent)eObjectArray[n];
            }
            ++n;
        }
        return null;
    }

    public void activated(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
    }
}

