/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.ui.internal.provider.IResourceChangeUpdater;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;

public class TestResourceChangeUpdater
implements IResourceChangeUpdater {
    private TestNavigator testNavigator;
    private List addedObjects;
    private List removedObjects;
    private List changedObjects;
    private List resourcesToSave;
    private Object[] expandedElements;
    private Object[] selectedElements;
    private boolean active;

    public TestResourceChangeUpdater(TestNavigator testNavigator) {
        this.testNavigator = testNavigator;
        this.active = true;
    }

    public void dispose() {
        this.testNavigator = null;
    }

    public void started() {
        this.addedObjects = new UniqueEList();
        this.removedObjects = new UniqueEList();
        this.changedObjects = new UniqueEList();
        this.resourcesToSave = new UniqueEList();
    }

    public void ended() {
        Iterator iterator;
        if (!this.addedObjects.isEmpty()) {
            iterator = this.addedObjects.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                Object object = ((ITreeContentProvider)this.testNavigator.getViewer().getContentProvider()).getParent(e);
                if (object == null) {
                    this.testNavigator.getTreeViewer().refresh(true);
                    return;
                }
                this.testNavigator.getTreeViewer().add(object, e);
            }
        }
        if (!this.removedObjects.isEmpty()) {
            this.testNavigator.getTreeViewer().remove(this.removedObjects.toArray());
        }
        if (!this.changedObjects.isEmpty()) {
            iterator = this.changedObjects.iterator();
            while (iterator.hasNext()) {
                this.testNavigator.getTreeViewer().refresh(iterator.next(), true);
            }
        }
        if (!this.resourcesToSave.isEmpty()) {
            iterator = this.resourcesToSave.iterator();
            while (iterator.hasNext()) {
                try {
                    EMFUtil.save((Resource)iterator.next());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.addedObjects.clear();
        this.addedObjects = null;
        this.removedObjects.clear();
        this.removedObjects = null;
        this.changedObjects.clear();
        this.changedObjects = null;
        this.resourcesToSave.clear();
        this.resourcesToSave = null;
        if (this.expandedElements != null) {
            this.convertURIToEObject(this.expandedElements);
            this.testNavigator.getTreeViewer().setExpandedElements(this.expandedElements);
            this.convertURIToEObject(this.selectedElements);
            this.testNavigator.getTreeViewer().setSelection((ISelection)new StructuredSelection(this.selectedElements), true);
            this.expandedElements = null;
            this.selectedElements = null;
        }
    }

    public boolean add(IResource iResource, IResource[] iResourceArray) {
        int n = 0;
        int n2 = iResourceArray.length;
        while (n < n2) {
            if (iResourceArray[n].getType() != 1) {
                if (this.testNavigator.isVisibleResource(iResourceArray[n])) {
                    this.addedObjects.add(iResourceArray[n]);
                }
            } else {
                Object object = this.testNavigator.getConvertedObjectFromFile(iResourceArray[n]);
                if (object == null) {
                    if (this.testNavigator.isVisibleResource(iResourceArray[n])) {
                        this.addedObjects.add(iResourceArray[n]);
                    }
                } else {
                    this.addedObjects.add(object);
                }
            }
            ++n;
        }
        return false;
    }

    public boolean remove(IResource iResource, IResource[] iResourceArray) {
        int n = 0;
        int n2 = iResourceArray.length;
        while (n < n2) {
            if (iResourceArray[n].getType() != 1) {
                this.removedObjects.add(iResourceArray[n]);
            } else {
                Object object = this.testNavigator.getCorrespondingObjectFromFile(iResourceArray[n]);
                if (object == null) {
                    this.removedObjects.add(iResourceArray[n]);
                } else {
                    this.removedObjects.add(object);
                    this.testNavigator.cleanConvertedObjectEntryFor(iResourceArray[n]);
                    if (object instanceof EObject) {
                        Resource resource = EMFUtil.getResource(null, (IFile)iResourceArray[n]);
                        EMFUtil.remove(resource);
                    }
                }
            }
            ++n;
        }
        return false;
    }

    public boolean replaced(IResource iResource) {
        return false;
    }

    public boolean updateProperties(IResource iResource) {
        if (iResource.getType() == 1) {
            Object[] objectArray = EMFUtil.getEObjects(null, (IFile)iResource);
            if (objectArray.length > 0) {
                this.testNavigator.getTreeViewer().update(objectArray, null);
            }
        } else {
            this.testNavigator.getTreeViewer().update((Object)iResource, null);
        }
        return false;
    }

    public boolean updateChildrenType(IResource iResource) {
        return false;
    }

    public boolean updateContent(IResource iResource, IResource iResource2) {
        URI uRI = this.getFileURI(iResource2);
        if (uRI != null) {
            EMFUtil.unloadIfNeeded(uRI);
            Object object = this.testNavigator.getCorrespondingObjectFromFile(iResource2);
            if (object != null) {
                this.removedObjects.add(object);
                this.testNavigator.cleanConvertedObjectEntryFor(iResource2);
                object = this.testNavigator.getConvertedObjectFromFile(iResource2);
                this.addedObjects.add(object);
            } else {
                this.changedObjects.add(iResource2);
            }
            if (this.expandedElements == null) {
                this.expandedElements = this.testNavigator.getTreeViewer().getExpandedElements();
                this.convertEObjectToURI(this.expandedElements);
                this.selectedElements = ((IStructuredSelection)this.testNavigator.getTreeViewer().getSelection()).toArray();
                this.convertEObjectToURI(this.selectedElements);
            }
        }
        return false;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public boolean isActive() {
        return this.active;
    }

    protected URI getFileURI(IResource iResource) {
        if (iResource.getType() == 1) {
            String string = iResource.getFileExtension();
            String[] stringArray = this.testNavigator.getVisibleFiles();
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals(string)) {
                    return URI.createPlatformResourceURI((String)iResource.getFullPath().toString());
                }
                ++n;
            }
        }
        return null;
    }

    protected boolean isValid(EObject eObject) {
        return eObject instanceof CMNNamedElement;
    }

    private void convertEObjectToURI(Object[] objectArray) {
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            if (objectArray[n] instanceof EObject) {
                objectArray[n] = EcoreUtil.getURI((EObject)((EObject)objectArray[n]));
            }
            ++n;
        }
    }

    private void convertURIToEObject(Object[] objectArray) {
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            if (objectArray[n] instanceof URI) {
                objectArray[n] = EMFUtil.getResourceSet().getEObject((URI)objectArray[n], false);
            }
            ++n;
        }
    }
}

