/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.IHyadesTestNavigatorProvider;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.model.ui.ITypeProviderFactory;
import org.eclipse.hyades.test.ui.internal.model.ui.VisibleTypes;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class TestSuiteHTNProvider
implements IHyadesTestNavigatorProvider {
    private ITypeProviderFactory typeProvidersFactory;

    public TestSuiteHTNProvider() {
        this.typeProvidersFactory = VisibleTypes.getInstance();
    }

    public TestSuiteHTNProvider(ITypeProviderFactory iTypeProviderFactory) {
        this.typeProvidersFactory = iTypeProviderFactory;
    }

    public void dispose() {
    }

    public Object[] getChildren(Object object) {
        if (object instanceof TPFTestSuite) {
            TPFTestSuite tPFTestSuite = (TPFTestSuite)object;
            IHyadesTestNavigatorProvider iHyadesTestNavigatorProvider = this.typeProvidersFactory.getProvider(tPFTestSuite.getType());
            if (iHyadesTestNavigatorProvider != null) {
                return iHyadesTestNavigatorProvider.getChildren(tPFTestSuite);
            }
            EList eList = tPFTestSuite.getTestCases();
            Object[] objectArray = new Object[eList.size()];
            int n = 0;
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                objectArray[n] = (TPFTestCase)iterator.next();
                ++n;
            }
            return objectArray;
        }
        return new Object[0];
    }

    public Object[] getElements(Object object) {
        TPFTestSuite tPFTestSuite;
        IHyadesTestNavigatorProvider iHyadesTestNavigatorProvider;
        if (object instanceof TPFTestSuite && (iHyadesTestNavigatorProvider = this.typeProvidersFactory.getProvider((tPFTestSuite = (TPFTestSuite)object).getType())) != null) {
            return iHyadesTestNavigatorProvider.getElements(tPFTestSuite);
        }
        return this.getChildren(object);
    }

    public Image getImage(Object object) {
        if (object instanceof TPFTestSuite) {
            TPFTestSuite tPFTestSuite = (TPFTestSuite)object;
            IHyadesTestNavigatorProvider iHyadesTestNavigatorProvider = this.typeProvidersFactory.getProvider(tPFTestSuite.getType());
            if (iHyadesTestNavigatorProvider != null) {
                return iHyadesTestNavigatorProvider.getImage(tPFTestSuite);
            }
            return TestUIImages.INSTANCE.getImage("testsuite_obj.gif");
        }
        return null;
    }

    public Object getParent(Object object) {
        if (object instanceof TPFTestSuite) {
            TPFTestSuite tPFTestSuite = (TPFTestSuite)object;
            IHyadesTestNavigatorProvider iHyadesTestNavigatorProvider = this.typeProvidersFactory.getProvider(tPFTestSuite.getType());
            if (iHyadesTestNavigatorProvider != null) {
                return iHyadesTestNavigatorProvider.getParent(tPFTestSuite);
            }
            EObject eObject = tPFTestSuite.eContainer();
            if (eObject == null || eObject instanceof Resource) {
                Resource resource = tPFTestSuite.eResource();
                IFile iFile = EMFUtil.getWorkspaceFile(resource);
                if (iFile != null) {
                    return iFile.getParent();
                }
            } else {
                return eObject;
            }
        }
        return null;
    }

    public String getText(Object object) {
        if (object instanceof TPFTestSuite) {
            TPFTestSuite tPFTestSuite = (TPFTestSuite)object;
            IHyadesTestNavigatorProvider iHyadesTestNavigatorProvider = this.typeProvidersFactory.getProvider(tPFTestSuite.getType());
            if (iHyadesTestNavigatorProvider != null) {
                return iHyadesTestNavigatorProvider.getText(tPFTestSuite);
            }
            return tPFTestSuite.getName();
        }
        return "";
    }

    public boolean hasChildren(Object object) {
        if (object instanceof TPFTestSuite) {
            TPFTestSuite tPFTestSuite = (TPFTestSuite)object;
            IHyadesTestNavigatorProvider iHyadesTestNavigatorProvider = this.typeProvidersFactory.getProvider(tPFTestSuite.getType());
            if (iHyadesTestNavigatorProvider != null) {
                return iHyadesTestNavigatorProvider.hasChildren(tPFTestSuite);
            }
            return tPFTestSuite.getTestCases().size() > 0;
        }
        return false;
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
    }

    public boolean isLabelProperty(Object object, String string) {
        TPFTestSuite tPFTestSuite;
        IHyadesTestNavigatorProvider iHyadesTestNavigatorProvider;
        if (object instanceof TPFTestSuite && (iHyadesTestNavigatorProvider = this.typeProvidersFactory.getProvider((tPFTestSuite = (TPFTestSuite)object).getType())) != null) {
            return iHyadesTestNavigatorProvider.isLabelProperty(tPFTestSuite, string);
        }
        return false;
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
    }

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) throws CoreException {
    }

    public int getVerdict(Object object) {
        TPFTestSuite tPFTestSuite;
        IHyadesTestNavigatorProvider iHyadesTestNavigatorProvider;
        if (object instanceof TPFTestSuite && (iHyadesTestNavigatorProvider = this.typeProvidersFactory.getProvider((tPFTestSuite = (TPFTestSuite)object).getType())) != null) {
            return iHyadesTestNavigatorProvider.getVerdict(tPFTestSuite);
        }
        return 0;
    }
}

