/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGArtifactLocationPair;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class DeploymentMapPage
extends WizardPage
implements SelectionListener,
ISelectionChangedListener {
    TPFDeployment deployment = null;
    StructuredViewer artifactViewer = null;
    StructuredViewer locationViewer = null;
    StructuredViewer pairViewer = null;
    CFGArtifact selectedArtifact = null;
    CFGLocation selectedLocation = null;
    CFGArtifactLocationPair selectedPair = null;
    Button createPairButton = null;
    Button removeButton = null;
    Button upButton = null;
    Button downButton = null;
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;

    protected DeploymentMapPage(String string, TPFDeployment tPFDeployment) {
        super(string);
        this.deployment = tPFDeployment;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth = 10;
        gridLayout.horizontalSpacing = 15;
        composite2.setLayout((Layout)gridLayout);
        Composite composite3 = this.createColumn(composite2);
        Composite composite4 = this.createColumn(composite2);
        this.artifactViewer = this.createViewer(composite3, this.deployment.getArtifacts());
        this.locationViewer = this.createViewer(composite4, this.deployment.getRefLocations());
        this.createPairButton = new Button(composite2, 8);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 2;
        gridData.horizontalSpan = 2;
        this.createPairButton.setLayoutData((Object)gridData);
        this.createPairButton.setToolTipText(TestUIPlugin.getString("BTN_CREATE_PAIR"));
        this.createPairButton.setImage(TestUIImages.INSTANCE.getImageDescriptor("downArrow.gif").createImage());
        this.createPairButton.setEnabled(false);
        this.createPairButton.addSelectionListener((SelectionListener)this);
        Composite composite5 = new Composite(composite2, 0);
        GridData gridData2 = new GridData(1808);
        gridData2.horizontalSpan = 2;
        composite5.setLayoutData((Object)gridData2);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.marginWidth = 0;
        gridLayout2.marginHeight = 0;
        gridLayout2.verticalSpacing = 10;
        gridLayout2.numColumns = 2;
        composite5.setLayout((Layout)gridLayout2);
        this.pairViewer = this.createTableViewer(composite5);
        Composite composite6 = new Composite(composite5, 0);
        GridData gridData3 = new GridData();
        gridData3.horizontalSpan = 2;
        gridData3 = new GridData(1040);
        composite6.setLayoutData((Object)gridData3);
        GridLayout gridLayout3 = new GridLayout();
        gridLayout3 = new GridLayout();
        gridLayout3.marginWidth = 0;
        gridLayout3.marginHeight = 0;
        gridLayout3.numColumns = 1;
        composite6.setLayout((Layout)gridLayout3);
        this.createButtons(composite6);
        this.setControl((Control)composite2);
    }

    private void createButtons(Composite composite) {
        this.removeButton = new Button(composite, 8);
        this.removeButton.setText(TestUIPlugin.getString("label.Remove"));
        GridData gridData = GridDataUtil.createHorizontalFill();
        this.removeButton.setLayoutData((Object)gridData);
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)this);
        this.upButton = new Button(composite, 8);
        this.upButton.setText(TestUIPlugin.getString("LBL_UP"));
        gridData = GridDataUtil.createHorizontalFill();
        gridData.verticalAlignment = 8;
        this.upButton.setLayoutData((Object)gridData);
        this.upButton.setEnabled(false);
        this.upButton.addSelectionListener((SelectionListener)this);
        this.downButton = new Button(composite, 8);
        this.downButton.setText(TestUIPlugin.getString("LBL_DOWN"));
        gridData = GridDataUtil.createHorizontalFill();
        gridData.verticalAlignment = 8;
        this.downButton.setLayoutData((Object)gridData);
        this.downButton.setEnabled(false);
        this.downButton.addSelectionListener((SelectionListener)this);
    }

    protected Composite createColumn(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)GridDataUtil.createFill());
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 10;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        return composite2;
    }

    protected StructuredViewer createViewer(Composite composite, Object object) {
        Tree tree = new Tree(composite, 67588);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 150;
        tree.setLayoutData((Object)gridData);
        ObjectContentProvider objectContentProvider = new ObjectContentProvider();
        TreeViewer treeViewer = new TreeViewer(tree);
        treeViewer.setContentProvider((IContentProvider)objectContentProvider);
        treeViewer.setLabelProvider((IBaseLabelProvider)new ObjectLabelProvider(true));
        treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.deployment != null) {
            treeViewer.setInput(object);
        }
        return treeViewer;
    }

    protected StructuredViewer createTableViewer(Composite composite) {
        Table table = new Table(composite, 67588);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 150;
        table.setLayoutData((Object)gridData);
        table.setLinesVisible(true);
        table.setHeaderVisible(false);
        TableColumn tableColumn = new TableColumn(table, 16384);
        TableColumn tableColumn2 = new TableColumn(table, 16384);
        table.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent controlEvent) {
            }

            public void controlResized(ControlEvent controlEvent) {
                if (controlEvent.getSource() instanceof Table) {
                    Table table = (Table)controlEvent.getSource();
                    int n = table.getSize().x;
                    int n2 = table.getGridLineWidth();
                    TableColumn[] tableColumnArray = table.getColumns();
                    int n3 = 0;
                    while (n3 < tableColumnArray.length) {
                        tableColumnArray[n3].setWidth((n - tableColumnArray.length * n2 - 2) / tableColumnArray.length);
                        ++n3;
                    }
                }
            }
        });
        ObjectContentProvider objectContentProvider = new ObjectContentProvider();
        TableViewer tableViewer = new TableViewer(table);
        tableViewer.setContentProvider((IContentProvider)objectContentProvider);
        tableViewer.setLabelProvider((IBaseLabelProvider)new MapLabelProvider());
        tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.deployment != null) {
            tableViewer.setInput((Object)this.deployment.getArtifactLocations());
        }
        return tableViewer;
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        int n;
        ISelection iSelection = selectionChangedEvent.getSelection();
        Object object = null;
        if (iSelection != null && !iSelection.isEmpty()) {
            object = ((IStructuredSelection)iSelection).getFirstElement();
            if (object != null && object instanceof CFGArtifact) {
                this.selectedArtifact = (CFGArtifact)object;
            }
            if (object != null && object instanceof CFGLocation) {
                this.selectedLocation = (CFGLocation)object;
            }
            if (object != null && object instanceof CFGArtifactLocationPair) {
                this.selectedPair = (CFGArtifactLocationPair)object;
            }
        }
        if (this.selectedArtifact != null && this.selectedLocation != null) {
            n = this.isPairUnique(this.deployment.getArtifactLocations(), this.selectedArtifact, this.selectedLocation) ? 1 : 0;
            this.createPairButton.setEnabled(n != 0);
        }
        if (this.selectedPair != null) {
            n = this.deployment.getArtifactLocations().indexOf((Object)this.selectedPair);
            int n2 = this.deployment.getArtifactLocations().size() - 1;
            boolean bl = true;
            boolean bl2 = true;
            if (n == 0) {
                bl = false;
            }
            if (n == n2) {
                bl2 = false;
            }
            this.removeButton.setEnabled(true);
            this.upButton.setEnabled(bl);
            this.downButton.setEnabled(bl2);
        } else {
            this.removeButton.setEnabled(false);
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
    }

    public void refresh() {
        this.artifactViewer.refresh();
        this.locationViewer.refresh();
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        int n;
        if (selectionEvent.widget == this.createPairButton && this.selectedArtifact != null && this.selectedLocation != null && this.isPairUnique(this.deployment.getArtifactLocations(), this.selectedArtifact, this.selectedLocation)) {
            CFGArtifactLocationPair cFGArtifactLocationPair = Common_ConfigurationFactory.eINSTANCE.createCFGArtifactLocationPair();
            cFGArtifactLocationPair.setArtifact(this.selectedArtifact);
            cFGArtifactLocationPair.setLocation(this.selectedLocation);
            this.deployment.getArtifactLocations().add((Object)cFGArtifactLocationPair);
            this.pairViewer.refresh();
            this.createPairButton.setEnabled(false);
            return;
        }
        ISelection iSelection = this.pairViewer.getSelection();
        Object object = null;
        if (iSelection != null && !iSelection.isEmpty()) {
            object = ((IStructuredSelection)iSelection).getFirstElement();
        }
        if (selectionEvent.widget == this.removeButton) {
            if (this.selectedPair != null) {
                this.deployment.getArtifactLocations().remove((Object)this.selectedPair);
                this.removeButton.setEnabled(false);
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
                this.selectedPair = null;
                this.pairViewer.refresh();
            }
            return;
        }
        if (selectionEvent.widget == this.upButton) {
            n = -1;
            if (object != null && object instanceof CFGArtifactLocationPair) {
                n = this.deployment.getArtifactLocations().indexOf((Object)((CFGArtifactLocationPair)object));
                this.deployment.getArtifactLocations().move(n, n - 1);
                this.pairViewer.refresh();
                if (n - 1 == 0) {
                    this.upButton.setEnabled(false);
                    this.downButton.setEnabled(true);
                } else {
                    this.upButton.setEnabled(true);
                    this.downButton.setEnabled(true);
                }
            }
        }
        if (selectionEvent.widget == this.downButton) {
            n = -1;
            int n2 = -1;
            if (object != null && object instanceof CFGArtifactLocationPair) {
                n = this.deployment.getArtifactLocations().indexOf((Object)((CFGArtifactLocationPair)object));
                n2 = this.deployment.getArtifactLocations().size() - 1;
                this.deployment.getArtifactLocations().move(n, n + 1);
                this.pairViewer.refresh();
                if (n + 1 == n2) {
                    this.upButton.setEnabled(true);
                    this.downButton.setEnabled(false);
                } else {
                    this.upButton.setEnabled(true);
                    this.downButton.setEnabled(true);
                }
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    private boolean isPairUnique(EList eList, CFGArtifact cFGArtifact, CFGLocation cFGLocation) {
        int n = 0;
        while (n < eList.size()) {
            CFGArtifactLocationPair cFGArtifactLocationPair = (CFGArtifactLocationPair)eList.get(n);
            if (cFGArtifactLocationPair.getArtifact().equals(cFGArtifact) && cFGArtifactLocationPair.getLocation().equals(cFGLocation)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class MapLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private MapLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            if (object instanceof CFGArtifactLocationPair) {
                CFGArtifactLocationPair cFGArtifactLocationPair = (CFGArtifactLocationPair)object;
                if (n == 0) {
                    return cFGArtifactLocationPair.getArtifact().getName();
                }
                if (n == 1) {
                    return cFGArtifactLocationPair.getLocation().getName();
                }
            }
            return new String();
        }
    }

    private class ObjectLabelProvider
    extends LabelProvider {
        private boolean useImages;

        public ObjectLabelProvider(boolean bl) {
            this.useImages = bl;
        }

        public Image getImage(Object object) {
            IWorkbenchAdapter iWorkbenchAdapter;
            if (!this.useImages || object == null) {
                return null;
            }
            if (object instanceof CFGArtifact) {
                return TestUIImages.INSTANCE.getImage("artifact_obj.gif");
            }
            if (object instanceof CFGLocation) {
                return TestUIImages.INSTANCE.getImage("location_obj.gif");
            }
            if (object instanceof IAdaptable && (iWorkbenchAdapter = (IWorkbenchAdapter)((IAdaptable)object).getAdapter(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = DeploymentMapPage.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter)) != null) {
                return iWorkbenchAdapter.getImageDescriptor(object).createImage();
            }
            return null;
        }

        public String getText(Object object) {
            IWorkbenchAdapter iWorkbenchAdapter;
            if (object == null) {
                return "";
            }
            String string = null;
            if (object instanceof CFGArtifact) {
                string = ((CFGArtifact)object).getName();
            } else if (object instanceof CFGLocation) {
                string = ((CFGLocation)object).getName();
            } else if (object instanceof IAdaptable && (iWorkbenchAdapter = (IWorkbenchAdapter)((IAdaptable)object).getAdapter(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = DeploymentMapPage.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter)) != null) {
                string = iWorkbenchAdapter.getLabel(object);
            }
            if (string == null) {
                string = object.toString();
            }
            return string;
        }

        public void dispose() {
            super.dispose();
        }
    }

    private class ObjectContentProvider
    implements ITreeContentProvider,
    IStructuredContentProvider {
        private ArrayList list = new ArrayList();

        public void dispose() {
            this.list.clear();
        }

        public Object[] getChildren(Object object) {
            return null;
        }

        public Object getParent(Object object) {
            return null;
        }

        public boolean hasChildren(Object object) {
            return false;
        }

        public Object[] getElements(Object object) {
            Object[] objectArray = new Object[]{};
            if (object == null) {
                return objectArray;
            }
            if (object instanceof EList) {
                int n = ((EList)object).size();
                objectArray = new Object[n];
                int n2 = 0;
                while (n2 < n) {
                    objectArray[n2] = ((EList)object).get(n2);
                    ++n2;
                }
            }
            return objectArray;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }
}

