/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofileFactory;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.wizard.DeploymentMapPage;
import org.eclipse.hyades.test.ui.internal.wizard.DeploymentObjectPage;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.PartInitException;

public class DeploymentNewWizard
extends HyadesNewWizard {
    DeploymentObjectPage artifactPage = null;
    DeploymentObjectPage locationPage = null;
    DeploymentMapPage mapPage = null;
    TPFDeployment deployment = null;

    public DeploymentNewWizard() {
        this.setWindowTitle(TestUIPlugin.getString("WIZ_DEPLOY_TTL"));
        this.setDefaultPageImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("newdeployment_wiz.gif"));
        IDialogSettings iDialogSettings = TestUIPlugin.getInstance().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection("TestSuiteNewWizard");
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection("TestSuiteNewWizard");
        }
        this.setDialogSettings(iDialogSettings2);
        this.deployment = Common_TestprofileFactory.eINSTANCE.createTPFDeployment();
    }

    protected String getFileExtension() {
        return "deploy";
    }

    public void addPages() {
        this.getLocationPage().setTitle(TestUIPlugin.getString("WIZ_DEPLOY_PG_TTL"));
        this.getLocationPage().setDescription(TestUIPlugin.getString("WIZ_DEPLOY_PG_LOC_DSC"));
        this.addPage((IWizardPage)this.getLocationPage());
        this.getAttributeWizardPage().setTitle(TestUIPlugin.getString("WIZ_DEPLOY_PG_TTL"));
        this.getAttributeWizardPage().setDescription(TestUIPlugin.getString("WIZ_DEPLOY_PG_ATT_DSC"));
        this.addPage((IWizardPage)this.getAttributeWizardPage());
        this.artifactPage = new DeploymentObjectPage("deploymentArtifact", this.deployment, Common_ConfigurationFactory.eINSTANCE.createCFGArtifact());
        this.artifactPage.setTitle(TestUIPlugin.getString("WIZ_DEPLOY_PG_TTL"));
        this.artifactPage.setDescription(TestUIPlugin.getString("WIZ_DEPLOY_PG_ART_DSC"));
        this.addPage((IWizardPage)this.artifactPage);
        this.locationPage = new DeploymentObjectPage("deploymentLocation", this.deployment, Common_ConfigurationFactory.eINSTANCE.createCFGLocation());
        this.locationPage.setTitle(TestUIPlugin.getString("WIZ_DEPLOY_PG_TTL"));
        this.locationPage.setDescription(TestUIPlugin.getString("WIZ_DEPLOY_PG_LOCATION_DSC"));
        this.addPage((IWizardPage)this.locationPage);
        this.mapPage = new DeploymentMapPage("deploymentMap", this.deployment);
        this.mapPage.setTitle(TestUIPlugin.getString("WIZ_DEPLOY_PG_TTL"));
        this.mapPage.setDescription(TestUIPlugin.getString("WIZ_DEPLOY_PG_MAP_DSC"));
        this.addPage((IWizardPage)this.mapPage);
    }

    protected boolean createObject(IFile iFile) throws Exception {
        Resource resource = this.createResource(iFile);
        resource.getContents().add((Object)this.createEObject());
        EMFUtil.save(resource);
        return true;
    }

    protected EObject createEObject() {
        this.deployment.setName(this.getAttributeWizardPage().getItemName());
        String string = this.getAttributeWizardPage().getItemDescription();
        if (string != null && string.trim().length() > 0) {
            this.deployment.setDescription(string);
        }
        return this.deployment;
    }

    protected Resource createResource(IFile iFile) {
        URI uRI = URI.createPlatformResourceURI((String)iFile.getFullPath().toString());
        Resource.Factory factory = EMFUtil.getResourceFactory("deploy");
        return factory.createResource(uRI);
    }

    protected void openEditor(IFile iFile) throws PartInitException {
        if (TestUIPlugin.getInstance().getPreferenceStore().getBoolean("openEditor")) {
            UIUtil.openEditor((IFile)iFile, (String)"org.eclipse.hyades.test.ui.editor.DeploymentEditorPart", (boolean)false);
        }
    }

    public IWizardPage getNextPage(IWizardPage iWizardPage) {
        this.mapPage.refresh();
        return super.getNextPage(iWizardPage);
    }
}

