/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard.selection;

import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.dialog.EObjectResourceSelectionDialog;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

public class WizardResourceSelectionPage
extends WizardSelectionPage
implements SelectionListener,
ModifyListener {
    private IWorkbench workbench;
    private IStructuredSelection structuredSelection;
    private IWizardNode newFileWizardNode;
    private String fileExtension;
    private Image fileImage;
    private Button useExistButton;
    private Button createNewButton;
    private Button browseButton;
    private Text existFileText;
    private boolean isValid;
    private EObject[] selectedEObjects;

    public WizardResourceSelectionPage(String string, IWorkbench iWorkbench, IStructuredSelection iStructuredSelection, String string2, Image image, IWizardNode iWizardNode) {
        super(string);
        this.workbench = iWorkbench;
        this.structuredSelection = iStructuredSelection;
        this.fileExtension = string2;
        this.fileImage = image;
        this.newFileWizardNode = iWizardNode;
        this.isValid = false;
        this.setTitle(TestUIPlugin.getString("DLG_RESOURCE_SEL"));
        this.setMessage(TestUIPlugin.getString("DLG_RESOURCE_DSC"));
    }

    public void createControl(Composite composite) {
        Group group = new Group(composite, 32);
        group.setLayout((Layout)new GridLayout(1, false));
        this.useExistButton = new Button((Composite)group, 16);
        this.useExistButton.setText(TestUIPlugin.getString("DLG_RESOURCE_USE_EXST"));
        this.useExistButton.setSelection(true);
        this.useExistButton.addSelectionListener((SelectionListener)this);
        Composite composite2 = new Composite((Composite)group, 0);
        composite2.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText(TestUIPlugin.getString("DLG_RESOURCE_EXST"));
        this.existFileText = new Text(composite2, 2048);
        this.existFileText.setLayoutData((Object)new GridData(768));
        this.existFileText.addModifyListener((ModifyListener)this);
        this.browseButton = new Button(composite2, 8);
        this.browseButton.setText(TestUIPlugin.getString("BTN_BROWSE"));
        this.browseButton.addSelectionListener((SelectionListener)this);
        this.createNewButton = new Button((Composite)group, 16);
        this.createNewButton.setText(TestUIPlugin.getString("DLG_RESOURCE_NEW"));
        this.createNewButton.setLayoutData((Object)new GridData(512));
        this.createNewButton.addSelectionListener((SelectionListener)this);
        this.setControl((Control)group);
    }

    protected IWizardNode getNewFileWizardNode() {
        IWizard iWizard;
        if (this.newFileWizardNode != null && !this.newFileWizardNode.isContentCreated() && (iWizard = this.newFileWizardNode.getWizard()) instanceof IWorkbenchWizard) {
            ((IWorkbenchWizard)iWizard).init(this.workbench, this.structuredSelection);
            iWizard.addPages();
        }
        return this.newFileWizardNode;
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        EObjectResourceSelectionDialog eObjectResourceSelectionDialog;
        int n;
        if (selectionEvent.widget == this.useExistButton) {
            if (this.isValid()) {
                this.setPageComplete(true);
            }
            this.existFileText.setEnabled(true);
            this.browseButton.setEnabled(true);
            this.browseButton.setFocus();
            super.setSelectedNode(null);
        } else if (selectionEvent.widget == this.createNewButton) {
            this.setPageComplete(false);
            this.existFileText.setEnabled(false);
            this.browseButton.setEnabled(false);
            super.setSelectedNode(this.getNewFileWizardNode());
        } else if (selectionEvent.widget == this.browseButton && (n = (eObjectResourceSelectionDialog = new EObjectResourceSelectionDialog(Display.getCurrent().getActiveShell(), TestUIPlugin.getString("DLG_RESOURCE_SEL"), new String[]{this.fileExtension}, this.fileImage)).open()) == 0) {
            this.selectedEObjects = eObjectResourceSelectionDialog.getSelectedObjects();
            IFile[] iFileArray = eObjectResourceSelectionDialog.getSelectedFiles();
            if (iFileArray != null && iFileArray.length > 0) {
                String string = "";
                int n2 = 0;
                while (n2 < iFileArray.length) {
                    string = string + iFileArray[n2].getFullPath().toString();
                    if (n2 < iFileArray.length - 1) {
                        string = string + ", ";
                    }
                    ++n2;
                }
                this.existFileText.removeModifyListener((ModifyListener)this);
                this.existFileText.setText(string);
                this.isValid = true;
                this.setPageComplete(true);
                this.existFileText.addModifyListener((ModifyListener)this);
            }
        }
    }

    public void modifyText(ModifyEvent modifyEvent) {
        if (modifyEvent.widget == this.existFileText) {
            String string = this.existFileText.getText();
            if (string != null && string.length() > 0) {
                IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                Vector<EObject> vector = new Vector<EObject>();
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    IResource iResource = iWorkspaceRoot.findMember(string2);
                    if (iResource == null || !iResource.exists() || !this.fileExtension.equals(iResource.getFileExtension())) {
                        this.setErrorMessage(string2 + TestUIPlugin.getString("DLG_RESOURCE_INVLD"));
                        break;
                    }
                    this.setErrorMessage(null);
                    URI uRI = URI.createPlatformResourceURI((String)((IFile)iResource).getFullPath().toString());
                    EObject[] eObjectArray = EMFUtil.getEObjects(uRI, true);
                    if (eObjectArray == null && eObjectArray.length <= 0) continue;
                    int n = 0;
                    while (n < eObjectArray.length) {
                        vector.add(eObjectArray[n]);
                        ++n;
                    }
                }
                if (vector.size() > 0) {
                    this.selectedEObjects = new EObject[vector.size()];
                    int n = 0;
                    while (n < vector.size()) {
                        this.selectedEObjects[n] = (EObject)vector.get(n);
                        ++n;
                    }
                    this.isValid = true;
                    this.setPageComplete(true);
                    return;
                }
            }
            this.selectedEObjects = null;
            this.isValid = false;
            this.setPageComplete(false);
        }
    }

    private boolean isValid() {
        return this.isValid;
    }

    public EObject[] getSelectedEObjects() {
        if (this.selectedEObjects == null) {
            this.selectedEObjects = new EObject[0];
        }
        return this.selectedEObjects;
    }
}

