/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.config.generator;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.hyades.internal.config.generator.AgentControllerConfig;
import org.eclipse.hyades.internal.config.generator.AgentControllerEnvironment;
import org.eclipse.hyades.internal.config.generator.Allow;
import org.eclipse.hyades.internal.config.generator.Application;
import org.eclipse.hyades.internal.config.generator.ConfigUtility;
import org.eclipse.hyades.internal.config.generator.Hosts;
import org.eclipse.hyades.internal.config.generator.Logger;
import org.eclipse.hyades.internal.config.generator.PlatformObject;
import org.eclipse.hyades.internal.config.generator.Plugin;
import org.eclipse.hyades.internal.config.generator.UserDefinition;
import org.eclipse.hyades.internal.config.generator.Variable;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigFile
extends DefaultHandler {
    protected static String TAG = ConfigUtility.getString("Config.AgentControllerConfig.Tag");
    private static String lineSeparator = System.getProperty("line.separator");
    protected DocumentBuilderFactory docBuildFactory = null;
    protected DocumentBuilder docBuild = null;
    protected Document doc = null;
    protected Element acConfig = null;
    protected Element holder = null;
    private int size = 100;
    private Hashtable hash = new Hashtable(this.size);
    private String sr = PlatformObject.sr;

    public ConfigFile() {
        this.docBuildFactory = DocumentBuilderFactory.newInstance();
        try {
            this.docBuild = this.docBuildFactory.newDocumentBuilder();
            this.createNewDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Logger.err("Cannot create document builder");
        }
    }

    public ConfigFile(String string) {
        this();
        this.loadExistingDocument(string);
    }

    public void saveToFile() {
        String string = new String(this.getValue("RASERVER_HOME") + this.sr + "config" + this.sr + "serviceconfig.xml");
        this.saveToFile(string);
    }

    public void saveToFile(String string) {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(string));
        }
        catch (Exception exception) {
            Logger.err(ConfigUtility.getString("Config.Writer.Error.CannotWriteFile") + " " + string);
            Logger.err(exception.getMessage());
        }
        if (printWriter != null) {
            printWriter.print(this.toString());
            printWriter.flush();
            printWriter.close();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = PlatformObject.encoding;
        String string2 = "1.0";
        stringBuffer.append("<?xml");
        stringBuffer.append(" version=\"" + string2 + "\"");
        stringBuffer.append(" encoding=\"" + string + "\"");
        stringBuffer.append("?>" + lineSeparator);
        NodeList nodeList = this.holder.getChildNodes();
        if (nodeList != null) {
            int n = 0;
            while (n < nodeList.getLength()) {
                stringBuffer.append(ConfigUtility.print(nodeList.item(n)));
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public void generateConfiguration() {
        this.generateHyadesConfiguration();
    }

    public void generateHyadesConfiguration() {
        String string = PlatformObject.sr;
        AgentControllerConfig.setVersion(this.acConfig, ConfigUtility.getString("Config.AgentController.Version"));
        AgentControllerConfig.setJvm(this.acConfig, this.resolveJvmDll(this.getValue("JAVA_PATH")));
        Element element = this.doc.createElement(AgentControllerEnvironment.TAG);
        AgentControllerEnvironment.setConfiguration(element, "default");
        this.acConfig.appendChild(element);
        Element element2 = this.doc.createElement(Variable.TAG);
        Variable.setName(element2, "JAVA_PATH");
        Variable.setValue(element2, this.getValue("JAVA_PATH"));
        Variable.setPosition(element2, "replace");
        element.appendChild(element2);
        element2 = this.doc.createElement(Variable.TAG);
        Variable.setName(element2, "RASERVER_HOME");
        Variable.setValue(element2, this.getValue("RASERVER_HOME"));
        Variable.setPosition(element2, "replace");
        element.appendChild(element2);
        element2 = this.doc.createElement(Variable.TAG);
        Variable.setName(element2, PlatformObject.libEnv);
        Variable.setValue(element2, "%RASERVER_HOME%" + string + PlatformObject.libPath);
        Variable.setPosition(element2, "prepend");
        element.appendChild(element2);
        element2 = this.doc.createElement(Variable.TAG);
        Variable.setName(element2, "LOCAL_AGENT_TEMP_DIR");
        Variable.setValue(element2, "%TMP%");
        Variable.setPosition(element2, "replace");
        element.appendChild(element2);
        element2 = this.doc.createElement(Variable.TAG);
        Variable.setName(element2, "SYS_TEMP_DIR");
        Variable.setValue(element2, PlatformObject.tempDir);
        Variable.setPosition(element2, "replace");
        element.appendChild(element2);
        element2 = this.doc.createElement(Variable.TAG);
        Variable.setName(element2, "CLASSPATH");
        Variable.setValue(element2, "%RASERVER_HOME%" + string + "lib" + string + "commons-logging.jar");
        Variable.setPosition(element2, "append");
        element.appendChild(element2);
        element2 = this.doc.createElement(Variable.TAG);
        Variable.setName(element2, "CLASSPATH");
        Variable.setValue(element2, "%RASERVER_HOME%" + string + "lib" + string + "hcframe.jar");
        Variable.setPosition(element2, "append");
        element.appendChild(element2);
        element2 = this.doc.createElement(Variable.TAG);
        Variable.setName(element2, "CLASSPATH");
        Variable.setValue(element2, "%RASERVER_HOME%" + string + "lib" + string + "hexcore.jar");
        Variable.setPosition(element2, "append");
        element.appendChild(element2);
        element2 = this.doc.createElement(Variable.TAG);
        Variable.setName(element2, "CLASSPATH");
        Variable.setValue(element2, "%RASERVER_HOME%" + string + "lib" + string + "hexl.jar");
        Variable.setPosition(element2, "append");
        element.appendChild(element2);
        element2 = this.doc.createElement(Variable.TAG);
        Variable.setName(element2, "CLASSPATH");
        Variable.setValue(element2, "%RASERVER_HOME%" + string + "lib" + string + "hexr.jar");
        Variable.setPosition(element2, "append");
        element.appendChild(element2);
        element2 = this.doc.createElement(Variable.TAG);
        Variable.setName(element2, "CLASSPATH");
        Variable.setValue(element2, "%RASERVER_HOME%" + string + "lib" + string + "hl14.jar");
        Variable.setPosition(element2, "append");
        element.appendChild(element2);
        element2 = this.doc.createElement(Variable.TAG);
        Variable.setName(element2, "CLASSPATH");
        Variable.setValue(element2, "%RASERVER_HOME%" + string + "lib" + string + "hlcommons.jar");
        Variable.setPosition(element2, "append");
        element.appendChild(element2);
        element2 = this.doc.createElement(Variable.TAG);
        Variable.setName(element2, "CLASSPATH");
        Variable.setValue(element2, "%RASERVER_HOME%" + string + "lib" + string + "hlcore.jar");
        Variable.setPosition(element2, "append");
        element.appendChild(element2);
        element2 = this.doc.createElement(Variable.TAG);
        Variable.setName(element2, "CLASSPATH");
        Variable.setValue(element2, "%RASERVER_HOME%" + string + "lib" + string + "hlevents.jar");
        Variable.setPosition(element2, "append");
        element.appendChild(element2);
        element2 = this.doc.createElement(Variable.TAG);
        Variable.setName(element2, "CLASSPATH");
        Variable.setValue(element2, "%RASERVER_HOME%" + string + "lib" + string + "hlcbe101.jar");
        Variable.setPosition(element2, "append");
        element.appendChild(element2);
        element2 = this.doc.createElement(Variable.TAG);
        Variable.setName(element2, "CLASSPATH");
        Variable.setValue(element2, "%RASERVER_HOME%" + string + "lib" + string + "ecore.jar");
        Variable.setPosition(element2, "append");
        element.appendChild(element2);
        element2 = this.doc.createElement(Variable.TAG);
        Variable.setName(element2, "CLASSPATH");
        Variable.setValue(element2, "%RASERVER_HOME%" + string + "lib" + string + "common.jar");
        Variable.setPosition(element2, "append");
        element.appendChild(element2);
        Element element3 = this.doc.createElement(Application.TAG);
        Application.setConfiguration(element3, "default");
        Application.setExecutable(element3, "java.exe");
        Application.setPath(element3, "%JAVA_PATH%");
        Application.setLocation(element3, "%SYS_TEMP_DIR%");
        this.acConfig.appendChild(element3);
        Element element4 = this.doc.createElement(Hosts.TAG);
        Hosts.setConfiguration(element4, "default");
        this.acConfig.appendChild(element4);
        if (this.getValue("ALLOW") != null) {
            if (this.getValue("ALLOW").toLowerCase().equals("custom")) {
                String[] stringArray = ConfigUtility.stringToArray(this.getValue("HOSTS"));
                if (stringArray.length > 0) {
                    int n = 0;
                    while (n < stringArray.length) {
                        Element element5 = this.doc.createElement(Allow.TAG);
                        element4.appendChild(element5);
                        if (stringArray[n].equalsIgnoreCase("all") || stringArray[n].equalsIgnoreCase("local")) {
                            Allow.setHost(element5, stringArray[n].toUpperCase());
                        } else {
                            Allow.setHost(element5, stringArray[n]);
                        }
                        ++n;
                    }
                } else {
                    Element element6 = this.doc.createElement(Allow.TAG);
                    Allow.setHost(element6, "LOCAL");
                    element4.appendChild(element6);
                }
            } else {
                Element element7 = this.doc.createElement(Allow.TAG);
                Allow.setHost(element7, this.getValue("ALLOW").toUpperCase());
                element4.appendChild(element7);
            }
        } else {
            Element element8 = this.doc.createElement(Allow.TAG);
            Allow.setHost(element8, "LOCAL");
            element4.appendChild(element8);
        }
        Element element9 = this.doc.createElement(Plugin.TAG);
        Plugin.setPath(element9, "%RASERVER_HOME%" + string + "plugins");
        this.acConfig.appendChild(element9);
    }

    public void createNewDocument() {
        DOMImplementation dOMImplementation = this.docBuild.getDOMImplementation();
        this.doc = dOMImplementation.createDocument(null, TAG, null);
        this.holder = this.doc.createElement("ElementHolder");
        this.acConfig = this.doc.createElement(AgentControllerConfig.TAG);
        AgentControllerConfig.setActiveConfiguration(this.acConfig, "default");
        AgentControllerConfig.setLoggingDetail(this.acConfig, "LOW");
        AgentControllerConfig.setLoggingLevel(this.acConfig, "INFORMATION");
        AgentControllerConfig.setPort(this.acConfig, "10002");
        AgentControllerConfig.setSecuredPort(this.acConfig, "10003");
        AgentControllerConfig.setVersion(this.acConfig, ConfigUtility.getString("Config.AgentController.Version"));
        AgentControllerConfig.setFilePort(this.acConfig, "10005");
        this.holder.appendChild(this.acConfig);
    }

    public void loadExistingDocument(String string) {
        block4: {
            SAXParser sAXParser = null;
            XMLReader xMLReader = null;
            try {
                sAXParser = SAXParserFactory.newInstance().newSAXParser();
                xMLReader = sAXParser.getXMLReader();
                xMLReader.setContentHandler(this);
                xMLReader.setErrorHandler(this);
            }
            catch (Exception exception) {
                Logger.err(ConfigUtility.getString("Config.Parser.Error.CreateParser") + " " + xMLReader);
                Logger.err(exception.getMessage());
            }
            if (xMLReader == null) break block4;
            try {
                xMLReader.parse(string);
            }
            catch (Exception exception) {
                Exception exception2;
                Logger.err(ConfigUtility.getString("Config.Parser.Error.ParseFile") + " " + string);
                Logger.err(exception.getMessage());
                if (!(exception instanceof SAXException) || (exception2 = ((SAXException)exception).getException()) == null) break block4;
                Logger.err(exception2.getMessage());
            }
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equals(UserDefinition.TAG)) {
            String string4 = null;
            String string5 = null;
            int n = 0;
            while (n < attributes.getLength()) {
                if (attributes.getQName(n).equals(ConfigUtility.getString("Config.UserDefinition.AuthenticationType.Tag"))) {
                    string4 = attributes.getValue(n);
                } else if (attributes.getQName(n).equals(ConfigUtility.getString("Config.UserDefinition.Name.Tag"))) {
                    string5 = attributes.getValue(n);
                } else {
                    Logger.out(ConfigUtility.getString("Config.Parser.Warning.UnrecognizedAttribute") + " " + attributes.getQName(n));
                }
                ++n;
            }
            if (string4 != null && string5 != null) {
                this.setValue("SECURITY", "true");
                if (this.getValue("USERS") == null) {
                    this.setValue("USERS", string5);
                } else {
                    this.setValue("USERS", this.getValue("USERS") + "," + string5);
                }
            }
        } else if (string3.equals(Variable.TAG)) {
            String string6 = null;
            String string7 = null;
            String string8 = null;
            int n = 0;
            while (n < attributes.getLength()) {
                if (attributes.getQName(n).equals(ConfigUtility.getString("Config.Variable.Name.Tag"))) {
                    string6 = attributes.getValue(n);
                } else if (attributes.getQName(n).equals(ConfigUtility.getString("Config.Variable.Value.Tag"))) {
                    string7 = attributes.getValue(n);
                } else if (attributes.getQName(n).equals(ConfigUtility.getString("Config.Variable.Position.Tag"))) {
                    string8 = attributes.getValue(n);
                } else {
                    Logger.out(ConfigUtility.getString("Config.Parser.Warning.UnrecognizedAttribute") + " " + attributes.getQName(n));
                }
                ++n;
            }
            if (string6 != null && string7 != null && string8 != null && !string6.equals("CLASSPATH") && !string6.equals("PATH")) {
                this.setValue(string6, string7);
            }
        } else if (string3.equals(Allow.TAG)) {
            String string9 = null;
            int n = 0;
            while (n < attributes.getLength()) {
                if (attributes.getQName(n).equals(ConfigUtility.getString("Config.Allow.Host.Tag"))) {
                    string9 = attributes.getValue(n);
                } else {
                    Logger.out(ConfigUtility.getString("Config.Parser.Warning.UnrecognizedAttribute") + " " + attributes.getQName(n));
                }
                ++n;
            }
            if (string9 != null) {
                if (string9.toLowerCase().equals("all") || string9.toLowerCase().equals("local")) {
                    this.setValue("ALLOW", string9.toUpperCase());
                    this.removeKey("HOSTS");
                } else {
                    this.setValue("ALLOW", "CUSTOM");
                    if (this.getValue("HOSTS") == null) {
                        this.setValue("HOSTS", string9);
                    } else {
                        this.setValue("HOSTS", this.getValue("HOSTS") + "," + string9);
                    }
                }
            }
        } else {
            Logger.out(ConfigUtility.getString("Config.Parser.Warning.UnrecognizedElement") + " " + string2);
        }
    }

    public String resolveJvmDll(String string) {
        if (PlatformObject.name.equals("OS/400")) {
            return new String("QSYS/QJVAJNI");
        }
        int n = string.lastIndexOf(this.sr + "java" + PlatformObject.exeExt);
        if (n == -1 && (n = string.lastIndexOf(this.sr + "javaw" + PlatformObject.exeExt)) == -1) {
            return new String("%JAVA_PATH%");
        }
        String string2 = string.substring(0, n);
        String string3 = null;
        try {
            string3 = ConfigUtility.getJvmLib(string2);
        }
        catch (Exception exception) {
            Logger.out(ConfigUtility.getString("Config.Jvm.Warning.CannotFindJvmLibrary") + ": " + PlatformObject.jvmLib);
        }
        if (string3 == null) {
            return new String("%JAVA_PATH%");
        }
        return string3;
    }

    public Element getAcConfig() {
        return this.acConfig;
    }

    public String getValue(String string) {
        return (String)this.hash.get(string);
    }

    public void setValue(String string, String string2) {
        this.hash.put(string, string2);
    }

    public void removeKey(String string) {
        this.hash.remove(string);
    }

    public boolean isExist(String string) {
        return this.hash.containsKey(string);
    }
}

