/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.config.generator;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import org.eclipse.hyades.internal.config.generator.ConfigFile;
import org.eclipse.hyades.internal.config.generator.ConfigUtility;
import org.eclipse.hyades.internal.config.generator.Logger;
import org.eclipse.hyades.internal.config.generator.PlatformObject;
import org.eclipse.hyades.internal.config.generator.PluginConfigFile;
import org.eclipse.hyades.internal.config.generator.TestJvm;

public class SetConfig {
    protected static ConfigFile conf = null;
    protected static boolean overwrite = false;
    protected static boolean silent = false;
    protected static boolean verify = true;
    private static int size = 100;
    private static String defaultConfigFile = null;
    private static Hashtable hash = new Hashtable(size);
    private static String sr = PlatformObject.sr;

    public static void main(String[] stringArray) {
        if (TestJvm.isMinimumVersion(ConfigUtility.getString("Config.Java.Version"), System.getProperty("java.version"))) {
            SetConfig.doIt(stringArray);
        } else {
            System.out.println(ConfigUtility.getString("Config.Prompt.JAVA_Version.Err") + ": " + ConfigUtility.getString("Config.Java.Version"));
            System.out.println(ConfigUtility.getString("Config.Prompt.JAVA_Version.Msg"));
        }
    }

    protected static void doIt(String[] stringArray) {
        File file;
        Object var1_1 = null;
        SetConfig.populateHashtable(stringArray);
        if (SetConfig.exist("-help") || SetConfig.exist("-h") || SetConfig.exist("-?")) {
            SetConfig.printHelp();
            return;
        }
        if (SetConfig.exist("-example") || SetConfig.exist("-ex")) {
            SetConfig.printExamples();
            return;
        }
        if (SetConfig.exist("-debug")) {
            Logger.setDebug(true);
        }
        if (SetConfig.exist("-overwrite") || SetConfig.exist("-ovr")) {
            overwrite = true;
        }
        if (SetConfig.exist("-silent") || SetConfig.exist("-s")) {
            silent = true;
        }
        if (SetConfig.exist("-noverify") || SetConfig.exist("-nov")) {
            verify = false;
        }
        if (SetConfig.getValue("RASERVER_HOME") == null) {
            file = new File("..");
            try {
                SetConfig.setValue("RASERVER_HOME", file.getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!SetConfig.isValidRaserverHome(SetConfig.getValue("RASERVER_HOME"))) {
            if (silent) {
                return;
            }
            SetConfig.setValue("RASERVER_HOME", SetConfig.promptRaserverHome(SetConfig.getValue("RASERVER_HOME")));
        }
        if (!SetConfig.isWritable(defaultConfigFile = new String(SetConfig.getValue("RASERVER_HOME") + sr + "config" + sr + "serviceconfig.xml"))) {
            System.out.println(ConfigUtility.getString("Config.Writer.Error.CannotWriteFile") + " " + defaultConfigFile);
            return;
        }
        conf = overwrite ? new ConfigFile() : ((file = new File(defaultConfigFile)).exists() ? new ConfigFile(file.getAbsolutePath()) : new ConfigFile());
        conf.setValue("RASERVER_HOME", SetConfig.getValue("RASERVER_HOME"));
        if (PlatformObject.name.equals("OS/400")) {
            conf.setValue("JAVA_PATH", "/QSYS.LIB/Q5BVAJVM.PGM");
        } else if (silent) {
            if (SetConfig.getValue("JAVA_PATH") == null || SetConfig.getValue("JAVA_PATH").equals("")) {
                if (conf.getValue("JAVA_PATH") == null || conf.getValue("JAVA_PATH").equals("")) {
                    if (SetConfig.isValidJava(System.getProperty("java.home") + sr + "bin" + sr + "java" + PlatformObject.exeExt)) {
                        conf.setValue("JAVA_PATH", System.getProperty("java.home") + sr + "bin" + sr + "java" + PlatformObject.exeExt);
                    } else {
                        conf.setValue("JAVA_PATH", "%JAVA_PATH%");
                    }
                }
            } else {
                conf.setValue("JAVA_PATH", SetConfig.getValue("JAVA_PATH"));
            }
        } else if (SetConfig.getValue("JAVA_PATH") == null) {
            if (conf.getValue("JAVA_PATH") == null) {
                conf.setValue("JAVA_PATH", SetConfig.promptJavaPath(System.getProperty("java.home") + sr + "bin" + sr + "java" + PlatformObject.exeExt));
            } else {
                conf.setValue("JAVA_PATH", SetConfig.promptJavaPath(conf.getValue("JAVA_PATH")));
            }
        } else if (SetConfig.isValidJava(SetConfig.getValue("JAVA_PATH"))) {
            conf.setValue("JAVA_PATH", SetConfig.getValue("JAVA_PATH"));
        } else {
            conf.setValue("JAVA_PATH", SetConfig.promptJavaPath(SetConfig.getValue("JAVA_PATH")));
        }
        if (silent) {
            if (SetConfig.getValue("ALLOW") == null) {
                if (conf.getValue("ALLOW") == null) {
                    conf.setValue("ALLOW", "LOCAL");
                }
            } else {
                conf.setValue("ALLOW", SetConfig.getValue("ALLOW"));
            }
        } else if (SetConfig.getValue("ALLOW") == null) {
            if (conf.getValue("ALLOW") == null) {
                conf.setValue("ALLOW", SetConfig.promptAllow("LOCAL"));
            } else {
                conf.setValue("ALLOW", SetConfig.promptAllow(conf.getValue("ALLOW")));
            }
        } else if (SetConfig.isValidAllow(SetConfig.getValue("ALLOW"))) {
            conf.setValue("ALLOW", SetConfig.getValue("ALLOW"));
        } else {
            conf.setValue("ALLOW", SetConfig.promptAllow(SetConfig.getValue("ALLOW")));
        }
        if (conf.getValue("ALLOW").toUpperCase().equals("CUSTOM")) {
            if (silent) {
                if (SetConfig.getValue("HOSTS") == null) {
                    if (conf.getValue("HOSTS") == null) {
                        conf.setValue("HOSTS", "localhost");
                    }
                } else {
                    conf.setValue("HOSTS", SetConfig.getValue("HOSTS"));
                }
            } else if (SetConfig.getValue("HOSTS") == null) {
                if (conf.getValue("HOSTS") == null) {
                    conf.setValue("HOSTS", SetConfig.promptHosts("localhost"));
                } else {
                    conf.setValue("HOSTS", SetConfig.promptHosts(conf.getValue("HOSTS")));
                }
            } else if (SetConfig.isValidHosts(SetConfig.getValue("HOSTS"))) {
                conf.setValue("HOSTS", SetConfig.getValue("HOSTS"));
            } else {
                conf.setValue("HOSTS", SetConfig.promptHosts(SetConfig.getValue("HOSTS")));
            }
        }
        conf.generateConfiguration();
        if (conf != null) {
            conf.saveToFile();
        }
        SetConfig.generatePluginConfigurations();
    }

    private static String promptRaserverHome(String string) {
        String string2 = null;
        System.out.println(ConfigUtility.getString("Config.Prompt.RASERVER_HOME.Tag"));
        System.out.print("  " + ConfigUtility.getString("Config.Prompt.Default") + "\"" + string + "\"");
        System.out.print(" (");
        System.out.print(ConfigUtility.getString("Config.Prompt.DefaultAccept"));
        System.out.println(")");
        do {
            System.out.print("  " + ConfigUtility.getString("Config.Prompt.NewValue"));
        } while (!SetConfig.isValidRaserverHome(string2 = SetConfig.promptUserInput(string)));
        return string2;
    }

    private static String promptJavaPath(String string) {
        String string2 = null;
        if (PlatformObject.name.startsWith("Windows")) {
            System.out.println(ConfigUtility.getString("Config.Prompt.JAVA_PATH.Tag.Windows"));
        } else {
            System.out.println(ConfigUtility.getString("Config.Prompt.JAVA_PATH.Tag.Unix"));
        }
        System.out.print("  " + ConfigUtility.getString("Config.Prompt.Default") + "\"" + string + "\"");
        System.out.print(" (");
        System.out.print(ConfigUtility.getString("Config.Prompt.DefaultAccept"));
        System.out.println(")");
        do {
            System.out.print("  " + ConfigUtility.getString("Config.Prompt.NewValue"));
        } while (!SetConfig.isValidJava(string2 = SetConfig.promptUserInput(string)));
        return string2;
    }

    private static String promptAllow(String string) {
        String string2 = null;
        System.out.println(ConfigUtility.getString("Config.Prompt.Allow.Tag"));
        System.out.print("  " + ConfigUtility.getString("Config.Prompt.Default") + "\"" + string + "\"");
        System.out.print(" (");
        System.out.print(ConfigUtility.getString("Config.Prompt.DefaultAccept"));
        System.out.println(")");
        do {
            System.out.print("  " + ConfigUtility.getString("Config.Prompt.NewValue"));
        } while (!SetConfig.isValidAllow(string2 = SetConfig.promptUserInput(string)));
        return string2;
    }

    private static String promptHosts(String string) {
        System.out.println(ConfigUtility.getString("Config.Prompt.Hosts.Tag"));
        System.out.print("  " + ConfigUtility.getString("Config.Prompt.Default") + "\"" + string + "\"");
        System.out.print(" (");
        System.out.print(ConfigUtility.getString("Config.Prompt.DefaultAccept"));
        System.out.println(")");
        System.out.print("  " + ConfigUtility.getString("Config.Prompt.NewValue"));
        return SetConfig.promptUserInput(string);
    }

    protected static String promptUserInput(String string) {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        try {
            string2 = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            string2 = string;
        }
        if (string2.equals("")) {
            string2 = string;
        }
        return ConfigUtility.removeTrailings(string2);
    }

    private static boolean isValidRaserverHome(String string) {
        if (!verify) {
            return true;
        }
        boolean bl = false;
        if (string == null) {
            System.out.println(ConfigUtility.getString("Config.Prompt.InvalidValue"));
            return false;
        }
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            if (PlatformObject.name.equals("OS/400")) {
                File file2 = new File(file.getAbsolutePath() + File.separator + "bin" + File.separator + "SetConfig.sh");
                if (file2.exists()) {
                    bl = true;
                }
            } else {
                File file3 = new File(file.getAbsolutePath() + File.separator + "bin" + File.separator + "RAServer" + PlatformObject.exeExt);
                if (file3.exists()) {
                    bl = true;
                }
            }
        }
        if (!bl) {
            System.out.println(ConfigUtility.getString("Config.Prompt.InvalidValue"));
        }
        return bl;
    }

    private static boolean isValidJava(String string) {
        if (!verify) {
            return true;
        }
        if (string == null) {
            System.out.println(ConfigUtility.getString("Config.Prompt.JAVA_PATH.Err"));
            return false;
        }
        File file = new File(string);
        if (file.exists() && file.isFile()) {
            boolean bl = TestJvm.isSupportedJava(string, ConfigUtility.getString("Config.Java.Version"));
            if (!bl) {
                System.out.println(ConfigUtility.getString("Config.Prompt.JAVA_Version.Err") + ": " + ConfigUtility.getString("Config.Java.Version"));
            }
            return bl;
        }
        System.out.println(ConfigUtility.getString("Config.Prompt.JAVA_PATH.Err"));
        return false;
    }

    private static boolean isValidAllow(String string) {
        if (!verify) {
            return true;
        }
        boolean bl = false;
        if (string == null) {
            System.out.println(ConfigUtility.getString("Config.Prompt.Allow.Err"));
            return false;
        }
        if (string.toLowerCase().equals("all") || string.toLowerCase().equals("local") || string.toLowerCase().equals("custom")) {
            bl = true;
        }
        if (!bl) {
            System.out.println(ConfigUtility.getString("Config.Prompt.Allow.Err"));
        }
        return bl;
    }

    private static boolean isValidHosts(String string) {
        if (!verify) {
            return true;
        }
        return string != null;
    }

    private static boolean isWritable(String string) {
        File file = new File(string);
        if (file.exists()) {
            return file.canWrite();
        }
        return file.getParentFile().canWrite();
    }

    protected static boolean exist(String string) {
        return hash.containsKey(string);
    }

    protected static String getValue(String string) {
        if (hash.containsKey(string)) {
            return (String)hash.get(string);
        }
        return null;
    }

    protected static void setValue(String string, String string2) {
        hash.put(string, string2);
    }

    protected static void removeKey(String string) {
        hash.remove(string);
    }

    private static void populateHashtable(String[] stringArray) {
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                int n2 = stringArray[n].indexOf(61);
                if (n2 == -1) {
                    SetConfig.setValue(stringArray[n], "");
                } else {
                    String string = SetConfig.trim(stringArray[n].substring(0, n2));
                    String string2 = SetConfig.trim(stringArray[n].substring(n2 + 1));
                    if (string != null && string2 != null) {
                        SetConfig.setValue(string, string2);
                    }
                }
                ++n;
            }
        }
    }

    private static String trim(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = 0;
        int n2 = string.length() - 1;
        while (n < n2 && (string.charAt(n) == ' ' || string.charAt(n) == '\"' || string.charAt(n) == '\'')) {
            ++n;
        }
        while (n2 > n && (string.charAt(n2) == ' ' || string.charAt(n2) == '\"' || string.charAt(n2) == '\'')) {
            --n2;
        }
        if (n != n2) {
            return string.substring(n, n2 + 1);
        }
        return null;
    }

    private static void printHelp() {
        if (PlatformObject.name.startsWith("Windows")) {
            System.out.println(ConfigUtility.getString("Config.Cmd.Usage.Windows"));
        } else {
            System.out.println(ConfigUtility.getString("Config.Cmd.Usage.Unix"));
        }
        System.out.println(ConfigUtility.getString("Config.Cmd.Flags"));
        System.out.println(ConfigUtility.getString("Config.Cmd.Help.Tag"));
        System.out.println("\t" + ConfigUtility.getString("Config.Cmd.Help.Msg"));
        System.out.println(ConfigUtility.getString("Config.Cmd.Silent.Tag"));
        System.out.println("\t" + ConfigUtility.getString("Config.Cmd.Silent.Msg"));
        System.out.println(ConfigUtility.getString("Config.Cmd.NoVerify.Tag"));
        System.out.println("\t" + ConfigUtility.getString("Config.Cmd.NoVerify.Msg"));
        System.out.println(ConfigUtility.getString("Config.Cmd.Examples.Tag"));
        System.out.println("\t" + ConfigUtility.getString("Config.Cmd.Examples.Msg"));
        System.out.println();
        System.out.println(ConfigUtility.getString("Config.Cmd.Params"));
        System.out.println(ConfigUtility.getString("Config.Cmd.RASERVER_HOME.Tag"));
        System.out.println("\t" + ConfigUtility.getString("Config.Cmd.RASERVER_HOME.Msg"));
        System.out.println(ConfigUtility.getString("Config.Cmd.JAVA_PATH.Tag"));
        System.out.println("\t" + ConfigUtility.getString("Config.Cmd.JAVA_PATH.Msg"));
        System.out.println(ConfigUtility.getString("Config.Cmd.ALLOW.Tag"));
        System.out.println("\t" + ConfigUtility.getString("Config.Cmd.ALLOW.Msg"));
        System.out.println(ConfigUtility.getString("Config.Cmd.HOSTS.Tag"));
        System.out.println("\t" + ConfigUtility.getString("Config.Cmd.HOSTS.Msg"));
    }

    private static void printExamples() {
        System.out.println(ConfigUtility.getString("Config.Example.Tag"));
        System.out.println(ConfigUtility.getString("Config.Example.Example1.Tag"));
        if (PlatformObject.name.startsWith("Windows")) {
            System.out.println("\t" + ConfigUtility.getString("Config.Example.Example1.Msg.Windows"));
        } else {
            System.out.println("\t" + ConfigUtility.getString("Config.Example.Example1.Msg.Unix"));
        }
        System.out.println(ConfigUtility.getString("Config.Example.Example2.Tag"));
        if (PlatformObject.name.startsWith("Windows")) {
            System.out.println("\t" + ConfigUtility.getString("Config.Example.Example2.Msg.Windows"));
        } else {
            System.out.println("\t" + ConfigUtility.getString("Config.Example.Example2.Msg.Unix"));
        }
        System.out.println(ConfigUtility.getString("Config.Example.Example3.Tag"));
        if (PlatformObject.name.startsWith("Windows")) {
            System.out.println("\t" + ConfigUtility.getString("Config.Example.Example3.Msg.Windows"));
        } else {
            System.out.println("\t" + ConfigUtility.getString("Config.Example.Example3.Msg.Unix"));
        }
        System.out.println(ConfigUtility.getString("Config.Example.Example4.Tag"));
        if (PlatformObject.name.startsWith("Windows")) {
            System.out.println("\t" + ConfigUtility.getString("Config.Example.Example4.Msg.Windows"));
        } else {
            System.out.println("\t" + ConfigUtility.getString("Config.Example.Example4.Msg.Unix"));
        }
    }

    protected static void generatePluginConfigurations() {
        SetConfig.generateDatacollectionConfiguration();
        SetConfig.generateParsersConfiguration();
        SetConfig.generateTestConfiguration();
    }

    private static void generateDatacollectionConfiguration() {
        String string = "org.eclipse.hyades.datacollection";
        String string2 = new String(SetConfig.getValue("RASERVER_HOME") + sr + "plugins" + sr + string + sr + "config" + sr + "pluginconfig.xml");
        PluginConfigFile pluginConfigFile = null;
        File file = new File(string2);
        pluginConfigFile = file.exists() && !overwrite ? new PluginConfigFile(file.getAbsolutePath()) : new PluginConfigFile();
        pluginConfigFile.setValue("RASERVER_HOME", SetConfig.getValue("RASERVER_HOME"));
        pluginConfigFile.generateConfiguration_datacollection(string);
    }

    private static void generateParsersConfiguration() {
        String string = "org.eclipse.hyades.logging.parsers";
        String string2 = new String(SetConfig.getValue("RASERVER_HOME") + sr + "plugins" + sr + string + sr + "config" + sr + "pluginconfig.xml");
        PluginConfigFile pluginConfigFile = null;
        File file = new File(string2);
        pluginConfigFile = file.exists() && !overwrite ? new PluginConfigFile(file.getAbsolutePath()) : new PluginConfigFile();
        pluginConfigFile.setValue("RASERVER_HOME", SetConfig.getValue("RASERVER_HOME"));
        pluginConfigFile.generateConfiguration_parsers(string);
    }

    private static void generateTestConfiguration() {
        String string = "org.eclipse.hyades.test";
        String string2 = new String(SetConfig.getValue("RASERVER_HOME") + sr + "plugins" + sr + string + sr + "config" + sr + "pluginconfig.xml");
        PluginConfigFile pluginConfigFile = null;
        File file = new File(string2);
        pluginConfigFile = file.exists() && !overwrite ? new PluginConfigFile(file.getAbsolutePath()) : new PluginConfigFile();
        pluginConfigFile.setValue("RASERVER_HOME", SetConfig.getValue("RASERVER_HOME"));
        pluginConfigFile.generateConfiguration_test(string);
    }
}

