/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.common.junit;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.eclipse.hyades.test.common.junit.HyadesTestUtil;
import org.eclipse.hyades.test.common.junit.IHyadesTest;

public class HyadesTestCase
extends TestCase
implements IHyadesTest {
    private String id;
    private String testInvocationId;
    private Test parent;
    private int iteration = 0;
    private int previousParentIteration = 0;
    private boolean synchronous = true;
    private boolean loop = false;

    public HyadesTestCase(String string) {
        super(string);
    }

    public String getId() {
        return this.id;
    }

    public IHyadesTest setId(String string) {
        this.id = string;
        return this;
    }

    public String getTestInvocationId() {
        return this.testInvocationId;
    }

    public IHyadesTest setTestInvocationId(String string) {
        this.testInvocationId = string;
        return this;
    }

    public void setParent(Test test) {
        this.parent = test;
    }

    public Test getParent() {
        return this.parent;
    }

    public int getIteration() {
        return this.iteration;
    }

    public IHyadesTest setSynchronous(boolean bl) {
        this.synchronous = bl;
        return this;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    protected void adjustIteration() {
        if (this.parent != null) {
            int n = this.previousParentIteration;
            if (this.parent instanceof IHyadesTest) {
                n = this.getParentIteration((IHyadesTest)this.parent);
            }
            if (n != this.previousParentIteration) {
                this.iteration = 0;
                this.previousParentIteration = n;
            }
        }
        ++this.iteration;
    }

    protected int getParentIteration(IHyadesTest iHyadesTest) {
        int n = iHyadesTest.getIteration();
        while (iHyadesTest != null && !iHyadesTest.isLoop()) {
            Test test = iHyadesTest.getParent();
            if (test == null || !(test instanceof IHyadesTest)) break;
            iHyadesTest = (IHyadesTest)test;
            n = iHyadesTest.getIteration();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TestResult testResult) {
        HyadesTestCase hyadesTestCase = this;
        synchronized (hyadesTestCase) {
            this.adjustIteration();
        }
        super.run(testResult);
    }

    public String toJUnitString() {
        return super.toString();
    }

    public String toString() {
        return HyadesTestUtil.getHierarchy(this, false);
    }

    public boolean isLoop() {
        return this.loop;
    }

    public IHyadesTest setLoop(boolean bl) {
        this.loop = bl;
        return this;
    }
}

