/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.builder;

import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.logging.adapter.Adapter;
import org.eclipse.hyades.logging.adapter.AdapterException;

public class Builder
extends IncrementalProjectBuilder {
    protected IProject[] build(int n, Map map, IProgressMonitor iProgressMonitor) throws CoreException {
        if (n == 6) {
            this.fullBuild(iProgressMonitor);
        } else {
            IResourceDelta iResourceDelta = this.getDelta(this.getProject());
            if (iResourceDelta == null) {
                this.fullBuild(iProgressMonitor);
            } else {
                this.incrementalBuild(iResourceDelta, iProgressMonitor);
            }
        }
        return null;
    }

    private void fullBuild(IProgressMonitor iProgressMonitor) throws CoreException {
        this.getProject().accept((IResourceVisitor)new MyBuildVisitor());
    }

    private void incrementalBuild(IResourceDelta iResourceDelta, IProgressMonitor iProgressMonitor) throws CoreException {
        iResourceDelta.accept((IResourceDeltaVisitor)new MyBuildDeltaVisitor());
    }

    private void buildResource(IResource iResource) {
        block6: {
            try {
                iResource.deleteMarkers("org.eclipse.hyades.logging.adapter.glaproblemmarker", true, 2);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            Adapter adapter = new Adapter();
            String string = iResource.getLocation().toOSString();
            adapter.setComponentConfigPath(string);
            adapter.setContextConfigPath(string);
            try {
                adapter.validate();
            }
            catch (AdapterException adapterException) {
                try {
                    IMarker iMarker = iResource.createMarker("org.eclipse.hyades.logging.adapter.glaproblemmarker");
                    if (!iMarker.exists()) break block6;
                    iMarker.setAttribute("message", (Object)adapterException.getLocalizedMessage());
                    iMarker.setAttribute("priority", 2);
                    iMarker.setAttribute("userEditable", true);
                }
                catch (CoreException coreException) {}
            }
        }
    }

    class MyBuildDeltaVisitor
    implements IResourceDeltaVisitor {
        public boolean visit(IResourceDelta iResourceDelta) {
            IResource iResource = iResourceDelta.getResource();
            if (iResource.getType() == 1) {
                Builder.this.buildResource(iResource);
            }
            return true;
        }
    }

    class MyBuildVisitor
    implements IResourceVisitor {
        public boolean visit(IResource iResource) {
            if (iResource.getType() == 1) {
                Builder.this.buildResource(iResource);
            }
            return true;
        }
    }
}

