/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.presentation;

import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.logging.adapter.model.internal.adapter.AdapterType;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.LoggingAgentOutputterTypeType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.NotificationOutputterTypeType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterPackage;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.SingleFileOutputterTypeType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.StandardOutOutputterTypeType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.AdapterCBESensorType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorFactory;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorPackage;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorPropertyType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SingleFileSensorType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.StaticParserSensorType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.ProcessUnitType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.PropertyType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.UnitFactory;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;

public class MigrationUtil {
    public static PropertyType getOrCreateProperty(ProcessUnitType processUnitType, String string) {
        PropertyType propertyType = MigrationUtil.getProperty(processUnitType.getProperty(), string);
        if (propertyType != null) {
            return propertyType;
        }
        propertyType = UnitFactory.eINSTANCE.createPropertyType();
        propertyType.setPropertyName(string);
        processUnitType.getProperty().add((Object)propertyType);
        return propertyType;
    }

    public static Object migrateLoad(AdapterType adapterType) {
        block7: {
            if (adapterType == null) break block7;
            try {
                adapterType.getConfiguration().getContextInstance();
                Iterator iterator = adapterType.getConfiguration().getContextInstance().iterator();
                while (iterator.hasNext()) {
                    OutputterConfigType outputterConfigType;
                    ContextInstanceType contextInstanceType = (ContextInstanceType)iterator.next();
                    if (contextInstanceType == null) continue;
                    Iterator iterator2 = contextInstanceType.getOutputter().iterator();
                    while (iterator2.hasNext()) {
                        outputterConfigType = (OutputterConfigType)iterator2.next();
                        if (outputterConfigType.getSingleFileOutputterType() != null) {
                            MigrationUtil.migrateLoad(outputterConfigType.getSingleFileOutputterType());
                            continue;
                        }
                        if (outputterConfigType.getLoggingAgentOutputterType() != null) {
                            MigrationUtil.migrateLoad(outputterConfigType.getLoggingAgentOutputterType());
                            continue;
                        }
                        if (outputterConfigType.getNotificationOutputterType() == null) continue;
                        MigrationUtil.migrateLoad(outputterConfigType.getNotificationOutputterType());
                    }
                    if (contextInstanceType.getSensor() == null) continue;
                    outputterConfigType = contextInstanceType.getSensor();
                    if (outputterConfigType.getSingleFileSensor() != null) {
                        MigrationUtil.migrateLoad(outputterConfigType.getSingleFileSensor());
                        continue;
                    }
                    if (outputterConfigType.getStaticParserSensor() == null) continue;
                    MigrationUtil.migrateLoad(outputterConfigType.getStaticParserSensor());
                }
            }
            catch (Exception exception) {
                Status status = new Status(4, AcadEditorPlugin.getDefault().getPluginId(), 4, AcadEditorPlugin.getDefault().getString("MIGRATION_LOAD_ERROR"), (Throwable)exception);
                AcadEditorPlugin.getDefault().logMessage((IStatus)status);
            }
        }
        return adapterType;
    }

    public static Object migrateSave(AdapterType adapterType) {
        block4: {
            if (adapterType == null) break block4;
            try {
                adapterType.getConfiguration().getContextInstance();
                Iterator iterator = adapterType.getConfiguration().getContextInstance().iterator();
                while (iterator.hasNext()) {
                    OutputterConfigType outputterConfigType;
                    ContextInstanceType contextInstanceType = (ContextInstanceType)iterator.next();
                    if (contextInstanceType == null) continue;
                    Iterator iterator2 = contextInstanceType.getOutputter().iterator();
                    while (iterator2.hasNext()) {
                        outputterConfigType = (OutputterConfigType)iterator2.next();
                        MigrationUtil.migrateSave(outputterConfigType);
                    }
                    if (contextInstanceType.getSensor() == null) continue;
                    outputterConfigType = contextInstanceType.getSensor();
                    MigrationUtil.migrateSave((SensorConfigType)outputterConfigType);
                }
            }
            catch (Exception exception) {
                Status status = new Status(4, AcadEditorPlugin.getDefault().getPluginId(), 4, AcadEditorPlugin.getDefault().getString("MIGRATION_SAVE_ERROR"), (Throwable)exception);
                AcadEditorPlugin.getDefault().logMessage((IStatus)status);
            }
        }
        return adapterType;
    }

    public static void migrateSave(SensorConfigType sensorConfigType) {
        if (sensorConfigType.getType() == SensorType.SINGLE_FILE_SENSOR_LITERAL) {
            SingleFileSensorType singleFileSensorType = sensorConfigType.getSingleFileSensor();
            if (singleFileSensorType == null) {
                singleFileSensorType = SensorFactory.eINSTANCE.createSingleFileSensorType();
                sensorConfigType.setSingleFileSensor(singleFileSensorType);
            }
            sensorConfigType.setAdapterCBESensor(null);
            sensorConfigType.setStaticParserSensor(null);
            singleFileSensorType.setDirectory(MigrationUtil.getPropertyValue(sensorConfigType.getProperty(), SensorPackage.eINSTANCE.getSingleFileSensorType_Directory()));
            singleFileSensorType.setFileName(MigrationUtil.getPropertyValue(sensorConfigType.getProperty(), SensorPackage.eINSTANCE.getSingleFileSensorType_FileName()));
            singleFileSensorType.setConverter(MigrationUtil.getPropertyValue(sensorConfigType.getProperty(), SensorPackage.eINSTANCE.getSingleFileSensorType_Converter()));
            singleFileSensorType.setShell(MigrationUtil.getPropertyValue(sensorConfigType.getProperty(), SensorPackage.eINSTANCE.getSingleFileSensorType_Shell()));
        } else if (sensorConfigType.getType() == SensorType.STATIC_PARSER_SENSOR_LITERAL) {
            StaticParserSensorType staticParserSensorType = sensorConfigType.getStaticParserSensor();
            if (staticParserSensorType == null) {
                staticParserSensorType = SensorFactory.eINSTANCE.createStaticParserSensorType();
                sensorConfigType.setStaticParserSensor(staticParserSensorType);
            }
            sensorConfigType.setAdapterCBESensor(null);
            sensorConfigType.setSingleFileSensor(null);
            staticParserSensorType.setDirectory(MigrationUtil.getPropertyValue(sensorConfigType.getProperty(), SensorPackage.eINSTANCE.getStaticParserSensorType_Directory()));
            staticParserSensorType.setFileName(MigrationUtil.getPropertyValue(sensorConfigType.getProperty(), SensorPackage.eINSTANCE.getStaticParserSensorType_FileName()));
            staticParserSensorType.setParserClassName(MigrationUtil.getPropertyValue(sensorConfigType.getProperty(), SensorPackage.eINSTANCE.getStaticParserSensorType_ParserClassName()));
        } else if (sensorConfigType.getType() == SensorType.ADAPTER_CBE_SENSOR_LITERAL) {
            AdapterCBESensorType adapterCBESensorType = sensorConfigType.getAdapterCBESensor();
            if (adapterCBESensorType == null) {
                adapterCBESensorType = SensorFactory.eINSTANCE.createAdapterCBESensorType();
                sensorConfigType.setAdapterCBESensor(adapterCBESensorType);
            }
            sensorConfigType.setStaticParserSensor(null);
            sensorConfigType.setSingleFileSensor(null);
        } else {
            sensorConfigType.setStaticParserSensor(null);
            sensorConfigType.setSingleFileSensor(null);
            sensorConfigType.setAdapterCBESensor(null);
        }
    }

    public static PropertyType getProperty(EList eList, String string) {
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            PropertyType propertyType = (PropertyType)iterator.next();
            if (propertyType.getPropertyName() == null || !propertyType.getPropertyName().equals(string)) continue;
            return propertyType;
        }
        return null;
    }

    public static String getPropertyValue(EList eList, EAttribute eAttribute) {
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            PropertyType propertyType = (PropertyType)iterator.next();
            if (propertyType.getPropertyName() == null || !propertyType.getPropertyName().equals(eAttribute.getName())) continue;
            return propertyType.getPropertyValue();
        }
        return null;
    }

    public static void migrateSave(OutputterConfigType outputterConfigType) {
        if (outputterConfigType.getType() == OutputterType.SINGLE_FILE_OUTPUTTER_LITERAL) {
            SingleFileOutputterTypeType singleFileOutputterTypeType = outputterConfigType.getSingleFileOutputterType();
            if (singleFileOutputterTypeType == null) {
                singleFileOutputterTypeType = OutputterFactory.eINSTANCE.createSingleFileOutputterTypeType();
                outputterConfigType.setSingleFileOutputterType(singleFileOutputterTypeType);
            }
            outputterConfigType.setLoggingAgentOutputterType(null);
            outputterConfigType.setNotificationOutputterType(null);
            outputterConfigType.setStandardOutOutputterType(null);
            singleFileOutputterTypeType.setDirectory(MigrationUtil.getPropertyValue(outputterConfigType.getProperty(), OutputterPackage.eINSTANCE.getSingleFileOutputterTypeType_Directory()));
            singleFileOutputterTypeType.setFileName(MigrationUtil.getPropertyValue(outputterConfigType.getProperty(), OutputterPackage.eINSTANCE.getSingleFileOutputterTypeType_FileName()));
        } else if (outputterConfigType.getType() == OutputterType.LOGGING_AGENT_OUTPUTTER_LITERAL) {
            LoggingAgentOutputterTypeType loggingAgentOutputterTypeType = outputterConfigType.getLoggingAgentOutputterType();
            if (loggingAgentOutputterTypeType == null) {
                loggingAgentOutputterTypeType = OutputterFactory.eINSTANCE.createLoggingAgentOutputterTypeType();
                outputterConfigType.setLoggingAgentOutputterType(loggingAgentOutputterTypeType);
            }
            outputterConfigType.setSingleFileOutputterType(null);
            outputterConfigType.setNotificationOutputterType(null);
            outputterConfigType.setStandardOutOutputterType(null);
            loggingAgentOutputterTypeType.setAgentName(MigrationUtil.getPropertyValue(outputterConfigType.getProperty(), OutputterPackage.eINSTANCE.getLoggingAgentOutputterTypeType_AgentName()));
            loggingAgentOutputterTypeType.setWaitUntilLoggingTime(MigrationUtil.getPropertyValue(outputterConfigType.getProperty(), OutputterPackage.eINSTANCE.getLoggingAgentOutputterTypeType_WaitUntilLoggingTime()));
        } else if (outputterConfigType.getType() == OutputterType.NOTIFICATION_OUTPUTTER_LITERAL) {
            NotificationOutputterTypeType notificationOutputterTypeType = outputterConfigType.getNotificationOutputterType();
            if (notificationOutputterTypeType == null) {
                notificationOutputterTypeType = OutputterFactory.eINSTANCE.createNotificationOutputterTypeType();
                outputterConfigType.setNotificationOutputterType(notificationOutputterTypeType);
            }
            outputterConfigType.setSingleFileOutputterType(null);
            outputterConfigType.setLoggingAgentOutputterType(null);
            outputterConfigType.setStandardOutOutputterType(null);
            notificationOutputterTypeType.setResourceURL(MigrationUtil.getPropertyValue(outputterConfigType.getProperty(), OutputterPackage.eINSTANCE.getNotificationOutputterTypeType_ResourceURL()));
        } else if (outputterConfigType.getType() == OutputterType.SINGLE_FILE_OUTPUTTER_LITERAL) {
            StandardOutOutputterTypeType standardOutOutputterTypeType = outputterConfigType.getStandardOutOutputterType();
            if (standardOutOutputterTypeType == null) {
                standardOutOutputterTypeType = OutputterFactory.eINSTANCE.createStandardOutOutputterTypeType();
                outputterConfigType.setStandardOutOutputterType(standardOutOutputterTypeType);
            }
            outputterConfigType.setNotificationOutputterType(null);
            outputterConfigType.setSingleFileOutputterType(null);
            outputterConfigType.setLoggingAgentOutputterType(null);
        } else {
            outputterConfigType.setNotificationOutputterType(null);
            outputterConfigType.setSingleFileOutputterType(null);
            outputterConfigType.setLoggingAgentOutputterType(null);
            outputterConfigType.setStandardOutOutputterType(null);
        }
    }

    public static void migrateLoad(LoggingAgentOutputterTypeType loggingAgentOutputterTypeType) {
        MigrationUtil.addOrSetProperty(loggingAgentOutputterTypeType.eContainer(), OutputterPackage.eINSTANCE.getLoggingAgentOutputterTypeType_AgentName(), loggingAgentOutputterTypeType.getAgentName());
        MigrationUtil.addOrSetProperty(loggingAgentOutputterTypeType.eContainer(), OutputterPackage.eINSTANCE.getLoggingAgentOutputterTypeType_WaitUntilLoggingTime(), loggingAgentOutputterTypeType.getWaitUntilLoggingTime());
    }

    public static void migrateLoad(NotificationOutputterTypeType notificationOutputterTypeType) {
        MigrationUtil.addOrSetProperty(notificationOutputterTypeType.eContainer(), OutputterPackage.eINSTANCE.getNotificationOutputterTypeType_ResourceURL(), notificationOutputterTypeType.getResourceURL());
    }

    public static void addOrSetProperty(EObject eObject, EAttribute eAttribute, String string) {
        MigrationUtil.addOrSetProperty(eObject, eAttribute.getName(), string);
    }

    public static void migrateLoad(SingleFileOutputterTypeType singleFileOutputterTypeType) {
        MigrationUtil.addOrSetProperty(singleFileOutputterTypeType.eContainer(), OutputterPackage.eINSTANCE.getSingleFileOutputterTypeType_Directory(), singleFileOutputterTypeType.getDirectory());
        MigrationUtil.addOrSetProperty(singleFileOutputterTypeType.eContainer(), OutputterPackage.eINSTANCE.getSingleFileOutputterTypeType_FileName(), singleFileOutputterTypeType.getFileName());
    }

    public static void addOrSetProperty(EObject eObject, String string, String string2) {
        if (string2 == null) {
            return;
        }
        PropertyType propertyType = MigrationUtil.getOrCreateProperty((ProcessUnitType)eObject, string);
        propertyType.setPropertyValue(string2);
    }

    public static void migrateLoad(SingleFileSensorType singleFileSensorType) {
        MigrationUtil.addOrSetProperty(singleFileSensorType.eContainer(), SensorPackage.eINSTANCE.getSingleFileSensorType_Directory(), singleFileSensorType.getDirectory());
        MigrationUtil.addOrSetProperty(singleFileSensorType.eContainer(), SensorPackage.eINSTANCE.getSingleFileSensorType_FileName(), singleFileSensorType.getFileName());
        MigrationUtil.addOrSetProperty(singleFileSensorType.eContainer(), SensorPackage.eINSTANCE.getSingleFileSensorType_Converter(), singleFileSensorType.getConverter());
        MigrationUtil.addOrSetProperty(singleFileSensorType.eContainer(), SensorPackage.eINSTANCE.getSingleFileSensorType_Shell(), singleFileSensorType.getShell());
    }

    public static void migrateLoad(StaticParserSensorType staticParserSensorType) {
        MigrationUtil.addOrSetProperty(staticParserSensorType.eContainer(), SensorPackage.eINSTANCE.getStaticParserSensorType_Directory(), staticParserSensorType.getDirectory());
        MigrationUtil.addOrSetProperty(staticParserSensorType.eContainer(), SensorPackage.eINSTANCE.getStaticParserSensorType_FileName(), staticParserSensorType.getFileName());
        MigrationUtil.addOrSetProperty(staticParserSensorType.eContainer(), SensorPackage.eINSTANCE.getStaticParserSensorType_ParserClassName(), staticParserSensorType.getParserClassName());
        Iterator iterator = staticParserSensorType.getSensorProperty().iterator();
        while (iterator.hasNext()) {
            SensorPropertyType sensorPropertyType = (SensorPropertyType)iterator.next();
            MigrationUtil.addOrSetProperty(staticParserSensorType.eContainer(), sensorPropertyType.getPropertyName(), sensorPropertyType.getPropertyValue());
        }
    }
}

