/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.actions;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.actions.DeleteAction;
import org.eclipse.hyades.trace.ui.internal.actions.OpenWizardAction;
import org.eclipse.hyades.trace.ui.internal.actions.SaveAction;
import org.eclipse.hyades.trace.ui.internal.actions.TraceLogActionGroup;
import org.eclipse.hyades.ui.extension.IAssociationMappingRegistry;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.dialogs.PropertyDialogAction;

public class TraceNavigatorActionGroup
extends TraceLogActionGroup {
    protected OpenWizardAction fOpenMonitorAction;
    protected OpenWizardAction fOpenProfAgentAction;
    protected PropertyDialogAction fPropertyDialogAction;
    protected OpenWizardAction fOpenProcessAction;
    static /* synthetic */ Class class$org$eclipse$hyades$trace$ui$internal$wizard$OpenMonitorWizard;
    static /* synthetic */ Class class$org$eclipse$hyades$trace$ui$internal$wizard$OpenProfAgentWizard;
    static /* synthetic */ Class class$org$eclipse$hyades$trace$ui$internal$wizard$OpenProcessWizard;

    public TraceNavigatorActionGroup(INavigator viewer) {
        super(viewer);
    }

    public void dispose() {
        this.deleteActions();
        super.dispose();
    }

    private void deleteActions() {
        if (this.fOpenMonitorAction != null) {
            this.fOpenMonitorAction.dispose();
            this.fOpenMonitorAction = null;
        }
        if (this.fOpenProcessAction != null) {
            this.fOpenProcessAction.dispose();
            this.fOpenProcessAction = null;
        }
        if (this.fPropertyDialogAction != null) {
            this.fPropertyDialogAction.dispose();
            this.fPropertyDialogAction = null;
        }
        if (this.fOpenProfAgentAction != null) {
            this.fOpenProfAgentAction.dispose();
            this.fOpenProfAgentAction = null;
        }
    }

    public void setContext(ActionContext context) {
        super.setContext(context);
    }

    protected void createActions() {
        super.createActions();
        this.fNewSnapshotGrp = new Separator("newSnapshotGroup");
        this.fGCGroup = new Separator("gcGroup");
        this.fTerminateGrp = new Separator("terminateGroup");
        this.fSaveToFile = new SaveAction(this.getNavigator());
        this.fOpenMonitorAction = new OpenWizardAction((INavigator)((PDProjectExplorer)this.getNavigator()), class$org$eclipse$hyades$trace$ui$internal$wizard$OpenMonitorWizard == null ? (class$org$eclipse$hyades$trace$ui$internal$wizard$OpenMonitorWizard = TraceNavigatorActionGroup.class$("org.eclipse.hyades.trace.ui.internal.wizard.OpenMonitorWizard")) : class$org$eclipse$hyades$trace$ui$internal$wizard$OpenMonitorWizard, UIPlugin.getResourceString("PROPERTIES"));
        this.fOpenProfAgentAction = new OpenWizardAction((INavigator)((PDProjectExplorer)this.getNavigator()), class$org$eclipse$hyades$trace$ui$internal$wizard$OpenProfAgentWizard == null ? (class$org$eclipse$hyades$trace$ui$internal$wizard$OpenProfAgentWizard = TraceNavigatorActionGroup.class$("org.eclipse.hyades.trace.ui.internal.wizard.OpenProfAgentWizard")) : class$org$eclipse$hyades$trace$ui$internal$wizard$OpenProfAgentWizard, UIPlugin.getResourceString("PROPERTIES"));
        this.fOpenProcessAction = new OpenWizardAction((INavigator)((PDProjectExplorer)this.getNavigator()), class$org$eclipse$hyades$trace$ui$internal$wizard$OpenProcessWizard == null ? (class$org$eclipse$hyades$trace$ui$internal$wizard$OpenProcessWizard = TraceNavigatorActionGroup.class$("org.eclipse.hyades.trace.ui.internal.wizard.OpenProcessWizard")) : class$org$eclipse$hyades$trace$ui$internal$wizard$OpenProcessWizard, UIPlugin.getResourceString("PROPERTIES"));
        this.fDeleteAction = new DeleteAction(this.getNavigator());
        this.fPropertyDialogAction = new PropertyDialogAction(this.getNavigator().getViewSite().getShell(), (ISelectionProvider)this.getNavigator().getViewer());
    }

    public void fillContextMenu(IMenuManager menu) {
        boolean multiSelection;
        super.fillContextMenu(menu);
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        boolean sameClass = false;
        boolean bl = multiSelection = selection.size() > 1;
        if (multiSelection) {
            sameClass = this.areSameClass(selection);
        }
        if (selection.isEmpty()) {
            this.fImportActionGroup.fillContextMenu(menu);
            menu.appendToGroup("group.refresh", (IAction)this.fRefreshTree);
            return;
        }
        Object sel = selection.iterator().next();
        this.updateActions(selection);
        if (sel instanceof TRCMonitor) {
            menu.appendToGroup("group.additions", (IContributionItem)new Separator("group.add.views"));
            this.addViews(menu, sel);
            menu.appendToGroup("group.refresh", (IContributionItem)this.fRefreshGrp);
        } else if (sel instanceof TRCNode) {
            menu.appendToGroup("group.additions", (IContributionItem)new Separator("group.add.views"));
            this.addViews(menu, sel);
            menu.appendToGroup("group.refresh", (IContributionItem)this.fRefreshGrp);
        } else if (sel instanceof TRCProcessProxy) {
            if (!multiSelection) {
                menu.appendToGroup("group.additions", (IContributionItem)this.fGCGroup);
                menu.appendToGroup("group.additions", (IContributionItem)this.fTerminateGrp);
                menu.appendToGroup("group.additions", (IContributionItem)new Separator("group.add.views"));
                this.addViews(menu, sel);
                menu.appendToGroup("group.refresh", (IContributionItem)this.fRefreshGrp);
            }
        } else if (sel instanceof TRCAgentProxy) {
            if (!multiSelection || sameClass) {
                menu.appendToGroup("group.additions", (IContributionItem)this.fMonitorGrp);
                menu.appendToGroup("group.additions", (IContributionItem)this.fGCGroup);
                menu.appendToGroup("group.additions", (IContributionItem)this.fAttachGrp);
            }
            if (!multiSelection) {
                menu.appendToGroup("group.additions", (IContributionItem)this.fNewSnapshotGrp);
                menu.appendToGroup("group.additions", (IContributionItem)this.fTerminateGrp);
                menu.appendToGroup("group.additions", (IContributionItem)new Separator("group.add.views"));
                this.addViews(menu, sel);
                menu.appendToGroup("group.refresh", (IContributionItem)this.fRefreshGrp);
            }
        } else if (sel instanceof INavigatorItem && !multiSelection) {
            menu.appendToGroup("group.additions", (IContributionItem)this.fMonitorGrp);
            menu.appendToGroup("group.additions", (IContributionItem)this.fGCGroup);
            menu.appendToGroup("group.additions", (IContributionItem)this.fAttachGrp);
            menu.appendToGroup("group.additions", (IContributionItem)new Separator("group.add.views"));
            this.addViews(menu, sel);
            menu.appendToGroup("group.refresh", (IContributionItem)this.fRefreshGrp);
        }
        menu.appendToGroup("group.delete", (IAction)this.fDeleteAction);
        menu.appendToGroup("group.save", (IAction)this.fSaveToFile);
        menu.appendToGroup("group.refresh", (IAction)this.fRefreshTree);
        menu.appendToGroup("group.refresh", (IAction)this.fRefreshLocal);
        if (!multiSelection) {
            if (this.fPropertyDialogAction.isApplicableForSelection()) {
                menu.appendToGroup("group.properties", (IAction)this.fPropertyDialogAction);
            }
            if (sel instanceof TRCMonitor) {
                menu.appendToGroup("group.properties", (IAction)this.fOpenMonitorAction);
            } else if (sel instanceof TRCNode) {
                menu.appendToGroup("group.properties", (IAction)this.fOpenNodeAction);
            } else if (sel instanceof TRCProcessProxy) {
                menu.appendToGroup("group.properties", (IAction)this.fOpenProcessAction);
            } else if (sel instanceof TRCAgentProxy) {
                if (((TRCAgentProxy)sel).getType().equals("Profiler")) {
                    menu.appendToGroup("group.properties", (IAction)this.fOpenProfAgentAction);
                } else {
                    menu.appendToGroup("group.properties", (IAction)this.fOpenLogAgentAction);
                }
            }
        }
        this.fImportActionGroup.fillContextMenu(menu);
    }

    protected void addViews(IMenuManager menu, Object obj) {
        block32: {
            MenuManager popup;
            block31: {
                if (obj == null || !(obj instanceof EObject) && !(obj instanceof INavigatorItem)) {
                    return;
                }
                popup = new MenuManager(UIPlugin.getResourceString("MENU_MANAGER"));
                menu.appendToGroup("group.add.views", (IContributionItem)popup);
                if (!(obj instanceof TRCMonitor)) break block31;
                TRCMonitor monitor = (TRCMonitor)obj;
                IAction[] actions = this.getViewMappingForType("Monitor");
                int idx = 0;
                while (idx < actions.length) {
                    if (actions[idx] != null) {
                        popup.add(actions[idx]);
                    }
                    ++idx;
                }
                ArrayList<String> typesList = new ArrayList<String>();
                EList nodes = monitor.getNodes();
                if (nodes.size() <= 0) break block32;
                int idx2 = 0;
                while (idx2 < nodes.size()) {
                    TRCNode node = (TRCNode)nodes.get(idx2);
                    EList processes = node.getProcessProxies();
                    int i = 0;
                    while (i < processes.size()) {
                        TRCProcessProxy process = (TRCProcessProxy)processes.get(i);
                        EList agents = process.getAgentProxies();
                        int j = 0;
                        while (j < agents.size()) {
                            TRCAgentProxy agent = (TRCAgentProxy)agents.get(j);
                            if (!typesList.contains(agent.getType())) {
                                typesList.add(agent.getType());
                                actions = this.getViewMappingForType(agent.getType());
                                if (actions.length > 0) {
                                    popup.add((IContributionItem)new Separator());
                                    int k = 0;
                                    while (k < actions.length) {
                                        popup.add(actions[k]);
                                        ++k;
                                    }
                                }
                            }
                            ++j;
                        }
                        ++i;
                    }
                    ++idx2;
                }
                break block32;
            }
            if (obj instanceof TRCNode) {
                IAction[] actions = this.getViewMappingForType("Host");
                int idx = 0;
                while (idx < actions.length) {
                    if (actions[idx] != null) {
                        popup.add(actions[idx]);
                    }
                    ++idx;
                }
                ArrayList<String> typesList = new ArrayList<String>();
                EList processes = ((TRCNode)obj).getProcessProxies();
                int i = 0;
                while (i < processes.size()) {
                    TRCProcessProxy process = (TRCProcessProxy)processes.get(i);
                    EList agents = process.getAgentProxies();
                    int j = 0;
                    while (j < agents.size()) {
                        TRCAgentProxy agent = (TRCAgentProxy)agents.get(j);
                        if (!typesList.contains(agent.getType())) {
                            typesList.add(agent.getType());
                            actions = this.getViewMappingForType(agent.getType());
                            if (actions.length > 0) {
                                popup.add((IContributionItem)new Separator());
                                int k = 0;
                                while (k < actions.length) {
                                    popup.add(actions[k]);
                                    ++k;
                                }
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            } else if (obj instanceof TRCProcessProxy) {
                ArrayList<String> typesList = new ArrayList<String>();
                EList agents = ((TRCProcessProxy)obj).getAgentProxies();
                int j = 0;
                while (j < agents.size()) {
                    TRCAgentProxy agent = (TRCAgentProxy)agents.get(j);
                    if (!typesList.contains(agent.getType())) {
                        typesList.add(agent.getType());
                        IAction[] actions = this.getViewMappingForType(agent.getType());
                        if (actions.length > 0) {
                            popup.add((IContributionItem)new Separator());
                            int k = 0;
                            while (k < actions.length) {
                                popup.add(actions[k]);
                                ++k;
                            }
                        }
                    }
                    ++j;
                }
            } else if (obj instanceof TRCAgentProxy) {
                IAction[] actions = this.getViewMappingForType(((TRCAgentProxy)obj).getType());
                int idx = 0;
                while (idx < actions.length) {
                    if (actions[idx] != null) {
                        popup.add(actions[idx]);
                    }
                    ++idx;
                }
            } else if (obj instanceof INavigatorItem) {
                IAction[] actions = this.getViewMappingForType(((INavigatorItem)obj).getType());
                int idx = 0;
                while (idx < actions.length) {
                    if (actions[idx] != null) {
                        popup.add(actions[idx]);
                    }
                    ++idx;
                }
            }
        }
    }

    public void handleDoubleClick(DoubleClickEvent event) {
        IAction action;
        IStructuredSelection s = (IStructuredSelection)event.getSelection();
        Object obj = s.getFirstElement();
        if (obj == null || !(obj instanceof EObject) && !(obj instanceof INavigatorItem)) {
            return;
        }
        if (obj instanceof TRCMonitor) {
            IAction action2 = this.getDefaultViewMappingForType("Monitor");
            if (action2 != null) {
                action2.run();
            }
        } else if (obj instanceof TRCNode) {
            IAction action3 = this.getDefaultViewMappingForType("Host");
            if (action3 != null) {
                action3.run();
            }
        } else if (obj instanceof TRCProcessProxy) {
            EList agents = ((TRCProcessProxy)obj).getAgentProxies();
            int idx = 0;
            while (idx < agents.size()) {
                IAction action4;
                TRCAgentProxy agent = (TRCAgentProxy)agents.get(idx);
                if (agent != null && !agent.eIsProxy() && (action4 = this.getDefaultViewMappingForType(agent.getType())) != null) {
                    action4.run();
                    return;
                }
                ++idx;
            }
        } else if (obj instanceof TRCAgentProxy) {
            IAction action5 = this.getDefaultViewMappingForType(((TRCAgentProxy)obj).getType());
            if (action5 != null) {
                action5.run();
            }
        } else if (obj instanceof INavigatorItem && (action = this.getDefaultViewMappingForType(((INavigatorItem)obj).getType())) != null) {
            action.run();
        }
    }

    public void propertyChanged(Object source, int propId) {
        if (source instanceof IAssociationMappingRegistry) {
            this.traceViewsMap.clear();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

