/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetType;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetsManager;
import org.eclipse.hyades.trace.ui.internal.launcher.TraceArguments;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSet;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetType;
import org.eclipse.hyades.trace.ui.launcher.IProfilingType;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ProfileJavaApplicationDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration conf, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("", 4);
            boolean success = ProfileJavaApplicationDelegate.performProfilingTypesLaunch(conf);
            monitor.worked(1);
            if (!success) {
                monitor.setCanceled(true);
                return;
            }
            ProfilingSetsManager manager = ProfilingSetsManager.instance();
            IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
            TraceArguments args = new TraceArguments(this.getMainTypeName(conf));
            args.setClassPath(this.getClasspathString(conf));
            args.setParameters(this.getProgramArguments(conf));
            args.setVMArguments(this.getVMArguments(conf));
            args.setEnvironmentVariable(manager.getEnvironmentVariables(conf));
            args.setAutoMonitoring(manager.getAutoMonitoring(conf));
            monitor.worked(1);
            String hostName = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, "localhost");
            int port = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, store.getInt("localhost_port"));
            String projectName = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, store.getString("prj_name"));
            String monitorName = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, store.getString("mon_name"));
            args.setHostName(hostName);
            args.setPortNumber(port);
            if (conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILE_TO_FILE, false)) {
                args.setProfileFile(conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, (String)null));
            }
            ArrayList filters = manager.getFilters(conf);
            Vector options = manager.getOptions(conf);
            monitor.worked(1);
            PDCoreUtil.launchTrace(args, filters, options, projectName, monitorName, launch);
            monitor.worked(1);
        }
        catch (CoreException e) {
            monitor.setCanceled(true);
            throw e;
        }
    }

    public static boolean performProfilingTypesLaunch(ILaunchConfiguration config) {
        boolean success = true;
        ProfilingSetsManager manager = ProfilingSetsManager.instance();
        IProfilingSet set = null;
        try {
            String setID = config.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_SET, (String)null);
            set = (IProfilingSet)manager.getProfilingSets().get(setID);
        }
        catch (CoreException e) {
            HyadesUIPlugin.logError((Throwable)e);
        }
        if (set == null) {
            return true;
        }
        IProfilingSetType[] profilingTypes = new ProfilingSetType[manager.getProfilingTypes().size()];
        profilingTypes = manager.getProfilingTypes().values().toArray(profilingTypes);
        List types = set.getProfilingTypes();
        int i = 0;
        while (i < profilingTypes.length) {
            IProfilingType type;
            String msg;
            if (types.contains(profilingTypes[i].getId()) && (msg = (type = profilingTypes[i].getProfilingType()).launch(config)) != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)UIPlugin.getResourceString("ERROR_DLG_CONFLICTS_TITLE"), (String)msg);
                    }
                });
                return false;
            }
            ++i;
        }
        return true;
    }

    private String getClasspathString(ILaunchConfiguration conf) throws CoreException {
        String classPath = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_CLASSPATH, (String)null);
        if (classPath == null) {
            StringBuffer buf = new StringBuffer();
            String[] entries = this.getClasspath(conf);
            int i = 0;
            while (i < entries.length - 1) {
                buf.append(entries[i]);
                buf.append(File.pathSeparatorChar);
                ++i;
            }
            buf.append(entries[entries.length - 1]);
            return buf.toString();
        }
        return classPath;
    }
}

