/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.preferences;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceHostUI;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class HostPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TraceHostUI _options;

    public HostPreferencePage() {
        this.setPreferenceStore(UIPlugin.getDefault().getPreferenceStore());
    }

    private void addHosts(String hosts) {
        if (hosts != null && !hosts.equals("")) {
            int idx = 0;
            while (idx != -1) {
                idx = hosts.indexOf(",");
                if (idx != -1) {
                    String host = hosts.substring(0, idx);
                    this._options.addHost(host);
                    hosts = hosts.substring(idx + 1);
                    continue;
                }
                this._options.addHost(hosts);
            }
        }
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        WorkbenchHelp.setHelp((Control)parent, (String)(UIPlugin.getPluginId() + ".hstp0000"));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this._options = new TraceHostUI();
        this._options.createControl(composite);
        return composite;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return UIPlugin.getDefault().getPreferenceStore();
    }

    public void init(IWorkbench workbench) {
    }

    private void initializeDefaults() {
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        this._options.reset();
        String hosts = store.getDefaultString("use_host");
        this.addHosts(hosts);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        UIPlugin.getDefault().savePluginPreferences();
        return true;
    }

    private void storeValues() {
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        String hosts = "";
        TableItem[] items = this._options.getHosts();
        int idx = 0;
        while (idx < items.length) {
            hosts = hosts + "," + items[idx].getText().trim();
            ++idx;
        }
        if (hosts.startsWith(",") && hosts.length() > 1) {
            hosts = hosts.substring(1);
        }
        store.setValue("use_host", hosts);
    }
}

