/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.AbstractChangeable;
import org.eclipse.hyades.trace.ui.internal.util.CTree;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;

public class DoubleCTree
extends AbstractChangeable {
    Composite _group;
    Composite groupWidget;
    public CTree sourceList;
    public CTree targetList;
    private CTree selectedList;
    public Label targetListLabel;
    public Label sourceListLabel;
    public Button add;
    public Button remove;
    public Button addAll;
    public Button removeAll;
    public Vector agentSelected = new Vector();
    private WizardPage _wizardPage;

    public void setSelectedAgents(Vector agents) {
        this.agentSelected = agents;
        this.updateSelectedTree(agents);
        this.changed();
    }

    private void updateSelectedTree(Vector selectedAgents) {
        TreeItem[] items = this.sourceList.getTree().getItems();
        int i = 0;
        while (i < items.length) {
            TreeItem temp = items[i];
            if (temp.getData() instanceof Process) {
                TreeItem[] sourceAgentItems = temp.getItems();
                int j = 0;
                while (j < sourceAgentItems.length) {
                    Agent agent;
                    if (sourceAgentItems[j].getData() instanceof Agent && this.IsAgentSelected(agent = (Agent)sourceAgentItems[j].getData(), selectedAgents)) {
                        this.moveFromSourceToTarget(sourceAgentItems[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void moveFromSourceToTarget(TreeItem item) {
        this.targetList.addItem(item, true);
        this.sourceList.remove(item);
    }

    private boolean IsAgentSelected(Agent agent, Vector selectedAgents) {
        int k = 0;
        while (k < selectedAgents.size()) {
            if (agent == (Agent)selectedAgents.elementAt(k)) {
                return true;
            }
            ++k;
        }
        return false;
    }

    public void addAgentToSelectList(TreeItem item) {
        if (item.getParentItem() != null) {
            this.addAgentSelected(item);
        } else {
            TreeItem[] agentItems = item.getItems();
            int k = 0;
            while (k < agentItems.length) {
                this.addAgentSelected(agentItems[k]);
                ++k;
            }
        }
    }

    public void removeAgentFromSelectList(TreeItem item) {
        if (item.getParentItem() != null) {
            this.removeAgentSelected(item);
        } else {
            TreeItem[] agentItems = item.getItems();
            int k = 0;
            while (k < agentItems.length) {
                this.removeAgentSelected(agentItems[k]);
                ++k;
            }
        }
    }

    private boolean vaildItemtoAdd(TreeItem item) {
        return !item.isDisposed() && item != null && (item.getParentItem() == null || !item.getParentItem().isDisposed());
    }

    public void addAgentSelected(TreeItem item) {
        Agent a = (Agent)item.getData();
        if (!this.agentSelected.contains(a)) {
            this.agentSelected.add(a);
        }
    }

    public void removeAgentSelected(TreeItem item) {
        Agent a = (Agent)item.getData();
        if (this.agentSelected.contains(a)) {
            this.agentSelected.remove(a);
        }
    }

    public void setWizardPage(WizardPage wizardPage) {
        this._wizardPage = wizardPage;
    }

    public DoubleCTree(Composite parent, int style, String groupText, String sourceTextID, String targetTextID) {
        this._group = new Composite(parent, style);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = -10;
        layout.horizontalSpacing = 0;
        this._group.setLayout((Layout)layout);
        this._group.setLayoutData((Object)GridUtil.createFill());
        this.createDoubleTree(this._group, sourceTextID, targetTextID);
        this.add.addListener(13, (Listener)new ButtonListener());
        this.remove.addListener(13, (Listener)new ButtonListener());
        this.addAll.addListener(13, (Listener)new ButtonListener());
        this.removeAll.addListener(13, (Listener)new ButtonListener());
        this.sourceList.getTree().addSelectionListener((SelectionListener)new TreeSelListener());
        this.targetList.getTree().addSelectionListener((SelectionListener)new TreeSelListener());
    }

    public void createDoubleTree(Composite parent, String sourceTextID, String targetTextID) {
        this.groupWidget = parent;
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.groupWidget.setLayout((Layout)layout);
        this.sourceList = new CTree(this.groupWidget, sourceTextID);
        this.sourceList.getTree().setLayoutData((Object)GridUtil.createFill());
        Composite buttonWidget = new Composite(this.groupWidget, 0);
        GridLayout blayout = new GridLayout();
        blayout.numColumns = 1;
        buttonWidget.setLayout((Layout)blayout);
        Label label = new Label(buttonWidget, 8);
        label.setText("");
        GridData spec = new GridData();
        spec.grabExcessVerticalSpace = true;
        spec.verticalAlignment = 4;
        label.setLayoutData((Object)spec);
        this.add = new Button(buttonWidget, 8);
        this.add.setText(UIPlugin.getResourceString("LEFT_TO_RIGHT"));
        spec = new GridData();
        spec.horizontalAlignment = 4;
        this.add.setLayoutData((Object)spec);
        this.remove = new Button(buttonWidget, 8);
        this.remove.setText(UIPlugin.getResourceString("RIGHT_TO_LEFT"));
        spec = new GridData();
        spec.horizontalAlignment = 4;
        this.remove.setLayoutData((Object)spec);
        new Label(buttonWidget, 0);
        this.addAll = new Button(buttonWidget, 8);
        this.addAll.setText(UIPlugin.getResourceString("LEFT_ALL_TO_RIGHT"));
        spec = new GridData();
        spec.horizontalAlignment = 4;
        this.addAll.setLayoutData((Object)spec);
        this.removeAll = new Button(buttonWidget, 8);
        this.removeAll.setText(UIPlugin.getResourceString("RIGHT_ALL_TO_LEFT"));
        spec = new GridData();
        spec.horizontalAlignment = 4;
        this.removeAll.setLayoutData((Object)spec);
        Label label1 = new Label(buttonWidget, 8);
        label1.setText("");
        spec = new GridData();
        spec.grabExcessVerticalSpace = true;
        spec.verticalAlignment = 4;
        label.setLayoutData((Object)spec);
        this.targetList = new CTree(this.groupWidget, targetTextID);
        this.targetList.getTree().setLayoutData((Object)GridUtil.createFill());
    }

    public void enable(boolean enable) {
        this._group.setEnabled(enable);
        this.add.setEnabled(enable);
        this.addAll.setEnabled(enable);
        this.remove.setEnabled(enable);
        this.removeAll.setEnabled(enable);
        this.sourceList.enable(enable);
        this.targetList.enable(enable);
    }

    public Control getControl() {
        return this._group;
    }

    private Vector getItems(CTree list) {
        Vector<TreeItem> items = new Vector<TreeItem>();
        int i = 0;
        while (i < list.getTree().getItemCount()) {
            TreeItem item = list.getItem(i);
            if (item != null) {
                items.addElement(item);
            }
            ++i;
        }
        return items;
    }

    public Vector getSelectedAgents() {
        return this.agentSelected;
    }

    public Vector getSourceItems() {
        return this.getItems(this.sourceList);
    }

    public Vector getTargetItems() {
        return this.getItems(this.targetList);
    }

    public String getText() {
        return this.getTargetItems().toString();
    }

    public Composite getWidget() {
        return this.groupWidget;
    }

    public void initialize(Enumeration processes, boolean showAll) {
        this.initialize(processes, showAll, false);
    }

    /*
     * Unable to fully structure code
     */
    public void initialize(Enumeration processes, boolean showAll, boolean showAttached) {
        block9: {
            block10: {
                block8: {
                    if (processes != null) break block8;
                    this.sourceList.initializeTree(null, showAll, showAttached);
                    this.targetList.initializeTree(null, showAll, showAttached);
                    break block9;
                }
                if (this.targetList.getItemCount() != 0) break block10;
                this.sourceList.initializeTree(processes, showAll, showAttached);
                this.targetList.initializeTree(null, showAll, showAttached);
                break block9;
            }
            allPIDList = new Vector<String>();
            while (processes.hasMoreElements()) {
                block11: {
                    process = (Process)processes.nextElement();
                    agents = process.listAgents();
                    pid = null;
                    try {
                        pid = process.getProcessId();
                        allPIDList.add(pid);
                    }
                    catch (Exception e) {
                        System.out.println("null pid");
                    }
                    sourceItem = this.getItemFromTree(this.sourceList, process);
                    targetItem = this.getItemFromTree(this.targetList, process);
                    if (sourceItem == null) break block11;
                    if (targetItem == null) ** GOTO lbl39
                    while (agents.hasMoreElements()) {
                        agent = (Agent)agents.nextElement();
                        agentItem = this.getAgentItem(targetItem, agent);
                        if (agentItem != null || (agentItem = this.getAgentItem(sourceItem, agent)) != null) continue;
                        this.createItemInSourceList(sourceItem, agent, showAttached);
                    }
                    this.removeAgentsInLists(process, targetItem, sourceItem);
                    continue;
lbl-1000:
                    // 1 sources

                    {
                        agent = (Agent)agents.nextElement();
                        agentItem = this.getAgentItem(sourceItem, agent);
                        if (agentItem != null) continue;
                        this.createItemInSourceList(sourceItem, agent, showAttached);
lbl39:
                        // 3 sources

                        ** while (agents.hasMoreElements())
                    }
lbl40:
                    // 1 sources

                    this.removeAgentsInLists(process, targetItem, sourceItem);
                    continue;
                }
                if (targetItem != null) {
                    processItem = null;
                    while (agents.hasMoreElements()) {
                        agent = (Agent)agents.nextElement();
                        agentItem = this.getAgentItem(targetItem, agent);
                        if (agentItem != null) continue;
                        if (processItem == null) {
                            processItem = this.sourceList.createItem(null, process, false);
                        }
                        this.createItemInSourceList(processItem, agent, showAttached);
                    }
                    this.removeAgentsInLists(process, targetItem, sourceItem);
                    continue;
                }
                this.sourceList.addProcessToTree(process, showAll, showAttached);
            }
            this.cleanUpSourceList(allPIDList);
            this.cleanUpTargetList(allPIDList);
        }
    }

    private void removeAgentsInLists(Process process, TreeItem targetItem, TreeItem sourceItem) {
        int i;
        int agentItemsSize;
        TreeItem[] agentItems;
        Agent agent = null;
        if (targetItem != null) {
            agentItems = targetItem.getItems();
            agentItemsSize = agentItems.length;
            i = 0;
            while (i < agentItemsSize) {
                agent = this.findAgentInProcess(process, agentItems[i].getText());
                if (agent == null) {
                    this.targetList.remove(agentItems[i]);
                    this.removeAgentFromSelectList(agentItems[i]);
                }
                ++i;
            }
        }
        if (sourceItem != null) {
            agentItems = sourceItem.getItems();
            agentItemsSize = agentItems.length;
            i = 0;
            while (i < agentItemsSize) {
                agent = this.findAgentInProcess(process, agentItems[i].getText());
                if (agent == null) {
                    this.sourceList.remove(agentItems[i]);
                    this.removeAgentFromSelectList(agentItems[i]);
                }
                ++i;
            }
        }
    }

    public Agent findAgentInProcess(Process process, String agentName) {
        Enumeration agents = process.listAgents();
        Agent agent = null;
        while (agents.hasMoreElements()) {
            agent = (Agent)agents.nextElement();
            if (!agent.getName().equals(agentName)) continue;
            return agent;
        }
        return null;
    }

    private void createItemInSourceList(TreeItem sourceItem, Agent agent, boolean showAttached) {
        boolean logAgentsEnabled = UIPlugin.getDefault().getPreferenceStore().getBoolean("log_option");
        boolean profileAgentsEnabled = UIPlugin.getDefault().getPreferenceStore().getBoolean("prof_option");
        if (agent.isActive() && (showAttached || !agent.isAttached())) {
            if (logAgentsEnabled && agent.getType().equals("Logging")) {
                this.sourceList.createItem(sourceItem, agent, false);
            } else if (profileAgentsEnabled && agent.getType().equals("Profiler")) {
                this.sourceList.createItem(sourceItem, agent, false);
            } else {
                ArrayList agentList = this.sourceList.getAgentTypeList();
                int i = 0;
                while (i < agentList.size()) {
                    if (!agent.getType().equals("Logging") && agent.getType().equals((String)agentList.get(i))) {
                        this.sourceList.createItem(sourceItem, agent, false);
                    }
                    ++i;
                }
            }
        }
    }

    public TreeItem getAgentItem(TreeItem treeItem, Agent agent) {
        TreeItem[] agentItems = treeItem.getItems();
        int i = 0;
        while (i < agentItems.length) {
            if (agentItems[i].getText().equals(agent.getName())) {
                return agentItems[i];
            }
            ++i;
        }
        return null;
    }

    public TreeItem getItemFromTree(CTree tree, Object obj) {
        int i = 0;
        while (i < tree.getTree().getItemCount()) {
            try {
                TreeItem item = tree.getItem(i);
                if (this.parseProcessID(item.getText()).equals(((Process)obj).getProcessId())) {
                    return item;
                }
            }
            catch (Exception e) {
                System.out.println("null pid");
            }
            ++i;
        }
        return null;
    }

    private String parseProcessID(String text) {
        if (text == null) {
            return null;
        }
        int sIdx = text.indexOf(":");
        int eIdx = text.indexOf("]");
        String pid = text.substring(sIdx + 1, eIdx);
        return pid;
    }

    private void cleanUpSourceList(Vector pidList) {
        TreeItem[] items = this.sourceList.getTree().getItems();
        Vector<TreeItem> v = new Vector<TreeItem>();
        int i = 0;
        while (i < items.length) {
            if (!pidList.contains(this.parseProcessID(items[i].getText()))) {
                v.add(items[i]);
                this.removeAgentFromSelectList(items[i]);
            }
            ++i;
        }
        this.removeFromTree(this.sourceList, v);
    }

    private void cleanUpTargetList(Vector pidList) {
        TreeItem[] items = this.targetList.getTree().getItems();
        Vector<TreeItem> v = new Vector<TreeItem>();
        int i = 0;
        while (i < items.length) {
            if (!pidList.contains(this.parseProcessID(items[i].getText()))) {
                v.add(items[i]);
                this.removeAgentFromSelectList(items[i]);
            }
            ++i;
        }
        this.removeFromTree(this.targetList, v);
    }

    private void removeFromTree(CTree tree, Vector v) {
        int i = 0;
        while (i < v.size()) {
            tree.remove((TreeItem)v.elementAt(i));
            ++i;
        }
    }

    public void removeAll() {
        this.targetList.getTree().removeAll();
        this.sourceList.getTree().removeAll();
    }

    public void setEnabled(boolean b) {
        this.targetList.getTree().setEnabled(b);
        this.sourceList.getTree().setEnabled(b);
    }

    public void setToolTipText(String text) {
        this.sourceList.setToolTipText(text);
        this.targetList.setToolTipText(text);
    }

    class ButtonListener
    implements Listener {
        ButtonListener() {
        }

        public void handleEvent(Event e) {
            if (e.widget == DoubleCTree.this.add) {
                DoubleCTree.this.targetList.getTree().setRedraw(false);
                DoubleCTree.this.sourceList.getTree().setRedraw(false);
                TreeItem[] items = DoubleCTree.this.sourceList.getSelectedItems();
                int i = 0;
                while (i < items.length) {
                    if (DoubleCTree.this.vaildItemtoAdd(items[i])) {
                        DoubleCTree.this.addAgentToSelectList(items[i]);
                        DoubleCTree.this.targetList.addItem(items[i], true);
                        DoubleCTree.this.sourceList.remove(items[i]);
                    }
                    ++i;
                }
                DoubleCTree.this.sourceList.clearSelection();
                if (DoubleCTree.this._wizardPage != null && DoubleCTree.this.agentSelected.size() > 0) {
                    DoubleCTree.this._wizardPage.setPageComplete(true);
                }
                DoubleCTree.this.targetList.getTree().setRedraw(true);
                DoubleCTree.this.sourceList.getTree().setRedraw(true);
            } else if (e.widget == DoubleCTree.this.addAll) {
                DoubleCTree.this.targetList.getTree().setRedraw(false);
                DoubleCTree.this.sourceList.getTree().setRedraw(false);
                int i = 0;
                while (i < DoubleCTree.this.sourceList.getTree().getItemCount()) {
                    TreeItem item = DoubleCTree.this.sourceList.getItem(i);
                    if (DoubleCTree.this.vaildItemtoAdd(item)) {
                        DoubleCTree.this.addAgentToSelectList(item);
                        DoubleCTree.this.targetList.addItem(item, false);
                    }
                    ++i;
                }
                DoubleCTree.this.sourceList.getTree().removeAll();
                DoubleCTree.this.targetList.getTree().selectAll();
                if (DoubleCTree.this._wizardPage != null && DoubleCTree.this.agentSelected.size() > 0) {
                    DoubleCTree.this._wizardPage.setPageComplete(true);
                }
                DoubleCTree.this.targetList.getTree().setRedraw(true);
                DoubleCTree.this.sourceList.getTree().setRedraw(true);
            } else if (e.widget == DoubleCTree.this.remove) {
                DoubleCTree.this.targetList.getTree().setRedraw(false);
                DoubleCTree.this.sourceList.getTree().setRedraw(false);
                TreeItem[] items = DoubleCTree.this.targetList.getSelectedItems();
                int i = 0;
                while (i < items.length) {
                    DoubleCTree.this.removeAgentFromSelectList(items[i]);
                    DoubleCTree.this.sourceList.addItem(items[i], false);
                    DoubleCTree.this.targetList.remove(items[i]);
                    ++i;
                }
                DoubleCTree.this.targetList.clearSelection();
                if (DoubleCTree.this.agentSelected.size() == 0 && DoubleCTree.this._wizardPage != null) {
                    DoubleCTree.this._wizardPage.setPageComplete(false);
                }
                DoubleCTree.this.targetList.getTree().setRedraw(true);
                DoubleCTree.this.sourceList.getTree().setRedraw(true);
            } else if (e.widget == DoubleCTree.this.removeAll) {
                DoubleCTree.this.targetList.getTree().setRedraw(false);
                DoubleCTree.this.sourceList.getTree().setRedraw(false);
                int i = 0;
                while (i < DoubleCTree.this.targetList.getTree().getItemCount()) {
                    TreeItem item = DoubleCTree.this.targetList.getItem(i);
                    DoubleCTree.this.removeAgentFromSelectList(item);
                    DoubleCTree.this.sourceList.addItem(item, false);
                    ++i;
                }
                DoubleCTree.this.targetList.getTree().removeAll();
                if (DoubleCTree.this._wizardPage != null) {
                    DoubleCTree.this._wizardPage.setPageComplete(false);
                }
                DoubleCTree.this.targetList.getTree().setRedraw(true);
                DoubleCTree.this.sourceList.getTree().setRedraw(true);
            }
            DoubleCTree.this.changed();
        }
    }

    class TreeSelListener
    implements SelectionListener {
        TreeSelListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == DoubleCTree.this.sourceList.getTree() && DoubleCTree.this.sourceList.getTree().getSelection().length != 0) {
                DoubleCTree.this.targetList.clearSelection();
            } else if (e.widget == DoubleCTree.this.targetList.getTree() && DoubleCTree.this.targetList.getTree().getSelection().length != 0) {
                DoubleCTree.this.sourceList.clearSelection();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            TreeItem[] items;
            if (e.widget == DoubleCTree.this.sourceList.getTree()) {
                TreeItem[] items2 = DoubleCTree.this.sourceList.getSelectedItems();
                if (items2.length > 0) {
                    int idx = 0;
                    while (idx < items2.length) {
                        DoubleCTree.this.addAgentToSelectList(items2[idx]);
                        DoubleCTree.this.targetList.addItem(items2[idx], true);
                        DoubleCTree.this.sourceList.remove(items2[idx]);
                        DoubleCTree.this.sourceList.clearSelection();
                        ++idx;
                    }
                    DoubleCTree.this.changed();
                }
            } else if (e.widget == DoubleCTree.this.targetList.getTree() && (items = DoubleCTree.this.targetList.getSelectedItems()).length > 0) {
                int idx = 0;
                while (idx < items.length) {
                    DoubleCTree.this.removeAgentFromSelectList(items[idx]);
                    DoubleCTree.this.sourceList.addItem(items[idx], false);
                    DoubleCTree.this.targetList.remove(items[idx]);
                    DoubleCTree.this.targetList.clearSelection();
                    ++idx;
                }
                DoubleCTree.this.changed();
            }
        }
    }
}

