/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.MonitorContentProvider;
import org.eclipse.hyades.trace.ui.internal.util.MonitorDrillDownComposite;
import org.eclipse.hyades.trace.ui.internal.util.MonitorLabelProvider;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class MonitorSelectionGroup
extends Composite {
    private Listener listener;
    private boolean allowNewContainerName = true;
    private Object selectedContainer;
    private Text containerNameField;
    private TreeViewer treeViewer;
    private static final int SIZING_SELECTION_PANE_HEIGHT = 250;
    private static final int SIZING_SELECTION_PANE_WIDTH = 250;

    public MonitorSelectionGroup(Composite parent, Listener listener, boolean allowNewContainerName) {
        this(parent, listener, allowNewContainerName, null);
    }

    public MonitorSelectionGroup(Composite parent, Listener listener, boolean allowNewContainerName, String message) {
        super(parent, 0);
        this.listener = listener;
        this.allowNewContainerName = allowNewContainerName;
        this.setFont(parent.getFont());
        if (message != null) {
            this.createContents(message);
        } else if (allowNewContainerName) {
            this.createContents(UIPlugin.getResourceString("STR_SELECT_MON_TEXT"));
        } else {
            this.createContents(UIPlugin.getResourceString("STR_SELECT_ONLY_TEXT"));
        }
    }

    public void containerSelectionChanged(Object container) {
        this.selectedContainer = container;
        if (this.allowNewContainerName) {
            String name;
            if (container == null) {
                this.containerNameField.setText("");
            } else if (container instanceof IFile) {
                name = ((IResource)container).getFullPath().makeRelative().toString();
                name = name.substring(0, name.lastIndexOf("."));
                this.containerNameField.setText(name);
            } else if (container instanceof IResource) {
                this.containerNameField.setText(((IResource)container).getFullPath().makeRelative().toString());
            } else if (container instanceof TRCMonitor) {
                name = TString.resourcePath(((TRCMonitor)container).eResource().getURI());
                name = name.substring(0, name.lastIndexOf("."));
                this.containerNameField.setText(name);
            }
        }
        if (this.listener != null) {
            Event changeEvent = new Event();
            changeEvent.type = 13;
            changeEvent.widget = this;
            this.listener.handleEvent(changeEvent);
        }
    }

    public void createContents(String message) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        Label label = new Label((Composite)this, 64);
        label.setText(message);
        label.setFont(this.getFont());
        if (this.allowNewContainerName) {
            this.containerNameField = new Text((Composite)this, 2052);
            this.containerNameField.setLayoutData((Object)new GridData(768));
            this.containerNameField.addListener(24, this.listener);
        } else {
            new Label((Composite)this, 0);
        }
        this.createTreeViewer();
    }

    protected void createTreeViewer() {
        MonitorDrillDownComposite drillDown = new MonitorDrillDownComposite(this, 2048);
        GridData spec = new GridData(1808);
        spec.widthHint = 250;
        spec.heightHint = 250;
        drillDown.setLayoutData(spec);
        this.treeViewer = new TreeViewer((Composite)drillDown, 0);
        drillDown.setChildTree(this.treeViewer);
        this.treeViewer.setContentProvider((IContentProvider)new MonitorContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new MonitorLabelProvider());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                MonitorSelectionGroup.this.containerSelectionChanged(selection.getFirstElement());
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object item = ((IStructuredSelection)selection).getFirstElement();
                    if (MonitorSelectionGroup.this.treeViewer.getExpandedState(item)) {
                        MonitorSelectionGroup.this.treeViewer.collapseToLevel(item, 1);
                    } else {
                        MonitorSelectionGroup.this.treeViewer.expandToLevel(item, 1);
                    }
                }
            }
        });
        this.treeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
    }

    public IPath getContainerFullPath() {
        if (this.allowNewContainerName) {
            String pathName = this.containerNameField.getText();
            if (pathName == null || pathName.length() < 1) {
                return null;
            }
            return new Path(pathName).makeAbsolute();
        }
        if (this.selectedContainer == null) {
            return null;
        }
        if (this.selectedContainer instanceof IResource) {
            return ((IResource)this.selectedContainer).getFullPath();
        }
        if (this.selectedContainer instanceof TRCMonitor) {
            return new Path(((TRCMonitor)this.selectedContainer).eResource().getURI().toString());
        }
        return new Path(this.selectedContainer.toString());
    }

    public void setInitialFocus() {
        if (this.allowNewContainerName) {
            this.containerNameField.setFocus();
        } else {
            this.treeViewer.getTree().setFocus();
        }
    }

    public void setSelectedContainer(Object container) {
        this.selectedContainer = container;
        ArrayList<IContainer> itemsToExpand = new ArrayList<IContainer>();
        if (container instanceof IContainer) {
            IContainer parent = ((IContainer)container).getParent();
            while (parent != null) {
                itemsToExpand.add(0, parent);
                parent = parent.getParent();
            }
            this.treeViewer.setExpandedElements(itemsToExpand.toArray());
            this.treeViewer.setSelection((ISelection)new StructuredSelection(container), true);
        }
    }
}

