/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceLocationUI;
import org.eclipse.hyades.trace.ui.internal.wizard.OpenLogAgentWizard;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class OpenLogAgentPage
extends WizardPage {
    protected TraceLocationUI _locationUI;
    protected Text _name;
    protected INavigator fViewer;

    public OpenLogAgentPage(String name, INavigator viewer) {
        super(name);
        this.setTitle(UIPlugin.getResourceString("LOG_AGENT_TITLE"));
        this.fViewer = viewer;
        this.setDescription("");
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 5;
        content.setLayout((Layout)layout);
        GridData gd = GridUtil.createFill();
        gd.widthHint = 500;
        gd.heightHint = 400;
        content.setLayoutData((Object)gd);
        this._locationUI = new TraceLocationUI();
        this._locationUI.createControl(content);
        this._locationUI.setEnabled(false);
        Composite nameGrp = new Composite(content, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 5;
        nameGrp.setLayout((Layout)layout);
        nameGrp.setLayoutData((Object)GridUtil.createHorizontalFill());
        Label nameLabel = new Label(nameGrp, 0);
        nameLabel.setText(UIPlugin.getResourceString("STR_AGENT_NAME"));
        this._name = new Text(nameGrp, 2048);
        this._name.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._name.setEnabled(false);
        this.setControl((Control)content);
        this.populateData();
        WorkbenchHelp.setHelp((Control)parent, (String)(UIPlugin.getPluginId() + ".olap0000"));
    }

    public boolean finish() {
        return true;
    }

    protected void populateData() {
        TRCAgentProxy agent;
        IResource sel = HyadesUtil.getSelectionFolder(this.fViewer);
        if (sel != null) {
            this._locationUI.setLocation(sel.getFullPath().toOSString());
        }
        if ((agent = ((OpenLogAgentWizard)this.getWizard()).getAgent()) == null) {
            return;
        }
        this._locationUI.setMonitor(agent.getProcessProxy().getNode().getMonitor().getName());
        this._name.setText(agent.getName());
    }
}

