/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileCollectionsUI;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.wizard.OpenProfAgentWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class OpenProfCollectionsPage
extends WizardPage {
    protected PDProjectExplorer fViewer;
    protected TraceProfileCollectionsUI _optionsUI;

    public OpenProfCollectionsPage(String name, PDProjectExplorer viewer) {
        super(name);
        this.setTitle(UIPlugin.getResourceString("PROF_LIMIT_TITLE"));
        this.setDescription(UIPlugin.getResourceString("PROF_LIMIT_DESC"));
        this.fViewer = viewer;
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 5;
        content.setLayout((Layout)layout);
        GridData gd = GridUtil.createFill();
        content.setLayoutData((Object)gd);
        this._optionsUI = new TraceProfileCollectionsUI();
        this._optionsUI.createControl(content);
        this._optionsUI.setWizardPage(this);
        TRCAgentProxy agent = ((OpenProfAgentWizard)this.getWizard()).getAgent();
        this.setControl((Control)content);
        this.populateData();
        this._optionsUI.enable(false);
        if (agent == null || !agent.isActive()) {
            this.setPageComplete(false);
            this._optionsUI.enable(false);
        }
        WorkbenchHelp.setHelp((Control)parent, (String)(UIPlugin.getPluginId() + ".opcp0000"));
    }

    public boolean finish(boolean shouldSend) {
        TRCAgentProxy agent = ((OpenProfAgentWizard)this.getWizard()).getAgent();
        if (agent == null || !agent.isActive()) {
            return true;
        }
        try {
            Object[] configs = agent.getConfigurations().toArray();
            if (configs.length > 0) {
                this.setConfiguration((TRCConfiguration)configs[0]);
            } else {
                HierarchyFactory factory = UIPlugin.getDefault().getPerftraceFactory();
                TRCConfiguration config = factory.createTRCConfiguration();
                config.setAgentProxy(agent);
                agent.getConfigurations().add((Object)config);
                this.setConfiguration(config);
            }
            if (shouldSend && agent.isActive() && agent.isMonitored()) {
                TRCProcessProxy process = agent.getProcessProxy();
                TRCNode node = process.getNode();
                this.sendConfigurationToAgent(agent, node.getName(), process.getPid());
            }
        }
        catch (ConcurrentModificationException exc) {
            exc.printStackTrace();
        }
        return true;
    }

    public boolean finish() {
        return this.finish(true);
    }

    private void sendConfigurationToAgent(TRCAgentProxy agent, String host, int processId) {
        block4: {
            Node node = PDCoreUtil.profileConnect(host, String.valueOf(agent.getProcessProxy().getNode().getPort()));
            if (node == null) {
                return;
            }
            Process p = node.getProcess(String.valueOf(processId));
            if (p == null) break block4;
            try {
                Agent a = p.getAgent(agent.getName());
                PDCoreUtil.setAgentConfiguration(agent, a);
                if (a != null && a.isActive()) {
                    a.publishConfiguration();
                    CustomCommand command = new CustomCommand();
                    command.setData("APPLYFILTERS");
                    a.invokeCustomCommand(command);
                }
            }
            catch (InactiveAgentException aex) {}
        }
    }

    protected void populateData() {
        TRCAgentProxy agent = ((OpenProfAgentWizard)this.getWizard()).getAgent();
        if (agent == null) {
            return;
        }
        EList options = null;
        EList configs = agent.getConfigurations();
        Iterator i = configs.iterator();
        if (i.hasNext()) {
            TRCConfiguration config = (TRCConfiguration)i.next();
            options = config.getOptions();
            this.updateConfigData(options);
            return;
        }
        this.updateConfigData(options);
    }

    protected void setConfiguration(TRCConfiguration config) {
        try {
            Object[] options = config.getOptions().toArray();
            HierarchyFactory factory = UIPlugin.getDefault().getPerftraceFactory();
            if (this._optionsUI.getLimitInvocations()) {
                TRCOption opt1;
                TRCOption opt = factory.createTRCOption();
                opt.setKey("BURST_MODE");
                if (this._optionsUI.getLimitTime()) {
                    opt.setValue("secondsAndInvocations");
                    opt1 = factory.createTRCOption();
                    opt1.setKey("BURST_SECONDS");
                    opt1.setValue(String.valueOf(this._optionsUI.getLimitTimeNb()));
                    opt1.setConfiguration(config);
                } else {
                    opt.setValue("invocations");
                }
                opt.setConfiguration(config);
                opt1 = factory.createTRCOption();
                opt1.setKey("BURST_INVOCATIONS");
                opt1.setValue(String.valueOf(this._optionsUI.getLimitInvocNb()));
                opt1.setConfiguration(config);
            } else if (this._optionsUI.getLimitTime()) {
                TRCOption opt = factory.createTRCOption();
                opt.setKey("BURST_MODE");
                opt.setKey("seconds");
                opt.setConfiguration(config);
                opt = factory.createTRCOption();
                opt.setKey("BURST_SECONDS");
                opt.setValue(String.valueOf(this._optionsUI.getLimitTimeNb()));
                opt.setConfiguration(config);
            }
        }
        catch (ConcurrentModificationException exc) {
            exc.printStackTrace();
        }
    }

    protected void updateConfigData(EList options) {
        if (options != null) {
            Iterator i = options.iterator();
            while (i.hasNext()) {
                TRCOption option = (TRCOption)i.next();
                if (option.getKey().equals("BURST_MODE")) {
                    if (option.getValue().equals("secondsAndInvocations")) {
                        this._optionsUI.setLimitInvocations(true);
                        this._optionsUI.setLimitTime(true);
                        continue;
                    }
                    if (option.getValue().equals("invocations")) {
                        this._optionsUI.setLimitInvocations(true);
                        this._optionsUI.setLimitTime(false);
                        continue;
                    }
                    if (!option.getValue().equals("seconds")) continue;
                    this._optionsUI.setLimitInvocations(false);
                    this._optionsUI.setLimitTime(true);
                    continue;
                }
                if (option.getKey().equals("BURST_INVOCATIONS")) {
                    this._optionsUI.setLimitInvocNb(option.getValue());
                    continue;
                }
                if (!option.getKey().equals("BURST_SECONDS")) continue;
                this._optionsUI.setLimitTimeNb(option.getValue());
            }
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (!((OpenProfAgentWizard)this.getWizard()).isProfilingAgent()) {
                this.getControl().setEnabled(false);
                this.getControl().setVisible(false);
                this.setDescription(UIPlugin.getResourceString("STR_LIMIT_IGNORED"));
            } else {
                this.getControl().setEnabled(true);
                this.getControl().setVisible(true);
                this.setDescription(UIPlugin.getResourceString("PROF_LIMIT_DESC"));
            }
        }
    }
}

