/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class Debugger {
    public String plugin_name = "";
    AbstractUIPlugin plugin = null;
    HashMap specials = new HashMap();
    public boolean PRINT_INFO = false;
    public boolean PRINT_WARNING = false;
    public boolean PRINT_ERROR = false;
    public boolean SHOW_THREAD = true;
    public boolean SHOW_CLASS = true;
    public boolean ALL_TO_STDOUT = false;
    public boolean ALL_TO_STDERR = false;
    public boolean PRINT_STACKTRACE = true;
    public boolean GENERATE_STACKTRACE = false;
    private HashMap mark_map = new HashMap();
    private static Object timers_lock = new Object();
    private static HashMap timers = new HashMap();

    public Debugger(String plugin_name) {
        this(null, plugin_name);
    }

    private void addSpecials(String s) {
        if (s == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(s, ",");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            System.out.println("DEBUGGER SPECIAL TOKEN:" + token);
            this.specials.put(token, new Boolean(true));
        }
    }

    public Debugger(AbstractUIPlugin plugin, String plugin_name) {
        String special_debug_info = System.getProperty("SPECIAL_DEBUG_INFO");
        this.addSpecials(special_debug_info);
        String special_debug = System.getProperty("SPECIAL_DEBUG");
        this.addSpecials(special_debug);
        String special_debug_all = System.getProperty("SPECIAL_DEBUG_ALL");
        if (special_debug_all != null) {
            special_debug_info = special_debug_all;
            special_debug = special_debug_all;
        }
        this.plugin = plugin;
        this.plugin_name = plugin_name;
        this.GENERATE_STACKTRACE = false;
        this.PRINT_STACKTRACE = true;
        this.ALL_TO_STDERR = false;
        this.ALL_TO_STDOUT = false;
        try {
            String debug = Platform.getDebugOption((String)(plugin_name + "/debug/error"));
            if (debug != null) {
                this.PRINT_ERROR = debug.equalsIgnoreCase("true");
            }
            if ((debug = Platform.getDebugOption((String)(plugin_name + "/debug/warning"))) != null) {
                this.PRINT_WARNING = debug.equalsIgnoreCase("true");
            }
            if ((debug = Platform.getDebugOption((String)(plugin_name + "/debug/info"))) != null) {
                this.PRINT_INFO = debug.equalsIgnoreCase("true");
            }
            boolean MASTER = false;
            debug = Platform.getDebugOption((String)(plugin_name + "/debug"));
            if (debug != null) {
                MASTER = debug.equalsIgnoreCase("true");
            }
            this.PRINT_ERROR = this.PRINT_ERROR && MASTER;
            this.PRINT_WARNING = this.PRINT_WARNING && MASTER;
            this.PRINT_INFO = this.PRINT_INFO && MASTER;
            debug = Platform.getDebugOption((String)(plugin_name + "/debug/showclass"));
            if (debug != null) {
                this.SHOW_CLASS = debug.equalsIgnoreCase("true");
            }
            if ((debug = Platform.getDebugOption((String)(plugin_name + "/debug/showthread"))) != null) {
                this.SHOW_THREAD = debug.equalsIgnoreCase("true");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (special_debug_info != null) {
            this.PRINT_INFO = true;
            this.PRINT_WARNING = true;
            this.PRINT_ERROR = true;
        }
        if (special_debug != null) {
            this.PRINT_WARNING = true;
            this.PRINT_ERROR = true;
        }
        this.info(plugin_name + " TEST INFORMATION MESSAGE");
        this.warning(plugin_name + " TEST WARNING MESSAGE");
        this.error(plugin_name + " TEST ERROR MESSAGE");
    }

    public void setPlugin(AbstractUIPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean check(String debug_option) {
        String special_debug = System.getProperty("SPECIAL_DEBUG_ALL");
        if (special_debug != null) {
            return true;
        }
        if (this.specials.get(debug_option) != null) {
            return true;
        }
        String debug = Platform.getDebugOption((String)(this.plugin_name + "/debug/" + debug_option));
        if (debug != null) {
            return debug.equalsIgnoreCase("true");
        }
        return false;
    }

    private void logStdOut(String message, String thread) {
        if (this.ALL_TO_STDERR) {
            System.err.print(message);
        } else {
            System.out.print(message);
        }
    }

    private void logStdErr(String message, String thread) {
        if (this.ALL_TO_STDOUT) {
            System.out.print(message);
        } else {
            System.err.print(message);
        }
    }

    public void mark(String textToPrint) {
        if (this.PRINT_INFO) {
            String caller = "";
            if (this.SHOW_CLASS) {
                caller = this.getCallerStackTrace();
            }
            String thread = "";
            if (this.SHOW_THREAD) {
                thread = Thread.currentThread().getName() + "/" + Thread.currentThread().hashCode();
            }
            long tmp = 0L;
            try {
                long now = System.currentTimeMillis();
                Long mark = (Long)this.mark_map.get(thread);
                if (mark == null) {
                    mark = new Long(System.currentTimeMillis());
                }
                tmp = now - mark;
                this.mark_map.put(thread, new Long(now));
            }
            catch (Exception e) {
                // empty catch block
            }
            String message = "M:(" + thread + "):(" + tmp + "ms):" + caller + ":" + textToPrint + "\n";
            this.logStdOut(message, thread);
        }
    }

    public void info(String textToPrint, Throwable t) {
        if (this.PRINT_INFO) {
            String caller = "";
            if (this.SHOW_CLASS) {
                caller = this.getCallerStackTrace();
            }
            String thread = "";
            if (this.SHOW_THREAD) {
                thread = Thread.currentThread().getName() + "/" + Thread.currentThread().hashCode();
            }
            String message = "I:(" + thread + "):" + caller + ":" + textToPrint + ": " + t + "\n";
            if (this.PRINT_STACKTRACE) {
                message = message + this.getStackTrace(t);
            }
            this.logStdOut(message, thread);
        }
    }

    public void info(String textToPrint) {
        if (this.PRINT_INFO) {
            String caller = "";
            if (this.SHOW_CLASS) {
                caller = this.getCallerStackTrace();
            }
            String thread = "";
            if (this.SHOW_THREAD) {
                thread = Thread.currentThread().getName() + "/" + Thread.currentThread().hashCode();
            }
            String message = "I:(" + thread + "):" + caller + ":" + textToPrint + "\n";
            this.logStdOut(message, thread);
        }
    }

    public void warning(String textToPrint, Throwable t) {
        if (this.PRINT_WARNING) {
            String caller = "";
            if (this.SHOW_CLASS) {
                caller = this.getCallerStackTrace();
            }
            String thread = "";
            if (this.SHOW_THREAD) {
                thread = Thread.currentThread().getName() + "/" + Thread.currentThread().hashCode();
            }
            String message = "W:(" + thread + "):" + caller + ":" + textToPrint + ": " + t + "\n";
            if (this.PRINT_STACKTRACE) {
                message = message + this.getStackTrace(t);
            }
            this.logStdOut(message, thread);
        }
    }

    public void warning(String textToPrint) {
        if (this.PRINT_WARNING) {
            String caller = "";
            if (this.SHOW_CLASS) {
                caller = this.getCallerStackTrace();
            }
            String thread = "";
            if (this.SHOW_THREAD) {
                thread = Thread.currentThread().getName() + "/" + Thread.currentThread().hashCode();
            }
            String message = "W:(" + thread + "):" + caller + ":" + textToPrint + "\n";
            if (this.GENERATE_STACKTRACE) {
                message = message + this.getStackTrace();
            }
            this.logStdOut(message, thread);
        }
    }

    public void error(String textToPrint, Throwable t) {
        if (this.PRINT_ERROR) {
            String caller = "";
            if (this.SHOW_CLASS) {
                caller = this.getCallerStackTrace();
            }
            String thread = "";
            if (this.SHOW_THREAD) {
                thread = Thread.currentThread().getName() + "/" + Thread.currentThread().hashCode();
            }
            String message = "E:(" + thread + "):" + caller + ":" + textToPrint + ": " + t + "\n";
            if (this.PRINT_STACKTRACE) {
                message = message + this.getStackTrace(t);
            }
            this.logStdErr(message, thread);
        }
    }

    public void error(String textToPrint) {
        if (this.PRINT_ERROR) {
            String caller = "";
            if (this.SHOW_CLASS) {
                caller = this.getCallerStackTrace();
            }
            String thread = "";
            if (this.SHOW_THREAD) {
                thread = Thread.currentThread().getName() + "/" + Thread.currentThread().hashCode();
            }
            String message = "E:(" + thread + "):" + caller + ":" + textToPrint + "\n";
            if (this.GENERATE_STACKTRACE) {
                message = message + this.getStackTrace();
            }
            this.logStdErr(message, thread);
        }
    }

    public void logVisibleError(Throwable t) {
        this.error("Error: " + t.getMessage(), t);
        this.logVisibleError(t, "Error: " + t.getMessage(), false);
    }

    public void logVisibleError(Throwable t, String error_msg, boolean show_dialog) {
        this.error(error_msg, t);
        if (this.plugin != null) {
            String plugin_id = this.plugin.getDescriptor().getUniqueIdentifier();
            String throwable_str = t.toString();
            Status status = new Status(4, plugin_id, 0, throwable_str, t);
            if (error_msg != null) {
                status = new Status(4, plugin_id, 0, error_msg, t);
            }
            this.plugin.getLog().log((IStatus)status);
            if (show_dialog) {
                MultiStatus mstatus = new MultiStatus(plugin_id, 4, throwable_str, t);
                StringBuffer sb = new StringBuffer();
                sb.append("Plugin ID...................").append(plugin_id).append("\n");
                sb.append("Plugin Provider.............").append(this.plugin.getDescriptor().getProviderName()).append("\n");
                sb.append("Plugin Version..............").append(this.plugin.getDescriptor().getVersionIdentifier()).append("\n");
                sb.append("Plugin Install URL..........").append(this.plugin.getDescriptor().getInstallURL()).append("\n");
                sb.append(this.getStackTrace(t));
                this.buildStatus(mstatus, sb.toString());
                Display display = this.plugin.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay();
                if (display == null) {
                    display = Display.getCurrent();
                }
                if (display == null) {
                    display = Display.getDefault();
                }
                display.syncExec((Runnable)new DialogShower(mstatus, error_msg, throwable_str));
            }
        } else {
            this.error("failed to log visible error - plugin is NULL", t);
        }
    }

    public void buildStatus(MultiStatus mstatus, String s) {
        s = s.replace('\t', ' ');
        StringTokenizer stok = new StringTokenizer(s, "\r\n");
        while (stok.hasMoreTokens()) {
            String tok = stok.nextToken();
            Status status = new Status(mstatus.getCode(), mstatus.getPlugin(), mstatus.getSeverity(), tok + "\r\n", mstatus.getException());
            mstatus.add((IStatus)status);
        }
    }

    private String getCallerStackTrace() {
        Throwable t = new Throwable();
        return this.getLineOfStackTrace(t, this.getStackTrace(t), 4);
    }

    private String getLineOfStackTrace(Throwable t, String stackTrace, int lineNumber) {
        int beginIndex = 0;
        int endIndex = 0;
        String cname = t.getClass().getName();
        int lastindex = stackTrace.lastIndexOf(cname);
        lastindex = lastindex == -1 ? 0 : (lastindex += cname.length());
        int index = lastindex;
        int i = 0;
        while (i < lineNumber) {
            beginIndex = index + 5;
            index = stackTrace.indexOf("\n", index + 1);
            endIndex = index - 1;
            ++i;
        }
        return stackTrace.substring(beginIndex, endIndex);
    }

    public String getStackTrace(Throwable t) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        t.printStackTrace(ps);
        return os.toString();
    }

    public String getStackTrace() {
        Throwable t = new Throwable("DEBUGGER GENERATED STACKTRACE");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        t.printStackTrace(ps);
        return os.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startAccumulator(String timer) {
        Object object = timers_lock;
        synchronized (object) {
            HashMap<String, Long> thread_timers = (HashMap<String, Long>)timers.get(Thread.currentThread());
            if (thread_timers == null) {
                thread_timers = new HashMap<String, Long>();
            }
            thread_timers.put("ACC:" + timer, new Long(System.currentTimeMillis()));
            timers.put(Thread.currentThread(), thread_timers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetAccumulator(String timer) {
        Object object = timers_lock;
        synchronized (object) {
            HashMap thread_timers = (HashMap)timers.get(Thread.currentThread());
            if (thread_timers == null) {
                return;
            }
            thread_timers.put("ACC_TOT:" + timer, new Long(0L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAccumulator(String timer) {
        Object object = timers_lock;
        synchronized (object) {
            HashMap thread_timers = (HashMap)timers.get(Thread.currentThread());
            if (thread_timers == null) {
                return "ACCUMULATOR NOT FOUND";
            }
            Long t = (Long)thread_timers.get("ACC_TOT:" + timer);
            if (t != null) {
                return timer + ":" + t;
            }
            return "ACCUMULATOR NOT FOUND";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String finishAccumulator(String timer) {
        Object object = timers_lock;
        synchronized (object) {
            HashMap thread_timers = (HashMap)timers.get(Thread.currentThread());
            if (thread_timers == null) {
                return "ACCUMULATOR NOT FOUND";
            }
            Long t = (Long)thread_timers.get("ACC:" + timer);
            long add = System.currentTimeMillis() - t;
            Long total = (Long)thread_timers.get("ACC_TOT:" + timer);
            if (total != null) {
                add += total.longValue();
            }
            thread_timers.put("ACC_TOT:" + timer, new Long(add));
            if (t != null) {
                return timer + ":" + add;
            }
            return "ACCUMULATOR NOT FOUND";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startTimer(String timer) {
        Object object = timers_lock;
        synchronized (object) {
            HashMap<String, Long> thread_timers = (HashMap<String, Long>)timers.get(Thread.currentThread());
            if (thread_timers == null) {
                thread_timers = new HashMap<String, Long>();
            }
            thread_timers.put("TIM:" + timer, new Long(System.currentTimeMillis()));
            timers.put(Thread.currentThread(), thread_timers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String finishTimer(String timer) {
        Object object = timers_lock;
        synchronized (object) {
            HashMap thread_timers = (HashMap)timers.get(Thread.currentThread());
            if (thread_timers == null) {
                return "TIMER NOT FOUND";
            }
            Long t = (Long)thread_timers.get("TIM:" + timer);
            if (t != null) {
                return timer + ":" + (System.currentTimeMillis() - t);
            }
            return "TIMER NOT FOUND";
        }
    }

    class DialogOpener
    implements Runnable {
        Shell shell;
        String msg;
        String throwable_str;
        Status status;

        DialogOpener() {
        }

        public void run() {
            ErrorDialog.openError((Shell)this.shell, (String)this.msg, (String)this.throwable_str, (IStatus)this.status);
        }
    }

    class DialogShower
    implements Runnable {
        MultiStatus mstatus;
        String error_msg;
        String throwable_str;

        public DialogShower(MultiStatus mstatus, String error_msg, String throwable_str) {
            this.mstatus = mstatus;
            this.error_msg = error_msg;
            this.throwable_str = throwable_str;
        }

        public void run() {
            try {
                IWorkbenchWindow def_window = Debugger.this.plugin.getWorkbench().getActiveWorkbenchWindow();
                if (def_window == null) {
                    def_window = Debugger.this.plugin.getWorkbench().getWorkbenchWindows()[0];
                }
                DialogOpener dialog = new DialogOpener();
                dialog.shell = def_window.getShell();
                dialog.status = this.mstatus;
                dialog.throwable_str = this.error_msg != null ? this.error_msg : this.throwable_str;
                dialog.msg = "Error in " + Debugger.this.plugin_name;
                dialog.shell.getDisplay().asyncExec((Runnable)dialog);
            }
            catch (Throwable x) {
                Debugger.this.error("failed to show error dialog", x);
            }
        }
    }
}

