/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.model.statistical.impl.StatisticalPackageImpl;
import org.eclipse.hyades.statistical.ui.Debugger;
import org.eclipse.hyades.statistical.ui.ImageManager;
import org.eclipse.hyades.statistical.ui.editor.internal.ImageRegistryProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class EditorPlugin
extends AbstractUIPlugin {
    public static final String PACKAGE_DEBUGGER = "org.eclipse.hyades.statistical.ui";
    public static final String PACKAGE_STATCON_MODULE = "org.eclipse.hyades.statistical.ui.StatConModule";
    public static final String PACKAGE_STATCON_FILE = "org.eclipse.hyades.statistical.ui.StatConFile";
    private static EditorPlugin plugin;
    public static Debugger DBG;
    private static ResourceBundle resourceBundle;
    public static ImageManager img;
    private static String infopops_id;

    public static void disposeObject(Object o) throws Throwable {
        Class<?> c = o.getClass();
        Throwable error = null;
        while (c != null) {
            try {
                Method o_dispose = c.getDeclaredMethod("dispose", new Class[0]);
                o_dispose.setAccessible(true);
                o_dispose.invoke(o, new Object[0]);
                error = null;
                break;
            }
            catch (Throwable e) {
                error = e;
                c = c.getSuperclass();
            }
        }
        if (error != null) {
            throw error;
        }
    }

    public EditorPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        DBG.setPlugin(this);
        DBG.info("StatCon Plugin Constructor");
        try {
            img.initialize(new URL(this.getDescriptor().getInstallURL(), "icons/full/"), ImageRegistryProvider.createImageRegistry());
            img.addImages();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        resourceBundle = this.getDescriptor().getResourceBundle();
        plugin = this;
        resourceBundle = this.getResourceBundle();
    }

    public static String getInfopopsId() {
        block2: {
            if (infopops_id != null) break block2;
            try {
                infopops_id = Platform.getPlugin((String)PACKAGE_DEBUGGER).getDescriptor().getUniqueIdentifier();
                DBG.info("Infopops Plugin ID = " + infopops_id);
            }
            catch (Throwable t) {
                DBG.logVisibleError(t, EditorPlugin.getString("ERROR_NO_INFOPOPS_ID"), false);
                infopops_id = PACKAGE_DEBUGGER;
            }
        }
        return infopops_id;
    }

    public void startup() throws CoreException {
        super.startup();
        DBG.info("calling StatisticalPackageImpl.init() to fix bugs");
        StatisticalPackageImpl.init();
    }

    public static EditorPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getString(String key) {
        try {
            return resourceBundle.getString(key);
        }
        catch (NullPointerException e) {
            return key;
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return resourceBundle;
    }

    public static Shell getActiveWorkbenchShell() {
        return EditorPlugin.getActiveWorkbenchWindow().getShell();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return EditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    static {
        DBG = new Debugger(PACKAGE_DEBUGGER);
        img = new ImageManager();
        infopops_id = null;
    }
}

