/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.variableloader.internal;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.hyades.model.statistical.SDContiguousObservation;
import org.eclipse.hyades.model.statistical.SDCounterDescriptor;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.model.statistical.SDRepresentation;
import org.eclipse.hyades.model.statistical.SDSampleWindow;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.model.statistical.SDTextObservation;
import org.eclipse.hyades.model.statistical.StatisticalFactory;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDGenericVariable;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDModifiableVariableRepresentation;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDVariableModifierProxy;
import org.eclipse.swt.graphics.Image;

public class SDModifiableVariable
extends SDGenericVariable
implements SDModifiableVariableRepresentation {
    public static final int NONE = -1;
    public static final int INTEGER = 0;
    public static final int LONG = 1;
    public static final int FLOAT = 2;
    public static final int DOUBLE = 3;
    public static final int STRING = 4;
    Object value = null;
    int measured_type = -1;
    int modifier_type = -1;
    StatisticalFactory factory = StatisticalFactory.eINSTANCE;
    SDMemberDescriptor descriptor;
    SDVariableModifierProxy modifier;
    SDCounterDescriptor measured_desc;
    SDCounterDescriptor requested_desc;
    SDSnapshotObservation measured;
    SDSnapshotObservation requested;
    double min_bound = Double.MIN_VALUE;
    double max_bound = Double.MAX_VALUE;
    Object last_requested;
    long last_req_time;
    Object last_measured;
    long last_mes_time;
    String[] possibles;

    public int getMeasuredType() {
        return this.measured_type;
    }

    public int getModifierType() {
        return this.modifier_type;
    }

    public String[] getEnumerationValues() {
        return this.possibles;
    }

    public void setEnumerationValues(String[] possible) {
        this.possibles = possible;
    }

    SDModifiableVariable(String unique_id, String name, String description, Image image, boolean has_bar, int measured_type, int modifier_type, SDMemberDescriptor descriptor, SDVariableModifierProxy modifier, double min, double max, SDSampleWindow window) {
        super(unique_id, name, description, image, has_bar);
        this.measured_type = measured_type;
        this.modifier_type = modifier_type;
        this.descriptor = descriptor;
        this.modifier = modifier;
        this.min_bound = min;
        this.max_bound = max;
        if (measured_type == 4) {
            this.measured = this.factory.createSDTextObservation();
            this.last_measured = null;
        } else {
            this.measured = this.factory.createSDContiguousObservation();
            this.last_measured = null;
        }
        this.measured.setWindow(window);
        if (modifier_type == 4) {
            this.requested = this.factory.createSDTextObservation();
            this.last_requested = null;
        } else {
            this.requested = this.factory.createSDContiguousObservation();
            this.last_requested = new Double(0.0);
        }
        this.requested.setWindow(window);
        this.requested_desc = this.factory.createSDCounterDescriptor();
        this.requested_desc.setParent((SDDescriptor)descriptor);
        this.requested_desc.setName(name + " - Requested");
        this.requested_desc.setDescription(description);
        this.measured_desc = this.factory.createSDCounterDescriptor();
        this.measured_desc.setParent((SDDescriptor)descriptor);
        this.measured_desc.setName(name + " - Measured");
        this.measured_desc.setDescription(description);
        this.requested_desc.setRepresentation((SDRepresentation)this);
        this.requested.setMemberDescriptor((SDMemberDescriptor)this.requested_desc);
        this.measured.setMemberDescriptor((SDMemberDescriptor)this.measured_desc);
    }

    public Object getLastMeasuredValue() {
        return this.last_measured;
    }

    public long getLastMeasuredTime() {
        return this.last_mes_time;
    }

    public Object getLastRequestedValue() {
        return this.last_requested;
    }

    public long getLastRequestedTime() {
        return this.last_req_time;
    }

    public double getMaxBound() {
        return this.max_bound;
    }

    public double getMinBound() {
        return this.min_bound;
    }

    private void addRequestedValue(long t, Double d) throws ClassCastException {
        SDContiguousObservation obs = (SDContiguousObservation)this.requested;
        BasicEList times = (BasicEList)obs.getCreationTime();
        BasicEList values = (BasicEList)obs.getValue();
        if (this.modifier_type == 0) {
            d = new Double(d.intValue());
        } else if (this.modifier_type == 1) {
            d = new Double(d.longValue());
        } else if (this.modifier_type == 2) {
            d = new Double(d.floatValue());
        }
        this.last_requested = d;
        this.last_req_time = t;
        this.addValue(times, values, t, d);
    }

    private void addRequestedValue(long t, String s) throws ClassCastException {
        SDTextObservation obs = (SDTextObservation)this.requested;
        BasicEList times = (BasicEList)obs.getCreationTime();
        BasicEList values = (BasicEList)obs.getTextValue();
        this.addValue(times, values, t, s);
        this.last_requested = s;
        this.last_req_time = t;
    }

    private void addMeasuredValue(long t, Double d) throws ClassCastException {
        SDContiguousObservation obs = (SDContiguousObservation)this.measured;
        BasicEList times = (BasicEList)obs.getCreationTime();
        BasicEList values = (BasicEList)obs.getValue();
        if (this.measured_type == 0) {
            d = new Double(d.intValue());
        } else if (this.measured_type == 1) {
            d = new Double(d.longValue());
        } else if (this.measured_type == 2) {
            d = new Double(d.floatValue());
        }
        this.addValue(times, values, t, d);
        this.last_measured = d;
        this.last_mes_time = t;
    }

    private void addMeasuredValue(long t, String s) throws ClassCastException {
        SDTextObservation obs = (SDTextObservation)this.measured;
        BasicEList times = (BasicEList)obs.getCreationTime();
        BasicEList values = (BasicEList)obs.getTextValue();
        this.addValue(times, values, t, s);
        this.last_measured = s;
        this.last_mes_time = t;
    }

    public void padRequestedValue(long t) throws ClassCastException {
        if (this.last_requested != null) {
            if (this.last_requested instanceof Double) {
                this.addRequestedValue(t, (Double)this.last_requested);
            } else {
                this.addRequestedValue(t, (String)this.last_requested);
            }
        }
    }

    public void padRequestedValue(long t, Object val) throws ClassCastException {
        if (val != null) {
            if (val instanceof Number) {
                this.addRequestedValue(t, new Double(((Number)this.last_requested).doubleValue()));
            } else {
                this.addRequestedValue(t, (String)val);
            }
        }
    }

    public void setRequestedValue(long t, int i) throws ClassCastException {
        this.addRequestedValue(t, new Double(i));
        this.modifier.requestValue(this.uid, i);
    }

    public void setRequestedValue(long t, long i) throws ClassCastException {
        this.addRequestedValue(t, new Double(i));
        this.modifier.requestValue(this.uid, i);
    }

    public void setRequestedValue(long t, float i) throws ClassCastException {
        this.addRequestedValue(t, new Double(i));
        this.modifier.requestValue(this.uid, i);
    }

    public void setRequestedValue(long t, double i) throws ClassCastException {
        this.addRequestedValue(t, new Double(i));
        this.modifier.requestValue(this.uid, i);
    }

    public void setRequestedValue(long t, Object newval) throws ClassCastException {
        if (this.modifier_type == 4) {
            this.addRequestedValue(t, (String)newval);
        } else {
            this.addRequestedValue(t, new Double(((Number)newval).doubleValue()));
        }
        this.modifier.requestValue(this.uid, newval);
    }

    public void setMeasuredValue(long t, int i) throws ClassCastException {
        this.addMeasuredValue(t, new Double(i));
    }

    public void setMeasuredValue(long t, long i) throws ClassCastException {
        this.addMeasuredValue(t, new Double(i));
    }

    public void setMeasuredValue(long t, float i) throws ClassCastException {
        this.addMeasuredValue(t, new Double(i));
    }

    public void setMeasuredValue(long t, double i) throws ClassCastException {
        this.addMeasuredValue(t, new Double(i));
    }

    public void setMeasuredValue(long t, Object newval) throws ClassCastException {
        if (this.measured_type == 4) {
            this.addMeasuredValue(t, (String)newval);
        } else {
            this.addMeasuredValue(t, new Double(((Number)newval).doubleValue()));
        }
    }
}

