/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.widgets.grapher.internal;

import java.util.Vector;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.BasicGraphSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.Graph;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.IndicatorSource;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.TimeZoomSlider;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.TimeZoomSliderTick;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSliderTick;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

public class ReferenceLineGraph
implements Graph {
    TimeZoomSlider xslider;
    ZoomSlider yslider;
    Color fg_col;
    int line_width = 1;
    boolean major;
    int line_style = 3;

    public ReferenceLineGraph(TimeZoomSlider xslider, ZoomSlider yslider, Color col, boolean major) {
        this.xslider = xslider;
        this.yslider = yslider;
        this.fg_col = col;
        this.major = major;
    }

    public BasicGraphSource getGraphSource() {
        return null;
    }

    public void setIndicatorSource(IndicatorSource isource) {
    }

    public double getXMin() {
        return Double.NEGATIVE_INFINITY;
    }

    public double getXMax() {
        return Double.POSITIVE_INFINITY;
    }

    public double getYMin() {
        return Double.NEGATIVE_INFINITY;
    }

    public double getYMax() {
        return Double.POSITIVE_INFINITY;
    }

    public TimeZoomSlider getXSlider() {
        return this.xslider;
    }

    public ZoomSlider getYSlider() {
        return this.yslider;
    }

    public void setXSlider(TimeZoomSlider slider) {
        this.xslider = slider;
    }

    public void setYSlider(ZoomSlider slider) {
        this.yslider = slider;
    }

    public void setForeground(Color col) {
        this.fg_col = col;
    }

    public Color getForeground() {
        return this.fg_col;
    }

    public void setLineWidth(int w) {
        this.line_width = w;
    }

    public int getLineWidth() {
        return this.line_width;
    }

    public void setLineStyle(int swt_line_style) {
        this.line_style = swt_line_style;
    }

    public int getLineStyle() {
        return this.line_style;
    }

    public void setUseIndicator(boolean b) {
    }

    public void paintGraph(GC gc, int x, int y, int w, int h) {
        int py1;
        gc.setForeground(this.fg_col);
        gc.setLineWidth(this.line_width);
        gc.setLineStyle(this.line_style);
        Vector yticks = this.yslider.getTickVector();
        double ystart = this.yslider.getMinVisible();
        double yend = this.yslider.getMaxVisible();
        Vector xticks = this.xslider.getTickVector();
        double xstart = this.xslider.pixel2Value(x);
        double xend = this.xslider.pixel2Value(x + w);
        int px1 = (int)this.xslider.value2Pixel(xstart);
        int px2 = (int)this.xslider.value2Pixel(xend);
        int tick = 0;
        while (tick < yticks.size()) {
            ZoomSliderTick ytick = (ZoomSliderTick)yticks.get(tick);
            if (ytick.textVisible && this.major) {
                py1 = (int)this.yslider.value2Pixel(ytick.value);
                gc.drawLine(px1, py1, px2, py1);
            } else if (!ytick.textVisible && !this.major) {
                py1 = (int)this.yslider.value2Pixel(ytick.value);
                gc.drawLine(px1, py1, px2, py1);
            }
            ++tick;
        }
        py1 = (int)this.yslider.value2Pixel(ystart);
        int py2 = (int)this.yslider.value2Pixel(yend);
        int tick2 = 0;
        while (tick2 < xticks.size()) {
            TimeZoomSliderTick xtick = (TimeZoomSliderTick)xticks.get(tick2);
            if (xtick.textVisible && this.major) {
                px1 = (int)this.xslider.value2Pixel(xtick.value);
                gc.drawLine(px1, py1, px1, py2);
            } else if (!xtick.textVisible && !this.major) {
                px1 = (int)this.xslider.value2Pixel(xtick.value);
                gc.drawLine(px1, py1, px1, py2);
            }
            ++tick2;
        }
    }

    public void setStaticScaling(double mult) {
    }

    public double getStaticScaling() {
        return 1.0;
    }
}

