/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.widgets.internal;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class BaseImageManager {
    private URL iconBaseURL;
    private ImageRegistry imageRegistry;
    private boolean loaded = false;

    protected void addImages() {
    }

    public void initialize(URL iconBaseURL, ImageRegistry imageRegistry) {
        this.iconBaseURL = iconBaseURL;
        this.imageRegistry = imageRegistry;
    }

    private void loadImages() {
        if (!this.loaded) {
            this.addImages();
            this.loaded = true;
        }
    }

    protected void add(String prefix, String name) {
        ImageDescriptor imageDescriptor = null;
        try {
            imageDescriptor = ImageDescriptor.createFromURL((URL)this.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException e) {
            imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        if (imageDescriptor != null) {
            if (this.imageRegistry == null) {
                EditorPlugin.DBG.error("IMAGE REGISTRY IS NULL!", new Throwable("null image registry"));
            }
            this.imageRegistry.put(name, imageDescriptor);
        } else {
            EditorPlugin.DBG.error("Image " + prefix + " " + name + " NOT FOUND!");
        }
    }

    private URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (this.iconBaseURL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(this.iconBaseURL, buffer.toString());
    }

    public ImageDescriptor getImageDescriptor(String key) {
        this.loadImages();
        return this.imageRegistry.getDescriptor(key);
    }

    public Image getImage(String key) {
        this.loadImages();
        return this.imageRegistry.get(key);
    }
}

