/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.hyades.test.ui.internal.editor.form.base.HyperlinkSegment;
import org.eclipse.hyades.test.ui.internal.editor.form.base.HyperlinkSettings;
import org.eclipse.hyades.test.ui.internal.editor.form.base.IHyperlinkSegment;
import org.eclipse.hyades.test.ui.internal.editor.form.base.IParagraph;
import org.eclipse.hyades.test.ui.internal.editor.form.base.IParagraphSegment;
import org.eclipse.hyades.test.ui.internal.editor.form.base.ITextSegment;
import org.eclipse.hyades.test.ui.internal.editor.form.base.Locator;
import org.eclipse.hyades.test.ui.internal.editor.form.base.TextSegment;
import org.eclipse.swt.graphics.GC;

public class Paragraph
implements IParagraph {
    public static final String HTTP = "http://";
    private Vector segments;
    private boolean addVerticalSpace = true;

    public Paragraph(boolean addVerticalSpace) {
        this.addVerticalSpace = addVerticalSpace;
    }

    public int getIndent() {
        return 0;
    }

    public boolean getAddVerticalSpace() {
        return this.addVerticalSpace;
    }

    public IParagraphSegment[] getSegments() {
        if (this.segments == null) {
            return new IParagraphSegment[0];
        }
        return this.segments.toArray(new IParagraphSegment[this.segments.size()]);
    }

    public void addSegment(IParagraphSegment segment) {
        if (this.segments == null) {
            this.segments = new Vector();
        }
        this.segments.add(segment);
    }

    public void parseRegularText(String text, boolean expandURLs, HyperlinkSettings settings, String fontId) {
        if (text.length() == 0) {
            return;
        }
        if (expandURLs) {
            int loc = text.indexOf(HTTP);
            if (loc == -1) {
                this.addSegment(new TextSegment(text, fontId));
            } else {
                int textLoc = 0;
                while (loc != -1) {
                    this.addSegment(new TextSegment(text.substring(textLoc, loc), fontId));
                    boolean added = false;
                    textLoc = loc;
                    while (textLoc < text.length()) {
                        char c = text.charAt(textLoc);
                        if (Character.isSpaceChar(c)) {
                            this.addHyperlinkSegment(text.substring(loc, textLoc), settings, fontId);
                            added = true;
                            break;
                        }
                        ++textLoc;
                    }
                    if (!added) {
                        this.addHyperlinkSegment(text.substring(loc), settings, fontId);
                        break;
                    }
                    loc = text.indexOf(HTTP, textLoc);
                }
                if (textLoc < text.length()) {
                    this.addSegment(new TextSegment(text.substring(textLoc), fontId));
                }
            }
        } else {
            this.addSegment(new TextSegment(text, fontId));
        }
    }

    private void addHyperlinkSegment(String text, HyperlinkSettings settings, String fontId) {
        HyperlinkSegment hs = new HyperlinkSegment(text, settings, fontId);
        hs.setWordWrapAllowed(false);
        hs.setActionId("urlHandler");
        this.addSegment(hs);
    }

    public void paint(GC gc, int width, Locator loc, int lineHeight, Hashtable objectTable, IHyperlinkSegment selectedLink) {
        IParagraphSegment[] segments = this.getSegments();
        if (segments.length > 0) {
            if (segments[0] instanceof ITextSegment && ((ITextSegment)segments[0]).isSelectable()) {
                ++loc.x;
            }
            int j = 0;
            while (j < segments.length) {
                IParagraphSegment segment = segments[j];
                boolean doSelect = false;
                if (selectedLink != null && segment.equals(selectedLink)) {
                    doSelect = true;
                }
                segment.paint(gc, width, loc, objectTable, doSelect);
                ++j;
            }
            loc.y += loc.rowHeight;
        } else {
            loc.y += lineHeight;
        }
    }

    public String getAccessibleText() {
        IParagraphSegment[] segments = this.getSegments();
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        int i = 0;
        while (i < segments.length) {
            IParagraphSegment segment = segments[i];
            if (segment instanceof ITextSegment) {
                String text = ((ITextSegment)segment).getText();
                writer.print(text);
            }
            ++i;
        }
        writer.println();
        swriter.flush();
        return swriter.toString();
    }

    public ITextSegment findSegmentAt(int x, int y) {
        if (this.segments != null) {
            int i = 0;
            while (i < this.segments.size()) {
                ITextSegment textSegment;
                IParagraphSegment segment = (IParagraphSegment)this.segments.get(i);
                if (segment instanceof ITextSegment && (textSegment = (ITextSegment)segment).contains(x, y)) {
                    return textSegment;
                }
                ++i;
            }
        }
        return null;
    }
}

