/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.test.ui.internal.editor.extension.IExtensibleEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormSection;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.util.ExtensionElementLink;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class RegisteredExtensionsSection
extends FormSection
implements IDisposable {
    private IExtensibleEditorExtension editorExtension;
    private IConfigurationElement[] extensionElements;
    private FormWidgetFactory factory;
    private Composite hyperlinksParent;

    public RegisteredExtensionsSection(IExtensibleEditorExtension editorExtension, IConfigurationElement[] extElements) {
        this.editorExtension = editorExtension;
        this.extensionElements = extElements;
        this.setCollapsable(true);
    }

    public void dispose() {
        this.editorExtension = null;
        this.factory = null;
        this.hyperlinksParent = null;
        super.dispose();
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        this.factory = factory;
        Composite container = factory.createComposite(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        container.setLayout((Layout)gridLayout);
        container.setLayoutData((Object)GridDataUtil.createFill());
        this.hyperlinksParent = factory.createComposite(container);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 2;
        this.hyperlinksParent.setLayout((Layout)gridLayout);
        this.hyperlinksParent.setLayoutData((Object)GridDataUtil.createFill());
        this.createLinkedElements();
        return container;
    }

    private void createLinkedElements() {
        if (this.extensionElements == null || this.extensionElements.length == 0) {
            return;
        }
        int i = 0;
        while (i < this.extensionElements.length) {
            ExtensionElementLink link = new ExtensionElementLink(this.editorExtension);
            link.create(this.factory, this.hyperlinksParent, this.extensionElements[i]);
            ++i;
        }
        this.hyperlinksParent.pack(true);
        Composite parent = this.hyperlinksParent.getParent();
        parent.setSize(parent.computeSize(parent.getSize().x, -1));
        parent.getParent().setSize(parent.getParent().computeSize(parent.getParent().getSize().x, -1));
    }
}

