/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.SelectableFormLabel;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class WidgetFactory
extends FormWidgetFactory
implements IDisposable {
    private VisibilityHandler visibilityHandler = new VisibilityHandler();
    private BorderPainter borderPainter = new BorderPainter();

    public WidgetFactory() {
        this(Display.getCurrent());
    }

    public WidgetFactory(Display display) {
        super(display);
    }

    public void dispose() {
        this.visibilityHandler = null;
        this.borderPainter = null;
        super.dispose();
    }

    protected VisibilityHandler getVisibilityHandler() {
        return this.visibilityHandler;
    }

    protected BorderPainter getBorderPainter() {
        return this.borderPainter;
    }

    public StyledText createStyledText(Composite parent, int style) {
        StyledText styledText = new StyledText(parent, style);
        styledText.setBackground(this.getBackgroundColor());
        styledText.setForeground(this.getForegroundColor());
        styledText.addFocusListener((FocusListener)this.getVisibilityHandler());
        return styledText;
    }

    public CCombo createCCombo(Composite parent, int style) {
        CCombo combo = new CCombo(parent, style);
        combo.setBackground(this.getBackgroundColor());
        combo.setForeground(this.getForegroundColor());
        combo.addFocusListener((FocusListener)this.getVisibilityHandler());
        return combo;
    }

    public void paintBordersFor(Composite parent) {
        parent.addPaintListener((PaintListener)this.getBorderPainter());
    }

    protected static class VisibilityHandler
    extends FocusAdapter {
        protected VisibilityHandler() {
        }

        public void focusGained(FocusEvent e) {
            Widget w = e.widget;
            if (w instanceof Control) {
                FormWidgetFactory.ensureVisible((Control)w);
            }
        }
    }

    protected class BorderPainter
    implements PaintListener {
        protected BorderPainter() {
        }

        public void paintControl(PaintEvent event) {
            Composite composite = (Composite)event.widget;
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                block13: {
                    GC gc;
                    Rectangle b;
                    boolean inactiveBorder;
                    Control c;
                    block14: {
                        c = children[i];
                        if ("Luiz".equals(c.getData())) {
                            System.out.println("Here");
                        }
                        inactiveBorder = false;
                        if (!c.getEnabled() && !(c instanceof CCombo) || c instanceof SelectableFormLabel) break block13;
                        Object flag = c.getData("FormWidgetFactory.drawBorder");
                        if (flag == null) break block14;
                        if (flag.equals(Boolean.FALSE)) break block13;
                        if (flag.equals("treeBorder")) {
                            inactiveBorder = true;
                        }
                    }
                    if (!inactiveBorder && (c instanceof Text || c instanceof Canvas || c instanceof CCombo)) {
                        b = c.getBounds();
                        gc = event.gc;
                        gc.setForeground(c.getBackground());
                        gc.drawRectangle(b.x - 1, b.y - 1, b.width + 1, b.height + 1);
                        gc.setForeground(WidgetFactory.this.getForegroundColor());
                        if (c instanceof CCombo) {
                            gc.drawRectangle(b.x - 1, b.y - 1, b.width + 1, b.height + 1);
                        } else if (c instanceof StyledText) {
                            gc.drawRectangle(b.x - 2, b.y - 2, b.width + 2, b.height + 3);
                        } else {
                            gc.drawRectangle(b.x - 1, b.y - 2, b.width + 1, b.height + 3);
                        }
                    } else if (inactiveBorder || c instanceof Table || c instanceof Tree || c instanceof TableTree) {
                        b = c.getBounds();
                        gc = event.gc;
                        gc.setForeground(WidgetFactory.this.getBorderColor());
                        gc.drawRectangle(b.x - 1, b.y - 1, b.width + 2, b.height + 2);
                    }
                }
                ++i;
            }
        }
    }
}

