/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.launch.providers;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.IHyadesTestNavigatorConverter;
import org.eclipse.hyades.test.ui.IHyadesTestNavigatorProvider;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.launch.extensions.LaunchConfigurationExtensionsManager;
import org.eclipse.hyades.test.ui.internal.model.ui.ITypeProviderFactory;
import org.eclipse.hyades.test.ui.internal.navigator.TestCaseHTNProvider;
import org.eclipse.hyades.test.ui.internal.navigator.TestSuiteHTNConverter;
import org.eclipse.hyades.test.ui.internal.navigator.TestSuiteHTNProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class TestProvider
extends LabelProvider
implements ITreeContentProvider {
    private IHyadesTestNavigatorConverter testSuiteConverter = new TestSuiteHTNConverter();
    private IHyadesTestNavigatorProvider testSuiteProvider = new TestSuiteHTNProvider(emptyTypeProviderFactory);
    private IHyadesTestNavigatorProvider testCaseProvider = new TestCaseHTNProvider(emptyTypeProviderFactory);
    private String mode;
    private String launchConfigurationType;
    private static ITypeProviderFactory emptyTypeProviderFactory = new ITypeProviderFactory(){

        public IHyadesTestNavigatorProvider getProvider(String type) {
            return null;
        }
    };
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;

    public TestProvider(String mode, String launchConfigurationType) {
        this.mode = mode;
        this.launchConfigurationType = launchConfigurationType;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IContainer) {
            try {
                IContainer container = (IContainer)parentElement;
                IResource[] members = container.members();
                ArrayList<Object> children = new ArrayList<Object>(members.length);
                int i = 0;
                while (i < members.length) {
                    Object converted;
                    if (members[i] instanceof IContainer) {
                        children.add(members[i]);
                    } else if (members[i] instanceof IFile && (converted = this.testSuiteConverter.getObjectFromResource(members[i])) != null && converted instanceof TPFTestSuite && this.isLaunchable((TPFTest)((TPFTestSuite)converted))) {
                        children.add(converted);
                    }
                    ++i;
                }
                return children.toArray();
            }
            catch (CoreException e) {
                TestUIPlugin.logError(e);
                return new Object[0];
            }
        }
        if (parentElement instanceof TPFTestSuite) {
            Object[] children = this.testSuiteProvider.getChildren(parentElement);
            ArrayList<Object> childlist = new ArrayList<Object>(children.length);
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof TPFTestCase && this.isLaunchable((TPFTest)((TPFTestCase)children[i]))) {
                    childlist.add(children[i]);
                }
                ++i;
            }
            return childlist.toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        if (element instanceof TPFTestSuite) {
            return this.testSuiteProvider.getParent(element);
        }
        if (element instanceof TPFTestCase) {
            return this.testCaseProvider.getParent(element);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Image getImage(Object element) {
        if (element instanceof IContainer) {
            ImageDescriptor descriptor;
            IWorkbenchAdapter workbenchAdapter = this.getWorkbenchAdapter(element);
            if (workbenchAdapter != null && (descriptor = workbenchAdapter.getImageDescriptor(element)) != null) {
                return descriptor.createImage();
            }
        } else {
            if (element instanceof TPFTestSuite) {
                return this.testSuiteProvider.getImage(element);
            }
            if (element instanceof TPFTestCase) {
                return this.testCaseProvider.getImage(element);
            }
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof IContainer) {
            IWorkbenchAdapter workbenchAdapter = this.getWorkbenchAdapter(element);
            if (workbenchAdapter != null) {
                return workbenchAdapter.getLabel(element);
            }
        } else {
            if (element instanceof TPFTestSuite) {
                return this.testSuiteProvider.getText(element);
            }
            if (element instanceof TPFTestCase) {
                return this.testCaseProvider.getText(element);
            }
        }
        return null;
    }

    private boolean isLaunchable(TPFTest test) {
        return LaunchConfigurationExtensionsManager.getInstance().isLaunchableElement(test, this.mode, this.launchConfigurationType);
    }

    private IWorkbenchAdapter getWorkbenchAdapter(Object object) {
        IWorkbenchAdapter workbenchAdapter = (IWorkbenchAdapter)Platform.getAdapterManager().getAdapter(object, class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = TestProvider.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter);
        if (workbenchAdapter == this) {
            return null;
        }
        return workbenchAdapter;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

