/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.launch.tabs;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.launch.extensions.LaunchConfigurationExtensionsManager;
import org.eclipse.hyades.test.ui.internal.launch.providers.DeploymentProvider;
import org.eclipse.hyades.test.ui.internal.launch.providers.TestProvider;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.launch.configurations.DeploymentLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.configurations.TestLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.extensions.IDeploymentsProvider;
import org.eclipse.hyades.test.ui.launch.extensions.ITestLaunchConfigurationValidator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.IWorkbenchPage;

public class TestAndDeploymentTab
extends AbstractLaunchConfigurationTab {
    protected TreeViewer testTreeViewer;
    protected ListViewer deploymentListViewer;
    private String mode;
    private String launchConfigurationType;

    public TestAndDeploymentTab(String mode, String launchConfigurationType) {
        this.mode = mode;
        this.launchConfigurationType = launchConfigurationType;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.horizontalSpacing = 25;
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        Label lblTest = new Label(composite, 0);
        GridData gdLblTest = new GridData(32);
        lblTest.setLayoutData((Object)gdLblTest);
        lblTest.setText(TestUIPlugin.getString("TestAndDeploymentTab.selectTestPrompt"));
        Label lblDeployment = new Label(composite, 0);
        GridData gdLblDeployment = new GridData(32);
        lblDeployment.setLayoutData((Object)gdLblDeployment);
        lblDeployment.setText(TestUIPlugin.getString("TestAndDeploymentTab.selectDeploymentPrompt"));
        this.createTestSelector(composite);
        this.createDeploymentSelector(composite);
        this.setControl((Control)composite);
    }

    private void createTestSelector(Composite composite) {
        GridData grid = new GridData(1808);
        grid.widthHint = 250;
        grid.heightHint = 150;
        this.testTreeViewer = new TreeViewer(composite);
        this.testTreeViewer.getControl().setLayoutData((Object)grid);
        TestProvider provider = new TestProvider(this.mode, this.launchConfigurationType);
        this.testTreeViewer.setContentProvider((IContentProvider)provider);
        this.testTreeViewer.setLabelProvider((IBaseLabelProvider)provider);
        this.testTreeViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.testTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TPFTestSuite deploymentInput = TestAndDeploymentTab.this.fillDeploymentsList(TestAndDeploymentTab.this.getSelectedTest());
                IDeploymentsProvider dprovider = LaunchConfigurationExtensionsManager.getInstance().getDeploymentsProvider(deploymentInput);
                TPFDeployment defaultDeployment = dprovider.getDefaultDeployment(deploymentInput);
                StructuredSelection selection = defaultDeployment != null ? new StructuredSelection((Object)defaultDeployment) : new StructuredSelection();
                TestAndDeploymentTab.this.deploymentListViewer.setSelection((ISelection)selection);
                TestAndDeploymentTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createDeploymentSelector(Composite composite) {
        GridData grid = new GridData(1808);
        grid.widthHint = 250;
        grid.heightHint = 150;
        this.deploymentListViewer = new ListViewer(composite);
        this.deploymentListViewer.getControl().setLayoutData((Object)grid);
        DeploymentProvider provider = new DeploymentProvider();
        this.deploymentListViewer.setContentProvider((IContentProvider)provider);
        this.deploymentListViewer.setLabelProvider((IBaseLabelProvider)provider);
        this.deploymentListViewer.setComparer((IElementComparer)provider);
        this.deploymentListViewer.setInput(null);
        this.deploymentListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TestAndDeploymentTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected TPFTestSuite fillDeploymentsList(TPFTest test) {
        TPFTestSuite deploymentInput = null;
        if (test != null) {
            if (test instanceof TPFTestSuite) {
                deploymentInput = (TPFTestSuite)test;
            } else if (test instanceof TPFTestCase) {
                deploymentInput = ((TPFTestCase)test).getTestSuite();
            }
        }
        this.deploymentListViewer.setInput(deploymentInput);
        return deploymentInput;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        TestLaunchConfigurationFacade.setTest(configuration, TestAndDeploymentTab.getContext());
    }

    protected TPFTest getSelectedTest() {
        Object obj;
        ISelection selection = this.testTreeViewer.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof TPFTest) {
            return (TPFTest)obj;
        }
        return null;
    }

    protected TPFDeployment getSelectedDeployment() {
        Object obj;
        ISelection selection = this.deploymentListViewer.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof TPFDeployment) {
            return (TPFDeployment)obj;
        }
        return null;
    }

    private void setDeploymentSelection(TPFDeployment deployment) {
        List list = this.deploymentListViewer.getList();
        list.deselectAll();
        if (deployment == null) {
            return;
        }
        int n = list.getItemCount();
        IElementComparer comparer = this.deploymentListViewer.getComparer();
        int i = 0;
        while (i < n) {
            if (comparer.equals((Object)deployment, this.deploymentListViewer.getElementAt(i))) {
                list.select(i);
                return;
            }
            ++i;
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        block3: {
            try {
                TPFTest test = TestLaunchConfigurationFacade.getTest(configuration);
                if (test != null) {
                    this.testTreeViewer.setSelection((ISelection)new StructuredSelection((Object)test), true);
                    this.fillDeploymentsList(test);
                    TPFDeployment depl = DeploymentLaunchConfigurationFacade.getDeployment(configuration);
                    this.setDeploymentSelection(depl);
                    break block3;
                }
                this.testTreeViewer.setSelection((ISelection)new StructuredSelection());
                this.deploymentListViewer.setSelection((ISelection)new StructuredSelection());
            }
            catch (CoreException e) {
                TestUIPlugin.logError(e);
            }
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        TPFTest test = this.getSelectedTest();
        TestLaunchConfigurationFacade.setTest(configuration, test);
        TPFDeployment depl = this.getSelectedDeployment();
        DeploymentLaunchConfigurationFacade.setDeployment(configuration, depl);
    }

    public String getName() {
        return TestUIPlugin.getString("TestAndDeploymentTab.testTabName");
    }

    public Image getImage() {
        return TestUIImages.INSTANCE.getImage("launch_testtab.gif");
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        ITestLaunchConfigurationValidator.Diagnostic diag;
        TPFDeployment depl;
        TPFTest test;
        this.setErrorMessage(null);
        try {
            test = TestLaunchConfigurationFacade.getTest(launchConfig);
        }
        catch (CoreException e) {
            test = null;
        }
        if (test == null) {
            this.setErrorMessage(TestUIPlugin.getString("_ERROR_TestAndDeploymentTab.noTestError"));
            return false;
        }
        if (this.deploymentListViewer.getList().getItemCount() == 0) {
            this.setErrorMessage("There are no Deployments available for the selected Test.");
            return false;
        }
        try {
            depl = DeploymentLaunchConfigurationFacade.getDeployment(launchConfig);
        }
        catch (CoreException e1) {
            depl = null;
        }
        if (depl == null) {
            this.setErrorMessage(TestUIPlugin.getString("_ERROR_TestAndDeploymentTab.noDeploymentError"));
            return false;
        }
        ITestLaunchConfigurationValidator validator = LaunchConfigurationExtensionsManager.getInstance().getLaunchConfigurationValidator(test);
        if (validator != null && (diag = validator.validate(launchConfig)) != null) {
            this.setErrorMessage(diag.getMessage());
            return diag.getSeverity() != 0;
        }
        return true;
    }

    public static TPFTest getContext() {
        block4: {
            try {
                IFile file;
                IStructuredSelection ss;
                Object obj;
                ISelection selection;
                IWorkbenchPage page = TestUIPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (page == null || !((selection = page.getSelection()) instanceof IStructuredSelection) || (obj = (ss = (IStructuredSelection)selection).getFirstElement()) == null) break block4;
                if (obj instanceof TPFTest) {
                    return (TPFTest)obj;
                }
                if (obj instanceof IFile && "testsuite".equals((file = (IFile)obj).getFileExtension())) {
                    return TestAndDeploymentTab.loadTestSuite(file);
                }
            }
            catch (Throwable t) {
                TestUIPlugin.logError(t);
            }
        }
        return null;
    }

    private static TPFTestSuite loadTestSuite(IFile resource) {
        EObject[] eobjs = EMFUtil.load(null, resource);
        int i = 0;
        while (i < eobjs.length) {
            if (eobjs[i] instanceof TPFTestSuite) {
                return (TPFTestSuite)eobjs[i];
            }
            ++i;
        }
        return null;
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }
}

