/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.launch.tabGroups;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.hyades.test.ui.internal.launch.tabs.ExecutionHistoryTab;
import org.eclipse.hyades.test.ui.internal.launch.tabs.TestAndDeploymentTab;
import org.eclipse.hyades.test.ui.internal.launch.tabs.TestComponentAndDeploymentTab;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileTab;

public abstract class AbstractTabGroup
extends AbstractLaunchConfigurationTabGroup {
    public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
        ArrayList tabs = new ArrayList(5);
        this.addRunnableItemSelectionTab(tabs, mode);
        this.addExecutionHistoryTab(tabs);
        this.addAdditionalTabs(tabs, mode);
        if (this.isProfilingMode(mode)) {
            this.addProfilingTab(tabs, true);
        }
        this.addCommonTab(tabs);
        ILaunchConfigurationTab[] array = new ILaunchConfigurationTab[tabs.size()];
        tabs.toArray(array);
        this.setTabs(array);
    }

    protected boolean isProfilingMode(String mode) {
        return mode.equals("profile");
    }

    protected void addExecutionHistoryTab(List tabList) {
        tabList.add(new ExecutionHistoryTab());
    }

    protected void addProfilingTab(List tabList, boolean attach) {
        tabList.add(new ProfileTab(attach));
    }

    protected void addCommonTab(List tabList) {
        tabList.add(new CommonTab());
    }

    protected void addTestAndDeploymentTab(List tabList, String mode, String launchConfigurationType) {
        tabList.add(new TestAndDeploymentTab(mode, launchConfigurationType));
    }

    protected void addTestComponentAndDeploymentTab(List tabList, String mode, String launchConfigurationType) {
        tabList.add(new TestComponentAndDeploymentTab(mode, launchConfigurationType));
    }

    protected abstract void addRunnableItemSelectionTab(List var1, String var2);

    protected abstract void addAdditionalTabs(List var1, String var2);
}

