/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.perfmon;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.ControlMessage;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.common.SetNVPairCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessFactory;
import org.eclipse.hyades.internal.execution.local.control.ProcessListener;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.perfmon.PerfmonLoader;
import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.perfmon.StatisticalLoaderListener;
import org.eclipse.hyades.perfmon.StatisticalXMLTranslator;
import org.eclipse.hyades.perfmon.xml.XMLParser;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.ProcessAdapter;

public class PerfmonCustomLoader
extends PerfmonLoader
implements DataProcessor {
    ArrayList listeners = new ArrayList();
    long started;
    String tracename;
    Node node;
    Process process;
    Agent agent;
    TRCAgent trcagent;
    boolean running = false;
    XMLParser parser = new XMLParser();
    StatisticalXMLTranslator translator;

    public PerfmonCustomLoader(long started, TRCAgent tagent, String modelname, String host, int port, String remote_host, int freq) throws Exception {
        this.started = started;
        this.init(modelname, tagent, host, port, remote_host, freq);
    }

    public PerfmonCustomLoader(long started, TRCAgent tagent, String modelname, String host, String remote_host, int freq) throws Exception {
        this.started = started;
        this.init(modelname, tagent, host, 10002, remote_host, freq);
    }

    public void killProcess() throws Exception {
        this.node.killProcess(this.process);
    }

    public void setFrequency(int freq) throws IOException {
        this.setNVPair("var_int", "DC_WAITTIME", "" + freq);
    }

    public void setRemoteHost(String host) throws IOException {
        if (host.length() == 0) {
            host = "NULL";
        }
        PerfmonPlugin.DBG.info("Setting remote host to " + host);
        this.setNVPair("var_string", "PERFMON_REG_HOST", host);
    }

    public void getUpdatedTree() throws IOException {
        this.setNVPair("updatetree", "", "true");
    }

    public void getUpdatedTree(SDDescriptor update) throws IOException {
        if (update.getId() == null) {
            return;
        }
        PerfmonPlugin.DBG.info("Requesting tree update for descriptor " + update.getName() + " (" + update.getId() + ")");
        this.setNVPair("updatetree", update.getId(), "true");
    }

    public void counterON(SDDescriptor counter) throws IOException, NullPointerException {
        String id = this.translator.getID(counter);
        if (id == null) {
            throw new NullPointerException("descriptor ID not found");
        }
        this.setNVPair("filter", id, "true");
    }

    public void counterOFF(SDDescriptor counter) throws IOException {
        String id = this.translator.getID(counter);
        if (id == null) {
            throw new IOException("descriptor ID not found");
        }
        this.setNVPair("filter", id, "false");
    }

    public SDDescriptor getModel() {
        return this.translator.getModel();
    }

    public void addLoaderListener(StatisticalLoaderListener listener) {
        this.translator.addLoaderListener(listener);
    }

    public void removeLoaderListener(StatisticalLoaderListener listener) {
        this.translator.addLoaderListener(listener);
    }

    private Agent findAgent(Node node) throws NotConnectedException {
        Agent agent = null;
        Enumeration processes = node.listProcesses();
        while (processes.hasMoreElements()) {
            Process p = (Process)processes.nextElement();
            PerfmonPlugin.DBG.info("checking RAC process " + p.getName());
            agent = this.findAgent(p);
            if (agent != null) break;
        }
        return agent;
    }

    private Agent findAgent(Process p) {
        if (p == null) {
            return null;
        }
        Enumeration agents = p.listAgents();
        Agent the_agent = null;
        if (!agents.hasMoreElements()) {
            PerfmonPlugin.DBG.info("found no agents in this process");
        }
        while (agents.hasMoreElements()) {
            Agent a = (Agent)agents.nextElement();
            PerfmonPlugin.DBG.info("found RAC agent " + a.getName() + "/" + a.getType());
            if (!a.getName().startsWith("PerfmonAgent") && !a.getType().startsWith("PerfmonAgent")) continue;
            try {
                if (a.isAttached()) continue;
                this.process = p;
                the_agent = a;
                PerfmonPlugin.DBG.info("agent not attached - accepting");
                break;
            }
            catch (Exception e) {
                PerfmonPlugin.DBG.warning("error checking agent " + e);
            }
        }
        return the_agent;
    }

    private void init(String modelname, TRCAgent trcagent, String host, int port, String remote_host, int freq) throws Exception {
        block10: {
            this.trcagent = trcagent;
            this.tracename = modelname;
            this.translator = new StatisticalXMLTranslator(trcagent, this.tracename);
            if (trcagent != null) {
                this.translator.getModel().setAgent(trcagent);
            }
            PerfmonPlugin.DBG.warning("asked to connect to " + host + ":" + port);
            try {
                this.node = NodeFactory.createNode((String)host);
                PerfmonPlugin.DBG.info("connecting to RAC");
                this.node.connect(port);
                PerfmonPlugin.DBG.info("connected to RAC");
                this.agent = this.findAgent(this.node);
                if (this.agent == null) {
                    PerfmonPlugin.DBG.info("Launching RAC PerfmonAgent");
                    this.process = ProcessFactory.createProcess((Node)this.node, (String)"PerfmonAgent");
                    if (this.process != null) {
                        ProcessAdapter adapter = new ProcessAdapter(this.process, null);
                        this.process.addProcessListener(new ProcessListener((IProcess)adapter){
                            private final /* synthetic */ IProcess val$adapter;
                            {
                                this.val$adapter = val$adapter;
                            }

                            public void processLaunched(Process p) {
                                UIPlugin.getDefault().registerLaunchProcess(this.val$adapter);
                            }

                            public void processExited(Process p) {
                                UIPlugin.getDefault().deregisterLaunchProcess(this.val$adapter);
                            }
                        });
                        this.process.launch();
                        long t = System.currentTimeMillis() + 8000L;
                        while (!this.process.isActive() && System.currentTimeMillis() < t) {
                            try {
                                Thread.sleep(200L);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        t = System.currentTimeMillis() + 25000L;
                        this.agent = this.findAgent(this.node);
                        while (this.agent == null && System.currentTimeMillis() < t) {
                            Thread.sleep(1250L);
                            this.agent = this.findAgent(this.node);
                        }
                    }
                }
                if (this.agent != null) {
                    PerfmonPlugin.DBG.info("attaching to perfmon agent " + this.agent.getName());
                    this.running = true;
                    this.agent.attach();
                    this.agent.startMonitoring((DataProcessor)this);
                    trcagent.setRuntimeId(this.agent.getUUID());
                    PerfmonPlugin.DBG.info("attached To & Monitoring Perfmon Agent");
                    this.setRemoteHost(remote_host);
                    this.setFrequency(freq);
                    this.getUpdatedTree();
                    break block10;
                }
                PerfmonPlugin.DBG.warning("no perfmon agent found");
                throw new Exception("Could not create PerfmonAgent on RAC");
            }
            catch (Exception e) {
                PerfmonPlugin.DBG.warning("problem initialising loader");
                throw e;
            }
        }
    }

    public void setNVPair(String type, String name, String value) throws IOException {
        ControlMessage message = new ControlMessage();
        SetNVPairCommand command = new SetNVPairCommand();
        try {
            command.setProcessId(Long.parseLong(this.process.getProcessId()));
        }
        catch (InactiveProcessException e) {
            throw new IOException("Inactive process - try again soon?");
        }
        command.setAgentName(this.agent.getName());
        command.setType(type);
        command.setName(name);
        command.setValue(value);
        message.appendCommand((CommandElement)command);
        this.node.getConnection().sendMessage(message, null);
    }

    public boolean isRunning() {
        return this.running;
    }

    public void shutdown() {
        block2: {
            this.running = false;
            PerfmonPlugin.DBG.info("shutdown");
            if (this.agent == null) break block2;
            try {
                PerfmonPlugin.DBG.info("detaching from agent");
                this.agent.stopMonitoring();
                this.agent.detach();
            }
            catch (Exception e) {
                PerfmonPlugin.DBG.warning("failed to detach from agent", (Throwable)e);
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.shutdown();
    }

    public void incoming(String msg) {
        try {
            this.parser.parse(this.translator, new ByteArrayInputStream(msg.getBytes()));
        }
        catch (Throwable t) {
            t.printStackTrace();
            PerfmonPlugin.DBG.warning("unable to parse message " + msg);
        }
    }

    private byte[] stringToBytes(String s) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        int i = 0;
        while (i < s.length()) {
            bout.write((byte)s.charAt(i));
            ++i;
        }
        return bout.toByteArray();
    }

    public void incommingData(byte[] buffer, int length, InetAddress peer) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < length) {
            sb.append((char)buffer[i]);
            ++i;
        }
        this.incoming(sb.toString().trim());
    }

    public void incommingData(char[] buffer, int length, InetAddress peer) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < length) {
            sb.append(buffer[i]);
            ++i;
        }
        this.incoming(sb.toString().trim());
    }

    public void invalidDataType(byte[] data, int length, InetAddress peer) {
        PerfmonPlugin.DBG.warning("invalid datatype");
    }

    public void waitingForData() {
    }
}

