/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.perfmon;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.perfmon.ImageManager;
import org.eclipse.hyades.perfmon.PerfmonGenericLoader;
import org.eclipse.hyades.perfmon.PerfmonLoader;
import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.perfmon.StatisticalLoaderListener;
import org.eclipse.hyades.statistical.ui.editor.internal.AgentChangeListener;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConInterface;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDModifiableVariableRepresentation;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDVariableLoader;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDVariableModifierProxy;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.TimeZoomSlider;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class PerfmonModuleTrace
implements AgentChangeListener,
SDVariableModifierProxy {
    private static final boolean USE_CUSTOM_LOADER = false;
    ImageManager img = PerfmonPlugin.img;
    StatConInterface statcon;
    IProgressMonitor pmonitor;
    String PERFMON_NODE = "Perfmon Trace";
    String ACTION_FILTER_COUNTERS = "Set Counter Filters";
    String ACTION_STOP_TRACE = "Stop Trace";
    String ACTION_UPDATE_TREE = "Update Counter Tree";
    String ACTION_START_TRACING = "Start Tracing this Counter";
    String ACTION_STOP_TRACING = "Stop Tracing this Counter";
    String ACTION_SETSMODELPATH = "Set Statistical Model save path...";
    String tracename;
    SimpleDateFormat smodel_sdf = new SimpleDateFormat("yyyyMMdd-HHmmss");
    boolean new_monitor = true;
    TRCMonitor monitor;
    TRCAgent agent;
    PerfmonLoader loader;
    VariablePadder var_padder;
    SDModifiableVariableRepresentation freq_var;
    double frequency = 1.0;
    URI smodelpath;
    URI monitor_uri;
    String rachost;

    public void unloadTrace() {
        this.var_padder.die = true;
        try {
            this.loader.shutdown();
        }
        catch (Exception e) {
            PerfmonPlugin.DBG.warning("failed to shut down Perfmon loader");
        }
        try {
            this.statcon.setConstantUpdate("PERFMON UPDATE " + this.loader.hashCode(), false, 1000L);
            this.statcon.setAgentImage(this.agent, this.img.getImage("trace_stop.gif"));
            this.statcon.removeAgentAction(this.agent, this.ACTION_FILTER_COUNTERS);
            this.statcon.removeAgentAction(this.agent, this.ACTION_STOP_TRACE);
            this.statcon.removeAgentAction(this.agent, this.ACTION_UPDATE_TREE);
        }
        catch (Exception e) {
            PerfmonPlugin.DBG.warning("failed to remove stuff from statcon");
        }
        this.statcon.removeAgentChangeListener((AgentChangeListener)this);
    }

    public void agentAdded(TRCAgent dead_agent) {
    }

    public void agentRemoved(TRCAgent dead_agent) {
        if (this.agent == dead_agent) {
            this.unloadTrace();
        }
    }

    public void requestValue(String unique_id, int i) throws ClassCastException {
        this.requestValue(unique_id, (double)i);
    }

    public void requestValue(String unique_id, long i) throws ClassCastException {
        this.requestValue(unique_id, (double)i);
    }

    public void requestValue(String unique_id, float i) throws ClassCastException {
        this.requestValue(unique_id, (double)i);
    }

    public void requestValue(String unique_id, double d) throws ClassCastException {
        block3: {
            if (!unique_id.equals("PERFMON#FREQUENCY")) break block3;
            if (d < 0.5) {
                d = 0.5;
            }
            int i = (int)(d * 1000.0);
            try {
                this.loader.setFrequency(i);
                this.frequency = d;
                this.freq_var.setMeasuredValue(System.currentTimeMillis(), d);
            }
            catch (IOException e) {
                PerfmonPlugin.DBG.logVisibleError((Throwable)e, PerfmonPlugin.getString("ERROR_SETTING_FREQUENCY") + " " + i, false);
            }
        }
    }

    public void requestValue(String unique_id, Object newval) throws ClassCastException {
        this.requestValue(unique_id, ((Number)newval).doubleValue());
    }

    public PerfmonModuleTrace(IProgressMonitor monitor, String rac_host, String reg_host, URI smodelpath, URI monitor_uri) {
        this.pmonitor = monitor;
        this.statcon = null;
        this.smodelpath = smodelpath;
        this.monitor_uri = monitor_uri;
        this.rachost = rac_host;
        new Init(rac_host, reg_host).run();
    }

    public PerfmonModuleTrace(StatConInterface statcon, String rac_host, String reg_host, URI smodelpath) {
        this.statcon = statcon;
        this.smodelpath = smodelpath;
        this.rachost = rac_host;
        new Init(rac_host, reg_host).start();
    }

    private String getStatModelFileName() {
        return this.tracename;
    }

    private void removeRepresentations(SDDescriptor descriptor) {
        if (descriptor == null) {
            return;
        }
        if (descriptor instanceof SDMemberDescriptor) {
            SDMemberDescriptor mem = (SDMemberDescriptor)descriptor;
            mem.setRepresentation(null);
            EList obslist = mem.getSnapshotObservation();
            int i = 0;
            while (i < obslist.size()) {
                SDSnapshotObservation obs = (SDSnapshotObservation)obslist.get(i);
                if (obs.getWindow() == null) {
                    PerfmonPlugin.DBG.warning("NULL OBSERVATION WINDOW UNDER " + descriptor.getName() + " (" + descriptor.getDescription() + ")");
                }
                ++i;
            }
        }
        EList list = descriptor.getChildren();
        int i = 0;
        while (i < list.size()) {
            this.removeRepresentations((SDDescriptor)list.get(i));
            ++i;
        }
    }

    private void saveResources() throws IOException {
        URI baseStatisticalModelURI = this.smodelpath;
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Path path = null;
        URI monitorURI = null;
        if (this.monitor_uri == null) {
            path = new Path(baseStatisticalModelURI + "/" + this.getStatModelFileName() + ".trcmxmi");
            monitorURI = URI.createPlatformResourceURI((String)workspaceRoot.getFile((IPath)path).getProjectRelativePath().toString());
        } else {
            monitorURI = this.monitor_uri;
        }
        path = new Path(baseStatisticalModelURI + "/" + this.getStatModelFileName() + ".trcnxmi");
        URI nodeURI = URI.createPlatformResourceURI((String)workspaceRoot.getFile((IPath)path).getProjectRelativePath().toString());
        path = new Path(baseStatisticalModelURI + "/" + this.getStatModelFileName() + ".trcpxmi");
        URI processURI = URI.createPlatformResourceURI((String)workspaceRoot.getFile((IPath)path).getProjectRelativePath().toString());
        path = new Path(baseStatisticalModelURI + "/" + this.getStatModelFileName() + ".trcaxmi");
        URI agentURI = URI.createPlatformResourceURI((String)workspaceRoot.getFile((IPath)path).getProjectRelativePath().toString());
        HierarchyResourceSetImpl resourceSet = HierarchyResourceSetImpl.getInstance();
        Resource monitorResource = null;
        Resource nodeResource = null;
        Resource processResource = null;
        Resource agentResource = null;
        try {
            monitorResource = resourceSet.getResource(monitorURI, true);
            PerfmonPlugin.DBG.info("got TRCMonitor resource OK");
        }
        catch (Exception e) {
            monitorResource = resourceSet.createResource(monitorURI);
            PerfmonPlugin.DBG.info("created TRCMonitor resource OK");
        }
        try {
            nodeResource = resourceSet.getResource(nodeURI, true);
            PerfmonPlugin.DBG.info("got TRCNode resource OK");
        }
        catch (Exception e) {
            nodeResource = resourceSet.createResource(nodeURI);
            PerfmonPlugin.DBG.info("created TRCNode resource OK");
        }
        try {
            processResource = resourceSet.getResource(processURI, true);
            PerfmonPlugin.DBG.info("got TRCProcessProxy resource OK");
        }
        catch (Exception e) {
            processResource = resourceSet.createResource(processURI);
            PerfmonPlugin.DBG.info("created TRCProcessProxy resource OK");
        }
        try {
            agentResource = resourceSet.getResource(agentURI, true);
            PerfmonPlugin.DBG.info("got TRCAgent resource OK");
        }
        catch (Exception e) {
            agentResource = resourceSet.createResource(agentURI);
            PerfmonPlugin.DBG.info("created TRCAgent resource OK");
        }
        if (this.monitor_uri == null) {
            try {
                monitorResource.getContents().add((Object)this.monitor);
            }
            catch (Exception e) {
                PerfmonPlugin.DBG.error("problem adding to monitor resource");
            }
        }
        try {
            nodeResource.getContents().add((Object)this.agent.getAgentProxy().getProcessProxy().getNode());
        }
        catch (Exception e) {
            PerfmonPlugin.DBG.error("problem adding to node resource");
        }
        try {
            processResource.getContents().add((Object)this.agent.getAgentProxy().getProcessProxy());
        }
        catch (Exception e) {
            PerfmonPlugin.DBG.error("problem adding to process resource");
        }
        agentResource.getContents().add((Object)this.agent);
    }

    private void saveStatisticalModel() throws IOException {
        EList descriptors = this.agent.getDescriptor();
        int i = 0;
        while (i < descriptors.size()) {
            this.removeRepresentations((SDDescriptor)descriptors.get(i));
            ++i;
        }
        URI baseStatisticalModelURI = this.smodelpath;
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Path path = new Path(baseStatisticalModelURI + "/" + this.getStatModelFileName() + ".trcaxmi");
        URI agentURI = URI.createURI((String)workspaceRoot.getFile((IPath)path).getProjectRelativePath().toString());
        if (this.statcon != null) {
            this.monitor.eResource().save(Collections.EMPTY_MAP);
            this.agent.getAgentProxy().getProcessProxy().getNode().eResource().save(Collections.EMPTY_MAP);
            this.agent.getAgentProxy().getProcessProxy().eResource().save(Collections.EMPTY_MAP);
            this.agent.eResource().save(Collections.EMPTY_MAP);
            this.statcon.setAgentFile(this.agent, agentURI);
        }
    }

    private void configureSliders() throws Exception {
        double ctime;
        TimeZoomSlider xslider = this.statcon.getGraphWindow().getXSlider(0);
        double minvis = xslider.getMinVisible();
        double maxvis = xslider.getMaxVisible();
        double min = xslider.getMinLimit();
        double max = xslider.getMaxLimit();
        minvis = ctime = (double)System.currentTimeMillis();
        maxvis = ctime + 60000.0;
        min = Math.min(min, ctime - 3600000.0);
        max = Math.max(max, ctime + 8.64E7);
        xslider.configure(min, max, minvis, maxvis, xslider.getResolution());
        ZoomSlider yslider = this.statcon.getGraphWindow().getYSlider(0);
        minvis = yslider.getMinVisible();
        maxvis = Math.max(yslider.getMaxVisible(), 100.0);
        min = yslider.getMinLimit();
        max = Math.max(yslider.getMaxLimit(), maxvis * 10.0);
        yslider.configure(min, max, minvis, maxvis, yslider.getResolution());
    }

    private void createTRCAgent(String tracename) {
        HierarchyResourceSetImpl resourceSet;
        HierarchyFactory hfactory = HierarchyFactory.eINSTANCE;
        TRCMonitor monitorroot = null;
        if (this.monitor_uri != null) {
            PerfmonPlugin.DBG.info("TRCMonitor URI specified - fetching TRCMonitor");
            resourceSet = HierarchyResourceSetImpl.getInstance();
            Resource monitorResource = null;
            try {
                monitorResource = resourceSet.getResource(this.monitor_uri, true);
                PerfmonPlugin.DBG.info("got TRCMonitor resource OK");
                this.new_monitor = false;
            }
            catch (Exception e) {
                monitorResource = resourceSet.createResource(this.monitor_uri);
                PerfmonPlugin.DBG.info("had to create new TRCMonitor resource");
                monitorroot = hfactory.createTRCMonitor();
                String mname = this.monitor_uri.toString();
                mname = mname.substring(mname.lastIndexOf("/") + 1);
                mname = mname.substring(0, mname.length() - ".trcmxmi".length());
                monitorroot.setName(mname);
                try {
                    monitorResource.getContents().add((Object)monitorroot);
                }
                catch (Exception x) {
                    PerfmonPlugin.DBG.error("problem adding to monitor resource", (Throwable)x);
                }
            }
            EList resources = monitorResource.getContents();
            int i = 0;
            while (i < resources.size()) {
                Object o = resources.get(i);
                if (o instanceof TRCMonitor) {
                    monitorroot = (TRCMonitor)o;
                    break;
                }
                ++i;
            }
        } else {
            PerfmonPlugin.DBG.info("TRCMonitor URI not specified - creating new TRCMonitor");
            monitorroot = hfactory.createTRCMonitor();
            monitorroot.setName(tracename);
        }
        TRCNode noderoot = hfactory.createTRCNode();
        noderoot.setMonitor(monitorroot);
        noderoot.setName(this.rachost);
        noderoot.setRuntimeId("unknown");
        noderoot.setTimezone(0.0);
        TRCProcessProxy pproxyroot = hfactory.createTRCProcessProxy();
        pproxyroot.setNode(noderoot);
        noderoot.getProcessProxies().add((Object)pproxyroot);
        pproxyroot.setActive(true);
        pproxyroot.setPid(-1);
        pproxyroot.setName(PerfmonPlugin.getString("PERFMON_AGENT"));
        TRCAgentProxy aproxyroot = hfactory.createTRCAgentProxy();
        aproxyroot.setProcessProxy(pproxyroot);
        pproxyroot.getAgentProxies().add((Object)aproxyroot);
        aproxyroot.setActive(true);
        aproxyroot.setAttached(true);
        aproxyroot.setMonitored(true);
        aproxyroot.setType("Profiler");
        aproxyroot.setName(PerfmonPlugin.getString("PERFMON_AGENT"));
        TRCAgent agentroot = hfactory.createTRCAgent();
        agentroot.setAgentProxy(aproxyroot);
        agentroot.setName(tracename);
        agentroot.setType("Profiler");
        resourceSet = HierarchyResourceSetImpl.getInstance();
        URI project_uri = this.smodelpath;
        String project_path = project_uri.toString().replaceFirst("platform:/resource/", "");
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.agent = agentroot;
        this.monitor = monitorroot;
        Path temp = new Path(project_path.toString().replaceFirst("platform:/resource/", ""));
        try {
            this.saveResources();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PerfmonPlugin.DBG.info("AGENT PROXY URI = " + this.agent.getAgentProxy().eResource().getURI());
        MonitorViewUpdate update = new MonitorViewUpdate();
        update.temp = temp;
        Display.getDefault().syncExec((Runnable)update);
    }

    public static final IContainer createContainer(IPath path) {
        IFolder container = null;
        IWorkspace workbench = UIPlugin.getPluginWorkbench();
        int segCount = path.segmentCount();
        int idx = 0;
        while (idx < segCount) {
            String seg = path.segment(idx);
            if (idx == 0) {
                IProject project = workbench.getRoot().getProject(path.uptoSegment(idx + 1).toString());
                if (project == null || !project.exists()) {
                    try {
                        project.create(null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                try {
                    project.open(null);
                }
                catch (Exception e) {
                    // empty catch block
                }
                container = project;
            } else {
                IFolder folder = workbench.getRoot().getFolder(path.uptoSegment(idx + 1));
                if (folder == null || !folder.exists()) {
                    try {
                        folder.create(false, true, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                container = folder;
            }
            ++idx;
        }
        try {
            container.getProject().refreshLocal(2, null);
        }
        catch (CoreException exc) {
            exc.printStackTrace();
        }
        return container;
    }

    private void redoActions() {
    }

    class AgentUpdateThread
    extends Thread
    implements StatisticalLoaderListener {
        public boolean die;
        TRCAgent agent;
        Object list_lock = new Object();
        ArrayList descriptor_updates = new ArrayList();
        HashMap descriptor_map = new HashMap();
        ArrayList agent_updates = new ArrayList();

        public AgentUpdateThread(TRCAgent trcagent) {
            this.agent = trcagent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void modelChanged(SDDescriptor des) {
            SDDescriptor parent = des;
            Object object = this.list_lock;
            synchronized (object) {
                if (parent == null) {
                    if (this.agent_updates.size() == 0) {
                        this.agent_updates.add(this.agent);
                    }
                } else {
                    if (this.descriptor_map.get(parent) != null) {
                        return;
                    }
                    SDDescriptor tmp = parent.getParent();
                    while (tmp != null) {
                        if (this.descriptor_map.get(tmp) != null) {
                            return;
                        }
                        tmp = tmp.getParent();
                    }
                    this.descriptor_updates.add(parent);
                    this.descriptor_map.put(parent, parent);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void collapse() {
            Object object = this.list_lock;
            synchronized (object) {
                if (this.agent_updates.size() > 0) {
                    return;
                }
                if (this.descriptor_updates.size() > 350) {
                    this.agent_updates.add(this.agent);
                    return;
                }
                int i = 0;
                while (i < this.descriptor_updates.size()) {
                    SDDescriptor descriptor = (SDDescriptor)this.descriptor_updates.get(i);
                    SDDescriptor tmp = descriptor.getParent();
                    while (tmp != null) {
                        if (this.descriptor_map.get(tmp) != null) {
                            this.descriptor_updates.remove(i--);
                            this.descriptor_map.remove(tmp);
                            break;
                        }
                        tmp = tmp.getParent();
                    }
                    ++i;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.die) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                Object object = this.list_lock;
                synchronized (object) {
                    this.collapse();
                    if (this.agent_updates.size() > 0) {
                        PerfmonModuleTrace.this.statcon.getGraphWindow().getDisplay().syncExec((Runnable)new ListUpdate(this.agent_updates));
                    } else if (this.descriptor_updates.size() > 0) {
                        PerfmonModuleTrace.this.statcon.getGraphWindow().getDisplay().syncExec((Runnable)new ListUpdate(this.descriptor_updates));
                    }
                    this.descriptor_updates = new ArrayList();
                    this.descriptor_map = new HashMap();
                    this.agent_updates = new ArrayList();
                }
            }
        }
    }

    class ListUpdate
    extends Thread {
        ArrayList items;

        public ListUpdate(ArrayList items) {
            this.items = items;
        }

        public void run() {
            try {
                int i = 0;
                while (i < this.items.size()) {
                    Object o = this.items.get(i);
                    if (o instanceof SDDescriptor) {
                        PerfmonModuleTrace.this.statcon.updateModel((SDDescriptor)o);
                    } else if (o instanceof TRCAgent) {
                        PerfmonModuleTrace.this.statcon.updateAgent((TRCAgent)o);
                        return;
                    }
                    ++i;
                }
            }
            catch (Throwable t) {
                PerfmonPlugin.DBG.warning("couldnt update perfmon agent " + t);
            }
        }
    }

    class PerfmonSetPath
    implements Runnable {
        PerfmonSetPath() {
        }

        public void run() {
            PerfmonPlugin.DBG.info("set test model save path");
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            Path container_savepath = null;
            IFolder container = null;
            try {
                container_savepath = new Path("" + PerfmonModuleTrace.this.smodelpath);
                container = workspaceRoot.getFolder((IPath)container_savepath);
            }
            catch (Throwable e) {
                PerfmonPlugin.DBG.warning("could not find valid IContainer for model save path");
            }
            PerfmonPlugin.DBG.info("showing container selection dialog");
            ContainerSelectionDialog dialog = null;
            dialog = new ContainerSelectionDialog(PerfmonModuleTrace.this.statcon.getGraphWindow().getShell(), (IContainer)container, false, PerfmonPlugin.getString("SMODEL_SELECT_PATH_DESCRIPTION"));
            dialog.open();
            Object[] result = dialog.getResult();
            if (result != null && result.length > 0) {
                URI savepath;
                Path container_path = (Path)result[0];
                PerfmonModuleTrace.this.smodelpath = savepath = URI.createPlatformResourceURI((String)container_path.toString());
                PerfmonPlugin.DBG.info("updating menuitems to reflect new model save path");
                PerfmonModuleTrace.this.redoActions();
                PerfmonModuleTrace.this.statcon.setDirty(true);
            }
        }
    }

    class CounterOFF
    implements Runnable {
        PerfmonLoader loader;

        public CounterOFF(PerfmonLoader loader) {
            this.loader = loader;
        }

        public void run() {
            try {
                this.apply(PerfmonModuleTrace.this.statcon.getSelectedDescriptor());
            }
            catch (Exception e) {
                PerfmonPlugin.DBG.error("unable to set counter to ON", (Throwable)e);
            }
        }

        void apply(SDDescriptor descriptor) throws IOException {
            this.loader.counterOFF(descriptor);
            PerfmonModuleTrace.this.statcon.setDescriptorImage(descriptor, PerfmonModuleTrace.this.img.getImage("trace_stop.gif"));
            EList children = descriptor.getChildren();
            int i = 0;
            while (i < children.size()) {
                this.apply((SDDescriptor)children.get(i));
                ++i;
            }
        }
    }

    class CounterON
    implements Runnable {
        PerfmonLoader loader;

        public CounterON(PerfmonLoader loader) {
            this.loader = loader;
        }

        public void run() {
            try {
                this.applyDown(PerfmonModuleTrace.this.statcon.getSelectedDescriptor());
                this.applyUp(PerfmonModuleTrace.this.statcon.getSelectedDescriptor());
            }
            catch (Exception e) {
                PerfmonPlugin.DBG.error("unable to set counter to ON", (Throwable)e);
            }
        }

        void apply(SDDescriptor descriptor) throws IOException {
            try {
                this.loader.counterON(descriptor);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            PerfmonModuleTrace.this.statcon.setDescriptorImage(descriptor, PerfmonModuleTrace.this.img.getImage("trace_start.gif"));
        }

        void applyUp(SDDescriptor descriptor) throws IOException {
            SDDescriptor parent = descriptor.getParent();
            if (parent != null) {
                this.apply(parent);
                this.applyUp(parent);
            }
        }

        void applyDown(SDDescriptor descriptor) throws IOException {
            this.apply(descriptor);
            EList children = descriptor.getChildren();
            int i = 0;
            while (i < children.size()) {
                this.applyDown((SDDescriptor)children.get(i));
                ++i;
            }
        }
    }

    class StopTraceAction
    implements Runnable {
        PerfmonLoader loader;
        TRCAgent agent;

        public StopTraceAction(PerfmonLoader loader, TRCAgent agent) {
            this.loader = loader;
            this.agent = agent;
        }

        public void run() {
            PerfmonModuleTrace.this.unloadTrace();
            try {
                PerfmonModuleTrace.this.saveStatisticalModel();
            }
            catch (Exception e) {
                PerfmonPlugin.DBG.error("problem saving statistical model", (Throwable)e);
            }
            try {
                this.loader.killProcess();
            }
            catch (Exception e) {
                PerfmonPlugin.DBG.error("problem killing perfmon process", (Throwable)e);
            }
        }
    }

    class UpdateTreeAction
    implements Runnable {
        PerfmonLoader loader;
        TRCAgent agent;

        public UpdateTreeAction(PerfmonLoader loader, TRCAgent agent) {
            this.loader = loader;
            this.agent = agent;
        }

        public void run() {
            try {
                SDDescriptor selected = PerfmonModuleTrace.this.statcon.getSelectedDescriptor();
                this.loader.getUpdatedTree(selected);
            }
            catch (IOException e) {
                PerfmonPlugin.DBG.logVisibleError((Throwable)e, PerfmonPlugin.getString("ERROR_UPDATE_TREE"), false);
            }
        }
    }

    class VariablePadder
    extends Thread {
        boolean die = false;

        VariablePadder() {
        }

        public void run() {
            while (!this.die) {
                try {
                    Thread.sleep(750L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    PerfmonModuleTrace.this.freq_var.padRequestedValue(System.currentTimeMillis());
                    PerfmonModuleTrace.this.freq_var.setMeasuredValue(System.currentTimeMillis(), PerfmonModuleTrace.this.freq_var.getLastMeasuredValue());
                }
                catch (Exception e) {
                    PerfmonPlugin.DBG.warning("unable to pad variable requested and measured - " + e);
                }
            }
        }
    }

    class Init
    extends Thread {
        String rac_host;
        String reg_host;

        public Init(String rac_host, String reg_host) {
            this.rac_host = rac_host;
            this.reg_host = reg_host;
        }

        public void run() {
            if (PerfmonModuleTrace.this.pmonitor != null) {
                PerfmonModuleTrace.this.pmonitor.setTaskName(PerfmonPlugin.getString("PROGRESS_LAUNCHING"));
            }
            try {
                if (this.reg_host.equalsIgnoreCase(this.rac_host)) {
                    this.reg_host = "null";
                }
                HierarchyFactory hfactory = HierarchyFactory.eINSTANCE;
                long started = System.currentTimeMillis();
                String host = this.rac_host;
                int port = 10002;
                String reg_host_name = this.reg_host;
                if (reg_host_name.equalsIgnoreCase("null")) {
                    reg_host_name = host;
                } else if (!this.reg_host.startsWith("\\\\")) {
                    this.reg_host = "\\\\" + this.reg_host;
                }
                PerfmonModuleTrace.this.tracename = "Perfmon Trace - " + reg_host_name + " (" + host + ") " + PerfmonModuleTrace.this.smodel_sdf.format(new Date(started));
                String modelname = "Perfmon Host Trace - " + PerfmonModuleTrace.this.smodel_sdf.format(new Date(started));
                PerfmonModuleTrace.this.createTRCAgent(PerfmonModuleTrace.this.tracename);
                PerfmonPlugin.DBG.info("Creating variable loader");
                SDVariableLoader varloader = null;
                if (PerfmonModuleTrace.this.statcon != null) {
                    varloader = new SDVariableLoader(PerfmonModuleTrace.this.agent, "Perfmon Controls");
                }
                AgentUpdateThread agentupdate = null;
                if (PerfmonModuleTrace.this.statcon != null) {
                    agentupdate = new AgentUpdateThread(PerfmonModuleTrace.this.agent);
                    agentupdate.start();
                }
                PerfmonModuleTrace.this.loader = new PerfmonGenericLoader(PerfmonModuleTrace.this.pmonitor, started, PerfmonModuleTrace.this.agent, modelname, host, port, this.reg_host, (int)(1000.0 * PerfmonModuleTrace.this.frequency));
                if (PerfmonModuleTrace.this.statcon != null) {
                    PerfmonModuleTrace.this.loader.addLoaderListener(agentupdate);
                }
                if (PerfmonModuleTrace.this.pmonitor != null) {
                    PerfmonModuleTrace.this.pmonitor.setTaskName(PerfmonPlugin.getString("PROGRESS_CONFIGURING"));
                }
                ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                event.setSource((Object)PerfmonModuleTrace.this.agent.getAgentProxy());
                event.setType(1);
                ProfileUpdate update = new ProfileUpdate();
                update.event = event;
                Display.getDefault().syncExec((Runnable)update);
                if (PerfmonModuleTrace.this.statcon != null) {
                    PerfmonPlugin.DBG.info("Creating frequency variable");
                    PerfmonModuleTrace.this.freq_var = varloader.createSDModifiableVariable("PERFMON#FREQUENCY", "Frequency (sec)", "The period between data updates in seconds", null, false, 3, 3, "Frequency", "Perfmon Controls", (SDVariableModifierProxy)PerfmonModuleTrace.this, 0.5, Double.MAX_VALUE);
                    Display.getDefault().syncExec((Runnable)new StatconUpdate1());
                    Display.getDefault().syncExec((Runnable)new StatconUpdate2());
                }
                if (PerfmonModuleTrace.this.pmonitor != null) {
                    PerfmonModuleTrace.this.pmonitor.done();
                }
            }
            catch (Throwable t) {
                if (PerfmonModuleTrace.this.pmonitor != null) {
                    PerfmonModuleTrace.this.pmonitor.done();
                }
                PerfmonPlugin.DBG.logVisibleError(t, PerfmonPlugin.getString("ERROR_STARTING_TRACE"), true);
            }
        }
    }

    class StatconUpdate2
    implements Runnable {
        StatconUpdate2() {
        }

        public void run() {
            try {
                PerfmonPlugin.DBG.info("Setting requested frequency to " + PerfmonModuleTrace.this.frequency);
                PerfmonModuleTrace.this.freq_var.setRequestedValue(System.currentTimeMillis(), PerfmonModuleTrace.this.frequency);
                PerfmonPlugin.DBG.info("setting up trcagent + variable padder");
                PerfmonModuleTrace.this.statcon.addAgentChangeListener((AgentChangeListener)PerfmonModuleTrace.this);
                PerfmonModuleTrace.this.statcon.setAgentImage(PerfmonModuleTrace.this.agent, PerfmonModuleTrace.this.img.getImage("trace_start.gif"));
                PerfmonModuleTrace.this.var_padder = new VariablePadder();
                PerfmonModuleTrace.this.var_padder.start();
            }
            catch (Throwable e) {
                PerfmonPlugin.DBG.logVisibleError(e, PerfmonPlugin.getString("ERROR_STATCON_UPDATE") + " (2)", true);
            }
        }
    }

    class StatconUpdate1
    implements Runnable {
        StatconUpdate1() {
        }

        public void run() {
            try {
                PerfmonModuleTrace.this.statcon.setConstantUpdate("PERFMON UPDATE " + PerfmonModuleTrace.this.loader.hashCode(), true, 1000L);
                PerfmonModuleTrace.this.statcon.addAgent(PerfmonModuleTrace.this.agent);
                PerfmonModuleTrace.this.statcon.addAgentAction(PerfmonModuleTrace.this.agent, PerfmonModuleTrace.this.ACTION_STOP_TRACE, PerfmonPlugin.getString("STOP_TRACE"), PerfmonModuleTrace.this.img.getImage("trace_stop.gif"), (Runnable)new StopTraceAction(PerfmonModuleTrace.this.loader, PerfmonModuleTrace.this.agent));
                PerfmonModuleTrace.this.statcon.addModelAction(PerfmonModuleTrace.this.agent, PerfmonModuleTrace.this.ACTION_UPDATE_TREE, PerfmonPlugin.getString("UPDATE_TREE"), PerfmonModuleTrace.this.img.getImage("update_tree.gif"), (Runnable)new UpdateTreeAction(PerfmonModuleTrace.this.loader, PerfmonModuleTrace.this.agent));
                PerfmonModuleTrace.this.statcon.addModelAction(PerfmonModuleTrace.this.agent, PerfmonModuleTrace.this.ACTION_START_TRACING, PerfmonPlugin.getString("START_TRACING"), PerfmonModuleTrace.this.img.getImage("trace_start.gif"), (Runnable)new CounterON(PerfmonModuleTrace.this.loader));
                PerfmonModuleTrace.this.statcon.addModelAction(PerfmonModuleTrace.this.agent, PerfmonModuleTrace.this.ACTION_STOP_TRACING, PerfmonPlugin.getString("STOP_TRACING"), PerfmonModuleTrace.this.img.getImage("trace_stop.gif"), (Runnable)new CounterOFF(PerfmonModuleTrace.this.loader));
                PerfmonModuleTrace.this.configureSliders();
            }
            catch (Throwable e) {
                PerfmonPlugin.DBG.logVisibleError(e, PerfmonPlugin.getString("ERROR_STATCON_UPDATE") + " (1)", true);
            }
        }
    }

    class ProfileUpdate
    implements Runnable {
        ProfileEvent event;

        ProfileUpdate() {
        }

        public void run() {
            try {
                UIPlugin.getDefault().notifyProfileEventListener(this.event);
            }
            catch (Throwable e) {
                PerfmonPlugin.DBG.logVisibleError(e, PerfmonPlugin.getString("ERROR_SEND_PROFILING"), true);
            }
        }
    }

    class MonitorViewUpdate
    implements Runnable {
        IPath temp;

        MonitorViewUpdate() {
        }

        public void run() {
            block3: {
                try {
                    if (!PerfmonModuleTrace.this.new_monitor) {
                        PDContentProvider.resetMonitors();
                        break block3;
                    }
                    PDContentProvider.addMonitor((IResource)PerfmonModuleTrace.createContainer(this.temp), (TRCMonitor)PerfmonModuleTrace.this.monitor);
                }
                catch (Throwable e) {
                    PerfmonPlugin.DBG.logVisibleError(e, PerfmonPlugin.getString("ERROR_UPDATE_PROFMON"), true);
                }
            }
        }
    }
}

