/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.util;

import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IDisplayValueClass;
import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IValidateValueClass;
import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IValueClassFactory;
import org.eclipse.hyades.test.ui.datapool.internal.util.StringValidatorValueClass;
import org.eclipse.hyades.test.ui.datapool.internal.util.StringValueClass;
import org.eclipse.hyades.test.ui.datapool.internal.util.StringValueFactory;

public class ValueClassMap {
    private static HashMap displayMap = null;
    private static HashMap validatorMap = null;
    private static HashMap valueFactoryMap = null;
    private static String mapVendorID = null;

    public static IDisplayValueClass getSWTValueDisplayClass(Object theObject) {
        if (theObject == null) {
            return null;
        }
        Class<?> cls = theObject.getClass();
        return ValueClassMap.getValueDisplayClass(cls);
    }

    public static IValidateValueClass getValueValidatorClass(Object theObject) {
        if (theObject == null) {
            return null;
        }
        Class<?> cls = theObject.getClass();
        return ValueClassMap.getValidatorClass(cls);
    }

    public static IValidateValueClass getValueValidatorClass(String theObjectClassName) {
        if (theObjectClassName == null) {
            return null;
        }
        return ValueClassMap.getValidatorClass(theObjectClassName);
    }

    public static IValueClassFactory getValueClassFactory(String theObjectClassName) {
        if (theObjectClassName == null) {
            return null;
        }
        return ValueClassMap.getClassFactory(theObjectClassName);
    }

    public static void setVendorID(String vendorID) {
        mapVendorID = vendorID;
    }

    private static IDisplayValueClass getValueDisplayClass(Class cls) {
        if (cls == null) {
            return null;
        }
        String cl = cls.getName();
        ValueClassMap.loadDisplayClassMap();
        Object result = displayMap.get(cl);
        if (result == null) {
            result = ValueClassMap.getValueDisplayClass(cls.getSuperclass());
        }
        if (result == null && cl.equals("java.lang.String")) {
            result = new StringValueClass();
        }
        return (IDisplayValueClass)result;
    }

    private static IDisplayValueClass getValueDisplayClass(String className) {
        if (className == null) {
            return null;
        }
        ValueClassMap.loadDisplayClassMap();
        Object result = displayMap.get(className);
        if (result == null && className.equals("java.lang.String")) {
            result = new StringValueClass();
        }
        return (IDisplayValueClass)result;
    }

    private static IValidateValueClass getValidatorClass(Class cls) {
        if (cls == null) {
            return null;
        }
        String cl = cls.getName();
        ValueClassMap.loadValidatorClassMap();
        Object result = validatorMap.get(cl);
        if (result == null) {
            result = ValueClassMap.getValidatorClass(cls.getSuperclass());
        }
        if (result == null && cl.equals("java.lang.String")) {
            result = new StringValidatorValueClass();
        }
        return (IValidateValueClass)result;
    }

    private static IValidateValueClass getValidatorClass(String className) {
        if (className == null) {
            return null;
        }
        ValueClassMap.loadDisplayClassMap();
        Object result = validatorMap.get(className);
        if (result == null && className.equals("java.lang.String")) {
            result = new StringValidatorValueClass();
        }
        return (IValidateValueClass)result;
    }

    private static IValueClassFactory getClassFactory(String className) {
        if (className == null) {
            return null;
        }
        ValueClassMap.loadValueFactoryMap();
        Object result = valueFactoryMap.get(className);
        if (result == null && className.equals("java.lang.String")) {
            result = new StringValueFactory();
        }
        return (IValueClassFactory)result;
    }

    private static void loadDisplayClassMap() {
        block5: {
            IExtensionPoint extensionPoint;
            if (displayMap == null) {
                displayMap = new HashMap(64);
            }
            if ((extensionPoint = Platform.getPluginRegistry().getExtensionPoint("org.eclipse.hyades.test.ui.datapool.valueObjectExtension")) == null) break block5;
            try {
                IConfigurationElement[] extensionPoints = extensionPoint.getConfigurationElements();
                int i = 0;
                while (i < extensionPoints.length) {
                    String vendorID;
                    if (mapVendorID == null || mapVendorID.equals(vendorID = extensionPoints[i].getAttribute("vendorID"))) {
                        String type = extensionPoints[i].getAttribute("type");
                        IDisplayValueClass displayValueClass = (IDisplayValueClass)extensionPoints[i].createExecutableExtension("displayValueClass");
                        displayMap.put(type, displayValueClass);
                    }
                    ++i;
                }
            }
            catch (Exception e) {}
        }
    }

    private static void loadValidatorClassMap() {
        block5: {
            IExtensionPoint extensionPoint;
            if (validatorMap == null) {
                validatorMap = new HashMap(64);
            }
            if ((extensionPoint = Platform.getPluginRegistry().getExtensionPoint("org.eclipse.hyades.test.ui.datapool.valueObjectValidatorExtension")) == null) break block5;
            try {
                IConfigurationElement[] extensionPoints = extensionPoint.getConfigurationElements();
                int i = 0;
                while (i < extensionPoints.length) {
                    String vendorID;
                    if (mapVendorID == null || mapVendorID.equals(vendorID = extensionPoints[i].getAttribute("vendorID"))) {
                        String type = extensionPoints[i].getAttribute("type");
                        IValidateValueClass validateValueClass = (IValidateValueClass)extensionPoints[i].createExecutableExtension("validateValueClass");
                        validatorMap.put(type, validateValueClass);
                    }
                    ++i;
                }
            }
            catch (Exception e) {}
        }
    }

    private static void loadValueFactoryMap() {
        block5: {
            IExtensionPoint extensionPoint;
            if (valueFactoryMap == null) {
                valueFactoryMap = new HashMap(64);
            }
            if ((extensionPoint = Platform.getPluginRegistry().getExtensionPoint("org.eclipse.hyades.test.ui.datapool.valueObjectExtension")) == null) break block5;
            try {
                IConfigurationElement[] extensionPoints = extensionPoint.getConfigurationElements();
                int i = 0;
                while (i < extensionPoints.length) {
                    String vendorID;
                    if (mapVendorID == null || mapVendorID.equals(vendorID = extensionPoints[i].getAttribute("vendorID"))) {
                        String type = extensionPoints[i].getAttribute("type");
                        IValueClassFactory valueFactory = (IValueClassFactory)extensionPoints[i].createExecutableExtension("valueClassFactory");
                        valueFactoryMap.put(type, valueFactory);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

