/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.util.tests;

import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.logging.events.cbe.AssociatedEvent;
import org.eclipse.hyades.logging.events.cbe.AssociationEngine;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.ContextDataElement;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.FormattingException;
import org.eclipse.hyades.logging.events.cbe.MsgCatalogToken;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;
import org.eclipse.hyades.logging.events.cbe.OtherSituation;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.events.cbe.StartSituation;
import org.eclipse.hyades.logging.events.cbe.impl.tests.Util;
import org.eclipse.hyades.logging.events.cbe.util.EventFormatter;
import org.eclipse.hyades.logging.events.cbe.util.EventHelpers;

public class EventFormatterTest
extends TestCase {
    public EventFormatterTest(String string) {
        super(string);
    }

    public void testInvalidXMLDocumentDeserialization() {
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><CommonBaseEvents xmlns=\"http://www.ibm.com/AC/commonbaseevent1_0_1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/AC/commonbaseevent1_0_1 commonbaseevent1_0_1.xsd \"> <CommonBaseEvent creationTime=\"2001-12-31T12:00:00\" elapsed Time=\"0\" extensionName=\"Name\" globalInstanceId=\"i0000000000000000000000000000040\" localInstanceId=\"\" msg=\"\" priority=\"0\" repeatCount=\"0\" sequenceNumber=\"0\" severity=\"0\" version=\"\">    <contextDataElements name=\"myContext\" type=\"String\">      <contextValue>contextValue</contextValue>     </context DataElements>    <extendedDataElements name=\"\" type=\"noValue\">      <values>values</values>       <children name=\"\" type=\"noValue\">          <values>values</values>       </children>      </extendedDataElements>    <associatedEvents resolvedEvents=\"i0000000000000000000000000000040\">      <associationEngineInfo id=\"i0000000000000000000000000000044\" name=\"MyCorrelationEngine\" type=\"Correlate\"/>    </associatedEvents> <reporterComponentId application=\"\" componentType=\"\" component=\"\" componentIdType=\"\" executionEnvironment=\"\" instanceId=\"\" location=\"\" locationType=\"Name\" processId=\"\" subComponent=\"\" threadId=\"\"/><sourceComponentId application=\"\" componentType=\"\" component=\"\" componentIdType=\"\" executionEnvironment=\"\" instanceId=\"\" location=\"\" locationType=\"Name\" processId=\"\" subComponent=\"\" threadId=\"\"/>    <msgDataElement msgLocale=\"EN\">      <msgCatalogTokens value=\"\"/>      <msgId>msgId</msgId>      <msgIdType>Name</msgIdType>      <msgCatalogId>msgCatalogId</msgCatalogId>      <msgCatalogType>msgCatalogType</msgCatalogType>      <msgCatalog>msgCatalog</msgCatalog>    </msgDataElement>    <situation categoryName=\"StartSituation\"><situationType reasoningScope=\"EXTERNAL\" successDisposition=\"SUCCESSFUL\" situationQualifier=\"START COMPLETED\" xsi:type=\"StartSituation\" />\t</situation>\t    <a:a xmlns:a=\"http://bar\" />    </CommonBaseEvent></CommonBaseEvents>";
        try {
            EventFormatter.eventsFromCanonicalXMLDoc(string);
            Assert.assertTrue((boolean)false);
        }
        catch (FormattingException formattingException) {
            // empty catch block
        }
    }

    public void testInvalidXMLFragmentDeserialization() {
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><CommonBaseEvents xmlns=\"http://www.ibm.com/AC/commonbaseevent1_0_1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/AC/commonbaseevent1_0_1 commonbaseevent1_0_1.xsd \"> <CommonBaseEvent creationTime=\"2001-12-31T12:00:00\" elapsed Time=\"0\" extensionName=\"Name\" globalInstanceId=\"i0000000000000000000000000000040\" localInstanceId=\"\" msg=\"\" priority=\"0\" repeatCount=\"0\" sequenceNumber=\"0\" severity=\"0\" version=\"\">    <contextDataElements name=\"myContext\" type=\"String\">      <contextValue>contextValue</contextValue>     </context DataElements>    <extendedDataElements name=\"\" type=\"noValue\">      <values>values</values>       <children name=\"\" type=\"noValue\">          <values>values</values>       </children>      </extendedDataElements>    <associatedEvents resolvedEvents=\"i0000000000000000000000000000040\">      <associationEngineInfo id=\"i0000000000000000000000000000044\" name=\"MyCorrelationEngine\" type=\"Correlate\"/>    </associatedEvents> <reporterComponentId application=\"\" componentType=\"\" component=\"\" componentIdType=\"\" executionEnvironment=\"\" instanceId=\"\" location=\"\" locationType=\"Name\" processId=\"\" subComponent=\"\" threadId=\"\"/><sourceComponentId application=\"\" componentType=\"\" component=\"\" componentIdType=\"\" executionEnvironment=\"\" instanceId=\"\" location=\"\" locationType=\"Name\" processId=\"\" subComponent=\"\" threadId=\"\"/>    <msgDataElement msgLocale=\"EN\">      <msgCatalogTokens value=\"\"/>      <msgId>msgId</msgId>      <msgIdType>Name</msgIdType>      <msgCatalogId>msgCatalogId</msgCatalogId>      <msgCatalogType>msgCatalogType</msgCatalogType>      <msgCatalog>msgCatalog</msgCatalog>    </msgDataElement>    <situation categoryName=\"StartSituation\"><situationType reasoningScope=\"EXTERNAL\" successDisposition=\"SUCCESSFUL\" situationQualifier=\"START COMPLETED\" xsi:type=\"StartSituation\" />\t</situation>\t    <a:a xmlns:a=\"http://bar\" />    </CommonBaseEvent></CommonBaseEvents>";
        try {
            EventFormatter.eventFromCanonicalXML(string);
            Assert.assertTrue((boolean)false);
        }
        catch (FormattingException formattingException) {
            // empty catch block
        }
    }

    public void testEventMultipleAnyElementsWithWhiteSpaceInXMLFragmentDeserialization() {
        String string = "<CommonBaseEvent creationTime=\"2001-12-31T12:00:00\" elapsedTime=\"0\" extensionName=\"Name\" globalInstanceId=\"CEE736B610030D11D88000A27990EF8D1A\" localInstanceId=\"\" msg=\"\" priority=\"0\" repeatCount=\"0\" sequenceNumber=\"0\" severity=\"0\" version=\"\"><contextDataElements name=\"\" type=\"\"><contextValue>contextValue</contextValue></contextDataElements> <extendedDataElements name=\"\" type=\"noValue\"><values>values</values> <children name=\"\" type=\"noValue\"> <values>values</values>    </children>     </extendedDataElements>    <associatedEvents resolvedEvents=\"i0000000000000000000000000000040\">      <associationEngine>i0000000000000000000000000000044</associationEngine>    </associatedEvents>    <reporterComponentId application=\"\" componentType=\"\" component=\"\" componentIdType=\"\" executionEnvironment=\"\" instanceId=\"\" location=\"\" locationType=\"Name\" processId=\"\" subComponent=\"\" threadId=\"\"/>    <sourceComponentId application=\"\" componentType=\"\" component=\"\" componentIdType=\"\" executionEnvironment=\"\" instanceId=\"\" location=\"\" locationType=\"Name\" processId=\"\" subComponent=\"\" threadId=\"\"/>    <msgDataElement msgLocale=\"EN\">      <msgCatalogTokens value=\"\"/>      <msgId>msgId</msgId>      <msgIdType>Name</msgIdType>      <msgCatalogId>msgCatalogId</msgCatalogId>      <msgCatalogType>msgCatalogType</msgCatalogType>      <msgCatalog>msgCatalog</msgCatalog>    </msgDataElement>    <situation categoryName=\"StartSituation\">    \t<situationType reasoningScope=\"EXTERNAL\" successDisposition=\"SUCCESSFUL\" situationQualifier=\"START COMPLETED\" xsi:type=\"StartSituation\" />\t</situation> \t <any namespace=\"##other\" processContents=\"skip\" />      <any1 abc=\"def\" />        <any2>          This is an any element</any2>  <GetLastTrade>          <symbol>DEF      </symbol>       </GetLastTrade>         <any3>     <xyz>       a=\"b c\" </xyz>     </any3></CommonBaseEvent>";
        try {
            String[] stringArray = new String[]{"<any namespace=\"##other\" processContents=\"skip\"></any>", "<any1 abc=\"def\"></any1>", "<any2>This is an any element</any2>", "<GetLastTrade><symbol>DEF</symbol></GetLastTrade>", "<any3><xyz>a=&quot;b c&quot;</xyz></any3>"};
            CommonBaseEvent commonBaseEvent = EventFormatter.eventFromCanonicalXML(string);
            EList eList = commonBaseEvent.getAny();
            Assert.assertNotNull((Object)eList);
            Assert.assertTrue((eList.size() == 5 ? 1 : 0) != 0);
            int n = 0;
            while (n < eList.size()) {
                Assert.assertTrue((boolean)eList.get(n).equals(stringArray[n]));
                ++n;
            }
        }
        catch (AssertionFailedError assertionFailedError) {
            throw assertionFailedError;
        }
        catch (Throwable throwable) {
            Assert.assertTrue((String)throwable.toString(), (boolean)false);
        }
    }

    public void testAlternateNameSpacesXMLDocumentDeserialization() {
        String string = "<?xml version=\"1.0\" encoding=\"ASCII\"?><cbe:CommonBaseEvents xmlns:cbe=\"http://www.ibm.com/AC/commonbaseevent1_0_1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/AC/commonbaseevent1_0_1 commonbaseevent1_0_1.xsd \"><cbe:AssociationEngine cbe:id=\"i0000000000000000000000000000044\" cbe:name=\"MyCorrelationEngine\" cbe:type=\"Correlate\"/><cbe:CommonBaseEvent cbe:creationTime=\"2001-12-31T12:00:00\" cbe:extensionName=\"Name\" cbe:globalInstanceId=\"CEE736B610030D11D88000A27990EF8D1A\">  <cbe:contextDataElements name=\"myContext\" type=\"String\">    <cbe:contextValue>contextValue</cbe:contextValue>  </cbe:contextDataElements>  <cbe:extendedDataElements name=\"ede1\" type=\"noValue\">    <cbe:values>values</cbe:values>    <cbe:children name=\"chname1\" type=\"noValue\">      <cbe:values>values</cbe:values>    </cbe:children>  </cbe:extendedDataElements>  <cbe:extendedDataElements name=\"ede2\" type=\"noValue\">    <cbe:values>values</cbe:values>    <cbe:children name=\"chname2\" type=\"noValue\">      <cbe:values>values</cbe:values>    </cbe:children>  </cbe:extendedDataElements>  <cbe:reporterComponentId application=\"appl1\" componentType=\"compType1\" component=\"comp1\" componentIdType=\"compIdType1\" executionEnvironment=\"exc1\" instanceId=\"id1\" location=\"loc1\" locationType=\"Hostname\" processId=\"pr1\" subComponent=\"sub1\" threadId=\"th1\"/>  <cbe:sourceComponentId application=\"app2\" componentType=\"compType2\" component=\"comp2\" componentIdType=\"compIdType2\" executionEnvironment=\"exc2\" instanceId=\"id2\" location=\"loc2\" locationType=\"SNA\" processId=\"pr2\" subComponent=\"sub2\" threadId=\"th2\"/>  <cbe:msgDataElement msgLocale=\"EN\">    <cbe:msgCatalogTokens value=\"value\"/>    <cbe:msgId>msgId</cbe:msgId>    <cbe:msgIdType>Name</cbe:msgIdType>    <cbe:msgCatalogId>msgCatalogId</cbe:msgCatalogId>    <cbe:msgCatalogType>msgCatalogType</cbe:msgCatalogType>    <cbe:msgCatalog>msgCatalog</cbe:msgCatalog>  </cbe:msgDataElement>  <cbe:situation categoryName=\"StartSituation\">    <cbe:situationType reasoningScope=\"EXTERNAL\" successDisposition=\"SUCCESSFUL\" situationQualifier=\"START COMPLETED\" xsi:type=\"StartSituation\" />  </cbe:situation></cbe:CommonBaseEvent></cbe:CommonBaseEvents>";
        try {
            CommonBaseEvent commonBaseEvent = EventFormatter.eventsFromCanonicalXMLDoc(string)[0];
            CommonBaseEvent commonBaseEvent2 = EventFormatter.eventsFromCanonicalXMLDoc(string)[0];
            Assert.assertEquals((Object)commonBaseEvent.getExtendedDataElements("root"), (Object)commonBaseEvent2.getExtendedDataElements("root"));
            Assert.assertEquals((Object)commonBaseEvent, (Object)commonBaseEvent2);
            Assert.assertEquals((String)commonBaseEvent.getGlobalInstanceId(), (String)"CEE736B610030D11D88000A27990EF8D1A");
            Assert.assertEquals((String)commonBaseEvent2.getGlobalInstanceId(), (String)"CEE736B610030D11D88000A27990EF8D1A");
            AssociationEngine associationEngine = EventFormatter.associationEnginesFromCanonicalXMLDoc(string)[0];
            AssociationEngine associationEngine2 = EventFormatter.associationEnginesFromCanonicalXMLDoc(string)[0];
            Assert.assertEquals((Object)associationEngine, (Object)associationEngine2);
            Assert.assertEquals((String)associationEngine.getId(), (String)"i0000000000000000000000000000044");
            Assert.assertEquals((String)associationEngine2.getId(), (String)"i0000000000000000000000000000044");
        }
        catch (AssertionFailedError assertionFailedError) {
            throw assertionFailedError;
        }
        catch (Throwable throwable) {
            Assert.assertTrue((String)throwable.toString(), (boolean)false);
        }
    }

    public void testXMLFragmentDeserializationWithMultipleAssociatedEvents() {
        String string = "<CommonBaseEvent creationTime=\"2001-12-31T12:00:00\" extensionName=\"Name\" globalInstanceId=\"CEE736B610030D11D88000A27990EF8D1A\">  <contextDataElements name=\"myContext\" type=\"String\">    <contextValue>contextValue</contextValue>  </contextDataElements>  <extendedDataElements name=\"ede1\" type=\"noValue\">    <values>values</values>    <children name=\"chname1\" type=\"noValue\">      <values>values</values>    </children>  </extendedDataElements>  <extendedDataElements name=\"ede2\" type=\"noValue\">    <values>values</values>    <children name=\"chname2\" type=\"noValue\">      <values>values</values>    </children>  </extendedDataElements> <associatedEvents resolvedEvents=\"i0000000000000000000000000000040 i00000000000000000000000000011132 i0000000000000000000000000022232\"><associationEngine>i0000000000000000000000000000032</associationEngine></associatedEvents><associatedEvents resolvedEvents=\"i0000000000000000000000000000040\"><associationEngineInfo id=\"i0000000000000000000000000000044\" name=\"MyCorrelationEngine\" type=\"Correlate\"/></associatedEvents> <reporterComponentId application=\"appl1\" componentType=\"compType1\" component=\"comp1\" componentIdType=\"compIdType1\" executionEnvironment=\"exc1\" instanceId=\"id1\" location=\"loc1\" locationType=\"Hostname\" processId=\"pr1\" subComponent=\"sub1\" threadId=\"th1\"/>  <sourceComponentId application=\"app2\" componentType=\"compType2\" component=\"comp2\" componentIdType=\"compIdType2\" executionEnvironment=\"exc2\" instanceId=\"id2\" location=\"loc2\" locationType=\"SNA\" processId=\"pr2\" subComponent=\"sub2\" threadId=\"th2\"/>  <msgDataElement msgLocale=\"EN\">    <msgCatalogTokens value=\"value\"/>    <msgId>msgId</msgId>    <msgIdType>Name</msgIdType>    <msgCatalogId>msgCatalogId</msgCatalogId>    <msgCatalogType>msgCatalogType</msgCatalogType>    <msgCatalog>msgCatalog</msgCatalog>  </msgDataElement>  <situation categoryName=\"StartSituation\">    <situationType reasoningScope=\"EXTERNAL\" successDisposition=\"SUCCESSFUL\" situationQualifier=\"START COMPLETED\" xsi:type=\"StartSituation\" />  </situation></CommonBaseEvent>";
        try {
            CommonBaseEvent commonBaseEvent = EventFormatter.eventFromCanonicalXML(string);
            Assert.assertEquals((String)commonBaseEvent.getGlobalInstanceId(), (String)"CEE736B610030D11D88000A27990EF8D1A");
            EList eList = commonBaseEvent.getAssociatedEvents();
            Assert.assertNotNull((Object)eList);
            Assert.assertTrue((eList.size() == 2 ? 1 : 0) != 0);
            AssociatedEvent associatedEvent = (AssociatedEvent)eList.get(0);
            Assert.assertNotNull((Object)associatedEvent);
            Assert.assertTrue((boolean)associatedEvent.getResolvedEvents().equals("i0000000000000000000000000000040 i00000000000000000000000000011132 i0000000000000000000000000022232"));
            Assert.assertTrue((boolean)associatedEvent.getAssociationEngine().equals("i0000000000000000000000000000032"));
            Assert.assertNull((Object)associatedEvent.getAssociationEngineInfo());
            associatedEvent = (AssociatedEvent)eList.get(1);
            Assert.assertNotNull((Object)associatedEvent);
            Assert.assertTrue((boolean)associatedEvent.getResolvedEvents().equals("i0000000000000000000000000000040"));
            Assert.assertNull((Object)associatedEvent.getAssociationEngine());
            AssociationEngine associationEngine = associatedEvent.getAssociationEngineInfo();
            Assert.assertNotNull((Object)associationEngine);
            Assert.assertTrue((boolean)associationEngine.getName().equals("MyCorrelationEngine"));
            Assert.assertTrue((boolean)associationEngine.getId().equals("i0000000000000000000000000000044"));
            Assert.assertTrue((boolean)associationEngine.getType().equals("Correlate"));
        }
        catch (AssertionFailedError assertionFailedError) {
            throw assertionFailedError;
        }
        catch (Throwable throwable) {
            Assert.assertTrue((String)throwable.toString(), (boolean)false);
        }
    }

    public void testEventAnyElementInXMLFragmentDeserialization() {
        String string = "<CommonBaseEvent creationTime=\"2001-12-31T12:00:00\" elapsedTime=\"0\" extensionName=\"Name\" globalInstanceId=\"CEE736B610030D11D88000A27990EF8D1A\" localInstanceId=\"\" msg=\"\" priority=\"0\" repeatCount=\"0\" sequenceNumber=\"0\" severity=\"0\" version=\"\"><contextDataElements name=\"\" type=\"\"><contextValue>contextValue</contextValue></contextDataElements> <extendedDataElements name=\"\" type=\"noValue\"><values>values</values> <children name=\"\" type=\"noValue\"> <values>values</values>    </children>     </extendedDataElements>    <associatedEvents resolvedEvents=\"i0000000000000000000000000000040\">      <associationEngine>i0000000000000000000000000000044</associationEngine>    </associatedEvents>    <reporterComponentId application=\"\" componentType=\"\" component=\"\" componentIdType=\"\" executionEnvironment=\"\" instanceId=\"\" location=\"\" locationType=\"Name\" processId=\"\" subComponent=\"\" threadId=\"\"/>    <sourceComponentId application=\"\" componentType=\"\" component=\"\" componentIdType=\"\" executionEnvironment=\"\" instanceId=\"\" location=\"\" locationType=\"Name\" processId=\"\" subComponent=\"\" threadId=\"\"/>    <msgDataElement msgLocale=\"EN\">      <msgCatalogTokens value=\"\"/>      <msgId>msgId</msgId>      <msgIdType>Name</msgIdType>      <msgCatalogId>msgCatalogId</msgCatalogId>      <msgCatalogType>msgCatalogType</msgCatalogType>      <msgCatalog>msgCatalog</msgCatalog>    </msgDataElement>    <situation categoryName=\"StartSituation\">    \t<situationType reasoningScope=\"EXTERNAL\" successDisposition=\"SUCCESSFUL\" situationQualifier=\"START COMPLETED\" xsi:type=\"StartSituation\" />\t</situation> \t <a:a xmlns:a=\"http://bar\" ><expression logicalOperator=\"AND\"><answer value=\"10\"></answer><preCondition xsi:type=\"SimpleNodeType\" propertyName=\"CommonBaseEvent:Source:contextDataElements\"  comparisonOperator=\"equals\"><answer value=\"9\"></answer><testPropertyName><answer value=\"8\"></answer>\"cbe:CommonBaseEvent:Target:contextDataElements\"</testPropertyName><answer value=\"7\"></answer></preCondition><answer value=\"6\"></answer><postCondition xsi:type=\"SimpleNodeType\" propertyName=\"CommonBaseEvent:Source:contextDataElements\" comparisonOperator=\"notNULL\"><answer value=\"5\"></answer><testPropertyName>\"cbe:CommonBaseEvent:Target:contextDataElements\"<answer value=\"4\"></answer></testPropertyName><answer value=\"3\"></answer></postCondition><answer value=\"2\"></answer></expression></a:a><a:a xmlns:a=\"http://bar\" ><expression logicalOperator=\"AND\"><answer value=\"10\"></answer><preCondition xsi:type=\"SimpleNodeType\" propertyName=\"CommonBaseEvent:Source:contextDataElements\"  comparisonOperator=\"equals\"><answer value=\"9\"></answer><testPropertyName><answer value=\"8\"></answer>\"cbe:CommonBaseEvent:Target:contextDataElements\"</testPropertyName><answer value=\"7\"></answer></preCondition><answer value=\"6\"></answer><postCondition xsi:type=\"SimpleNodeType\" propertyName=\"CommonBaseEvent:Source:contextDataElements\" comparisonOperator=\"notNULL\"><answer value=\"5\"></answer><testPropertyName>\"cbe:CommonBaseEvent:Target:contextDataElements\"<answer value=\"4\"></answer></testPropertyName><answer value=\"3\"></answer></postCondition><answer value=\"2\"></answer></expression></a:a><a:a xmlns:a=\"http://bar\" ><expression logicalOperator=\"AND\"><answer value=\"10\"></answer><preCondition xsi:type=\"SimpleNodeType\" propertyName=\"CommonBaseEvent:Source:contextDataElements\"  comparisonOperator=\"equals\"><answer value=\"9\"></answer><testPropertyName><answer value=\"8\"></answer>\"cbe:CommonBaseEvent:Target:contextDataElements\"</testPropertyName><answer value=\"7\"></answer></preCondition><answer value=\"6\"></answer><postCondition xsi:type=\"SimpleNodeType\" propertyName=\"CommonBaseEvent:Source:contextDataElements\" comparisonOperator=\"notNULL\"><answer value=\"5\"></answer><testPropertyName>\"cbe:CommonBaseEvent:Target:contextDataElements\"<answer value=\"4\"></answer></testPropertyName><answer value=\"3\"></answer></postCondition><answer value=\"2\"></answer></expression></a:a></CommonBaseEvent>";
        try {
            CommonBaseEvent commonBaseEvent = EventFormatter.eventFromCanonicalXML(string);
            String string2 = "<a:a xmlns:a=\"http://bar\"><expression logicalOperator=\"AND\"><answer value=\"10\"></answer><preCondition xsi:type=\"SimpleNodeType\" propertyName=\"CommonBaseEvent:Source:contextDataElements\" comparisonOperator=\"equals\"><answer value=\"9\"></answer><testPropertyName><answer value=\"8\"></answer>&quot;cbe:CommonBaseEvent:Target:contextDataElements&quot;</testPropertyName><answer value=\"7\"></answer></preCondition><answer value=\"6\"></answer><postCondition xsi:type=\"SimpleNodeType\" propertyName=\"CommonBaseEvent:Source:contextDataElements\" comparisonOperator=\"notNULL\"><answer value=\"5\"></answer><testPropertyName>&quot;cbe:CommonBaseEvent:Target:contextDataElements&quot;<answer value=\"4\"></answer></testPropertyName><answer value=\"3\"></answer></postCondition><answer value=\"2\"></answer></expression></a:a>";
            EList eList = commonBaseEvent.getAny();
            Assert.assertNotNull((Object)eList);
            Assert.assertTrue((eList.size() == 3 ? 1 : 0) != 0);
            int n = 0;
            while (n < eList.size()) {
                Assert.assertTrue((boolean)eList.get(n).equals(string2));
                ++n;
            }
        }
        catch (AssertionFailedError assertionFailedError) {
            throw assertionFailedError;
        }
        catch (Throwable throwable) {
            Assert.assertTrue((String)throwable.toString(), (boolean)false);
        }
    }

    public void testOtherSituationAnyElementInXMLFragmentDeserialization() {
        String string = "<CommonBaseEvent creationTime=\"2001-12-31T12:00:00\" elapsedTime=\"0\" extensionName=\"Name\" globalInstanceId=\"CEE736B610030D11D88000A27990EF8D1A\" localInstanceId=\"\" msg=\"\" priority=\"0\" repeatCount=\"0\" sequenceNumber=\"0\" severity=\"0\" version=\"\"><contextDataElements name=\"\" type=\"\"><contextValue>contextValue</contextValue></contextDataElements> <extendedDataElements name=\"\" type=\"noValue\"><values>values</values> <children name=\"\" type=\"noValue\"> <values>values</values>    </children>     </extendedDataElements>    <associatedEvents resolvedEvents=\"i0000000000000000000000000000040\">      <associationEngine>i0000000000000000000000000000044</associationEngine>    </associatedEvents>    <reporterComponentId application=\"\" componentType=\"\" component=\"\" componentIdType=\"\" executionEnvironment=\"\" instanceId=\"\" location=\"\" locationType=\"Name\" processId=\"\" subComponent=\"\" threadId=\"\"/>    <sourceComponentId application=\"\" componentType=\"\" component=\"\" componentIdType=\"\" executionEnvironment=\"\" instanceId=\"\" location=\"\" locationType=\"Name\" processId=\"\" subComponent=\"\" threadId=\"\"/>    <msgDataElement msgLocale=\"EN\">      <msgCatalogTokens value=\"\"/>      <msgId>msgId</msgId>      <msgIdType>Name</msgIdType>      <msgCatalogId>msgCatalogId</msgCatalogId>      <msgCatalogType>msgCatalogType</msgCatalogType>      <msgCatalog>msgCatalog</msgCatalog>    </msgDataElement>    <situation categoryName=\"OtherSituation\">    \t<situationType reasoningScope=\"EXTERNAL\" xsi:type=\"OtherSituation\"><a:a xmlns:a=\"http://bar\" ><expression logicalOperator=\"AND\"><answer value=\"10\"></answer><preCondition xsi:type=\"SimpleNodeType\" propertyName=\"CommonBaseEvent:Source:contextDataElements\"  comparisonOperator=\"equals\"><answer value=\"9\"></answer><testPropertyName><answer value=\"8\"></answer>\"cbe:CommonBaseEvent:Target:contextDataElements\"</testPropertyName><answer value=\"7\"></answer></preCondition><answer value=\"6\"></answer><postCondition xsi:type=\"SimpleNodeType\" propertyName=\"CommonBaseEvent:Source:contextDataElements\" comparisonOperator=\"notNULL\"><answer value=\"5\"></answer><testPropertyName>\"cbe:CommonBaseEvent:Target:contextDataElements\"<answer value=\"4\"></answer></testPropertyName><answer value=\"3\"></answer></postCondition><answer value=\"2\"></answer></expression></a:a><a:a xmlns:a=\"http://bar\" ><expression logicalOperator=\"AND\"><answer value=\"10\"></answer><preCondition xsi:type=\"SimpleNodeType\" propertyName=\"CommonBaseEvent:Source:contextDataElements\"  comparisonOperator=\"equals\"><answer value=\"9\"></answer><testPropertyName><answer value=\"8\"></answer>\"cbe:CommonBaseEvent:Target:contextDataElements\"</testPropertyName><answer value=\"7\"></answer></preCondition><answer value=\"6\"></answer><postCondition xsi:type=\"SimpleNodeType\" propertyName=\"CommonBaseEvent:Source:contextDataElements\" comparisonOperator=\"notNULL\"><answer value=\"5\"></answer><testPropertyName>\"cbe:CommonBaseEvent:Target:contextDataElements\"<answer value=\"4\"></answer></testPropertyName><answer value=\"3\"></answer></postCondition><answer value=\"2\"></answer></expression></a:a><a:a xmlns:a=\"http://bar\" ><expression logicalOperator=\"AND\"><answer value=\"10\"></answer><preCondition xsi:type=\"SimpleNodeType\" propertyName=\"CommonBaseEvent:Source:contextDataElements\"  comparisonOperator=\"equals\"><answer value=\"9\"></answer><testPropertyName><answer value=\"8\"></answer>\"cbe:CommonBaseEvent:Target:contextDataElements\"</testPropertyName><answer value=\"7\"></answer></preCondition><answer value=\"6\"></answer><postCondition xsi:type=\"SimpleNodeType\" propertyName=\"CommonBaseEvent:Source:contextDataElements\" comparisonOperator=\"notNULL\"><answer value=\"5\"></answer><testPropertyName>\"cbe:CommonBaseEvent:Target:contextDataElements\"<answer value=\"4\"></answer></testPropertyName><answer value=\"3\"></answer></postCondition><answer value=\"2\"></answer></expression></a:a></situationType>\t</situation></CommonBaseEvent>";
        try {
            CommonBaseEvent commonBaseEvent = EventFormatter.eventFromCanonicalXML(string);
            String string2 = "<a:a xmlns:a=\"http://bar\"><expression logicalOperator=\"AND\"><answer value=\"10\"></answer><preCondition xsi:type=\"SimpleNodeType\" propertyName=\"CommonBaseEvent:Source:contextDataElements\" comparisonOperator=\"equals\"><answer value=\"9\"></answer><testPropertyName><answer value=\"8\"></answer>&quot;cbe:CommonBaseEvent:Target:contextDataElements&quot;</testPropertyName><answer value=\"7\"></answer></preCondition><answer value=\"6\"></answer><postCondition xsi:type=\"SimpleNodeType\" propertyName=\"CommonBaseEvent:Source:contextDataElements\" comparisonOperator=\"notNULL\"><answer value=\"5\"></answer><testPropertyName>&quot;cbe:CommonBaseEvent:Target:contextDataElements&quot;<answer value=\"4\"></answer></testPropertyName><answer value=\"3\"></answer></postCondition><answer value=\"2\"></answer></expression></a:a><a:a xmlns:a=\"http://bar\"><expression logicalOperator=\"AND\"><answer value=\"10\"></answer><preCondition xsi:type=\"SimpleNodeType\" propertyName=\"CommonBaseEvent:Source:contextDataElements\" comparisonOperator=\"equals\"><answer value=\"9\"></answer><testPropertyName><answer value=\"8\"></answer>&quot;cbe:CommonBaseEvent:Target:contextDataElements&quot;</testPropertyName><answer value=\"7\"></answer></preCondition><answer value=\"6\"></answer><postCondition xsi:type=\"SimpleNodeType\" propertyName=\"CommonBaseEvent:Source:contextDataElements\" comparisonOperator=\"notNULL\"><answer value=\"5\"></answer><testPropertyName>&quot;cbe:CommonBaseEvent:Target:contextDataElements&quot;<answer value=\"4\"></answer></testPropertyName><answer value=\"3\"></answer></postCondition><answer value=\"2\"></answer></expression></a:a><a:a xmlns:a=\"http://bar\"><expression logicalOperator=\"AND\"><answer value=\"10\"></answer><preCondition xsi:type=\"SimpleNodeType\" propertyName=\"CommonBaseEvent:Source:contextDataElements\" comparisonOperator=\"equals\"><answer value=\"9\"></answer><testPropertyName><answer value=\"8\"></answer>&quot;cbe:CommonBaseEvent:Target:contextDataElements&quot;</testPropertyName><answer value=\"7\"></answer></preCondition><answer value=\"6\"></answer><postCondition xsi:type=\"SimpleNodeType\" propertyName=\"CommonBaseEvent:Source:contextDataElements\" comparisonOperator=\"notNULL\"><answer value=\"5\"></answer><testPropertyName>&quot;cbe:CommonBaseEvent:Target:contextDataElements&quot;<answer value=\"4\"></answer></testPropertyName><answer value=\"3\"></answer></postCondition><answer value=\"2\"></answer></expression></a:a>";
            Situation situation = commonBaseEvent.getSituation();
            Assert.assertNotNull((Object)situation);
            Assert.assertTrue((boolean)situation.getCategoryName().equals("OtherSituation"));
            SituationType situationType = situation.getSituationType();
            Assert.assertNotNull((Object)situationType);
            Assert.assertTrue((boolean)((OtherSituation)situationType).getAny().equals(string2));
        }
        catch (AssertionFailedError assertionFailedError) {
            throw assertionFailedError;
        }
        catch (Throwable throwable) {
            Assert.assertTrue((String)throwable.toString(), (boolean)false);
        }
    }

    public void testXMLDocumentDeserializationWithSpaces() {
        String string = "<?xml version=\"1.0\" encoding=\"ASCII\"?><CommonBaseEvents xmlns:cbe=\"http://www.ibm.com/AC/commonbaseevent1_0_1\"    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"    xsi:schemaLocation=\"http://www.ibm.com/AC/commonbaseevent1_0_1 commonbaseevent1_0_1.xsd \"    ><AssociationEngine id=\"i0000000000000000000000000000044\"    name=\"MyCorrelationEngine\"    type=\"Correlate\"/><CommonBaseEvent    creationTime=\"2001-12-31T12:00:00\"    extensionName=\"Name\"    globalInstanceId=\"CEE736B610030D11D88000A27990EF8D1A\"    >  <contextDataElements name=\"myContext\"    type=\"String\"    >    <contextValue    >contextValue</contextValue    >  </contextDataElements    >  <extendedDataElements name=\"ede1\"    type=\"noValue\"    >    <values       >values</values      >    <children name=\"chname1\"    type=\"noValue\"    >      <values    >values</values    >    </children    >  </extendedDataElements    >  <extendedDataElements name=\"ede2\"    type=\"noValue\"    >    <values    >values</values    >    <children name=\"chname2\"    type=\"noValue\"    >      <values    >values</values    >    </children    >  </extendedDataElements    >  <reporterComponentId application=\"appl1\"    componentType=\"compType1\"    component=\"comp1\"    componentIdType=\"compIdType1\"    executionEnvironment=\"exc1\"    instanceId=\"id1\"    location=\"loc1\"    locationType=\"Hostname\"    processId=\"pr1\"    subComponent=\"sub1\"    threadId=\"th1\"/>  <sourceComponentId application=\"app2\"    componentType=\"compType2\"    component=\"comp2\"    componentIdType=\"compIdType2\"    executionEnvironment=\"exc2\"    instanceId=\"id2\"    location=\"loc2\"    locationType=\"SNA\"    processId=\"pr2\"    subComponent=\"sub2\"    threadId=\"th2\"/>  <msgDataElement msgLocale=\"EN\"    >    <msgCatalogTokens value=\"value\"/>    <msgId    >msgId</msgId    >    <msgIdType    >Name</msgIdType    >    <msgCatalogId    >msgCatalogId</msgCatalogId    >    <msgCatalogType    >msgCatalogType</msgCatalogType    >    <msgCatalog    >msgCatalog</msgCatalog    >  </msgDataElement    >  <situation categoryName=\"StartSituation\"    >    <situationType reasoningScope=\"EXTERNAL\"    successDisposition=\"SUCCESSFUL\"    situationQualifier=\"START COMPLETED\"    xsi:type=\"StartSituation\"    />  </situation    ></CommonBaseEvent    ></CommonBaseEvents    >";
        try {
            CommonBaseEvent commonBaseEvent = EventFormatter.eventsFromCanonicalXMLDoc(string)[0];
            CommonBaseEvent commonBaseEvent2 = EventFormatter.eventsFromCanonicalXMLDoc(string)[0];
            Assert.assertEquals((Object)commonBaseEvent.getExtendedDataElements("root"), (Object)commonBaseEvent2.getExtendedDataElements("root"));
            Assert.assertEquals((Object)commonBaseEvent, (Object)commonBaseEvent2);
            Assert.assertEquals((String)commonBaseEvent.getGlobalInstanceId(), (String)"CEE736B610030D11D88000A27990EF8D1A");
            Assert.assertEquals((String)commonBaseEvent2.getGlobalInstanceId(), (String)"CEE736B610030D11D88000A27990EF8D1A");
            AssociationEngine associationEngine = EventFormatter.associationEnginesFromCanonicalXMLDoc(string)[0];
            AssociationEngine associationEngine2 = EventFormatter.associationEnginesFromCanonicalXMLDoc(string)[0];
            Assert.assertEquals((Object)associationEngine, (Object)associationEngine2);
            Assert.assertEquals((String)associationEngine.getId(), (String)"i0000000000000000000000000000044");
            Assert.assertEquals((String)associationEngine2.getId(), (String)"i0000000000000000000000000000044");
        }
        catch (AssertionFailedError assertionFailedError) {
            throw assertionFailedError;
        }
        catch (Throwable throwable) {
            Assert.assertTrue((String)throwable.toString(), (boolean)false);
        }
    }

    public void testXMLDocumentDeserialization() {
        String string = "<?xml version=\"1.0\" encoding=\"ASCII\"?><CommonBaseEvents xmlns:cbe=\"http://www.ibm.com/AC/commonbaseevent1_0_1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/AC/commonbaseevent1_0_1 commonbaseevent1_0_1.xsd \"><AssociationEngine id=\"i0000000000000000000000000000044\" name=\"MyCorrelationEngine\" type=\"Correlate\"/><CommonBaseEvent creationTime=\"2001-12-31T12:00:00\" extensionName=\"Name\" globalInstanceId=\"CEE736B610030D11D88000A27990EF8D1A\">  <contextDataElements name=\"myContext\" type=\"String\">    <contextValue>contextValue</contextValue>  </contextDataElements>  <extendedDataElements name=\"ede1\" type=\"noValue\">    <values>values</values>    <children name=\"chname1\" type=\"noValue\">      <values>values</values>    </children>  </extendedDataElements>  <extendedDataElements name=\"ede2\" type=\"noValue\">    <values>values</values>    <children name=\"chname2\" type=\"noValue\">      <values>values</values>    </children>  </extendedDataElements>  <reporterComponentId application=\"appl1\" componentType=\"compType1\" component=\"comp1\" componentIdType=\"compIdType1\" executionEnvironment=\"exc1\" instanceId=\"id1\" location=\"loc1\" locationType=\"Hostname\" processId=\"pr1\" subComponent=\"sub1\" threadId=\"th1\"/>  <sourceComponentId application=\"app2\" componentType=\"compType2\" component=\"comp2\" componentIdType=\"compIdType2\" executionEnvironment=\"exc2\" instanceId=\"id2\" location=\"loc2\" locationType=\"SNA\" processId=\"pr2\" subComponent=\"sub2\" threadId=\"th2\"/>  <msgDataElement msgLocale=\"EN\">    <msgCatalogTokens value=\"value\"/>    <msgId>msgId</msgId>    <msgIdType>Name</msgIdType>    <msgCatalogId>msgCatalogId</msgCatalogId>    <msgCatalogType>msgCatalogType</msgCatalogType>    <msgCatalog>msgCatalog</msgCatalog>  </msgDataElement>  <situation categoryName=\"StartSituation\">    <situationType reasoningScope=\"EXTERNAL\" successDisposition=\"SUCCESSFUL\" situationQualifier=\"START COMPLETED\" xsi:type=\"StartSituation\" />  </situation></CommonBaseEvent></CommonBaseEvents>";
        try {
            CommonBaseEvent commonBaseEvent = EventFormatter.eventsFromCanonicalXMLDoc(string)[0];
            CommonBaseEvent commonBaseEvent2 = EventFormatter.eventsFromCanonicalXMLDoc(string)[0];
            Assert.assertEquals((Object)commonBaseEvent.getExtendedDataElements("root"), (Object)commonBaseEvent2.getExtendedDataElements("root"));
            Assert.assertEquals((Object)commonBaseEvent, (Object)commonBaseEvent2);
            Assert.assertEquals((String)commonBaseEvent.getGlobalInstanceId(), (String)"CEE736B610030D11D88000A27990EF8D1A");
            Assert.assertEquals((String)commonBaseEvent2.getGlobalInstanceId(), (String)"CEE736B610030D11D88000A27990EF8D1A");
            AssociationEngine associationEngine = EventFormatter.associationEnginesFromCanonicalXMLDoc(string)[0];
            AssociationEngine associationEngine2 = EventFormatter.associationEnginesFromCanonicalXMLDoc(string)[0];
            Assert.assertEquals((Object)associationEngine, (Object)associationEngine2);
            Assert.assertEquals((String)associationEngine.getId(), (String)"i0000000000000000000000000000044");
            Assert.assertEquals((String)associationEngine2.getId(), (String)"i0000000000000000000000000000044");
        }
        catch (AssertionFailedError assertionFailedError) {
            throw assertionFailedError;
        }
        catch (Throwable throwable) {
            Assert.assertTrue((String)throwable.toString(), (boolean)false);
        }
    }

    public void testXMLDocumentWithMultipleEventsDeserialization() {
        String string = "<?xml version=\"1.0\" encoding=\"ASCII\"?><CommonBaseEvents xmlns:cbe=\"http://www.ibm.com/AC/commonbaseevent1_0_1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/AC/commonbaseevent1_0_1 commonbaseevent1_0_1.xsd \"><AssociationEngine id=\"i0000000000000000000000000000044\" name=\"MyCorrelationEngine\" type=\"Correlate\"/><AssociationEngine id=\"i0000000000000000000000000000045\" name=\"MyCorrelationEngine\" type=\"Correlate\"/><AssociationEngine id=\"i0000000000000000000000000000046\" name=\"MyCorrelationEngine\" type=\"Correlate\"/><CommonBaseEvent creationTime=\"2001-12-31T12:00:00\" extensionName=\"Name\" globalInstanceId=\"CEE736B610030D11D88000A27990EF8D1A1\">  <contextDataElements name=\"myContext\" type=\"String\">    <contextValue>contextValue</contextValue>  </contextDataElements>  <extendedDataElements name=\"ede1\" type=\"noValue\">    <values>values</values>    <children name=\"chname1\" type=\"noValue\">      <values>values</values>    </children>  </extendedDataElements>  <extendedDataElements name=\"ede2\" type=\"noValue\">    <values>values</values>    <children name=\"chname2\" type=\"noValue\">      <values>values</values>    </children>  </extendedDataElements>  <reporterComponentId application=\"appl1\" componentType=\"compType1\" component=\"comp1\" componentIdType=\"compIdType1\" executionEnvironment=\"exc1\" instanceId=\"id1\" location=\"loc1\" locationType=\"Hostname\" processId=\"pr1\" subComponent=\"sub1\" threadId=\"th1\"/>  <sourceComponentId application=\"app2\" componentType=\"compType2\" component=\"comp2\" componentIdType=\"compIdType2\" executionEnvironment=\"exc2\" instanceId=\"id2\" location=\"loc2\" locationType=\"SNA\" processId=\"pr2\" subComponent=\"sub2\" threadId=\"th2\"/>  <msgDataElement msgLocale=\"EN\">    <msgCatalogTokens value=\"value\"/>    <msgId>msgId</msgId>    <msgIdType>Name</msgIdType>    <msgCatalogId>msgCatalogId</msgCatalogId>    <msgCatalogType>msgCatalogType</msgCatalogType>    <msgCatalog>msgCatalog</msgCatalog>  </msgDataElement>  <situation categoryName=\"StartSituation\">    <situationType reasoningScope=\"EXTERNAL\" successDisposition=\"SUCCESSFUL\" situationQualifier=\"START COMPLETED\" xsi:type=\"StartSituation\" />  </situation></CommonBaseEvent><CommonBaseEvent creationTime=\"2001-12-31T12:00:00\" extensionName=\"Name\" globalInstanceId=\"CEE736B610030D11D88000A27990EF8D1A2\">  <contextDataElements name=\"myContext\" type=\"String\">    <contextValue>contextValue</contextValue>  </contextDataElements>  <extendedDataElements name=\"ede1\" type=\"noValue\">    <values>values</values>    <children name=\"chname1\" type=\"noValue\">      <values>values</values>    </children>  </extendedDataElements>  <extendedDataElements name=\"ede2\" type=\"noValue\">    <values>values</values>    <children name=\"chname2\" type=\"noValue\">      <values>values</values>    </children>  </extendedDataElements>  <reporterComponentId application=\"appl1\" componentType=\"compType1\" component=\"comp1\" componentIdType=\"compIdType1\" executionEnvironment=\"exc1\" instanceId=\"id1\" location=\"loc1\" locationType=\"Hostname\" processId=\"pr1\" subComponent=\"sub1\" threadId=\"th1\"/>  <sourceComponentId application=\"app2\" componentType=\"compType2\" component=\"comp2\" componentIdType=\"compIdType2\" executionEnvironment=\"exc2\" instanceId=\"id2\" location=\"loc2\" locationType=\"SNA\" processId=\"pr2\" subComponent=\"sub2\" threadId=\"th2\"/>  <msgDataElement msgLocale=\"EN\">    <msgCatalogTokens value=\"value\"/>    <msgId>msgId</msgId>    <msgIdType>Name</msgIdType>    <msgCatalogId>msgCatalogId</msgCatalogId>    <msgCatalogType>msgCatalogType</msgCatalogType>    <msgCatalog>msgCatalog</msgCatalog>  </msgDataElement>  <situation categoryName=\"StartSituation\">    <situationType reasoningScope=\"EXTERNAL\" successDisposition=\"SUCCESSFUL\" situationQualifier=\"START COMPLETED\" xsi:type=\"StartSituation\" />  </situation></CommonBaseEvent><CommonBaseEvent creationTime=\"2001-12-31T12:00:00\" extensionName=\"Name\" globalInstanceId=\"CEE736B610030D11D88000A27990EF8D1A3\">  <contextDataElements name=\"myContext\" type=\"String\">    <contextValue>contextValue</contextValue>  </contextDataElements>  <extendedDataElements name=\"ede1\" type=\"noValue\">    <values>values</values>    <children name=\"chname1\" type=\"noValue\">      <values>values</values>    </children>  </extendedDataElements>  <extendedDataElements name=\"ede2\" type=\"noValue\">    <values>values</values>    <children name=\"chname2\" type=\"noValue\">      <values>values</values>    </children>  </extendedDataElements>  <reporterComponentId application=\"appl1\" componentType=\"compType1\" component=\"comp1\" componentIdType=\"compIdType1\" executionEnvironment=\"exc1\" instanceId=\"id1\" location=\"loc1\" locationType=\"Hostname\" processId=\"pr1\" subComponent=\"sub1\" threadId=\"th1\"/>  <sourceComponentId application=\"app2\" componentType=\"compType2\" component=\"comp2\" componentIdType=\"compIdType2\" executionEnvironment=\"exc2\" instanceId=\"id2\" location=\"loc2\" locationType=\"SNA\" processId=\"pr2\" subComponent=\"sub2\" threadId=\"th2\"/>  <msgDataElement msgLocale=\"EN\">    <msgCatalogTokens value=\"value\"/>    <msgId>msgId</msgId>    <msgIdType>Name</msgIdType>    <msgCatalogId>msgCatalogId</msgCatalogId>    <msgCatalogType>msgCatalogType</msgCatalogType>    <msgCatalog>msgCatalog</msgCatalog>  </msgDataElement>  <situation categoryName=\"StartSituation\">    <situationType reasoningScope=\"EXTERNAL\" successDisposition=\"SUCCESSFUL\" situationQualifier=\"START COMPLETED\" xsi:type=\"StartSituation\" />  </situation></CommonBaseEvent></CommonBaseEvents>";
        try {
            AssociationEngine[] associationEngineArray;
            CommonBaseEvent[] commonBaseEventArray = EventFormatter.eventsFromCanonicalXMLDoc(string);
            CommonBaseEvent[] commonBaseEventArray2 = EventFormatter.eventsFromCanonicalXMLDoc(string);
            Assert.assertTrue((commonBaseEventArray.length == commonBaseEventArray2.length ? 1 : 0) != 0);
            int n = 0;
            while (n < commonBaseEventArray.length) {
                Assert.assertEquals((Object)commonBaseEventArray[n].getExtendedDataElements("root"), (Object)commonBaseEventArray2[n].getExtendedDataElements("root"));
                Assert.assertEquals((Object)commonBaseEventArray[n], (Object)commonBaseEventArray2[n]);
                Assert.assertTrue((boolean)commonBaseEventArray[n].getGlobalInstanceId().startsWith("CEE736B610030D11D88000A27990EF8D1A"));
                Assert.assertTrue((boolean)commonBaseEventArray2[n].getGlobalInstanceId().startsWith("CEE736B610030D11D88000A27990EF8D1A"));
                ++n;
            }
            AssociationEngine[] associationEngineArray2 = EventFormatter.associationEnginesFromCanonicalXMLDoc(string);
            Assert.assertTrue((associationEngineArray2.length == (associationEngineArray = EventFormatter.associationEnginesFromCanonicalXMLDoc(string)).length ? 1 : 0) != 0);
            int n2 = 0;
            while (n2 < associationEngineArray2.length) {
                Assert.assertEquals((Object)associationEngineArray2[n2], (Object)associationEngineArray[n2]);
                Assert.assertTrue((boolean)associationEngineArray2[n2].getId().startsWith("i000000000000000000000000000004"));
                Assert.assertTrue((boolean)associationEngineArray[n2].getId().startsWith("i000000000000000000000000000004"));
                ++n2;
            }
        }
        catch (AssertionFailedError assertionFailedError) {
            throw assertionFailedError;
        }
        catch (Throwable throwable) {
            Assert.assertTrue((String)throwable.toString(), (boolean)false);
        }
    }

    public void testCBE101Sample1XMLDocumentDeserialization() {
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><CommonBaseEvents xmlns=\"http://www.ibm.com/AC/commonbaseevent1_0_1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/AC/commonbaseevent1_0_1 commonbaseevent1_0_1.xsd \"> <AssociationEngine id=\"i0000000000000000000000000000044\" name=\"MyCorrelationEngine\" type=\"Correlate\"/><CommonBaseEvent creationTime=\"2001-12-31T12:00:00\" elapsedTime=\"0\" extensionName=\"Name\" globalInstanceId=\"CEE736B610030D11D88000A27990EF8D1A\" localInstanceId=\"\" msg=\"\" priority=\"0\" repeatCount=\"0\" sequenceNumber=\"0\" severity=\"0\" version=\"\">    <contextDataElements name=\"myContext\" type=\"String\">      <contextValue>contextValue</contextValue>     </contextDataElements>    <extendedDataElements name=\"\" type=\"noValue\">      <values>values</values>        <children name=\"\" type=\"noValue\">          <values>values</values>       </children>       </extendedDataElements>    <associatedEvents resolvedEvents=\"i0000000000000000000000000000040\">      <associationEngineInfo id=\"i0000000000000000000000000000044\" name=\"MyCorrelationEngine\" type=\"Correlate\"/>    </associatedEvents>    <reporterComponentId application=\"\" componentType=\"\" component=\"\" componentIdType=\"\" executionEnvironment=\"\" instanceId=\"\" location=\"\" locationType=\"Name\" processId=\"\" subComponent=\"\" threadId=\"\"/>    <sourceComponentId application=\"\" componentType=\"\" component=\"\" componentIdType=\"\" executionEnvironment=\"\" instanceId=\"\" location=\"\" locationType=\"Name\" processId=\"\" subComponent=\"\" threadId=\"\"/>    <msgDataElement msgLocale=\"EN\">       <msgCatalogTokens value=\"\"/>      <msgId>msgId</msgId>      <msgIdType>Name</msgIdType>      <msgCatalogId>msgCatalogId</msgCatalogId>      <msgCatalogType>msgCatalogType</msgCatalogType>      <msgCatalog>msgCatalog</msgCatalog>    </msgDataElement>    <situation categoryName=\"StartSituation\">     \t<situationType reasoningScope=\"EXTERNAL\" successDisposition=\"SUCCESSFUL\" situationQualifier=\"START COMPLETED\" xsi:type=\"StartSituation\" />     </situation>\t       <a:a xmlns:a=\"http://bar\" />   </CommonBaseEvent></CommonBaseEvents>";
        try {
            CommonBaseEvent commonBaseEvent = EventFormatter.eventsFromCanonicalXMLDoc(string)[0];
            CommonBaseEvent commonBaseEvent2 = EventFormatter.eventsFromCanonicalXMLDoc(string)[0];
            Assert.assertEquals((Object)commonBaseEvent, (Object)commonBaseEvent2);
            Assert.assertEquals((String)commonBaseEvent.getGlobalInstanceId(), (String)"CEE736B610030D11D88000A27990EF8D1A");
            Assert.assertEquals((String)commonBaseEvent2.getGlobalInstanceId(), (String)"CEE736B610030D11D88000A27990EF8D1A");
            AssociationEngine associationEngine = EventFormatter.associationEnginesFromCanonicalXMLDoc(string)[0];
            AssociationEngine associationEngine2 = EventFormatter.associationEnginesFromCanonicalXMLDoc(string)[0];
            Assert.assertEquals((Object)associationEngine, (Object)associationEngine2);
            Assert.assertEquals((String)associationEngine.getId(), (String)"i0000000000000000000000000000044");
            Assert.assertEquals((String)associationEngine2.getId(), (String)"i0000000000000000000000000000044");
        }
        catch (AssertionFailedError assertionFailedError) {
            throw assertionFailedError;
        }
        catch (Throwable throwable) {
            Assert.assertTrue((String)throwable.toString(), (boolean)false);
        }
    }

    public void testCBE101Sample2XMLDocumentDeserialization() {
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><CommonBaseEvents xmlns=\"http://www.ibm.com/AC/commonbaseevent1_0_1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/AC/commonbaseevent1_0_1 commonbaseevent1_0_1.xsd \"><AssociationEngine id=\"i0000000000000000000000000000044\" name=\"MyCorrelationEngine\" type=\"Correlate\"/><CommonBaseEvent creationTime=\"2001-12-31T12:00:00\" elapsedTime=\"0\" extensionName=\"Name\" globalInstanceId=\"CEE736B610030D11D88000A27990EF8D1A\" localInstanceId=\"\" msg=\"\" priority=\"0\" repeatCount=\"0\" sequenceNumber=\"0\" severity=\"0\" version=\"\"><contextDataElements name=\"\" type=\"\"><contextValue>contextValue</contextValue></contextDataElements> <extendedDataElements name=\"\" type=\"noValue\"><values>values</values> <children name=\"\" type=\"noValue\"> <values>values</values>    </children>     </extendedDataElements>    <associatedEvents resolvedEvents=\"i0000000000000000000000000000040\">      <associationEngine>i0000000000000000000000000000044</associationEngine>    </associatedEvents>    <reporterComponentId application=\"\" componentType=\"\" component=\"\" componentIdType=\"\" executionEnvironment=\"\" instanceId=\"\" location=\"\" locationType=\"Name\" processId=\"\" subComponent=\"\" threadId=\"\"/>    <sourceComponentId application=\"\" componentType=\"\" component=\"\" componentIdType=\"\" executionEnvironment=\"\" instanceId=\"\" location=\"\" locationType=\"Name\" processId=\"\" subComponent=\"\" threadId=\"\"/>    <msgDataElement msgLocale=\"EN\">      <msgCatalogTokens value=\"\"/>      <msgId>msgId</msgId>      <msgIdType>Name</msgIdType>      <msgCatalogId>msgCatalogId</msgCatalogId>      <msgCatalogType>msgCatalogType</msgCatalogType>      <msgCatalog>msgCatalog</msgCatalog>    </msgDataElement>    <situation categoryName=\"StartSituation\">    \t<situationType reasoningScope=\"EXTERNAL\" successDisposition=\"SUCCESSFUL\" situationQualifier=\"START COMPLETED\" xsi:type=\"StartSituation\" />\t</situation> \t <a:a xmlns:a=\"http://bar\" > \t     <expression logicalOperator=\"AND\"><preCondition xsi:type=\"SimpleNodeType\" propertyName=\"CommonBaseEvent:Source:contextDataElements\"  comparisonOperator=\"equals\"><testPropertyName>\"cbe:CommonBaseEvent:Target:contextDataElements\"</testPropertyName></preCondition><postCondition xsi:type=\"SimpleNodeType\" propertyName=\"CommonBaseEvent:Source:contextDataElements\" comparisonOperator=\"notNULL\"><testPropertyName>\"cbe:CommonBaseEvent:Target:contextDataElements\"</testPropertyName></postCondition></expression><answer value=\"0\"/></a:a></CommonBaseEvent></CommonBaseEvents>";
        try {
            CommonBaseEvent commonBaseEvent = EventFormatter.eventsFromCanonicalXMLDoc(string)[0];
            CommonBaseEvent commonBaseEvent2 = EventFormatter.eventsFromCanonicalXMLDoc(string)[0];
            Assert.assertEquals((Object)commonBaseEvent, (Object)commonBaseEvent2);
            Assert.assertEquals((String)commonBaseEvent.getGlobalInstanceId(), (String)"CEE736B610030D11D88000A27990EF8D1A");
            Assert.assertEquals((String)commonBaseEvent2.getGlobalInstanceId(), (String)"CEE736B610030D11D88000A27990EF8D1A");
            AssociationEngine associationEngine = EventFormatter.associationEnginesFromCanonicalXMLDoc(string)[0];
            AssociationEngine associationEngine2 = EventFormatter.associationEnginesFromCanonicalXMLDoc(string)[0];
            Assert.assertEquals((Object)associationEngine, (Object)associationEngine2);
            Assert.assertEquals((String)associationEngine.getId(), (String)"i0000000000000000000000000000044");
            Assert.assertEquals((String)associationEngine2.getId(), (String)"i0000000000000000000000000000044");
        }
        catch (AssertionFailedError assertionFailedError) {
            throw assertionFailedError;
        }
        catch (Throwable throwable) {
            Assert.assertTrue((String)throwable.toString(), (boolean)false);
        }
    }

    public void testEventScatteredAnyElementInXMLFragmentDeserialization() {
        String string = "<CommonBaseEvent   xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"   xmlns=\"http://www.ibm.com/AC/commonbaseevent1_0_1\"   creationTime=\"2001-12-31T12:00:00\" extensionName=\"Name\" globalInstanceId=\"i0000000000000000000000000000040\"><GetLastTrade><symbol>DEF</symbol></GetLastTrade><any1 namespace=\"##other\" processContents=\"skip\" /><sourceComponentId   application=\"appl_src\"  componentType=\"compType_src\"   component=\"comp_src\"   componentIdType=\"compIdType_src\" executionEnvironment=\"exc_src\"   instanceId=\"id_src\"   location=\"loc_src\"   locationType=\"Hostname\"  processId=\"pr_src\"   subComponent=\"sub_src\"   threadId=\"th_src\"/><any2><abc>d=\"e f\"</abc></any2><situation categoryName=\"AvailableSituation\">      <situationType     reasoningScope=\"INTERNAL\" operationDisposition=\"STARTABLE\"   availabilityDisposition=\"AVAILABLE\"  processingDisposition=\"FUNCTION_PROCESS\"  xsi:type=\"AvailableSituation\" />  </situation><any namespace=\"##other\" processContents=\"skip\" /></CommonBaseEvent>";
        try {
            CommonBaseEvent commonBaseEvent = EventFormatter.eventFromCanonicalXML(string);
            String[] stringArray = new String[]{"<GetLastTrade><symbol>DEF</symbol></GetLastTrade>", "<any1 namespace=\"##other\" processContents=\"skip\"></any1>", "<any2><abc>d=&quot;e f&quot;</abc></any2>", "<any namespace=\"##other\" processContents=\"skip\"></any>"};
            EList eList = commonBaseEvent.getAny();
            Assert.assertNotNull((Object)eList);
            Assert.assertTrue((eList.size() == 4 ? 1 : 0) != 0);
            int n = 0;
            while (n < eList.size()) {
                Assert.assertTrue((boolean)eList.get(n).equals(stringArray[n]));
                ++n;
            }
        }
        catch (AssertionFailedError assertionFailedError) {
            throw assertionFailedError;
        }
        catch (Throwable throwable) {
            Assert.assertTrue((String)throwable.toString(), (boolean)false);
        }
    }

    public void testCBEPropertiesAfterXMLDocumentDeserialization() {
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><CommonBaseEvents xmlns=\"http://www.ibm.com/AC/commonbaseevent1_0_1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/AC/commonbaseevent1_0_1 commonbaseevent1_0_1.xsd \"><AssociationEngine id=\"i0000000000000000000000000000044\" name=\"MyCorrelationEngine\" type=\"Correlate\"/><CommonBaseEvent creationTime=\"2001-12-31T12:00:00\" elapsedTime=\"0\" extensionName=\"Name\" globalInstanceId=\"CEE736B610030D11D88000A27990EF8D1A\" localInstanceId=\"\" msg=\"\" priority=\"0\" repeatCount=\"0\" sequenceNumber=\"0\" severity=\"0\" version=\"\"><contextDataElements name=\"\" type=\"\"><contextValue>contextValue</contextValue></contextDataElements> <extendedDataElements name=\"\" type=\"noValue\"><values>values</values> <children name=\"\" type=\"noValue\"> <values>values</values>    </children>     </extendedDataElements>    <associatedEvents resolvedEvents=\"i0000000000000000000000000000040\">      <associationEngine>i0000000000000000000000000000044</associationEngine>    </associatedEvents>    <reporterComponentId application=\"\" componentType=\"\" component=\"\" componentIdType=\"\" executionEnvironment=\"\" instanceId=\"\" location=\"\" locationType=\"Name\" processId=\"\" subComponent=\"\" threadId=\"\"/>    <sourceComponentId application=\"\" componentType=\"\" component=\"\" componentIdType=\"\" executionEnvironment=\"\" instanceId=\"\" location=\"\" locationType=\"Name\" processId=\"\" subComponent=\"\" threadId=\"\"/>    <msgDataElement msgLocale=\"EN\">      <msgCatalogTokens value=\"\"/>      <msgId>msgId</msgId>      <msgIdType>Name</msgIdType>      <msgCatalogId>msgCatalogId</msgCatalogId>      <msgCatalogType>msgCatalogType</msgCatalogType>      <msgCatalog>msgCatalog</msgCatalog>    </msgDataElement>    <situation categoryName=\"StartSituation\">    \t<situationType reasoningScope=\"EXTERNAL\" successDisposition=\"SUCCESSFUL\" situationQualifier=\"START COMPLETED\" xsi:type=\"StartSituation\" />\t</situation> \t <a:a xmlns:a=\"http://bar\" > \t     <expression logicalOperator=\"AND\"><preCondition xsi:type=\"SimpleNodeType\" propertyName=\"CommonBaseEvent:Source:contextDataElements\"  comparisonOperator=\"equals\"><testPropertyName>\"cbe:CommonBaseEvent:Target:contextDataElements\"</testPropertyName></preCondition><postCondition xsi:type=\"SimpleNodeType\" propertyName=\"CommonBaseEvent:Source:contextDataElements\" comparisonOperator=\"notNULL\"><testPropertyName>\"cbe:CommonBaseEvent:Target:contextDataElements\"</testPropertyName></postCondition></expression><answer value=\"0\"/></a:a></CommonBaseEvent></CommonBaseEvents>";
        try {
            AssociationEngine[] associationEngineArray = EventFormatter.associationEnginesFromCanonicalXMLDoc(string);
            Assert.assertNotNull((Object)associationEngineArray);
            Assert.assertTrue((associationEngineArray.length == 1 ? 1 : 0) != 0);
            Assert.assertNotNull((Object)associationEngineArray[0]);
            Assert.assertTrue((boolean)associationEngineArray[0].getId().equals("i0000000000000000000000000000044"));
            Assert.assertTrue((boolean)associationEngineArray[0].getName().equals("MyCorrelationEngine"));
            Assert.assertTrue((boolean)associationEngineArray[0].getType().equals("Correlate"));
            CommonBaseEvent[] commonBaseEventArray = EventFormatter.eventsFromCanonicalXMLDoc(string);
            Assert.assertNotNull((Object)commonBaseEventArray);
            Assert.assertTrue((commonBaseEventArray.length == 1 ? 1 : 0) != 0);
            Assert.assertNotNull((Object)commonBaseEventArray[0]);
            Assert.assertTrue((boolean)commonBaseEventArray[0].isSetCreationTime());
            Assert.assertTrue((boolean)commonBaseEventArray[0].getCreationTime().equals("2001-12-31T12:00:00"));
            Assert.assertTrue((commonBaseEventArray[0].getCreationTimeAsLong() == EventHelpers.dateToLong("2001-12-31T12:00:00") ? 1 : 0) != 0);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            simpleDateFormat.setCalendar(new GregorianCalendar(new SimpleTimeZone(0, "UTC")));
            Assert.assertTrue((commonBaseEventArray[0].getCreationTimeAsLong() == simpleDateFormat.parse("2001-12-31T12:00:00").getTime() ? 1 : 0) != 0);
            Assert.assertTrue((boolean)commonBaseEventArray[0].isSetElapsedTime());
            Assert.assertTrue((commonBaseEventArray[0].getElapsedTime() == 0L ? 1 : 0) != 0);
            Assert.assertTrue((boolean)commonBaseEventArray[0].getExtensionName().equals("Name"));
            Assert.assertTrue((boolean)commonBaseEventArray[0].getGlobalInstanceId().equals("CEE736B610030D11D88000A27990EF8D1A"));
            Assert.assertTrue((boolean)commonBaseEventArray[0].getLocalInstanceId().equals(""));
            Assert.assertTrue((boolean)commonBaseEventArray[0].isSetPriority());
            Assert.assertTrue((commonBaseEventArray[0].getPriority() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)commonBaseEventArray[0].isSetSeverity());
            Assert.assertTrue((commonBaseEventArray[0].getSeverity() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)commonBaseEventArray[0].isSetRepeatCount());
            Assert.assertTrue((commonBaseEventArray[0].getRepeatCount() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)commonBaseEventArray[0].isSetSequenceNumber());
            Assert.assertTrue((commonBaseEventArray[0].getSequenceNumber() == 0L ? 1 : 0) != 0);
            Assert.assertTrue((boolean)commonBaseEventArray[0].getVersion().equals(""));
            EList eList = commonBaseEventArray[0].getContextDataElements();
            Assert.assertNotNull((Object)eList);
            Assert.assertTrue((eList.size() == 1 ? 1 : 0) != 0);
            Assert.assertNotNull(eList.get(0));
            Assert.assertTrue((boolean)((ContextDataElement)eList.get(0)).getName().equals(""));
            Assert.assertTrue((boolean)((ContextDataElement)eList.get(0)).getType().equals(""));
            Assert.assertTrue((boolean)((ContextDataElement)eList.get(0)).getContextValue().equals("contextValue"));
            Assert.assertNull((Object)((ContextDataElement)eList.get(0)).getContextId());
            EList eList2 = commonBaseEventArray[0].getExtendedDataElements();
            Assert.assertNotNull((Object)eList2);
            Assert.assertTrue((eList2.size() == 1 ? 1 : 0) != 0);
            Assert.assertNotNull(eList2.get(0));
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(0)).getName().equals(""));
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(0)).getType().equals("noValue"));
            Assert.assertTrue((((ExtendedDataElement)eList2.get(0)).getValues().size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(0)).getValues().get(0).equals("values"));
            Assert.assertNull((Object)((ExtendedDataElement)eList2.get(0)).getHexValue());
            Assert.assertTrue((((ExtendedDataElement)eList2.get(0)).getChildren().size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((ExtendedDataElement)((ExtendedDataElement)eList2.get(0)).getChildren().get(0)).getName().equals(""));
            Assert.assertTrue((boolean)((ExtendedDataElement)((ExtendedDataElement)eList2.get(0)).getChildren().get(0)).getType().equals("noValue"));
            Assert.assertTrue((((ExtendedDataElement)((ExtendedDataElement)eList2.get(0)).getChildren().get(0)).getValues().size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((ExtendedDataElement)((ExtendedDataElement)eList2.get(0)).getChildren().get(0)).getValues().get(0).equals("values"));
            Assert.assertNull((Object)((ExtendedDataElement)((ExtendedDataElement)eList2.get(0)).getChildren().get(0)).getHexValue());
            EList eList3 = commonBaseEventArray[0].getAssociatedEvents();
            Assert.assertNotNull((Object)eList3);
            Assert.assertTrue((eList3.size() == 1 ? 1 : 0) != 0);
            Assert.assertNotNull(eList3.get(0));
            Assert.assertTrue((boolean)((AssociatedEvent)eList3.get(0)).getResolvedEvents().equals("i0000000000000000000000000000040"));
            Assert.assertTrue((boolean)((AssociatedEvent)eList3.get(0)).getAssociationEngine().equals("i0000000000000000000000000000044"));
            Assert.assertNull((Object)((AssociatedEvent)eList3.get(0)).getAssociationEngineInfo());
            ComponentIdentification componentIdentification = commonBaseEventArray[0].getReporterComponentId();
            Assert.assertNotNull((Object)componentIdentification);
            Assert.assertTrue((boolean)componentIdentification.getApplication().equals(""));
            Assert.assertTrue((boolean)componentIdentification.getComponentType().equals(""));
            Assert.assertTrue((boolean)componentIdentification.getComponent().equals(""));
            Assert.assertTrue((boolean)componentIdentification.getComponentIdType().equals(""));
            Assert.assertTrue((boolean)componentIdentification.getExecutionEnvironment().equals(""));
            Assert.assertTrue((boolean)componentIdentification.getInstanceId().equals(""));
            Assert.assertTrue((boolean)componentIdentification.getLocation().equals(""));
            Assert.assertTrue((boolean)componentIdentification.getLocationType().equals("Name"));
            Assert.assertTrue((boolean)componentIdentification.getProcessId().equals(""));
            Assert.assertTrue((boolean)componentIdentification.getSubComponent().equals(""));
            Assert.assertTrue((boolean)componentIdentification.getThreadId().equals(""));
            ComponentIdentification componentIdentification2 = commonBaseEventArray[0].getSourceComponentId();
            Assert.assertNotNull((Object)componentIdentification2);
            Assert.assertTrue((boolean)componentIdentification2.getApplication().equals(""));
            Assert.assertTrue((boolean)componentIdentification2.getComponentType().equals(""));
            Assert.assertTrue((boolean)componentIdentification2.getComponent().equals(""));
            Assert.assertTrue((boolean)componentIdentification2.getComponentIdType().equals(""));
            Assert.assertTrue((boolean)componentIdentification2.getExecutionEnvironment().equals(""));
            Assert.assertTrue((boolean)componentIdentification2.getInstanceId().equals(""));
            Assert.assertTrue((boolean)componentIdentification2.getLocation().equals(""));
            Assert.assertTrue((boolean)componentIdentification2.getLocationType().equals("Name"));
            Assert.assertTrue((boolean)componentIdentification2.getProcessId().equals(""));
            Assert.assertTrue((boolean)componentIdentification2.getSubComponent().equals(""));
            Assert.assertTrue((boolean)componentIdentification2.getThreadId().equals(""));
            MsgDataElement msgDataElement = commonBaseEventArray[0].getMsgDataElement();
            Assert.assertNotNull((Object)msgDataElement);
            Assert.assertTrue((boolean)msgDataElement.getMsgLocale().equals("EN"));
            Assert.assertTrue((boolean)msgDataElement.getMsgCatalog().equals("msgCatalog"));
            Assert.assertTrue((boolean)msgDataElement.getMsgCatalogId().equals("msgCatalogId"));
            Assert.assertTrue((boolean)msgDataElement.getMsgCatalogType().equals("msgCatalogType"));
            Assert.assertTrue((boolean)msgDataElement.getMsgId().equals("msgId"));
            Assert.assertTrue((boolean)msgDataElement.getMsgIdType().equals("Name"));
            Assert.assertNotNull((Object)msgDataElement.getMsgCatalogTokens());
            Assert.assertTrue((msgDataElement.getMsgCatalogTokens().size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((MsgCatalogToken)msgDataElement.getMsgCatalogTokens().get(0)).getValue().equals(""));
            Situation situation = commonBaseEventArray[0].getSituation();
            Assert.assertNotNull((Object)situation);
            Assert.assertTrue((boolean)situation.getCategoryName().equals("StartSituation"));
            SituationType situationType = situation.getSituationType();
            Assert.assertNotNull((Object)situationType);
            Assert.assertTrue((boolean)(situationType instanceof StartSituation));
            Assert.assertTrue((boolean)((StartSituation)situationType).getReasoningScope().equals("EXTERNAL"));
            Assert.assertTrue((boolean)((StartSituation)situationType).getSituationQualifier().equals("START COMPLETED"));
            Assert.assertTrue((boolean)((StartSituation)situationType).getSuccessDisposition().equals("SUCCESSFUL"));
            String string2 = "<a:a xmlns:a=\"http://bar\"><expression logicalOperator=\"AND\"><preCondition xsi:type=\"SimpleNodeType\" propertyName=\"CommonBaseEvent:Source:contextDataElements\" comparisonOperator=\"equals\"><testPropertyName>&quot;cbe:CommonBaseEvent:Target:contextDataElements&quot;</testPropertyName></preCondition><postCondition xsi:type=\"SimpleNodeType\" propertyName=\"CommonBaseEvent:Source:contextDataElements\" comparisonOperator=\"notNULL\"><testPropertyName>&quot;cbe:CommonBaseEvent:Target:contextDataElements&quot;</testPropertyName></postCondition></expression><answer value=\"0\"></answer></a:a>";
            EList eList4 = commonBaseEventArray[0].getAny();
            Assert.assertNotNull((Object)eList4);
            Assert.assertTrue((eList4.size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)eList4.get(0).equals(string2));
            Assert.assertEquals((Object)commonBaseEventArray[0], (Object)EventFormatter.eventFromCanonicalXML(EventFormatter.toCanonicalXMLString(commonBaseEventArray[0], false)));
        }
        catch (AssertionFailedError assertionFailedError) {
            throw assertionFailedError;
        }
        catch (Throwable throwable) {
            Assert.assertTrue((String)throwable.toString(), (boolean)false);
        }
    }

    public void testUnOrderedCBEPropertiesAfterXMLDocumentDeserialization_1() {
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><CommonBaseEvents xmlns=\"http://www.ibm.com/AC/commonbaseevent1_0_1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/AC/commonbaseevent1_0_1 commonbaseevent1_0_1.xsd \"><AssociationEngine id=\"i0000000000000000000000000000044\" name=\"MyCorrelationEngine\" type=\"Correlate\"/><CommonBaseEvent creationTime=\"2001-12-31T12:00:00\" elapsedTime=\"0\" extensionName=\"Name\" globalInstanceId=\"CEE736B610030D11D88000A27990EF8D1A\" localInstanceId=\"\" msg=\"\" priority=\"0\" repeatCount=\"0\" sequenceNumber=\"0\" severity=\"0\" version=\"\">        <extendedDataElements name=\"\" type=\"noValue\"><values>values</values> <children name=\"\" type=\"noValue\"> <values>values</values>    </children>     </extendedDataElements>    <sourceComponentId location=\"loc_src\" locationType=\"HID\" component=\"comp_src\" subComponent=\"sub_src\" componentIdType=\"compIdType_src\" componentType=\"compType_src\"/>                        <msgDataElement msgLocale=\"EN\">      <msgCatalogTokens value=\"\"/>      <msgId>msgId</msgId>      <msgIdType>Name</msgIdType>      <msgCatalogId>msgCatalogId</msgCatalogId>      <msgCatalogType>msgCatalogType</msgCatalogType>      <msgCatalog>msgCatalog</msgCatalog>    </msgDataElement>            <contextDataElements name=\"\" type=\"\"><contextValue>contextValue</contextValue></contextDataElements>                 </CommonBaseEvent></CommonBaseEvents>";
        try {
            AssociationEngine[] associationEngineArray = EventFormatter.associationEnginesFromCanonicalXMLDoc(string);
            Assert.assertNotNull((Object)associationEngineArray);
            Assert.assertTrue((associationEngineArray.length == 1 ? 1 : 0) != 0);
            Assert.assertNotNull((Object)associationEngineArray[0]);
            Assert.assertTrue((boolean)associationEngineArray[0].getId().equals("i0000000000000000000000000000044"));
            Assert.assertTrue((boolean)associationEngineArray[0].getName().equals("MyCorrelationEngine"));
            Assert.assertTrue((boolean)associationEngineArray[0].getType().equals("Correlate"));
            CommonBaseEvent[] commonBaseEventArray = EventFormatter.eventsFromCanonicalXMLDoc(string);
            Assert.assertNotNull((Object)commonBaseEventArray);
            Assert.assertTrue((commonBaseEventArray.length == 1 ? 1 : 0) != 0);
            Assert.assertNotNull((Object)commonBaseEventArray[0]);
            Assert.assertTrue((boolean)commonBaseEventArray[0].isSetCreationTime());
            Assert.assertTrue((boolean)commonBaseEventArray[0].getCreationTime().equals("2001-12-31T12:00:00"));
            Assert.assertTrue((commonBaseEventArray[0].getCreationTimeAsLong() == EventHelpers.dateToLong("2001-12-31T12:00:00") ? 1 : 0) != 0);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            simpleDateFormat.setCalendar(new GregorianCalendar(new SimpleTimeZone(0, "UTC")));
            Assert.assertTrue((commonBaseEventArray[0].getCreationTimeAsLong() == simpleDateFormat.parse("2001-12-31T12:00:00").getTime() ? 1 : 0) != 0);
            Assert.assertTrue((boolean)commonBaseEventArray[0].isSetElapsedTime());
            Assert.assertTrue((commonBaseEventArray[0].getElapsedTime() == 0L ? 1 : 0) != 0);
            Assert.assertTrue((boolean)commonBaseEventArray[0].getExtensionName().equals("Name"));
            Assert.assertTrue((boolean)commonBaseEventArray[0].getGlobalInstanceId().equals("CEE736B610030D11D88000A27990EF8D1A"));
            Assert.assertTrue((boolean)commonBaseEventArray[0].getLocalInstanceId().equals(""));
            Assert.assertTrue((boolean)commonBaseEventArray[0].isSetPriority());
            Assert.assertTrue((commonBaseEventArray[0].getPriority() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)commonBaseEventArray[0].isSetSeverity());
            Assert.assertTrue((commonBaseEventArray[0].getSeverity() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)commonBaseEventArray[0].isSetRepeatCount());
            Assert.assertTrue((commonBaseEventArray[0].getRepeatCount() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)commonBaseEventArray[0].isSetSequenceNumber());
            Assert.assertTrue((commonBaseEventArray[0].getSequenceNumber() == 0L ? 1 : 0) != 0);
            Assert.assertTrue((boolean)commonBaseEventArray[0].getVersion().equals(""));
            EList eList = commonBaseEventArray[0].getContextDataElements();
            Assert.assertNotNull((Object)eList);
            Assert.assertTrue((eList.size() == 1 ? 1 : 0) != 0);
            Assert.assertNotNull(eList.get(0));
            Assert.assertTrue((boolean)((ContextDataElement)eList.get(0)).getName().equals(""));
            Assert.assertTrue((boolean)((ContextDataElement)eList.get(0)).getType().equals(""));
            Assert.assertTrue((boolean)((ContextDataElement)eList.get(0)).getContextValue().equals("contextValue"));
            Assert.assertNull((Object)((ContextDataElement)eList.get(0)).getContextId());
            EList eList2 = commonBaseEventArray[0].getExtendedDataElements();
            Assert.assertNotNull((Object)eList2);
            Assert.assertTrue((eList2.size() == 1 ? 1 : 0) != 0);
            Assert.assertNotNull(eList2.get(0));
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(0)).getName().equals(""));
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(0)).getType().equals("noValue"));
            Assert.assertTrue((((ExtendedDataElement)eList2.get(0)).getValues().size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(0)).getValues().get(0).equals("values"));
            Assert.assertNull((Object)((ExtendedDataElement)eList2.get(0)).getHexValue());
            Assert.assertTrue((((ExtendedDataElement)eList2.get(0)).getChildren().size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((ExtendedDataElement)((ExtendedDataElement)eList2.get(0)).getChildren().get(0)).getName().equals(""));
            Assert.assertTrue((boolean)((ExtendedDataElement)((ExtendedDataElement)eList2.get(0)).getChildren().get(0)).getType().equals("noValue"));
            Assert.assertTrue((((ExtendedDataElement)((ExtendedDataElement)eList2.get(0)).getChildren().get(0)).getValues().size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((ExtendedDataElement)((ExtendedDataElement)eList2.get(0)).getChildren().get(0)).getValues().get(0).equals("values"));
            Assert.assertNull((Object)((ExtendedDataElement)((ExtendedDataElement)eList2.get(0)).getChildren().get(0)).getHexValue());
            EList eList3 = commonBaseEventArray[0].getAssociatedEvents();
            Assert.assertNotNull((Object)eList3);
            Assert.assertTrue((eList3.size() == 0 ? 1 : 0) != 0);
            ComponentIdentification componentIdentification = commonBaseEventArray[0].getReporterComponentId();
            Assert.assertNull((Object)componentIdentification);
            ComponentIdentification componentIdentification2 = commonBaseEventArray[0].getSourceComponentId();
            Assert.assertNotNull((Object)componentIdentification2);
            Assert.assertNull((Object)componentIdentification2.getApplication());
            Assert.assertTrue((boolean)componentIdentification2.getComponentType().equals("compType_src"));
            Assert.assertTrue((boolean)componentIdentification2.getComponent().equals("comp_src"));
            Assert.assertTrue((boolean)componentIdentification2.getComponentIdType().equals("compIdType_src"));
            Assert.assertNull((Object)componentIdentification2.getExecutionEnvironment());
            Assert.assertNull((Object)componentIdentification2.getInstanceId());
            Assert.assertTrue((boolean)componentIdentification2.getLocation().equals("loc_src"));
            Assert.assertTrue((boolean)componentIdentification2.getLocationType().equals("HID"));
            Assert.assertNull((Object)componentIdentification2.getProcessId());
            Assert.assertTrue((boolean)componentIdentification2.getSubComponent().equals("sub_src"));
            Assert.assertNull((Object)componentIdentification2.getThreadId());
            MsgDataElement msgDataElement = commonBaseEventArray[0].getMsgDataElement();
            Assert.assertNotNull((Object)msgDataElement);
            Assert.assertTrue((boolean)msgDataElement.getMsgLocale().equals("EN"));
            Assert.assertTrue((boolean)msgDataElement.getMsgCatalog().equals("msgCatalog"));
            Assert.assertTrue((boolean)msgDataElement.getMsgCatalogId().equals("msgCatalogId"));
            Assert.assertTrue((boolean)msgDataElement.getMsgCatalogType().equals("msgCatalogType"));
            Assert.assertTrue((boolean)msgDataElement.getMsgId().equals("msgId"));
            Assert.assertTrue((boolean)msgDataElement.getMsgIdType().equals("Name"));
            Assert.assertNotNull((Object)msgDataElement.getMsgCatalogTokens());
            Assert.assertTrue((msgDataElement.getMsgCatalogTokens().size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((MsgCatalogToken)msgDataElement.getMsgCatalogTokens().get(0)).getValue().equals(""));
            Situation situation = commonBaseEventArray[0].getSituation();
            Assert.assertNull((Object)situation);
            EList eList4 = commonBaseEventArray[0].getAny();
            Assert.assertNotNull((Object)eList4);
            Assert.assertTrue((eList4.size() == 0 ? 1 : 0) != 0);
        }
        catch (AssertionFailedError assertionFailedError) {
            throw assertionFailedError;
        }
        catch (Throwable throwable) {
            Assert.assertTrue((String)throwable.toString(), (boolean)false);
        }
    }

    public void testUnOrderedCBEPropertiesAfterXMLDocumentDeserialization_2() {
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><CommonBaseEvents xmlns=\"http://www.ibm.com/AC/commonbaseevent1_0_1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/AC/commonbaseevent1_0_1 commonbaseevent1_0_1.xsd \"><AssociationEngine id=\"i0000000000000000000000000000044\" name=\"MyCorrelationEngine\" type=\"Correlate\"/><CommonBaseEvent creationTime=\"2001-12-31T12:00:00\" elapsedTime=\"0\" extensionName=\"Name\" globalInstanceId=\"CEE736B610030D11D88000A27990EF8D1A\" localInstanceId=\"\" msg=\"\" priority=\"0\" repeatCount=\"0\" sequenceNumber=\"0\" severity=\"0\" version=\"\">        <situation categoryName=\"StartSituation\">    \t<situationType reasoningScope=\"EXTERNAL\" successDisposition=\"SUCCESSFUL\" situationQualifier=\"START COMPLETED\" xsi:type=\"StartSituation\" />\t</situation> \t <sourceComponentId location=\"loc_src\" locationType=\"HID\" component=\"comp_src\" subComponent=\"sub_src\" componentIdType=\"compIdType_src\" componentType=\"compType_src\"/>                        </CommonBaseEvent></CommonBaseEvents>";
        try {
            AssociationEngine[] associationEngineArray = EventFormatter.associationEnginesFromCanonicalXMLDoc(string);
            Assert.assertNotNull((Object)associationEngineArray);
            Assert.assertTrue((associationEngineArray.length == 1 ? 1 : 0) != 0);
            Assert.assertNotNull((Object)associationEngineArray[0]);
            Assert.assertTrue((boolean)associationEngineArray[0].getId().equals("i0000000000000000000000000000044"));
            Assert.assertTrue((boolean)associationEngineArray[0].getName().equals("MyCorrelationEngine"));
            Assert.assertTrue((boolean)associationEngineArray[0].getType().equals("Correlate"));
            CommonBaseEvent[] commonBaseEventArray = EventFormatter.eventsFromCanonicalXMLDoc(string);
            Assert.assertNotNull((Object)commonBaseEventArray);
            Assert.assertTrue((commonBaseEventArray.length == 1 ? 1 : 0) != 0);
            Assert.assertNotNull((Object)commonBaseEventArray[0]);
            Assert.assertTrue((boolean)commonBaseEventArray[0].isSetCreationTime());
            Assert.assertTrue((boolean)commonBaseEventArray[0].getCreationTime().equals("2001-12-31T12:00:00"));
            Assert.assertTrue((commonBaseEventArray[0].getCreationTimeAsLong() == EventHelpers.dateToLong("2001-12-31T12:00:00") ? 1 : 0) != 0);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            simpleDateFormat.setCalendar(new GregorianCalendar(new SimpleTimeZone(0, "UTC")));
            Assert.assertTrue((commonBaseEventArray[0].getCreationTimeAsLong() == simpleDateFormat.parse("2001-12-31T12:00:00").getTime() ? 1 : 0) != 0);
            Assert.assertTrue((boolean)commonBaseEventArray[0].isSetElapsedTime());
            Assert.assertTrue((commonBaseEventArray[0].getElapsedTime() == 0L ? 1 : 0) != 0);
            Assert.assertTrue((boolean)commonBaseEventArray[0].getExtensionName().equals("Name"));
            Assert.assertTrue((boolean)commonBaseEventArray[0].getGlobalInstanceId().equals("CEE736B610030D11D88000A27990EF8D1A"));
            Assert.assertTrue((boolean)commonBaseEventArray[0].getLocalInstanceId().equals(""));
            Assert.assertTrue((boolean)commonBaseEventArray[0].isSetPriority());
            Assert.assertTrue((commonBaseEventArray[0].getPriority() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)commonBaseEventArray[0].isSetSeverity());
            Assert.assertTrue((commonBaseEventArray[0].getSeverity() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)commonBaseEventArray[0].isSetRepeatCount());
            Assert.assertTrue((commonBaseEventArray[0].getRepeatCount() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)commonBaseEventArray[0].isSetSequenceNumber());
            Assert.assertTrue((commonBaseEventArray[0].getSequenceNumber() == 0L ? 1 : 0) != 0);
            Assert.assertTrue((boolean)commonBaseEventArray[0].getVersion().equals(""));
            EList eList = commonBaseEventArray[0].getContextDataElements();
            Assert.assertNotNull((Object)eList);
            Assert.assertTrue((eList.size() == 0 ? 1 : 0) != 0);
            EList eList2 = commonBaseEventArray[0].getExtendedDataElements();
            Assert.assertNotNull((Object)eList2);
            Assert.assertTrue((eList2.size() == 0 ? 1 : 0) != 0);
            EList eList3 = commonBaseEventArray[0].getAssociatedEvents();
            Assert.assertNotNull((Object)eList3);
            Assert.assertTrue((eList3.size() == 0 ? 1 : 0) != 0);
            ComponentIdentification componentIdentification = commonBaseEventArray[0].getReporterComponentId();
            Assert.assertNull((Object)componentIdentification);
            ComponentIdentification componentIdentification2 = commonBaseEventArray[0].getSourceComponentId();
            Assert.assertNotNull((Object)componentIdentification2);
            Assert.assertNull((Object)componentIdentification2.getApplication());
            Assert.assertTrue((boolean)componentIdentification2.getComponentType().equals("compType_src"));
            Assert.assertTrue((boolean)componentIdentification2.getComponent().equals("comp_src"));
            Assert.assertTrue((boolean)componentIdentification2.getComponentIdType().equals("compIdType_src"));
            Assert.assertNull((Object)componentIdentification2.getExecutionEnvironment());
            Assert.assertNull((Object)componentIdentification2.getInstanceId());
            Assert.assertTrue((boolean)componentIdentification2.getLocation().equals("loc_src"));
            Assert.assertTrue((boolean)componentIdentification2.getLocationType().equals("HID"));
            Assert.assertNull((Object)componentIdentification2.getProcessId());
            Assert.assertTrue((boolean)componentIdentification2.getSubComponent().equals("sub_src"));
            Assert.assertNull((Object)componentIdentification2.getThreadId());
            MsgDataElement msgDataElement = commonBaseEventArray[0].getMsgDataElement();
            Assert.assertNull((Object)msgDataElement);
            Situation situation = commonBaseEventArray[0].getSituation();
            Assert.assertNotNull((Object)situation);
            Assert.assertTrue((boolean)situation.getCategoryName().equals("StartSituation"));
            SituationType situationType = situation.getSituationType();
            Assert.assertNotNull((Object)situationType);
            Assert.assertTrue((boolean)(situationType instanceof StartSituation));
            Assert.assertTrue((boolean)((StartSituation)situationType).getReasoningScope().equals("EXTERNAL"));
            Assert.assertTrue((boolean)((StartSituation)situationType).getSituationQualifier().equals("START COMPLETED"));
            Assert.assertTrue((boolean)((StartSituation)situationType).getSuccessDisposition().equals("SUCCESSFUL"));
            EList eList4 = commonBaseEventArray[0].getAny();
            Assert.assertNotNull((Object)eList4);
            Assert.assertTrue((eList4.size() == 0 ? 1 : 0) != 0);
        }
        catch (AssertionFailedError assertionFailedError) {
            throw assertionFailedError;
        }
        catch (Throwable throwable) {
            Assert.assertTrue((String)throwable.toString(), (boolean)false);
        }
    }

    public void testUnOrderedCBEPropertiesAfterXMLDocumentDeserialization_3() {
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><CommonBaseEvents xmlns=\"http://www.ibm.com/AC/commonbaseevent1_0_1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/AC/commonbaseevent1_0_1 commonbaseevent1_0_1.xsd \"><AssociationEngine id=\"i0000000000000000000000000000044\" name=\"MyCorrelationEngine\" type=\"Correlate\"/><CommonBaseEvent creationTime=\"2001-12-31T12:00:00\" elapsedTime=\"0\" extensionName=\"Name\" globalInstanceId=\"CEE736B610030D11D88000A27990EF8D1A\" localInstanceId=\"\" msg=\"\" priority=\"0\" repeatCount=\"0\" sequenceNumber=\"0\" severity=\"0\" version=\"\">        <situation categoryName=\"StartSituation\">    \t<situationType reasoningScope=\"EXTERNAL\" successDisposition=\"SUCCESSFUL\" situationQualifier=\"START COMPLETED\" xsi:type=\"StartSituation\" />\t</situation> \t <reporterComponentId application=\"appl_rep\" componentType=\"compType_rep\" component=\"comp_rep\" componentIdType=\"compIdType_rep\" executionEnvironment=\"exc_rep\" instanceId=\"id_rep\" location=\"loc_rep\" locationType=\"Hostname\" processId=\"pr_rep\" subComponent=\"sub_rep\" threadId=\"th_rep\"/> <sourceComponentId location=\"loc_src\" locationType=\"HID\" component=\"comp_src\" subComponent=\"sub_src\" componentIdType=\"compIdType_src\" componentType=\"compType_src\"/>                <msgDataElement msgLocale=\"EN\">      <msgCatalogTokens value=\"\"/>      <msgId>msgId</msgId>      <msgIdType>Name</msgIdType>      <msgCatalogId>msgCatalogId</msgCatalogId>      <msgCatalogType>msgCatalogType</msgCatalogType>      <msgCatalog>msgCatalog</msgCatalog>    </msgDataElement>            <extendedDataElements name=\"\" type=\"noValue\"><values>values</values> <children name=\"\" type=\"noValue\"> <values>values</values>    </children>     </extendedDataElements>                    <contextDataElements name=\"\" type=\"\"><contextValue>contextValue</contextValue></contextDataElements>                                         </CommonBaseEvent></CommonBaseEvents>";
        try {
            AssociationEngine[] associationEngineArray = EventFormatter.associationEnginesFromCanonicalXMLDoc(string);
            Assert.assertNotNull((Object)associationEngineArray);
            Assert.assertTrue((associationEngineArray.length == 1 ? 1 : 0) != 0);
            Assert.assertNotNull((Object)associationEngineArray[0]);
            Assert.assertTrue((boolean)associationEngineArray[0].getId().equals("i0000000000000000000000000000044"));
            Assert.assertTrue((boolean)associationEngineArray[0].getName().equals("MyCorrelationEngine"));
            Assert.assertTrue((boolean)associationEngineArray[0].getType().equals("Correlate"));
            CommonBaseEvent[] commonBaseEventArray = EventFormatter.eventsFromCanonicalXMLDoc(string);
            Assert.assertNotNull((Object)commonBaseEventArray);
            Assert.assertTrue((commonBaseEventArray.length == 1 ? 1 : 0) != 0);
            Assert.assertNotNull((Object)commonBaseEventArray[0]);
            Assert.assertTrue((boolean)commonBaseEventArray[0].isSetCreationTime());
            Assert.assertTrue((boolean)commonBaseEventArray[0].getCreationTime().equals("2001-12-31T12:00:00"));
            Assert.assertTrue((commonBaseEventArray[0].getCreationTimeAsLong() == EventHelpers.dateToLong("2001-12-31T12:00:00") ? 1 : 0) != 0);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            simpleDateFormat.setCalendar(new GregorianCalendar(new SimpleTimeZone(0, "UTC")));
            Assert.assertTrue((commonBaseEventArray[0].getCreationTimeAsLong() == simpleDateFormat.parse("2001-12-31T12:00:00").getTime() ? 1 : 0) != 0);
            Assert.assertTrue((boolean)commonBaseEventArray[0].isSetElapsedTime());
            Assert.assertTrue((commonBaseEventArray[0].getElapsedTime() == 0L ? 1 : 0) != 0);
            Assert.assertTrue((boolean)commonBaseEventArray[0].getExtensionName().equals("Name"));
            Assert.assertTrue((boolean)commonBaseEventArray[0].getGlobalInstanceId().equals("CEE736B610030D11D88000A27990EF8D1A"));
            Assert.assertTrue((boolean)commonBaseEventArray[0].getLocalInstanceId().equals(""));
            Assert.assertTrue((boolean)commonBaseEventArray[0].isSetPriority());
            Assert.assertTrue((commonBaseEventArray[0].getPriority() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)commonBaseEventArray[0].isSetSeverity());
            Assert.assertTrue((commonBaseEventArray[0].getSeverity() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)commonBaseEventArray[0].isSetRepeatCount());
            Assert.assertTrue((commonBaseEventArray[0].getRepeatCount() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)commonBaseEventArray[0].isSetSequenceNumber());
            Assert.assertTrue((commonBaseEventArray[0].getSequenceNumber() == 0L ? 1 : 0) != 0);
            Assert.assertTrue((boolean)commonBaseEventArray[0].getVersion().equals(""));
            EList eList = commonBaseEventArray[0].getContextDataElements();
            Assert.assertNotNull((Object)eList);
            Assert.assertTrue((eList.size() == 1 ? 1 : 0) != 0);
            Assert.assertNotNull(eList.get(0));
            Assert.assertTrue((boolean)((ContextDataElement)eList.get(0)).getName().equals(""));
            Assert.assertTrue((boolean)((ContextDataElement)eList.get(0)).getType().equals(""));
            Assert.assertTrue((boolean)((ContextDataElement)eList.get(0)).getContextValue().equals("contextValue"));
            Assert.assertNull((Object)((ContextDataElement)eList.get(0)).getContextId());
            EList eList2 = commonBaseEventArray[0].getExtendedDataElements();
            Assert.assertNotNull((Object)eList2);
            Assert.assertTrue((eList2.size() == 1 ? 1 : 0) != 0);
            Assert.assertNotNull(eList2.get(0));
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(0)).getName().equals(""));
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(0)).getType().equals("noValue"));
            Assert.assertTrue((((ExtendedDataElement)eList2.get(0)).getValues().size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(0)).getValues().get(0).equals("values"));
            Assert.assertNull((Object)((ExtendedDataElement)eList2.get(0)).getHexValue());
            Assert.assertTrue((((ExtendedDataElement)eList2.get(0)).getChildren().size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((ExtendedDataElement)((ExtendedDataElement)eList2.get(0)).getChildren().get(0)).getName().equals(""));
            Assert.assertTrue((boolean)((ExtendedDataElement)((ExtendedDataElement)eList2.get(0)).getChildren().get(0)).getType().equals("noValue"));
            Assert.assertTrue((((ExtendedDataElement)((ExtendedDataElement)eList2.get(0)).getChildren().get(0)).getValues().size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((ExtendedDataElement)((ExtendedDataElement)eList2.get(0)).getChildren().get(0)).getValues().get(0).equals("values"));
            Assert.assertNull((Object)((ExtendedDataElement)((ExtendedDataElement)eList2.get(0)).getChildren().get(0)).getHexValue());
            EList eList3 = commonBaseEventArray[0].getAssociatedEvents();
            Assert.assertNotNull((Object)eList3);
            Assert.assertTrue((eList3.size() == 0 ? 1 : 0) != 0);
            ComponentIdentification componentIdentification = commonBaseEventArray[0].getReporterComponentId();
            Assert.assertNotNull((Object)componentIdentification);
            Assert.assertTrue((boolean)componentIdentification.getApplication().equals("appl_rep"));
            Assert.assertTrue((boolean)componentIdentification.getComponentType().equals("compType_rep"));
            Assert.assertTrue((boolean)componentIdentification.getComponent().equals("comp_rep"));
            Assert.assertTrue((boolean)componentIdentification.getComponentIdType().equals("compIdType_rep"));
            Assert.assertTrue((boolean)componentIdentification.getExecutionEnvironment().equals("exc_rep"));
            Assert.assertTrue((boolean)componentIdentification.getInstanceId().equals("id_rep"));
            Assert.assertTrue((boolean)componentIdentification.getLocation().equals("loc_rep"));
            Assert.assertTrue((boolean)componentIdentification.getLocationType().equals("Hostname"));
            Assert.assertTrue((boolean)componentIdentification.getProcessId().equals("pr_rep"));
            Assert.assertTrue((boolean)componentIdentification.getSubComponent().equals("sub_rep"));
            Assert.assertTrue((boolean)componentIdentification.getThreadId().equals("th_rep"));
            ComponentIdentification componentIdentification2 = commonBaseEventArray[0].getSourceComponentId();
            Assert.assertNotNull((Object)componentIdentification2);
            Assert.assertNull((Object)componentIdentification2.getApplication());
            Assert.assertTrue((boolean)componentIdentification2.getComponentType().equals("compType_src"));
            Assert.assertTrue((boolean)componentIdentification2.getComponent().equals("comp_src"));
            Assert.assertTrue((boolean)componentIdentification2.getComponentIdType().equals("compIdType_src"));
            Assert.assertNull((Object)componentIdentification2.getExecutionEnvironment());
            Assert.assertNull((Object)componentIdentification2.getInstanceId());
            Assert.assertTrue((boolean)componentIdentification2.getLocation().equals("loc_src"));
            Assert.assertTrue((boolean)componentIdentification2.getLocationType().equals("HID"));
            Assert.assertNull((Object)componentIdentification2.getProcessId());
            Assert.assertTrue((boolean)componentIdentification2.getSubComponent().equals("sub_src"));
            Assert.assertNull((Object)componentIdentification2.getThreadId());
            MsgDataElement msgDataElement = commonBaseEventArray[0].getMsgDataElement();
            Assert.assertNotNull((Object)msgDataElement);
            Assert.assertTrue((boolean)msgDataElement.getMsgLocale().equals("EN"));
            Assert.assertTrue((boolean)msgDataElement.getMsgCatalog().equals("msgCatalog"));
            Assert.assertTrue((boolean)msgDataElement.getMsgCatalogId().equals("msgCatalogId"));
            Assert.assertTrue((boolean)msgDataElement.getMsgCatalogType().equals("msgCatalogType"));
            Assert.assertTrue((boolean)msgDataElement.getMsgId().equals("msgId"));
            Assert.assertTrue((boolean)msgDataElement.getMsgIdType().equals("Name"));
            Assert.assertNotNull((Object)msgDataElement.getMsgCatalogTokens());
            Assert.assertTrue((msgDataElement.getMsgCatalogTokens().size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((MsgCatalogToken)msgDataElement.getMsgCatalogTokens().get(0)).getValue().equals(""));
            Situation situation = commonBaseEventArray[0].getSituation();
            Assert.assertNotNull((Object)situation);
            Assert.assertTrue((boolean)situation.getCategoryName().equals("StartSituation"));
            SituationType situationType = situation.getSituationType();
            Assert.assertNotNull((Object)situationType);
            Assert.assertTrue((boolean)(situationType instanceof StartSituation));
            Assert.assertTrue((boolean)((StartSituation)situationType).getReasoningScope().equals("EXTERNAL"));
            Assert.assertTrue((boolean)((StartSituation)situationType).getSituationQualifier().equals("START COMPLETED"));
            Assert.assertTrue((boolean)((StartSituation)situationType).getSuccessDisposition().equals("SUCCESSFUL"));
            String string2 = "<a:a xmlns:a=\"http://bar\"><expression logicalOperator=\"AND\"><preCondition xsi:type=\"SimpleNodeType\" propertyName=\"CommonBaseEvent:Source:contextDataElements\" comparisonOperator=\"equals\"><testPropertyName>&quot;cbe:CommonBaseEvent:Target:contextDataElements&quot;</testPropertyName></preCondition><postCondition xsi:type=\"SimpleNodeType\" propertyName=\"CommonBaseEvent:Source:contextDataElements\" comparisonOperator=\"notNULL\"><testPropertyName>&quot;cbe:CommonBaseEvent:Target:contextDataElements&quot;</testPropertyName></postCondition></expression><answer value=\"0\"></answer></a:a>";
            EList eList4 = commonBaseEventArray[0].getAny();
            Assert.assertNotNull((Object)eList4);
            Assert.assertTrue((eList4.size() == 0 ? 1 : 0) != 0);
        }
        catch (AssertionFailedError assertionFailedError) {
            throw assertionFailedError;
        }
        catch (Throwable throwable) {
            Assert.assertTrue((String)throwable.toString(), (boolean)false);
        }
    }

    public void testCBEPropertiesAfterXMLFragmentDeserialization_1() {
        String string = "<CommonBaseEvent creationTime=\"2001-12-31T12:00:00\" elapsedTime=\"0\" extensionName=\"Name\" globalInstanceId=\"i0000000000000000000000000000040\" localInstanceId=\"\" msg=\"\" priority=\"0\" repeatCount=\"0\" sequenceNumber=\"0\" severity=\"0\" version=\"\"><reporterComponentId application=\"appl_rep\" componentType=\"compType_rep\" component=\"comp_rep\" componentIdType=\"compIdType_rep\" executionEnvironment=\"exc_rep\" instanceId=\"id_rep\" location=\"loc_rep\" locationType=\"Hostname\" processId=\"pr_rep\" subComponent=\"sub_rep\" threadId=\"th_rep\"/> <sourceComponentId location=\"loc_src\" locationType=\"HID\" component=\"comp_src\" subComponent=\"sub_src\" componentIdType=\"compIdType_src\" componentType=\"compType_src\"/> <msgDataElement msgLocale=\"EN\"> <msgCatalogTokens value=\"value\"/> <msgId>msgId</msgId> <msgIdType>Name</msgIdType> <msgCatalogId>msgCatalogId</msgCatalogId> <msgCatalogType>msgCatalogType</msgCatalogType> <msgCatalog>msgCatalog</msgCatalog></msgDataElement> <contextDataElements name=\"myContext\" type=\"String\"> <contextValue>contextValue</contextValue></contextDataElements><extendedDataElements name=\"ede1\" type=\"boolean\"> <values>true</values></extendedDataElements><extendedDataElements name=\"ede2\" type=\"stringArray\"> <values>First Value</values><values>Second Value</values></extendedDataElements><associatedEvents resolvedEvents=\"i0000000000000000000000000000040\"> <associationEngine>i0000000000000000000000000000032</associationEngine></associatedEvents> <situation categoryName=\"StartSituation\"> <situationType reasoningScope=\"EXTERNAL\" successDisposition=\"SUCCESSFUL\" situationQualifier=\"START COMPLETED\" xsi:type=\"StartSituation\"/> </situation></CommonBaseEvent>";
        try {
            CommonBaseEvent commonBaseEvent = EventFormatter.eventFromCanonicalXML(string);
            Assert.assertNotNull((Object)commonBaseEvent);
            Assert.assertTrue((boolean)commonBaseEvent.isSetCreationTime());
            Assert.assertTrue((boolean)commonBaseEvent.getCreationTime().equals("2001-12-31T12:00:00"));
            Assert.assertTrue((commonBaseEvent.getCreationTimeAsLong() == EventHelpers.dateToLong("2001-12-31T12:00:00") ? 1 : 0) != 0);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            simpleDateFormat.setCalendar(new GregorianCalendar(new SimpleTimeZone(0, "UTC")));
            Assert.assertTrue((commonBaseEvent.getCreationTimeAsLong() == simpleDateFormat.parse("2001-12-31T12:00:00").getTime() ? 1 : 0) != 0);
            Assert.assertTrue((boolean)commonBaseEvent.isSetElapsedTime());
            Assert.assertTrue((commonBaseEvent.getElapsedTime() == 0L ? 1 : 0) != 0);
            Assert.assertTrue((boolean)commonBaseEvent.getExtensionName().equals("Name"));
            Assert.assertTrue((boolean)commonBaseEvent.getGlobalInstanceId().equals("i0000000000000000000000000000040"));
            Assert.assertTrue((boolean)commonBaseEvent.getLocalInstanceId().equals(""));
            Assert.assertTrue((boolean)commonBaseEvent.isSetPriority());
            Assert.assertTrue((commonBaseEvent.getPriority() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)commonBaseEvent.isSetSeverity());
            Assert.assertTrue((commonBaseEvent.getSeverity() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)commonBaseEvent.isSetRepeatCount());
            Assert.assertTrue((commonBaseEvent.getRepeatCount() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)commonBaseEvent.isSetSequenceNumber());
            Assert.assertTrue((commonBaseEvent.getSequenceNumber() == 0L ? 1 : 0) != 0);
            Assert.assertTrue((boolean)commonBaseEvent.getVersion().equals(""));
            EList eList = commonBaseEvent.getContextDataElements();
            Assert.assertNotNull((Object)eList);
            Assert.assertTrue((eList.size() == 1 ? 1 : 0) != 0);
            Assert.assertNotNull(eList.get(0));
            Assert.assertTrue((boolean)((ContextDataElement)eList.get(0)).getName().equals("myContext"));
            Assert.assertTrue((boolean)((ContextDataElement)eList.get(0)).getType().equals("String"));
            Assert.assertTrue((boolean)((ContextDataElement)eList.get(0)).getContextValue().equals("contextValue"));
            Assert.assertNull((Object)((ContextDataElement)eList.get(0)).getContextId());
            EList eList2 = commonBaseEvent.getExtendedDataElements();
            Assert.assertNotNull((Object)eList2);
            Assert.assertTrue((eList2.size() == 2 ? 1 : 0) != 0);
            Assert.assertNotNull(eList2.get(0));
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(0)).getName().equals("ede1"));
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(0)).getType().equals("boolean"));
            Assert.assertTrue((((ExtendedDataElement)eList2.get(0)).getValues().size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(0)).getValues().get(0).equals("true"));
            Assert.assertNull((Object)((ExtendedDataElement)eList2.get(0)).getHexValue());
            Assert.assertTrue((((ExtendedDataElement)eList2.get(0)).getChildren().size() == 0 ? 1 : 0) != 0);
            Assert.assertNotNull(eList2.get(1));
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(1)).getName().equals("ede2"));
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(1)).getType().equals("stringArray"));
            Assert.assertTrue((((ExtendedDataElement)eList2.get(1)).getValues().size() == 2 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(1)).getValues().get(0).equals("First Value"));
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(1)).getValues().get(1).equals("Second Value"));
            Assert.assertNull((Object)((ExtendedDataElement)eList2.get(1)).getHexValue());
            Assert.assertTrue((((ExtendedDataElement)eList2.get(1)).getChildren().size() == 0 ? 1 : 0) != 0);
            EList eList3 = commonBaseEvent.getAssociatedEvents();
            Assert.assertNotNull((Object)eList3);
            Assert.assertTrue((eList3.size() == 1 ? 1 : 0) != 0);
            Assert.assertNotNull(eList3.get(0));
            Assert.assertTrue((boolean)((AssociatedEvent)eList3.get(0)).getResolvedEvents().equals("i0000000000000000000000000000040"));
            Assert.assertTrue((boolean)((AssociatedEvent)eList3.get(0)).getAssociationEngine().equals("i0000000000000000000000000000032"));
            Assert.assertNull((Object)((AssociatedEvent)eList3.get(0)).getAssociationEngineInfo());
            ComponentIdentification componentIdentification = commonBaseEvent.getReporterComponentId();
            Assert.assertNotNull((Object)componentIdentification);
            Assert.assertTrue((boolean)componentIdentification.getApplication().equals("appl_rep"));
            Assert.assertTrue((boolean)componentIdentification.getComponentType().equals("compType_rep"));
            Assert.assertTrue((boolean)componentIdentification.getComponent().equals("comp_rep"));
            Assert.assertTrue((boolean)componentIdentification.getComponentIdType().equals("compIdType_rep"));
            Assert.assertTrue((boolean)componentIdentification.getExecutionEnvironment().equals("exc_rep"));
            Assert.assertTrue((boolean)componentIdentification.getInstanceId().equals("id_rep"));
            Assert.assertTrue((boolean)componentIdentification.getLocation().equals("loc_rep"));
            Assert.assertTrue((boolean)componentIdentification.getLocationType().equals("Hostname"));
            Assert.assertTrue((boolean)componentIdentification.getProcessId().equals("pr_rep"));
            Assert.assertTrue((boolean)componentIdentification.getSubComponent().equals("sub_rep"));
            Assert.assertTrue((boolean)componentIdentification.getThreadId().equals("th_rep"));
            ComponentIdentification componentIdentification2 = commonBaseEvent.getSourceComponentId();
            Assert.assertNotNull((Object)componentIdentification2);
            Assert.assertNull((Object)componentIdentification2.getApplication());
            Assert.assertTrue((boolean)componentIdentification2.getComponentType().equals("compType_src"));
            Assert.assertTrue((boolean)componentIdentification2.getComponent().equals("comp_src"));
            Assert.assertTrue((boolean)componentIdentification2.getComponentIdType().equals("compIdType_src"));
            Assert.assertNull((Object)componentIdentification2.getExecutionEnvironment());
            Assert.assertNull((Object)componentIdentification2.getInstanceId());
            Assert.assertTrue((boolean)componentIdentification2.getLocation().equals("loc_src"));
            Assert.assertTrue((boolean)componentIdentification2.getLocationType().equals("HID"));
            Assert.assertNull((Object)componentIdentification2.getProcessId());
            Assert.assertTrue((boolean)componentIdentification2.getSubComponent().equals("sub_src"));
            Assert.assertNull((Object)componentIdentification2.getThreadId());
            MsgDataElement msgDataElement = commonBaseEvent.getMsgDataElement();
            Assert.assertNotNull((Object)msgDataElement);
            Assert.assertTrue((boolean)msgDataElement.getMsgLocale().equals("EN"));
            Assert.assertTrue((boolean)msgDataElement.getMsgCatalog().equals("msgCatalog"));
            Assert.assertTrue((boolean)msgDataElement.getMsgCatalogId().equals("msgCatalogId"));
            Assert.assertTrue((boolean)msgDataElement.getMsgCatalogType().equals("msgCatalogType"));
            Assert.assertTrue((boolean)msgDataElement.getMsgId().equals("msgId"));
            Assert.assertTrue((boolean)msgDataElement.getMsgIdType().equals("Name"));
            Assert.assertNotNull((Object)msgDataElement.getMsgCatalogTokens());
            Assert.assertTrue((msgDataElement.getMsgCatalogTokens().size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((MsgCatalogToken)msgDataElement.getMsgCatalogTokens().get(0)).getValue().equals("value"));
            Situation situation = commonBaseEvent.getSituation();
            Assert.assertNotNull((Object)situation);
            Assert.assertTrue((boolean)situation.getCategoryName().equals("StartSituation"));
            SituationType situationType = situation.getSituationType();
            Assert.assertNotNull((Object)situationType);
            Assert.assertTrue((boolean)(situationType instanceof StartSituation));
            Assert.assertTrue((boolean)((StartSituation)situationType).getReasoningScope().equals("EXTERNAL"));
            Assert.assertTrue((boolean)((StartSituation)situationType).getSituationQualifier().equals("START COMPLETED"));
            Assert.assertTrue((boolean)((StartSituation)situationType).getSuccessDisposition().equals("SUCCESSFUL"));
            EList eList4 = commonBaseEvent.getAny();
            Assert.assertNotNull((Object)eList4);
            Assert.assertTrue((eList4.size() == 0 ? 1 : 0) != 0);
            Assert.assertEquals((Object)commonBaseEvent, (Object)EventFormatter.eventFromCanonicalXML(EventFormatter.toCanonicalXMLString(commonBaseEvent, false)));
        }
        catch (AssertionFailedError assertionFailedError) {
            throw assertionFailedError;
        }
        catch (Throwable throwable) {
            Assert.assertTrue((String)throwable.toString(), (boolean)false);
        }
    }

    public void testCBEPropertiesAfterXMLFragmentDeserialization_2() {
        String string = "<CommonBaseEvent creationTime=\"2004-06-06T15:13:21.891Z\" globalInstanceId=\"don6:1086534779703:3\" msg=\"ADMN0015I: AdminService initialized.\" severity=\"10\" version=\"1.0.1\">\t<extendedDataElements name=\"sequenceNumber\" type=\"long\">\t\t<values>4</values>\t</extendedDataElements>\t<extendedDataElements name=\"threadID\" type=\"int\">\t\t<values>10</values>\t</extendedDataElements>\t<extendedDataElements name=\"level\">\t\t<children name=\"name\" type=\"string\">\t\t\t<values>AUDIT</values>\t\t</children>\t\t<children name=\"value\" type=\"int\">\t\t\t<values>850</values>\t\t</children>\t</extendedDataElements>\t<extendedDataElements name=\"loggerName\" type=\"string\">\t\t<values>com.ibm.ws.management.AdminInitializer</values>\t</extendedDataElements>\t<extendedDataElements name=\"organization\" type=\"string\">\t\t<values>IBM</values>\t</extendedDataElements>\t<extendedDataElements name=\"product\" type=\"string\">\t\t<values>WebSphere</values>\t</extendedDataElements>\t<extendedDataElements name=\"component\" type=\"string\">\t\t<values>Application Server</values>\t</extendedDataElements>\t<extendedDataElements name=\"version\" type=\"string\">\t\t<values>Platform 6.0 Beta [BASE 6.0.0.0 o0418.30] </values>\t</extendedDataElements>\t<extendedDataElements name=\"processId\" type=\"string\">\t\t<values>628</values>\t</extendedDataElements>\t<extendedDataElements name=\"processName\" type=\"string\">\t\t<values>don6\\don6\\server1</values>\t</extendedDataElements>\t<extendedDataElements name=\"localizable\" type=\"string\">\t\t<values>yes</values>\t</extendedDataElements>\t<sourceComponentId component=\"com.ibm.ws.management.AdminInitializer\" executionEnvironment=\"Windows 2000[x86]#5.0\" instanceId=\"don6\\don6\\server1\" location=\"don6\" locationType=\"Hostname\" processId=\"1086534779703\" threadId=\"main\" componentType=\"http://www.ibm.com/namespaces/autonomic/WebSphereApplicationServer\"/>\t<msgDataElement msgLocale=\"en_US\">\t\t<msgCatalogId>ADMN0015I</msgCatalogId>\t\t<msgCatalogType>Java</msgCatalogType>\t\t<msgCatalog>com.ibm.ws.management.resources.adminservice</msgCatalog>\t</msgDataElement></CommonBaseEvent>";
        try {
            CommonBaseEvent commonBaseEvent = EventFormatter.eventFromCanonicalXML(string);
            Assert.assertNotNull((Object)commonBaseEvent);
            Assert.assertTrue((boolean)commonBaseEvent.isSetCreationTime());
            Assert.assertTrue((boolean)commonBaseEvent.getCreationTime().equals("2004-06-06T15:13:21.891Z"));
            Assert.assertTrue((commonBaseEvent.getCreationTimeAsLong() == EventHelpers.dateToLong("2004-06-06T15:13:21.891Z") ? 1 : 0) != 0);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            simpleDateFormat.setCalendar(new GregorianCalendar(new SimpleTimeZone(0, "UTC")));
            Assert.assertTrue((commonBaseEvent.getCreationTimeAsLong() == simpleDateFormat.parse("2004-06-06T15:13:21.891Z").getTime() ? 1 : 0) != 0);
            Assert.assertFalse((boolean)commonBaseEvent.isSetElapsedTime());
            Assert.assertTrue((commonBaseEvent.getElapsedTime() == 0L ? 1 : 0) != 0);
            Assert.assertNull((Object)commonBaseEvent.getExtensionName());
            Assert.assertTrue((boolean)commonBaseEvent.getGlobalInstanceId().equals("don6:1086534779703:3"));
            Assert.assertNull((Object)commonBaseEvent.getLocalInstanceId());
            Assert.assertFalse((boolean)commonBaseEvent.isSetPriority());
            Assert.assertTrue((commonBaseEvent.getPriority() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)commonBaseEvent.isSetSeverity());
            Assert.assertTrue((commonBaseEvent.getSeverity() == 10 ? 1 : 0) != 0);
            Assert.assertFalse((boolean)commonBaseEvent.isSetRepeatCount());
            Assert.assertTrue((commonBaseEvent.getRepeatCount() == 0 ? 1 : 0) != 0);
            Assert.assertFalse((boolean)commonBaseEvent.isSetSequenceNumber());
            Assert.assertTrue((commonBaseEvent.getSequenceNumber() == 0L ? 1 : 0) != 0);
            Assert.assertTrue((boolean)commonBaseEvent.getVersion().equals("1.0.1"));
            Assert.assertTrue((boolean)commonBaseEvent.getMsg().equals("ADMN0015I: AdminService initialized."));
            EList eList = commonBaseEvent.getContextDataElements();
            Assert.assertNotNull((Object)eList);
            Assert.assertTrue((eList.size() == 0 ? 1 : 0) != 0);
            EList eList2 = commonBaseEvent.getExtendedDataElements();
            Assert.assertNotNull((Object)eList2);
            Assert.assertTrue((eList2.size() == 11 ? 1 : 0) != 0);
            Assert.assertNotNull(eList2.get(0));
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(0)).getName().equals("sequenceNumber"));
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(0)).getType().equals("long"));
            Assert.assertTrue((((ExtendedDataElement)eList2.get(0)).getValues().size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(0)).getValues().get(0).equals("4"));
            Assert.assertNull((Object)((ExtendedDataElement)eList2.get(0)).getHexValue());
            Assert.assertTrue((((ExtendedDataElement)eList2.get(0)).getChildren().size() == 0 ? 1 : 0) != 0);
            Assert.assertNotNull(eList2.get(1));
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(1)).getName().equals("threadID"));
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(1)).getType().equals("int"));
            Assert.assertTrue((((ExtendedDataElement)eList2.get(1)).getValues().size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(1)).getValues().get(0).equals("10"));
            Assert.assertNull((Object)((ExtendedDataElement)eList2.get(1)).getHexValue());
            Assert.assertTrue((((ExtendedDataElement)eList2.get(1)).getChildren().size() == 0 ? 1 : 0) != 0);
            Assert.assertNotNull(eList2.get(2));
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(2)).getName().equals("level"));
            Assert.assertNull((Object)((ExtendedDataElement)eList2.get(2)).getType());
            Assert.assertTrue((((ExtendedDataElement)eList2.get(2)).getValues().size() == 0 ? 1 : 0) != 0);
            Assert.assertNull((Object)((ExtendedDataElement)eList2.get(2)).getHexValue());
            Assert.assertTrue((((ExtendedDataElement)eList2.get(2)).getChildren().size() == 2 ? 1 : 0) != 0);
            Assert.assertNotNull(((ExtendedDataElement)eList2.get(2)).getChildren().get(0));
            Assert.assertTrue((boolean)((ExtendedDataElement)((ExtendedDataElement)eList2.get(2)).getChildren().get(0)).getName().equals("name"));
            Assert.assertTrue((boolean)((ExtendedDataElement)((ExtendedDataElement)eList2.get(2)).getChildren().get(0)).getType().equals("string"));
            Assert.assertTrue((((ExtendedDataElement)((ExtendedDataElement)eList2.get(2)).getChildren().get(0)).getValues().size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((ExtendedDataElement)((ExtendedDataElement)eList2.get(2)).getChildren().get(0)).getValues().get(0).equals("AUDIT"));
            Assert.assertNull((Object)((ExtendedDataElement)((ExtendedDataElement)eList2.get(2)).getChildren().get(0)).getHexValue());
            Assert.assertTrue((((ExtendedDataElement)((ExtendedDataElement)eList2.get(2)).getChildren().get(0)).getChildren().size() == 0 ? 1 : 0) != 0);
            Assert.assertNotNull(((ExtendedDataElement)eList2.get(2)).getChildren().get(1));
            Assert.assertTrue((boolean)((ExtendedDataElement)((ExtendedDataElement)eList2.get(2)).getChildren().get(1)).getName().equals("value"));
            Assert.assertTrue((boolean)((ExtendedDataElement)((ExtendedDataElement)eList2.get(2)).getChildren().get(1)).getType().equals("int"));
            Assert.assertTrue((((ExtendedDataElement)((ExtendedDataElement)eList2.get(2)).getChildren().get(1)).getValues().size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((ExtendedDataElement)((ExtendedDataElement)eList2.get(2)).getChildren().get(1)).getValues().get(0).equals("850"));
            Assert.assertNull((Object)((ExtendedDataElement)((ExtendedDataElement)eList2.get(2)).getChildren().get(1)).getHexValue());
            Assert.assertTrue((((ExtendedDataElement)((ExtendedDataElement)eList2.get(2)).getChildren().get(1)).getChildren().size() == 0 ? 1 : 0) != 0);
            Assert.assertNotNull(eList2.get(3));
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(3)).getName().equals("loggerName"));
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(3)).getType().equals("string"));
            Assert.assertTrue((((ExtendedDataElement)eList2.get(3)).getValues().size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(3)).getValues().get(0).equals("com.ibm.ws.management.AdminInitializer"));
            Assert.assertNull((Object)((ExtendedDataElement)eList2.get(3)).getHexValue());
            Assert.assertTrue((((ExtendedDataElement)eList2.get(3)).getChildren().size() == 0 ? 1 : 0) != 0);
            Assert.assertNotNull(eList2.get(4));
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(4)).getName().equals("organization"));
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(4)).getType().equals("string"));
            Assert.assertTrue((((ExtendedDataElement)eList2.get(4)).getValues().size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(4)).getValues().get(0).equals("IBM"));
            Assert.assertNull((Object)((ExtendedDataElement)eList2.get(4)).getHexValue());
            Assert.assertTrue((((ExtendedDataElement)eList2.get(4)).getChildren().size() == 0 ? 1 : 0) != 0);
            Assert.assertNotNull(eList2.get(5));
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(5)).getName().equals("product"));
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(5)).getType().equals("string"));
            Assert.assertTrue((((ExtendedDataElement)eList2.get(5)).getValues().size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(5)).getValues().get(0).equals("WebSphere"));
            Assert.assertNull((Object)((ExtendedDataElement)eList2.get(5)).getHexValue());
            Assert.assertTrue((((ExtendedDataElement)eList2.get(5)).getChildren().size() == 0 ? 1 : 0) != 0);
            Assert.assertNotNull(eList2.get(6));
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(6)).getName().equals("component"));
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(6)).getType().equals("string"));
            Assert.assertTrue((((ExtendedDataElement)eList2.get(6)).getValues().size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(6)).getValues().get(0).equals("Application Server"));
            Assert.assertNull((Object)((ExtendedDataElement)eList2.get(6)).getHexValue());
            Assert.assertTrue((((ExtendedDataElement)eList2.get(6)).getChildren().size() == 0 ? 1 : 0) != 0);
            Assert.assertNotNull(eList2.get(7));
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(7)).getName().equals("version"));
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(7)).getType().equals("string"));
            Assert.assertTrue((((ExtendedDataElement)eList2.get(7)).getValues().size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(7)).getValues().get(0).equals("Platform 6.0 Beta [BASE 6.0.0.0 o0418.30] "));
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(7)).getValuesAsString().equals("Platform 6.0 Beta [BASE 6.0.0.0 o0418.30] "));
            Assert.assertNull((Object)((ExtendedDataElement)eList2.get(7)).getHexValue());
            Assert.assertTrue((((ExtendedDataElement)eList2.get(7)).getChildren().size() == 0 ? 1 : 0) != 0);
            Assert.assertNotNull(eList2.get(8));
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(8)).getName().equals("processId"));
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(8)).getType().equals("string"));
            Assert.assertTrue((((ExtendedDataElement)eList2.get(8)).getValues().size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(8)).getValues().get(0).equals("628"));
            Assert.assertNull((Object)((ExtendedDataElement)eList2.get(8)).getHexValue());
            Assert.assertTrue((((ExtendedDataElement)eList2.get(8)).getChildren().size() == 0 ? 1 : 0) != 0);
            Assert.assertNotNull(eList2.get(9));
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(9)).getName().equals("processName"));
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(9)).getType().equals("string"));
            Assert.assertTrue((((ExtendedDataElement)eList2.get(9)).getValues().size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(9)).getValues().get(0).equals("don6\\don6\\server1"));
            Assert.assertNull((Object)((ExtendedDataElement)eList2.get(9)).getHexValue());
            Assert.assertTrue((((ExtendedDataElement)eList2.get(9)).getChildren().size() == 0 ? 1 : 0) != 0);
            Assert.assertNotNull(eList2.get(10));
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(10)).getName().equals("localizable"));
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(10)).getType().equals("string"));
            Assert.assertTrue((((ExtendedDataElement)eList2.get(10)).getValues().size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((ExtendedDataElement)eList2.get(10)).getValues().get(0).equals("yes"));
            Assert.assertNull((Object)((ExtendedDataElement)eList2.get(10)).getHexValue());
            Assert.assertTrue((((ExtendedDataElement)eList2.get(10)).getChildren().size() == 0 ? 1 : 0) != 0);
            EList eList3 = commonBaseEvent.getAssociatedEvents();
            Assert.assertNotNull((Object)eList3);
            Assert.assertTrue((eList3.size() == 0 ? 1 : 0) != 0);
            ComponentIdentification componentIdentification = commonBaseEvent.getReporterComponentId();
            Assert.assertNull((Object)componentIdentification);
            ComponentIdentification componentIdentification2 = commonBaseEvent.getSourceComponentId();
            Assert.assertNotNull((Object)componentIdentification2);
            Assert.assertNull((Object)componentIdentification2.getApplication());
            Assert.assertTrue((boolean)componentIdentification2.getComponentType().equals("http://www.ibm.com/namespaces/autonomic/WebSphereApplicationServer"));
            Assert.assertTrue((boolean)componentIdentification2.getComponent().equals("com.ibm.ws.management.AdminInitializer"));
            Assert.assertNull((Object)componentIdentification2.getComponentIdType());
            Assert.assertTrue((boolean)componentIdentification2.getExecutionEnvironment().equals("Windows 2000[x86]#5.0"));
            Assert.assertTrue((boolean)componentIdentification2.getInstanceId().equals("don6\\don6\\server1"));
            Assert.assertTrue((boolean)componentIdentification2.getLocation().equals("don6"));
            Assert.assertTrue((boolean)componentIdentification2.getLocationType().equals("Hostname"));
            Assert.assertTrue((boolean)componentIdentification2.getProcessId().equals("1086534779703"));
            Assert.assertNull((Object)componentIdentification2.getSubComponent());
            Assert.assertTrue((boolean)componentIdentification2.getThreadId().equals("main"));
            MsgDataElement msgDataElement = commonBaseEvent.getMsgDataElement();
            Assert.assertNotNull((Object)msgDataElement);
            Assert.assertTrue((boolean)msgDataElement.getMsgLocale().equals("en_US"));
            Assert.assertTrue((boolean)msgDataElement.getMsgCatalog().equals("com.ibm.ws.management.resources.adminservice"));
            Assert.assertTrue((boolean)msgDataElement.getMsgCatalogId().equals("ADMN0015I"));
            Assert.assertTrue((boolean)msgDataElement.getMsgCatalogType().equals("Java"));
            Assert.assertNull((Object)msgDataElement.getMsgId());
            Assert.assertNull((Object)msgDataElement.getMsgIdType());
            Assert.assertNotNull((Object)msgDataElement.getMsgCatalogTokens());
            Assert.assertTrue((msgDataElement.getMsgCatalogTokens().size() == 0 ? 1 : 0) != 0);
            Situation situation = commonBaseEvent.getSituation();
            Assert.assertNull((Object)situation);
            EList eList4 = commonBaseEvent.getAny();
            Assert.assertNotNull((Object)eList4);
            Assert.assertTrue((eList4.size() == 0 ? 1 : 0) != 0);
        }
        catch (AssertionFailedError assertionFailedError) {
            throw assertionFailedError;
        }
        catch (Throwable throwable) {
            Assert.assertTrue((String)throwable.toString(), (boolean)false);
        }
    }

    public void testXMLFragmentDeserialization() {
        String string = "<CommonBaseEvent globalInstanceId=\"CEE736B610030D11D88000A27990EF8D1A\" localInstanceId=\"LOCAL INSTANCE ID :-) :-)\" msg=\"msg 2 &lt;&gt;&amp;;&quot;&apos; :-)\" elapsedTime=\"123\" priority=\"3\" repeatCount=\"0\" sequenceNumber=\"0\" severity=\"5\" version=\"1.0.1\"><contextDataElements name=\"ettk id\" type=\"anIDTYPE\"><contextId> FIRST</contextId></contextDataElements><contextDataElements name=\"&lt;ettk&amp;value&gt;\" type=\"anVALUETYPE\"><contextValue>SECOND</contextValue></contextDataElements><extendedDataElements name=\"root\" type=\"long\"><children name=\"Child2\" type=\"long\"><children name=\"Child31\" type=\"long\"><children name=\"Child41\" type=\"hexBinary\"><hexValue>818283</hexValue></children></children><children name=\"Child32\" type=\"long\"><children name=\"Child42\" type=\"stringArray\"><values>one</values><values>two</values><values>three</values></children></children><children name=\"Child33\" type=\"long\"><children name=\"Child43\" type=\"longArray\"><values>4</values><values>5</values></children></children></children></extendedDataElements><associatedEvents resolvedEvents=\"cbe1 cbe2\"><associationEngine>AE id</associationEngine></associatedEvents><sourceComponentId application=\"ettkAPP\"/><msgDataElement msgLocale=\"msgLocale\"><msgCatalogTokens value=\"msgCatalogToken1\"/><msgCatalogTokens value=\"msgCatalogToken2\"/><msgId>msgId</msgId><msgIdType>msgIdType</msgIdType><msgCatalogId>msgCatalogId</msgCatalogId><msgCatalogType>msgCatalogType</msgCatalogType><msgCatalog>MsgCatalog</msgCatalog></msgDataElement></CommonBaseEvent>";
        try {
            CommonBaseEvent commonBaseEvent = EventFormatter.eventFromCanonicalXML(string);
            CommonBaseEvent commonBaseEvent2 = EventFormatter.eventFromCanonicalXML(string);
            Assert.assertEquals((Object)commonBaseEvent.getExtendedDataElements("root"), (Object)commonBaseEvent2.getExtendedDataElements("root"));
            Assert.assertEquals((Object)commonBaseEvent, (Object)commonBaseEvent2);
            Assert.assertEquals((String)commonBaseEvent.getGlobalInstanceId(), (String)"CEE736B610030D11D88000A27990EF8D1A");
            Assert.assertEquals((String)commonBaseEvent2.getGlobalInstanceId(), (String)"CEE736B610030D11D88000A27990EF8D1A");
        }
        catch (AssertionFailedError assertionFailedError) {
            throw assertionFailedError;
        }
        catch (Throwable throwable) {
            Assert.assertTrue((String)throwable.toString(), (boolean)false);
        }
    }

    public void testXMLFragmentSerialization() {
        CommonBaseEvent commonBaseEvent = Util.generateEvent();
        String string = EventFormatter.toCanonicalXMLString(commonBaseEvent, false);
        String string2 = EventFormatter.toCanonicalXMLString(commonBaseEvent, true);
        CommonBaseEvent commonBaseEvent2 = null;
        CommonBaseEvent commonBaseEvent3 = null;
        try {
            commonBaseEvent2 = EventFormatter.eventFromCanonicalXML(string);
            commonBaseEvent3 = EventFormatter.eventFromCanonicalXML(string2);
        }
        catch (AssertionFailedError assertionFailedError) {
            throw assertionFailedError;
        }
        catch (Throwable throwable) {
            Assert.assertTrue((String)throwable.toString(), (boolean)false);
        }
        Assert.assertEquals((Object)commonBaseEvent, (Object)commonBaseEvent2);
        Assert.assertEquals((Object)commonBaseEvent, (Object)commonBaseEvent3);
        Assert.assertEquals((String)string, (String)EventFormatter.toCanonicalXMLString(commonBaseEvent2, false));
        Assert.assertEquals((String)string2, (String)EventFormatter.toCanonicalXMLString(commonBaseEvent3, true));
    }

    public void testXMLDocumentSerialization() {
        CommonBaseEvent commonBaseEvent = Util.generateEvent();
        String string = EventFormatter.toCanonicalXMLDocString(commonBaseEvent, false);
        String string2 = EventFormatter.toCanonicalXMLDocString(commonBaseEvent, true);
        CommonBaseEvent commonBaseEvent2 = null;
        CommonBaseEvent commonBaseEvent3 = null;
        try {
            commonBaseEvent2 = EventFormatter.eventsFromCanonicalXMLDoc(string)[0];
            commonBaseEvent3 = EventFormatter.eventsFromCanonicalXMLDoc(string2)[0];
        }
        catch (AssertionFailedError assertionFailedError) {
            throw assertionFailedError;
        }
        catch (Throwable throwable) {
            Assert.assertTrue((String)throwable.toString(), (boolean)false);
        }
        Assert.assertEquals((Object)commonBaseEvent, (Object)commonBaseEvent2);
        Assert.assertEquals((Object)commonBaseEvent, (Object)commonBaseEvent3);
        Assert.assertEquals((String)string, (String)EventFormatter.toCanonicalXMLDocString(commonBaseEvent2, false));
        Assert.assertEquals((String)string2, (String)EventFormatter.toCanonicalXMLDocString(commonBaseEvent3, true));
    }

    public void testEventFactoryXMLTemplateDocumentDeserialization() {
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><TemplateEvent version=\"1.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"templateEvent.xsd\"><CommonBaseEvent globalInstanceId=\"CEE736B610030D11D88000A27990EF8D1A\"><situation categoryName=\"ReportSituation\"><situationType xsi:type=\"ReportSituation\" reasoningScope=\"INTERNAL\" reportCategory=\"LOG\"/></situation></CommonBaseEvent></TemplateEvent>";
        try {
            CommonBaseEvent commonBaseEvent = EventFormatter.eventsFromCanonicalXMLDoc(string)[0];
            CommonBaseEvent commonBaseEvent2 = EventFormatter.eventsFromCanonicalXMLDoc(string)[0];
            Assert.assertEquals((Object)commonBaseEvent.getSituation(), (Object)commonBaseEvent2.getSituation());
            Assert.assertEquals((Object)commonBaseEvent, (Object)commonBaseEvent2);
            Assert.assertEquals((String)commonBaseEvent.getGlobalInstanceId(), (String)"CEE736B610030D11D88000A27990EF8D1A");
            Assert.assertEquals((String)commonBaseEvent2.getGlobalInstanceId(), (String)"CEE736B610030D11D88000A27990EF8D1A");
        }
        catch (AssertionFailedError assertionFailedError) {
            throw assertionFailedError;
        }
        catch (Throwable throwable) {
            Assert.assertTrue((String)throwable.toString(), (boolean)false);
        }
    }

    public void testEventFactoryXMLTemplateFragmentDeserialization() {
        String string = "<CommonBaseEvent globalInstanceId=\"CEE736B610030D11D88000A27990EF8D1A\"><situation categoryName=\"ReportSituation\"><situationType xsi:type=\"ReportSituation\" reasoningScope=\"INTERNAL\" reportCategory=\"LOG\"/></situation></CommonBaseEvent>";
        try {
            CommonBaseEvent commonBaseEvent = EventFormatter.eventFromCanonicalXML(string);
            CommonBaseEvent commonBaseEvent2 = EventFormatter.eventFromCanonicalXML(string);
            Assert.assertEquals((Object)commonBaseEvent.getSituation(), (Object)commonBaseEvent2.getSituation());
            Assert.assertEquals((Object)commonBaseEvent, (Object)commonBaseEvent2);
            Assert.assertEquals((String)commonBaseEvent.getGlobalInstanceId(), (String)"CEE736B610030D11D88000A27990EF8D1A");
            Assert.assertEquals((String)commonBaseEvent2.getGlobalInstanceId(), (String)"CEE736B610030D11D88000A27990EF8D1A");
        }
        catch (AssertionFailedError assertionFailedError) {
            throw assertionFailedError;
        }
        catch (Throwable throwable) {
            Assert.assertTrue((String)throwable.toString(), (boolean)false);
        }
    }

    public void testEventFactoryXMLTemplateFragmentSerialization() {
        CommonBaseEvent commonBaseEvent = EventFactory.eINSTANCE.createCommonBaseEvent();
        Situation situation = EventFactory.eINSTANCE.createSituation();
        situation.setCategoryName("ReportSituation");
        situation.setReportSituation("INTERNAL", "LOG");
        commonBaseEvent.setSituation(situation);
        String string = EventFormatter.toCanonicalXMLString(commonBaseEvent, false);
        String string2 = EventFormatter.toCanonicalXMLString(commonBaseEvent, true);
        CommonBaseEvent commonBaseEvent2 = null;
        CommonBaseEvent commonBaseEvent3 = null;
        try {
            commonBaseEvent2 = EventFormatter.eventFromCanonicalXML(string);
            commonBaseEvent3 = EventFormatter.eventFromCanonicalXML(string2);
        }
        catch (AssertionFailedError assertionFailedError) {
            throw assertionFailedError;
        }
        catch (Throwable throwable) {
            Assert.assertTrue((String)throwable.toString(), (boolean)false);
        }
        Assert.assertEquals((Object)commonBaseEvent, (Object)commonBaseEvent2);
        Assert.assertEquals((Object)commonBaseEvent, (Object)commonBaseEvent3);
        Assert.assertEquals((String)string, (String)EventFormatter.toCanonicalXMLString(commonBaseEvent2, false));
        Assert.assertEquals((String)string2, (String)EventFormatter.toCanonicalXMLString(commonBaseEvent3, true));
    }

    public void testEventFactoryXMLTemplateDocumentSerialization() {
        CommonBaseEvent commonBaseEvent = EventFactory.eINSTANCE.createCommonBaseEvent();
        Situation situation = EventFactory.eINSTANCE.createSituation();
        situation.setCategoryName("ReportSituation");
        situation.setReportSituation("INTERNAL", "LOG");
        commonBaseEvent.setSituation(situation);
        String string = EventFormatter.toCanonicalXMLDocString(commonBaseEvent, false);
        String string2 = EventFormatter.toCanonicalXMLDocString(commonBaseEvent, true);
        CommonBaseEvent commonBaseEvent2 = null;
        CommonBaseEvent commonBaseEvent3 = null;
        try {
            commonBaseEvent2 = EventFormatter.eventsFromCanonicalXMLDoc(string)[0];
            commonBaseEvent3 = EventFormatter.eventsFromCanonicalXMLDoc(string2)[0];
        }
        catch (AssertionFailedError assertionFailedError) {
            throw assertionFailedError;
        }
        catch (Throwable throwable) {
            Assert.assertTrue((String)throwable.toString(), (boolean)false);
        }
        Assert.assertEquals((Object)commonBaseEvent, (Object)commonBaseEvent2);
        Assert.assertEquals((Object)commonBaseEvent, (Object)commonBaseEvent3);
        Assert.assertEquals((String)string, (String)EventFormatter.toCanonicalXMLDocString(commonBaseEvent2, false));
        Assert.assertEquals((String)string2, (String)EventFormatter.toCanonicalXMLDocString(commonBaseEvent3, true));
    }

    public void testExtendedDataElementTypesInXMLDocumentDeserialization() {
        String string = "<?xml version=\"1.0\" encoding=\"ASCII\"?><CommonBaseEvents xmlns:cbe=\"http://www.ibm.com/AC/commonbaseevent1_0_1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/AC/commonbaseevent1_0_1 commonbaseevent1_0_1.xsd \"><AssociationEngine id=\"i0000000000000000000000000000044\" name=\"MyCorrelationEngine\" type=\"Correlate\"/><CommonBaseEvent creationTime=\"2001-12-31T12:00:00\" extensionName=\"Name\" globalInstanceId=\"CEE736B610030D11D88000A27990EF8D1A\">  <contextDataElements name=\"myContext\" type=\"String\">    <contextValue>contextValue</contextValue>  </contextDataElements><extendedDataElements name=\"ede1\" type=\"boolean\"><values>true</values><children name=\"chname1\" type=\"int\"><values>10</values></children><children name=\"chname2\" type=\"booleanArray\"> <values>[true,false]</values></children></extendedDataElements><extendedDataElements name=\"ede2\" type=\"string\"><values>&quot;stringValue&quot;</values><children name=\"chname3\" type=\"noValue\"></children></extendedDataElements><reporterComponentId application=\"appl1\" componentType=\"compType1\" component=\"comp1\" componentIdType=\"compIdType1\" executionEnvironment=\"exc1\" instanceId=\"id1\" location=\"loc1\" locationType=\"Hostname\" processId=\"pr1\" subComponent=\"sub1\" threadId=\"th1\"/>  <sourceComponentId application=\"app2\" componentType=\"compType2\" component=\"comp2\" componentIdType=\"compIdType2\" executionEnvironment=\"exc2\" instanceId=\"id2\" location=\"loc2\" locationType=\"SNA\" processId=\"pr2\" subComponent=\"sub2\" threadId=\"th2\"/>  <msgDataElement msgLocale=\"EN\">    <msgCatalogTokens value=\"value\"/>    <msgId>msgId</msgId>    <msgIdType>Name</msgIdType>    <msgCatalogId>msgCatalogId</msgCatalogId>    <msgCatalogType>msgCatalogType</msgCatalogType>    <msgCatalog>msgCatalog</msgCatalog>  </msgDataElement>  <situation categoryName=\"StartSituation\">    <situationType reasoningScope=\"EXTERNAL\" successDisposition=\"SUCCESSFUL\" situationQualifier=\"START COMPLETED\" xsi:type=\"StartSituation\" />  </situation></CommonBaseEvent></CommonBaseEvents>";
        try {
            CommonBaseEvent commonBaseEvent = EventFormatter.eventsFromCanonicalXMLDoc(string)[0];
            CommonBaseEvent commonBaseEvent2 = EventFormatter.eventsFromCanonicalXMLDoc(string)[0];
            Assert.assertEquals((String)((ExtendedDataElement)commonBaseEvent.getExtendedDataElements("ede1").get(0)).getType(), (String)"boolean");
            Assert.assertEquals((String)((ExtendedDataElement)((ExtendedDataElement)commonBaseEvent.getExtendedDataElements("ede1").get(0)).getChildren("chname1").get(0)).getType(), (String)"int");
            Assert.assertEquals((String)((ExtendedDataElement)((ExtendedDataElement)commonBaseEvent.getExtendedDataElements("ede1").get(0)).getChildren("chname2").get(0)).getType(), (String)"booleanArray");
            Assert.assertEquals((String)((ExtendedDataElement)commonBaseEvent.getExtendedDataElements("ede2").get(0)).getType(), (String)"string");
            Assert.assertEquals((String)((ExtendedDataElement)((ExtendedDataElement)commonBaseEvent.getExtendedDataElements("ede2").get(0)).getChildren("chname3").get(0)).getType(), (String)"noValue");
            Assert.assertEquals((Object)commonBaseEvent, (Object)commonBaseEvent2);
            Assert.assertEquals((String)commonBaseEvent.getGlobalInstanceId(), (String)"CEE736B610030D11D88000A27990EF8D1A");
            Assert.assertEquals((String)commonBaseEvent2.getGlobalInstanceId(), (String)"CEE736B610030D11D88000A27990EF8D1A");
            AssociationEngine associationEngine = EventFormatter.associationEnginesFromCanonicalXMLDoc(string)[0];
            AssociationEngine associationEngine2 = EventFormatter.associationEnginesFromCanonicalXMLDoc(string)[0];
            Assert.assertEquals((Object)associationEngine, (Object)associationEngine2);
            Assert.assertEquals((String)associationEngine.getId(), (String)"i0000000000000000000000000000044");
            Assert.assertEquals((String)associationEngine2.getId(), (String)"i0000000000000000000000000000044");
        }
        catch (AssertionFailedError assertionFailedError) {
            throw assertionFailedError;
        }
        catch (Throwable throwable) {
            Assert.assertTrue((String)throwable.toString(), (boolean)false);
        }
    }

    public void testExtendedDataElementTypesInXMLFragmentDeserialization() {
        String string = "<CommonBaseEvent creationTime=\"2001-12-31T12:00:00\" extensionName=\"Name\" globalInstanceId=\"CEE736B610030D11D88000A27990EF8D1A\">  <contextDataElements name=\"myContext\" type=\"String\">    <contextValue>contextValue</contextValue>  </contextDataElements><extendedDataElements name=\"ede1\" type=\"boolean\"><values>true</values><children name=\"chname1\" type=\"int\"><values>10</values></children><children name=\"chname2\" type=\"booleanArray\"> <values>[true,false]</values></children></extendedDataElements><extendedDataElements name=\"ede2\" type=\"string\"><values>&quot;stringValue&quot;</values><children name=\"chname3\" type=\"noValue\"></children></extendedDataElements><reporterComponentId application=\"appl1\" componentType=\"compType1\" component=\"comp1\" componentIdType=\"compIdType1\" executionEnvironment=\"exc1\" instanceId=\"id1\" location=\"loc1\" locationType=\"Hostname\" processId=\"pr1\" subComponent=\"sub1\" threadId=\"th1\"/>  <sourceComponentId application=\"app2\" componentType=\"compType2\" component=\"comp2\" componentIdType=\"compIdType2\" executionEnvironment=\"exc2\" instanceId=\"id2\" location=\"loc2\" locationType=\"SNA\" processId=\"pr2\" subComponent=\"sub2\" threadId=\"th2\"/>  <msgDataElement msgLocale=\"EN\">    <msgCatalogTokens value=\"value\"/>    <msgId>msgId</msgId>    <msgIdType>Name</msgIdType>    <msgCatalogId>msgCatalogId</msgCatalogId>    <msgCatalogType>msgCatalogType</msgCatalogType>    <msgCatalog>msgCatalog</msgCatalog>  </msgDataElement>  <situation categoryName=\"StartSituation\">    <situationType reasoningScope=\"EXTERNAL\" successDisposition=\"SUCCESSFUL\" situationQualifier=\"START COMPLETED\" xsi:type=\"StartSituation\" />  </situation></CommonBaseEvent>";
        try {
            CommonBaseEvent commonBaseEvent = EventFormatter.eventFromCanonicalXML(string);
            CommonBaseEvent commonBaseEvent2 = EventFormatter.eventFromCanonicalXML(string);
            Assert.assertEquals((String)((ExtendedDataElement)commonBaseEvent.getExtendedDataElements("ede1").get(0)).getType(), (String)"boolean");
            Assert.assertEquals((String)((ExtendedDataElement)((ExtendedDataElement)commonBaseEvent.getExtendedDataElements("ede1").get(0)).getChildren("chname1").get(0)).getType(), (String)"int");
            Assert.assertEquals((String)((ExtendedDataElement)((ExtendedDataElement)commonBaseEvent.getExtendedDataElements("ede1").get(0)).getChildren("chname2").get(0)).getType(), (String)"booleanArray");
            Assert.assertEquals((String)((ExtendedDataElement)commonBaseEvent.getExtendedDataElements("ede2").get(0)).getType(), (String)"string");
            Assert.assertEquals((String)((ExtendedDataElement)((ExtendedDataElement)commonBaseEvent.getExtendedDataElements("ede2").get(0)).getChildren("chname3").get(0)).getType(), (String)"noValue");
            Assert.assertEquals((Object)commonBaseEvent, (Object)commonBaseEvent2);
            Assert.assertEquals((String)commonBaseEvent.getGlobalInstanceId(), (String)"CEE736B610030D11D88000A27990EF8D1A");
            Assert.assertEquals((String)commonBaseEvent2.getGlobalInstanceId(), (String)"CEE736B610030D11D88000A27990EF8D1A");
        }
        catch (AssertionFailedError assertionFailedError) {
            throw assertionFailedError;
        }
        catch (Throwable throwable) {
            Assert.assertTrue((String)throwable.toString(), (boolean)false);
        }
    }

    public void testDeprecatedXMLDocumentDeserialization() {
        String string = "<?xml version=\"1.0\" encoding=\"ASCII\"?><CommonBaseEvents xmlns:cbe=\"http://www.ibm.com/AC/commonbaseevent1_0_1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/AC/commonbaseevent1_0_1 commonbaseevent1_0_1.xsd \"><AssociationEngine id=\"i0000000000000000000000000000044\" name=\"MyCorrelationEngine\" type=\"Correlate\"/><CommonBaseEvent creationTime=\"2001-12-31T12:00:00\" extensionName=\"Name\" globalInstanceId=\"CEE736B610030D11D88000A27990EF8D1A\">  <contextDataElements name=\"myContext\" type=\"String\">    <contextValue>contextValue</contextValue>  </contextDataElements>  <extendedDataElements name=\"ede1\" type=\"noValue\">    <values>values</values>    <children name=\"chname1\" type=\"noValue\">      <values>values</values>    </children>  </extendedDataElements>  <extendedDataElements name=\"ede2\" type=\"noValue\">    <values>values</values>    <children name=\"chname2\" type=\"noValue\">      <values>values</values>    </children>  </extendedDataElements>  <reporterComponentId application=\"appl1\" componentType=\"compType1\" component=\"comp1\" componentIdType=\"compIdType1\" executionEnvironment=\"exc1\" instanceId=\"id1\" location=\"loc1\" locationType=\"Hostname\" processId=\"pr1\" subComponent=\"sub1\" threadId=\"th1\"/>  <sourceComponentId application=\"app2\" componentType=\"compType2\" component=\"comp2\" componentIdType=\"compIdType2\" executionEnvironment=\"exc2\" instanceId=\"id2\" location=\"loc2\" locationType=\"SNA\" processId=\"pr2\" subComponent=\"sub2\" threadId=\"th2\"/>  <msgDataElement msgLocale=\"EN\">    <msgCatalogTokens value=\"value\"/>    <msgId>msgId</msgId>    <msgIdType>Name</msgIdType>    <msgCatalogId>msgCatalogId</msgCatalogId>    <msgCatalogType>msgCatalogType</msgCatalogType>    <msgCatalog>msgCatalog</msgCatalog>  </msgDataElement>  <situation categoryName=\"StartSituation\">    <situationType reasoningScope=\"EXTERNAL\" successDisposition=\"SUCCESSFUL\" situationQualifier=\"START COMPLETED\" xsi:type=\"StartSituation\" />  </situation></CommonBaseEvent></CommonBaseEvents>";
        CommonBaseEvent commonBaseEvent = EventFactory.eINSTANCE.createCommonBaseEvent();
        CommonBaseEvent commonBaseEvent2 = EventFactory.eINSTANCE.createCommonBaseEvent();
        EventFormatter.fromCanonicalXMLDocString(commonBaseEvent, string);
        EventFormatter.fromCanonicalXMLDocString(commonBaseEvent2, string);
        Assert.assertEquals((Object)commonBaseEvent.getExtendedDataElements("root"), (Object)commonBaseEvent2.getExtendedDataElements("root"));
        Assert.assertEquals((Object)commonBaseEvent, (Object)commonBaseEvent2);
        Assert.assertEquals((String)commonBaseEvent.getGlobalInstanceId(), (String)"CEE736B610030D11D88000A27990EF8D1A");
        Assert.assertEquals((String)commonBaseEvent2.getGlobalInstanceId(), (String)"CEE736B610030D11D88000A27990EF8D1A");
        AssociationEngine associationEngine = EventFactory.eINSTANCE.createAssociationEngine();
        AssociationEngine associationEngine2 = EventFactory.eINSTANCE.createAssociationEngine();
        EventFormatter.fromCanonicalXMLDocString(associationEngine, string);
        EventFormatter.fromCanonicalXMLDocString(associationEngine2, string);
        Assert.assertEquals((Object)associationEngine, (Object)associationEngine2);
        Assert.assertEquals((String)associationEngine.getId(), (String)"i0000000000000000000000000000044");
        Assert.assertEquals((String)associationEngine2.getId(), (String)"i0000000000000000000000000000044");
    }

    public void testDeprecatedCBE101Sample1XMLDocumentDeserialization() {
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><CommonBaseEvents xmlns=\"http://www.ibm.com/AC/commonbaseevent1_0_1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/AC/commonbaseevent1_0_1 commonbaseevent1_0_1.xsd \"><AssociationEngine id=\"i0000000000000000000000000000044\" name=\"MyCorrelationEngine\" type=\"Correlate\"/><CommonBaseEvent creationTime=\"2001-12-31T12:00:00\" elapsedTime=\"0\" extensionName=\"Name\" globalInstanceId=\"CEE736B610030D11D88000A27990EF8D1A\" localInstanceId=\"\" msg=\"\" priority=\"0\" repeatCount=\"0\" sequenceNumber=\"0\" severity=\"0\" version=\"\">    <contextDataElements name=\"myContext\" type=\"String\">      <contextValue>contextValue</contextValue>     </contextDataElements>    <extendedDataElements name=\"\" type=\"noValue\">      <values>values</values>        <children name=\"\" type=\"noValue\">          <values>values</values>       </children>       </extendedDataElements>    <associatedEvents resolvedEvents=\"i0000000000000000000000000000040\">      <associationEngineInfo id=\"i0000000000000000000000000000044\" name=\"MyCorrelationEngine\" type=\"Correlate\"/>    </associatedEvents>    <reporterComponentId application=\"\" componentType=\"\" component=\"\" componentIdType=\"\" executionEnvironment=\"\" instanceId=\"\" location=\"\" locationType=\"Name\" processId=\"\" subComponent=\"\" threadId=\"\"/>    <sourceComponentId application=\"\" componentType=\"\" component=\"\" componentIdType=\"\" executionEnvironment=\"\" instanceId=\"\" location=\"\" locationType=\"Name\" processId=\"\" subComponent=\"\" threadId=\"\"/>    <msgDataElement msgLocale=\"EN\">       <msgCatalogTokens value=\"\"/>      <msgId>msgId</msgId>      <msgIdType>Name</msgIdType>      <msgCatalogId>msgCatalogId</msgCatalogId>      <msgCatalogType>msgCatalogType</msgCatalogType>      <msgCatalog>msgCatalog</msgCatalog>    </msgDataElement>    <situation categoryName=\"StartSituation\">     \t<situationType reasoningScope=\"EXTERNAL\" successDisposition=\"SUCCESSFUL\" situationQualifier=\"START COMPLETED\" xsi:type=\"StartSituation\" />     </situation>\t       <a:a xmlns:a=\"http://bar\" />   </CommonBaseEvent></CommonBaseEvents>";
        CommonBaseEvent commonBaseEvent = EventFactory.eINSTANCE.createCommonBaseEvent();
        CommonBaseEvent commonBaseEvent2 = EventFactory.eINSTANCE.createCommonBaseEvent();
        EventFormatter.fromCanonicalXMLDocString(commonBaseEvent, string);
        EventFormatter.fromCanonicalXMLDocString(commonBaseEvent2, string);
        Assert.assertEquals((Object)commonBaseEvent, (Object)commonBaseEvent2);
        Assert.assertEquals((String)commonBaseEvent.getGlobalInstanceId(), (String)"CEE736B610030D11D88000A27990EF8D1A");
        Assert.assertEquals((String)commonBaseEvent2.getGlobalInstanceId(), (String)"CEE736B610030D11D88000A27990EF8D1A");
        AssociationEngine associationEngine = EventFactory.eINSTANCE.createAssociationEngine();
        AssociationEngine associationEngine2 = EventFactory.eINSTANCE.createAssociationEngine();
        EventFormatter.fromCanonicalXMLDocString(associationEngine, string);
        EventFormatter.fromCanonicalXMLDocString(associationEngine2, string);
        Assert.assertEquals((Object)associationEngine, (Object)associationEngine2);
        Assert.assertEquals((String)associationEngine.getId(), (String)"i0000000000000000000000000000044");
        Assert.assertEquals((String)associationEngine2.getId(), (String)"i0000000000000000000000000000044");
    }

    public void testDeprecatedCBE101Sample2XMLDocumentDeserialization() {
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><CommonBaseEvents xmlns=\"http://www.ibm.com/AC/commonbaseevent1_0_1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/AC/commonbaseevent1_0_1 commonbaseevent1_0_1.xsd \"><AssociationEngine id=\"i0000000000000000000000000000044\" name=\"MyCorrelationEngine\" type=\"Correlate\"/><CommonBaseEvent creationTime=\"2001-12-31T12:00:00\" elapsedTime=\"0\" extensionName=\"Name\" globalInstanceId=\"CEE736B610030D11D88000A27990EF8D1A\" localInstanceId=\"\" msg=\"\" priority=\"0\" repeatCount=\"0\" sequenceNumber=\"0\" severity=\"0\" version=\"\"><contextDataElements name=\"\" type=\"\"><contextValue>contextValue</contextValue></contextDataElements> <extendedDataElements name=\"\" type=\"noValue\"><values>values</values> <children name=\"\" type=\"noValue\"> <values>values</values>    </children>     </extendedDataElements>    <associatedEvents resolvedEvents=\"i0000000000000000000000000000040\">      <associationEngine>i0000000000000000000000000000044</associationEngine>    </associatedEvents>    <reporterComponentId application=\"\" componentType=\"\" component=\"\" componentIdType=\"\" executionEnvironment=\"\" instanceId=\"\" location=\"\" locationType=\"Name\" processId=\"\" subComponent=\"\" threadId=\"\"/>    <sourceComponentId application=\"\" componentType=\"\" component=\"\" componentIdType=\"\" executionEnvironment=\"\" instanceId=\"\" location=\"\" locationType=\"Name\" processId=\"\" subComponent=\"\" threadId=\"\"/>    <msgDataElement msgLocale=\"EN\">      <msgCatalogTokens value=\"\"/>      <msgId>msgId</msgId>      <msgIdType>Name</msgIdType>      <msgCatalogId>msgCatalogId</msgCatalogId>      <msgCatalogType>msgCatalogType</msgCatalogType>      <msgCatalog>msgCatalog</msgCatalog>    </msgDataElement>    <situation categoryName=\"StartSituation\">    \t<situationType reasoningScope=\"EXTERNAL\" successDisposition=\"SUCCESSFUL\" situationQualifier=\"START COMPLETED\" xsi:type=\"StartSituation\" />\t</situation> \t <a:a xmlns:a=\"http://bar\" > \t     <expression logicalOperator=\"AND\"><preCondition xsi:type=\"SimpleNodeType\" propertyName=\"CommonBaseEvent:Source:contextDataElements\"  comparisonOperator=\"equals\"><testPropertyName>\"cbe:CommonBaseEvent:Target:contextDataElements\"</testPropertyName></preCondition><postCondition xsi:type=\"SimpleNodeType\" propertyName=\"CommonBaseEvent:Source:contextDataElements\" comparisonOperator=\"notNULL\"><testPropertyName>\"cbe:CommonBaseEvent:Target:contextDataElements\"</testPropertyName></postCondition></expression><answer value=\"0\"/></a:a></CommonBaseEvent></CommonBaseEvents>";
        CommonBaseEvent commonBaseEvent = EventFactory.eINSTANCE.createCommonBaseEvent();
        CommonBaseEvent commonBaseEvent2 = EventFactory.eINSTANCE.createCommonBaseEvent();
        EventFormatter.fromCanonicalXMLDocString(commonBaseEvent, string);
        EventFormatter.fromCanonicalXMLDocString(commonBaseEvent2, string);
        Assert.assertEquals((Object)commonBaseEvent, (Object)commonBaseEvent2);
        Assert.assertEquals((String)commonBaseEvent.getGlobalInstanceId(), (String)"CEE736B610030D11D88000A27990EF8D1A");
        Assert.assertEquals((String)commonBaseEvent2.getGlobalInstanceId(), (String)"CEE736B610030D11D88000A27990EF8D1A");
        AssociationEngine associationEngine = EventFactory.eINSTANCE.createAssociationEngine();
        AssociationEngine associationEngine2 = EventFactory.eINSTANCE.createAssociationEngine();
        EventFormatter.fromCanonicalXMLDocString(associationEngine, string);
        EventFormatter.fromCanonicalXMLDocString(associationEngine2, string);
        Assert.assertEquals((Object)associationEngine, (Object)associationEngine2);
        Assert.assertEquals((String)associationEngine.getId(), (String)"i0000000000000000000000000000044");
        Assert.assertEquals((String)associationEngine2.getId(), (String)"i0000000000000000000000000000044");
    }

    public void testDeprecatedXMLFragmentDeserialization() {
        String string = "<CommonBaseEvent globalInstanceId=\"CEE736B610030D11D88000A27990EF8D1A\" localInstanceId=\"LOCAL INSTANCE ID :-) :-)\" msg=\"msg 2 &lt;&gt;&amp;;&quot;&apos; :-)\" elapsedTime=\"123\" priority=\"3\" repeatCount=\"0\" sequenceNumber=\"0\" severity=\"5\" version=\"1.0.1\"><contextDataElements name=\"ettk id\" type=\"anIDTYPE\"><contextId> FIRST</contextId></contextDataElements><contextDataElements name=\"&lt;ettk&amp;value&gt;\" type=\"anVALUETYPE\"><contextValue>SECOND</contextValue></contextDataElements><extendedDataElements name=\"root\" type=\"long\"><children name=\"Child2\" type=\"long\"><children name=\"Child31\" type=\"long\"><children name=\"Child41\" type=\"hexBinary\"><hexValue>818283</hexValue></children></children><children name=\"Child32\" type=\"long\"><children name=\"Child42\" type=\"stringArray\"><values>one</values><values>two</values><values>three</values></children></children><children name=\"Child33\" type=\"long\"><children name=\"Child43\" type=\"longArray\"><values>4</values><values>5</values></children></children></children></extendedDataElements><associatedEvents resolvedEvents=\"cbe1 cbe2\"><associationEngine>AE id</associationEngine></associatedEvents><sourceComponentId application=\"ettkAPP\"/><msgDataElement msgLocale=\"msgLocale\"><msgCatalogTokens value=\"msgCatalogToken1\"/><msgCatalogTokens value=\"msgCatalogToken2\"/><msgId>msgId</msgId><msgIdType>msgIdType</msgIdType><msgCatalogId>msgCatalogId</msgCatalogId><msgCatalogType>msgCatalogType</msgCatalogType><msgCatalog>MsgCatalog</msgCatalog></msgDataElement></CommonBaseEvent>";
        CommonBaseEvent commonBaseEvent = EventFactory.eINSTANCE.createCommonBaseEvent();
        CommonBaseEvent commonBaseEvent2 = EventFactory.eINSTANCE.createCommonBaseEvent();
        EventFormatter.fromCanonicalXMLString(commonBaseEvent, string);
        EventFormatter.fromCanonicalXMLString(commonBaseEvent2, string);
        Assert.assertEquals((Object)commonBaseEvent.getExtendedDataElements("root"), (Object)commonBaseEvent2.getExtendedDataElements("root"));
        Assert.assertEquals((Object)commonBaseEvent, (Object)commonBaseEvent2);
        Assert.assertEquals((String)commonBaseEvent.getGlobalInstanceId(), (String)"CEE736B610030D11D88000A27990EF8D1A");
        Assert.assertEquals((String)commonBaseEvent2.getGlobalInstanceId(), (String)"CEE736B610030D11D88000A27990EF8D1A");
    }

    public void testDeprecatedXMLFragmentSerialization() {
        CommonBaseEvent commonBaseEvent = Util.generateEvent();
        String string = EventFormatter.toCanonicalXMLString(commonBaseEvent, false);
        String string2 = EventFormatter.toCanonicalXMLString(commonBaseEvent, true);
        CommonBaseEvent commonBaseEvent2 = EventFactory.eINSTANCE.createCommonBaseEvent();
        CommonBaseEvent commonBaseEvent3 = EventFactory.eINSTANCE.createCommonBaseEvent();
        EventFormatter.fromCanonicalXMLString(commonBaseEvent2, string);
        EventFormatter.fromCanonicalXMLString(commonBaseEvent3, string2);
        Assert.assertEquals((Object)commonBaseEvent, (Object)commonBaseEvent2);
        Assert.assertEquals((Object)commonBaseEvent, (Object)commonBaseEvent3);
        Assert.assertEquals((String)string, (String)EventFormatter.toCanonicalXMLString(commonBaseEvent2, false));
        Assert.assertEquals((String)string2, (String)EventFormatter.toCanonicalXMLString(commonBaseEvent3, true));
    }

    public void testDeprecatedXMLDocumentSerialization() {
        CommonBaseEvent commonBaseEvent = Util.generateEvent();
        String string = EventFormatter.toCanonicalXMLDocString(commonBaseEvent, false);
        String string2 = EventFormatter.toCanonicalXMLDocString(commonBaseEvent, true);
        CommonBaseEvent commonBaseEvent2 = EventFactory.eINSTANCE.createCommonBaseEvent();
        CommonBaseEvent commonBaseEvent3 = EventFactory.eINSTANCE.createCommonBaseEvent();
        EventFormatter.fromCanonicalXMLDocString(commonBaseEvent2, string);
        EventFormatter.fromCanonicalXMLDocString(commonBaseEvent3, string2);
        Assert.assertEquals((Object)commonBaseEvent, (Object)commonBaseEvent2);
        Assert.assertEquals((Object)commonBaseEvent, (Object)commonBaseEvent3);
        Assert.assertEquals((String)string, (String)EventFormatter.toCanonicalXMLDocString(commonBaseEvent2, false));
        Assert.assertEquals((String)string2, (String)EventFormatter.toCanonicalXMLDocString(commonBaseEvent3, true));
    }

    public void testDeprecatedEventFactoryXMLTemplateDocumentDeserialization() {
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><TemplateEvent version=\"1.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"templateEvent.xsd\"><CommonBaseEvent globalInstanceId=\"CEE736B610030D11D88000A27990EF8D1A\"><situation categoryName=\"ReportSituation\"><situationType xsi:type=\"ReportSituation\" reasoningScope=\"INTERNAL\" reportCategory=\"LOG\"/></situation></CommonBaseEvent></TemplateEvent>";
        CommonBaseEvent commonBaseEvent = EventFactory.eINSTANCE.createCommonBaseEvent();
        CommonBaseEvent commonBaseEvent2 = EventFactory.eINSTANCE.createCommonBaseEvent();
        EventFormatter.fromCanonicalXMLDocString(commonBaseEvent, string);
        EventFormatter.fromCanonicalXMLDocString(commonBaseEvent2, string);
        Assert.assertEquals((Object)commonBaseEvent.getSituation(), (Object)commonBaseEvent2.getSituation());
        Assert.assertEquals((Object)commonBaseEvent, (Object)commonBaseEvent2);
        Assert.assertEquals((String)commonBaseEvent.getGlobalInstanceId(), (String)"CEE736B610030D11D88000A27990EF8D1A");
        Assert.assertEquals((String)commonBaseEvent2.getGlobalInstanceId(), (String)"CEE736B610030D11D88000A27990EF8D1A");
    }

    public void testDeprecatedEventFactoryXMLTemplateFragmentDeserialization() {
        String string = "<CommonBaseEvent globalInstanceId=\"CEE736B610030D11D88000A27990EF8D1A\"><situation categoryName=\"ReportSituation\"><situationType xsi:type=\"ReportSituation\" reasoningScope=\"INTERNAL\" reportCategory=\"LOG\"/></situation></CommonBaseEvent>";
        CommonBaseEvent commonBaseEvent = EventFactory.eINSTANCE.createCommonBaseEvent();
        CommonBaseEvent commonBaseEvent2 = EventFactory.eINSTANCE.createCommonBaseEvent();
        EventFormatter.fromCanonicalXMLString(commonBaseEvent, string);
        EventFormatter.fromCanonicalXMLString(commonBaseEvent2, string);
        Assert.assertEquals((Object)commonBaseEvent.getSituation(), (Object)commonBaseEvent2.getSituation());
        Assert.assertEquals((Object)commonBaseEvent, (Object)commonBaseEvent2);
        Assert.assertEquals((String)commonBaseEvent.getGlobalInstanceId(), (String)"CEE736B610030D11D88000A27990EF8D1A");
        Assert.assertEquals((String)commonBaseEvent2.getGlobalInstanceId(), (String)"CEE736B610030D11D88000A27990EF8D1A");
    }

    public void testDeprecatedEventFactoryXMLTemplateFragmentSerialization() {
        CommonBaseEvent commonBaseEvent = EventFactory.eINSTANCE.createCommonBaseEvent();
        Situation situation = EventFactory.eINSTANCE.createSituation();
        situation.setCategoryName("ReportSituation");
        situation.setReportSituation("INTERNAL", "LOG");
        commonBaseEvent.setSituation(situation);
        String string = EventFormatter.toCanonicalXMLString(commonBaseEvent, false);
        String string2 = EventFormatter.toCanonicalXMLString(commonBaseEvent, true);
        CommonBaseEvent commonBaseEvent2 = EventFactory.eINSTANCE.createCommonBaseEvent();
        CommonBaseEvent commonBaseEvent3 = EventFactory.eINSTANCE.createCommonBaseEvent();
        EventFormatter.fromCanonicalXMLString(commonBaseEvent2, string);
        EventFormatter.fromCanonicalXMLString(commonBaseEvent3, string2);
        Assert.assertEquals((Object)commonBaseEvent, (Object)commonBaseEvent2);
        Assert.assertEquals((Object)commonBaseEvent, (Object)commonBaseEvent3);
        Assert.assertEquals((String)string, (String)EventFormatter.toCanonicalXMLString(commonBaseEvent2, false));
        Assert.assertEquals((String)string2, (String)EventFormatter.toCanonicalXMLString(commonBaseEvent3, true));
    }

    public void testDeprecatedEventFactoryXMLTemplateDocumentSerialization() {
        CommonBaseEvent commonBaseEvent = EventFactory.eINSTANCE.createCommonBaseEvent();
        Situation situation = EventFactory.eINSTANCE.createSituation();
        situation.setCategoryName("ReportSituation");
        situation.setReportSituation("INTERNAL", "LOG");
        commonBaseEvent.setSituation(situation);
        String string = EventFormatter.toCanonicalXMLDocString(commonBaseEvent, false);
        String string2 = EventFormatter.toCanonicalXMLDocString(commonBaseEvent, true);
        CommonBaseEvent commonBaseEvent2 = EventFactory.eINSTANCE.createCommonBaseEvent();
        CommonBaseEvent commonBaseEvent3 = EventFactory.eINSTANCE.createCommonBaseEvent();
        EventFormatter.fromCanonicalXMLDocString(commonBaseEvent2, string);
        EventFormatter.fromCanonicalXMLDocString(commonBaseEvent3, string2);
        Assert.assertEquals((Object)commonBaseEvent, (Object)commonBaseEvent2);
        Assert.assertEquals((Object)commonBaseEvent, (Object)commonBaseEvent3);
        Assert.assertEquals((String)string, (String)EventFormatter.toCanonicalXMLDocString(commonBaseEvent2, false));
        Assert.assertEquals((String)string2, (String)EventFormatter.toCanonicalXMLDocString(commonBaseEvent3, true));
    }

    public void testDeprecatedExtendedDataElementTypesInXMLDocumentDeserialization() {
        String string = "<?xml version=\"1.0\" encoding=\"ASCII\"?><CommonBaseEvents xmlns:cbe=\"http://www.ibm.com/AC/commonbaseevent1_0_1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/AC/commonbaseevent1_0_1 commonbaseevent1_0_1.xsd \"><AssociationEngine id=\"i0000000000000000000000000000044\" name=\"MyCorrelationEngine\" type=\"Correlate\"/><CommonBaseEvent creationTime=\"2001-12-31T12:00:00\" extensionName=\"Name\" globalInstanceId=\"CEE736B610030D11D88000A27990EF8D1A\">  <contextDataElements name=\"myContext\" type=\"String\">    <contextValue>contextValue</contextValue>  </contextDataElements><extendedDataElements name=\"ede1\" type=\"boolean\"><values>true</values><children name=\"chname1\" type=\"int\"><values>10</values></children><children name=\"chname2\" type=\"booleanArray\"> <values>[true,false]</values></children></extendedDataElements><extendedDataElements name=\"ede2\" type=\"string\"><values>&quot;stringValue&quot;</values><children name=\"chname3\" type=\"noValue\"></children></extendedDataElements><reporterComponentId application=\"appl1\" componentType=\"compType1\" component=\"comp1\" componentIdType=\"compIdType1\" executionEnvironment=\"exc1\" instanceId=\"id1\" location=\"loc1\" locationType=\"Hostname\" processId=\"pr1\" subComponent=\"sub1\" threadId=\"th1\"/>  <sourceComponentId application=\"app2\" componentType=\"compType2\" component=\"comp2\" componentIdType=\"compIdType2\" executionEnvironment=\"exc2\" instanceId=\"id2\" location=\"loc2\" locationType=\"SNA\" processId=\"pr2\" subComponent=\"sub2\" threadId=\"th2\"/>  <msgDataElement msgLocale=\"EN\">    <msgCatalogTokens value=\"value\"/>    <msgId>msgId</msgId>    <msgIdType>Name</msgIdType>    <msgCatalogId>msgCatalogId</msgCatalogId>    <msgCatalogType>msgCatalogType</msgCatalogType>    <msgCatalog>msgCatalog</msgCatalog>  </msgDataElement>  <situation categoryName=\"StartSituation\">    <situationType reasoningScope=\"EXTERNAL\" successDisposition=\"SUCCESSFUL\" situationQualifier=\"START COMPLETED\" xsi:type=\"StartSituation\" />  </situation></CommonBaseEvent></CommonBaseEvents>";
        CommonBaseEvent commonBaseEvent = EventFactory.eINSTANCE.createCommonBaseEvent();
        CommonBaseEvent commonBaseEvent2 = EventFactory.eINSTANCE.createCommonBaseEvent();
        EventFormatter.fromCanonicalXMLDocString(commonBaseEvent, string);
        EventFormatter.fromCanonicalXMLDocString(commonBaseEvent2, string);
        Assert.assertEquals((String)((ExtendedDataElement)commonBaseEvent.getExtendedDataElements("ede1").get(0)).getType(), (String)"boolean");
        Assert.assertEquals((String)((ExtendedDataElement)((ExtendedDataElement)commonBaseEvent.getExtendedDataElements("ede1").get(0)).getChildren("chname1").get(0)).getType(), (String)"int");
        Assert.assertEquals((String)((ExtendedDataElement)((ExtendedDataElement)commonBaseEvent.getExtendedDataElements("ede1").get(0)).getChildren("chname2").get(0)).getType(), (String)"booleanArray");
        Assert.assertEquals((String)((ExtendedDataElement)commonBaseEvent.getExtendedDataElements("ede2").get(0)).getType(), (String)"string");
        Assert.assertEquals((String)((ExtendedDataElement)((ExtendedDataElement)commonBaseEvent.getExtendedDataElements("ede2").get(0)).getChildren("chname3").get(0)).getType(), (String)"noValue");
        Assert.assertEquals((Object)commonBaseEvent, (Object)commonBaseEvent2);
        Assert.assertEquals((String)commonBaseEvent.getGlobalInstanceId(), (String)"CEE736B610030D11D88000A27990EF8D1A");
        Assert.assertEquals((String)commonBaseEvent2.getGlobalInstanceId(), (String)"CEE736B610030D11D88000A27990EF8D1A");
        AssociationEngine associationEngine = EventFactory.eINSTANCE.createAssociationEngine();
        AssociationEngine associationEngine2 = EventFactory.eINSTANCE.createAssociationEngine();
        EventFormatter.fromCanonicalXMLDocString(associationEngine, string);
        EventFormatter.fromCanonicalXMLDocString(associationEngine2, string);
        Assert.assertEquals((Object)associationEngine, (Object)associationEngine2);
        Assert.assertEquals((String)associationEngine.getId(), (String)"i0000000000000000000000000000044");
        Assert.assertEquals((String)associationEngine2.getId(), (String)"i0000000000000000000000000000044");
    }

    public void testDeprecatedExtendedDataElementTypesInXMLFragmentDeserialization() {
        String string = "<CommonBaseEvent creationTime=\"2001-12-31T12:00:00\" extensionName=\"Name\" globalInstanceId=\"CEE736B610030D11D88000A27990EF8D1A\">  <contextDataElements name=\"myContext\" type=\"String\">    <contextValue>contextValue</contextValue>  </contextDataElements><extendedDataElements name=\"ede1\" type=\"boolean\"><values>true</values><children name=\"chname1\" type=\"int\"><values>10</values></children><children name=\"chname2\" type=\"booleanArray\"> <values>[true,false]</values></children></extendedDataElements><extendedDataElements name=\"ede2\" type=\"string\"><values>&quot;stringValue&quot;</values><children name=\"chname3\" type=\"noValue\"></children></extendedDataElements><reporterComponentId application=\"appl1\" componentType=\"compType1\" component=\"comp1\" componentIdType=\"compIdType1\" executionEnvironment=\"exc1\" instanceId=\"id1\" location=\"loc1\" locationType=\"Hostname\" processId=\"pr1\" subComponent=\"sub1\" threadId=\"th1\"/>  <sourceComponentId application=\"app2\" componentType=\"compType2\" component=\"comp2\" componentIdType=\"compIdType2\" executionEnvironment=\"exc2\" instanceId=\"id2\" location=\"loc2\" locationType=\"SNA\" processId=\"pr2\" subComponent=\"sub2\" threadId=\"th2\"/>  <msgDataElement msgLocale=\"EN\">    <msgCatalogTokens value=\"value\"/>    <msgId>msgId</msgId>    <msgIdType>Name</msgIdType>    <msgCatalogId>msgCatalogId</msgCatalogId>    <msgCatalogType>msgCatalogType</msgCatalogType>    <msgCatalog>msgCatalog</msgCatalog>  </msgDataElement>  <situation categoryName=\"StartSituation\">    <situationType reasoningScope=\"EXTERNAL\" successDisposition=\"SUCCESSFUL\" situationQualifier=\"START COMPLETED\" xsi:type=\"StartSituation\" />  </situation></CommonBaseEvent>";
        CommonBaseEvent commonBaseEvent = EventFactory.eINSTANCE.createCommonBaseEvent();
        CommonBaseEvent commonBaseEvent2 = EventFactory.eINSTANCE.createCommonBaseEvent();
        EventFormatter.fromCanonicalXMLString(commonBaseEvent, string);
        EventFormatter.fromCanonicalXMLString(commonBaseEvent2, string);
        Assert.assertEquals((String)((ExtendedDataElement)commonBaseEvent.getExtendedDataElements("ede1").get(0)).getType(), (String)"boolean");
        Assert.assertEquals((String)((ExtendedDataElement)((ExtendedDataElement)commonBaseEvent.getExtendedDataElements("ede1").get(0)).getChildren("chname1").get(0)).getType(), (String)"int");
        Assert.assertEquals((String)((ExtendedDataElement)((ExtendedDataElement)commonBaseEvent.getExtendedDataElements("ede1").get(0)).getChildren("chname2").get(0)).getType(), (String)"booleanArray");
        Assert.assertEquals((String)((ExtendedDataElement)commonBaseEvent.getExtendedDataElements("ede2").get(0)).getType(), (String)"string");
        Assert.assertEquals((String)((ExtendedDataElement)((ExtendedDataElement)commonBaseEvent.getExtendedDataElements("ede2").get(0)).getChildren("chname3").get(0)).getType(), (String)"noValue");
        Assert.assertEquals((Object)commonBaseEvent, (Object)commonBaseEvent2);
        Assert.assertEquals((String)commonBaseEvent.getGlobalInstanceId(), (String)"CEE736B610030D11D88000A27990EF8D1A");
        Assert.assertEquals((String)commonBaseEvent2.getGlobalInstanceId(), (String)"CEE736B610030D11D88000A27990EF8D1A");
    }
}

