/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.formatters;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.ICBEPropertyConstants;
import org.eclipse.hyades.logging.adapter.IDirectedGraph;
import org.eclipse.hyades.logging.adapter.IFormatter;
import org.eclipse.hyades.logging.adapter.impl.ProcessUnit;
import org.eclipse.hyades.logging.core.Guid;
import org.eclipse.hyades.logging.events.cbe.AssociatedEvent;
import org.eclipse.hyades.logging.events.cbe.AssociationEngine;
import org.eclipse.hyades.logging.events.cbe.AvailableSituation;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.ConfigureSituation;
import org.eclipse.hyades.logging.events.cbe.ConnectSituation;
import org.eclipse.hyades.logging.events.cbe.ContextDataElement;
import org.eclipse.hyades.logging.events.cbe.CreateSituation;
import org.eclipse.hyades.logging.events.cbe.DependencySituation;
import org.eclipse.hyades.logging.events.cbe.DestroySituation;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.FeatureSituation;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;
import org.eclipse.hyades.logging.events.cbe.OtherSituation;
import org.eclipse.hyades.logging.events.cbe.ReportSituation;
import org.eclipse.hyades.logging.events.cbe.RequestSituation;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.events.cbe.StartSituation;
import org.eclipse.hyades.logging.events.cbe.StopSituation;
import org.eclipse.hyades.logging.events.cbe.impl.SimpleEventFactoryHomeImpl;

public class CBEFormatter
extends ProcessUnit
implements IFormatter,
ICBEPropertyConstants {
    private static final String BUILTIN = "##BUILTIN";
    private static EventFactory eventFactory = new SimpleEventFactoryHomeImpl().getEventFactory("org.eclipse.hyades.logging.adapter.formatters.CBEFormatter");
    private String localHostId = null;
    private String localHostIdFormat = null;
    private static final String HOST_ID_FORMAT_IPV4 = "IPV4";
    private static final String HOST_ID_FORMAT_IPV6 = "IPV6";
    private static final String NONE = "None";
    private static final String UNKNOWN_HOST = "Unknown Host";

    public Object[] processEventItems(Object[] msgs) {
        if (msgs == null || msgs.length == 0) {
            return null;
        }
        return this.processDirectedGraphs(msgs);
    }

    private CommonBaseEvent[] processDirectedGraphs(Object[] msgs) {
        CommonBaseEvent[] cbes = new CommonBaseEvent[msgs.length];
        int k = 0;
        while (k < msgs.length) {
            HashMap<String, Object> cache = new HashMap<String, Object>();
            Iterator ni = ((List)msgs[k]).iterator();
            CommonBaseEvent cbe = eventFactory.createCommonBaseEvent();
            cbe.setGlobalInstanceId(Guid.generate());
            while (ni.hasNext()) {
                CommonBaseEvent event;
                CommonBaseEvent event2;
                IDirectedGraph graphEntry = (IDirectedGraph)ni.next();
                List path = graphEntry.getPath();
                try {
                    CommonBaseEvent event3;
                    if (((String)path.get(0)).equals("CommonBaseEvent")) {
                        String key;
                        String value;
                        if (((String)path.get(2)).equals("extensionName")) {
                            cbe.setExtensionName((String)graphEntry.getValue());
                            continue;
                        }
                        if (((String)path.get(2)).equals("localInstanceId")) {
                            value = (String)graphEntry.getValue();
                            if (value.equals(BUILTIN)) {
                                value = this.getLocalHostId() + System.currentTimeMillis() + Integer.toString(msgs[k].hashCode());
                            }
                            cbe.setLocalInstanceId(value);
                            continue;
                        }
                        if (((String)path.get(2)).equals("globalInstanceId")) {
                            value = (String)graphEntry.getValue();
                            if (value.equals(BUILTIN)) {
                                value = new Guid().toString();
                            }
                            cbe.setGlobalInstanceId(value);
                            continue;
                        }
                        if (((String)path.get(2)).equals("creationTime")) {
                            try {
                                String strValue = (String)graphEntry.getValue();
                                cbe.setCreationTime(strValue);
                                continue;
                            }
                            catch (ClassCastException e) {
                                Long lValue = (Long)graphEntry.getValue();
                                cbe.setCreationTimeAsLong(lValue.longValue());
                                continue;
                            }
                            catch (Exception e) {
                                throw e;
                            }
                        }
                        if (((String)path.get(2)).equals("severity")) {
                            cbe.setSeverity(Short.parseShort((String)graphEntry.getValue()));
                            continue;
                        }
                        if (((String)path.get(2)).equals("priority")) {
                            cbe.setPriority(Short.parseShort((String)graphEntry.getValue()));
                            continue;
                        }
                        if (((String)path.get(2)).equals("msg")) {
                            String message = (String)graphEntry.getValue();
                            int chunks = message.length() / 1024;
                            if (chunks == 0) {
                                cbe.setMsg(message);
                                continue;
                            }
                            cbe.setMsg(message.substring(0, 1024));
                            int i = 0;
                            while (i < chunks) {
                                int offset = 1024 * i;
                                String subChunk = message.substring(offset, offset + 1024);
                                String edeName = "message_" + i;
                                ExtendedDataElement ede = (ExtendedDataElement)cache.get(edeName);
                                if (ede == null) {
                                    ede = eventFactory.createExtendedDataElement();
                                    cbe.addExtendedDataElement(ede);
                                    cache.put(edeName, ede);
                                }
                                ede.setName(edeName);
                                ede.setType("string");
                                ede.setValues(new String[]{subChunk});
                                ++i;
                            }
                            continue;
                        }
                        if (((String)path.get(2)).equals("repeatCount")) {
                            cbe.setRepeatCount(Short.parseShort((String)graphEntry.getValue()));
                            continue;
                        }
                        if (((String)path.get(2)).equals("elapsedTime")) {
                            cbe.setElapsedTime(Long.parseLong((String)graphEntry.getValue()));
                            continue;
                        }
                        if (((String)path.get(2)).equals("sequenceNumber")) {
                            cbe.setSequenceNumber(Long.parseLong((String)graphEntry.getValue()));
                            continue;
                        }
                        if (((String)path.get(2)).equals("version")) {
                            cbe.setVersion((String)graphEntry.getValue());
                            continue;
                        }
                        if (((String)path.get(2)).equals("otherData")) {
                            cbe.addAny((String)graphEntry.getValue());
                            continue;
                        }
                        if (((String)path.get(2)).equals("msgDataElement")) {
                            MsgDataElement mde = cbe.getMsgDataElement();
                            if (mde == null) {
                                mde = eventFactory.createMsgDataElement();
                                cbe.setMsgDataElement(mde);
                            }
                            if (((String)path.get(4)).equals("msgId")) {
                                mde.setMsgId((String)graphEntry.getValue());
                                continue;
                            }
                            if (((String)path.get(4)).equals("msgIdType")) {
                                mde.setMsgIdType((String)graphEntry.getValue());
                                continue;
                            }
                            if (((String)path.get(4)).equals("msgCatalogId")) {
                                mde.setMsgCatalogId((String)graphEntry.getValue());
                                continue;
                            }
                            if (((String)path.get(4)).equals("msgCatalogTokens")) {
                                String msgCatTok = (String)graphEntry.getValue();
                                if (msgCatTok == null || msgCatTok.length() <= 0) continue;
                                mde.addMsgCatalogTokenAsString(msgCatTok);
                                continue;
                            }
                            if (((String)path.get(4)).equals("msgCatalogType")) {
                                mde.setMsgCatalogType((String)graphEntry.getValue());
                                continue;
                            }
                            if (((String)path.get(4)).equals("msgCatalog")) {
                                mde.setMsgCatalog((String)graphEntry.getValue());
                                continue;
                            }
                            if (((String)path.get(4)).equals("msgLocale")) {
                                mde.setMsgLocale((String)graphEntry.getValue());
                                continue;
                            }
                            event2 = this.getEventFactory().createCommonBaseEvent();
                            event2.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_MsgDataElement_WARN_");
                            event2.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(4)});
                            event2.setSeverity((short)30);
                            this.log(event2);
                            continue;
                        }
                        if (((String)path.get(2)).equals("contextDataElements")) {
                            key = (String)path.get(2) + (String)path.get(3);
                            ContextDataElement cde = (ContextDataElement)cache.get(key);
                            if (cde == null) {
                                cde = eventFactory.createContextDataElement();
                                cbe.addContextDataElement(cde);
                                cache.put(key, cde);
                            }
                            if (((String)path.get(4)).equals("contextId")) {
                                if (cde.getContextValue() != null) {
                                    event = this.getEventFactory().createCommonBaseEvent();
                                    event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Duplicate_ContextDataElement_WARN_");
                                    event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(4), "contextValue"});
                                    event.setSeverity((short)30);
                                    this.log(event);
                                    continue;
                                }
                                cde.setContextId((String)graphEntry.getValue());
                                continue;
                            }
                            if (((String)path.get(4)).equals("type")) {
                                cde.setType((String)graphEntry.getValue());
                                continue;
                            }
                            if (((String)path.get(4)).equals("name")) {
                                cde.setName((String)graphEntry.getValue());
                                continue;
                            }
                            if (((String)path.get(4)).equals("contextValue")) {
                                if (cde.getContextId() != null) {
                                    event = this.getEventFactory().createCommonBaseEvent();
                                    event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Duplicate_ContextDataElement_WARN_");
                                    event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(4), "contextId"});
                                    event.setSeverity((short)30);
                                    this.log(event);
                                    continue;
                                }
                                cde.setContextValue((String)graphEntry.getValue());
                                continue;
                            }
                            event = this.getEventFactory().createCommonBaseEvent();
                            event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_ContextDataElement_WARN_");
                            event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(4)});
                            event.setSeverity((short)30);
                            this.log(event);
                            continue;
                        }
                        if (((String)path.get(2)).equals("reporterComponentId") || ((String)path.get(2)).equals("sourceComponentId")) {
                            String value2;
                            ComponentIdentification cid;
                            if (((String)path.get(2)).equals("reporterComponentId")) {
                                cid = cbe.getReporterComponentId();
                                if (cid == null) {
                                    cid = eventFactory.createComponentIdentification();
                                    cbe.setReporterComponentId(cid);
                                }
                            } else {
                                cid = cbe.getSourceComponentId();
                                if (cid == null) {
                                    cid = eventFactory.createComponentIdentification();
                                    cbe.setSourceComponentId(cid);
                                }
                            }
                            if (((String)path.get(4)).equals("location")) {
                                value2 = (String)graphEntry.getValue();
                                if (value2.equals(BUILTIN)) {
                                    value2 = this.getLocalHostId();
                                }
                                cid.setLocation(value2);
                                continue;
                            }
                            if (((String)path.get(4)).equals("locationType")) {
                                value2 = (String)graphEntry.getValue();
                                if (value2.equals(BUILTIN)) {
                                    value2 = this.getLocalHostIdFormat();
                                }
                                cid.setLocationType(value2);
                                continue;
                            }
                            if (((String)path.get(4)).equals("application")) {
                                cid.setApplication((String)graphEntry.getValue());
                                continue;
                            }
                            if (((String)path.get(4)).equals("executionEnvironment")) {
                                cid.setExecutionEnvironment((String)graphEntry.getValue());
                                continue;
                            }
                            if (((String)path.get(4)).equals("component")) {
                                cid.setComponent((String)graphEntry.getValue());
                                continue;
                            }
                            if (((String)path.get(4)).equals("subComponent")) {
                                cid.setSubComponent((String)graphEntry.getValue());
                                continue;
                            }
                            if (((String)path.get(4)).equals("componentIdType")) {
                                cid.setComponentIdType((String)graphEntry.getValue());
                                continue;
                            }
                            if (((String)path.get(4)).equals("componentType")) {
                                cid.setComponentType((String)graphEntry.getValue());
                                continue;
                            }
                            if (((String)path.get(4)).equals("instanceId")) {
                                cid.setInstanceId((String)graphEntry.getValue());
                                continue;
                            }
                            if (((String)path.get(4)).equals("processId")) {
                                cid.setProcessId((String)graphEntry.getValue());
                                continue;
                            }
                            if (((String)path.get(4)).equals("threadId")) {
                                cid.setThreadId((String)graphEntry.getValue());
                                continue;
                            }
                            event2 = this.getEventFactory().createCommonBaseEvent();
                            event2.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_ComponentIdentification_WARN_");
                            event2.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(4)});
                            event2.setSeverity((short)30);
                            this.log(event2);
                            continue;
                        }
                        if (((String)path.get(2)).equals("situation")) {
                            Situation sit = cbe.getSituation();
                            if (sit == null) {
                                sit = eventFactory.createSituation();
                                cbe.setSituation(sit);
                            }
                            if (((String)path.get(4)).equals("categoryName")) {
                                sit.setCategoryName((String)graphEntry.getValue());
                                continue;
                            }
                            if (((String)path.get(4)).equals("situationType")) {
                                SituationType sittype;
                                AvailableSituation asit;
                                if (((String)path.get(6)).equals("AvailableSituation")) {
                                    asit = null;
                                    sittype = sit.getSituationType();
                                    if (sittype == null) {
                                        asit = eventFactory.createAvailableSituation();
                                        sit.setSituationType((SituationType)asit);
                                    } else if (sittype instanceof AvailableSituation) {
                                        asit = (AvailableSituation)sittype;
                                    }
                                    if (asit == null) continue;
                                    if (((String)path.get(8)).equals("reasoningScope")) {
                                        asit.setReasoningScope((String)graphEntry.getValue());
                                        continue;
                                    }
                                    if (((String)path.get(8)).equals("operationDisposition")) {
                                        asit.setOperationDisposition((String)graphEntry.getValue());
                                        continue;
                                    }
                                    if (((String)path.get(8)).equals("processingDisposition")) {
                                        asit.setProcessingDisposition((String)graphEntry.getValue());
                                        continue;
                                    }
                                    if (((String)path.get(8)).equals("availabilityDisposition")) {
                                        asit.setAvailabilityDisposition((String)graphEntry.getValue());
                                        continue;
                                    }
                                    CommonBaseEvent event4 = this.getEventFactory().createCommonBaseEvent();
                                    event4.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_AvailableSituation_WARN_");
                                    event4.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(8)});
                                    event4.setSeverity((short)30);
                                    this.log(event4);
                                    continue;
                                }
                                if (((String)path.get(6)).equals("RequestSituation")) {
                                    asit = null;
                                    sittype = sit.getSituationType();
                                    if (sittype == null) {
                                        asit = eventFactory.createRequestSituation();
                                        sit.setSituationType((SituationType)asit);
                                    } else if (sittype instanceof RequestSituation) {
                                        asit = (RequestSituation)sittype;
                                    }
                                    if (asit == null) continue;
                                    if (((String)path.get(8)).equals("reasoningScope")) {
                                        asit.setReasoningScope((String)graphEntry.getValue());
                                        continue;
                                    }
                                    if (((String)path.get(8)).equals("successDisposition")) {
                                        asit.setSuccessDisposition((String)graphEntry.getValue());
                                        continue;
                                    }
                                    if (((String)path.get(8)).equals("situationQualifier")) {
                                        asit.setSituationQualifier((String)graphEntry.getValue());
                                        continue;
                                    }
                                    CommonBaseEvent event5 = this.getEventFactory().createCommonBaseEvent();
                                    event5.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_RequestSituation_WARN_");
                                    event5.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(8)});
                                    event5.setSeverity((short)30);
                                    this.log(event5);
                                    continue;
                                }
                                if (((String)path.get(6)).equals("StartSituation")) {
                                    asit = null;
                                    sittype = sit.getSituationType();
                                    if (sittype == null) {
                                        asit = eventFactory.createStartSituation();
                                        sit.setSituationType((SituationType)asit);
                                    } else if (sittype instanceof StartSituation) {
                                        asit = (StartSituation)sittype;
                                    }
                                    if (asit == null) continue;
                                    if (((String)path.get(8)).equals("reasoningScope")) {
                                        asit.setReasoningScope((String)graphEntry.getValue());
                                        continue;
                                    }
                                    if (((String)path.get(8)).equals("successDisposition")) {
                                        asit.setSuccessDisposition((String)graphEntry.getValue());
                                        continue;
                                    }
                                    if (((String)path.get(8)).equals("situationQualifier")) {
                                        asit.setSituationQualifier((String)graphEntry.getValue());
                                        continue;
                                    }
                                    CommonBaseEvent event6 = this.getEventFactory().createCommonBaseEvent();
                                    event6.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_StartSituation_WARN_");
                                    event6.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(8)});
                                    event6.setSeverity((short)30);
                                    this.log(event6);
                                    continue;
                                }
                                if (((String)path.get(6)).equals("StopSituation")) {
                                    asit = null;
                                    sittype = sit.getSituationType();
                                    if (sittype == null) {
                                        asit = eventFactory.createStopSituation();
                                        sit.setSituationType((SituationType)asit);
                                    } else if (sittype instanceof StopSituation) {
                                        asit = (StopSituation)sittype;
                                    }
                                    if (asit == null) continue;
                                    if (((String)path.get(8)).equals("reasoningScope")) {
                                        asit.setReasoningScope((String)graphEntry.getValue());
                                        continue;
                                    }
                                    if (((String)path.get(8)).equals("successDisposition")) {
                                        asit.setSuccessDisposition((String)graphEntry.getValue());
                                        continue;
                                    }
                                    if (((String)path.get(8)).equals("situationQualifier")) {
                                        asit.setSituationQualifier((String)graphEntry.getValue());
                                        continue;
                                    }
                                    CommonBaseEvent event7 = this.getEventFactory().createCommonBaseEvent();
                                    event7.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_StopSituation_WARN_");
                                    event7.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(8)});
                                    event7.setSeverity((short)30);
                                    this.log(event7);
                                    continue;
                                }
                                if (((String)path.get(6)).equals("ConnectSituation")) {
                                    asit = null;
                                    sittype = sit.getSituationType();
                                    if (sittype == null) {
                                        asit = eventFactory.createConnectSituation();
                                        sit.setSituationType((SituationType)asit);
                                    } else if (sittype instanceof ConnectSituation) {
                                        asit = (ConnectSituation)sittype;
                                    }
                                    if (asit == null) continue;
                                    if (((String)path.get(8)).equals("reasoningScope")) {
                                        asit.setReasoningScope((String)graphEntry.getValue());
                                        continue;
                                    }
                                    if (((String)path.get(8)).equals("successDisposition")) {
                                        asit.setSuccessDisposition((String)graphEntry.getValue());
                                        continue;
                                    }
                                    if (((String)path.get(8)).equals("situationDisposition")) {
                                        asit.setSituationDisposition((String)graphEntry.getValue());
                                        continue;
                                    }
                                    CommonBaseEvent event8 = this.getEventFactory().createCommonBaseEvent();
                                    event8.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_ConnectSituation_WARN_");
                                    event8.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(8)});
                                    event8.setSeverity((short)30);
                                    this.log(event8);
                                    continue;
                                }
                                if (((String)path.get(6)).equals("ConfigureSituation")) {
                                    asit = null;
                                    sittype = sit.getSituationType();
                                    if (sittype == null) {
                                        asit = eventFactory.createConfigureSituation();
                                        sit.setSituationType((SituationType)asit);
                                    } else if (sittype instanceof ConfigureSituation) {
                                        asit = (ConfigureSituation)sittype;
                                    }
                                    if (asit == null) continue;
                                    if (((String)path.get(8)).equals("reasoningScope")) {
                                        asit.setReasoningScope((String)graphEntry.getValue());
                                        continue;
                                    }
                                    if (((String)path.get(8)).equals("successDisposition")) {
                                        asit.setSuccessDisposition((String)graphEntry.getValue());
                                        continue;
                                    }
                                    CommonBaseEvent event9 = this.getEventFactory().createCommonBaseEvent();
                                    event9.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_ConfigureSituation_WARN_");
                                    event9.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(8)});
                                    event9.setSeverity((short)30);
                                    this.log(event9);
                                    continue;
                                }
                                if (((String)path.get(6)).equals("CreateSituation")) {
                                    asit = null;
                                    sittype = sit.getSituationType();
                                    if (sittype == null) {
                                        asit = eventFactory.createCreateSituation();
                                        sit.setSituationType((SituationType)asit);
                                    } else if (sittype instanceof CreateSituation) {
                                        asit = (CreateSituation)sittype;
                                    }
                                    if (asit == null) continue;
                                    if (((String)path.get(8)).equals("reasoningScope")) {
                                        asit.setReasoningScope((String)graphEntry.getValue());
                                        continue;
                                    }
                                    if (((String)path.get(8)).equals("successDisposition")) {
                                        asit.setSuccessDisposition((String)graphEntry.getValue());
                                        continue;
                                    }
                                    CommonBaseEvent event10 = this.getEventFactory().createCommonBaseEvent();
                                    event10.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_CreateSituation_WARN_");
                                    event10.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(8)});
                                    event10.setSeverity((short)30);
                                    this.log(event10);
                                    continue;
                                }
                                if (((String)path.get(6)).equals("DestroySituation")) {
                                    asit = null;
                                    sittype = sit.getSituationType();
                                    if (sittype == null) {
                                        asit = eventFactory.createDestroySituation();
                                        sit.setSituationType((SituationType)asit);
                                    } else if (sittype instanceof DestroySituation) {
                                        asit = (DestroySituation)sittype;
                                    }
                                    if (asit == null) continue;
                                    if (((String)path.get(8)).equals("reasoningScope")) {
                                        asit.setReasoningScope((String)graphEntry.getValue());
                                        continue;
                                    }
                                    if (((String)path.get(8)).equals("successDisposition")) {
                                        asit.setSuccessDisposition((String)graphEntry.getValue());
                                        continue;
                                    }
                                    CommonBaseEvent event11 = this.getEventFactory().createCommonBaseEvent();
                                    event11.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_CreateSituation_WARN_");
                                    event11.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(8)});
                                    event11.setSeverity((short)30);
                                    this.log(event11);
                                    continue;
                                }
                                if (((String)path.get(6)).equals("ReportSituation")) {
                                    asit = null;
                                    sittype = sit.getSituationType();
                                    if (sittype == null) {
                                        asit = eventFactory.createReportSituation();
                                        sit.setSituationType((SituationType)asit);
                                    } else if (sittype instanceof ReportSituation) {
                                        asit = (ReportSituation)sittype;
                                    }
                                    if (asit == null) continue;
                                    if (((String)path.get(8)).equals("reasoningScope")) {
                                        asit.setReasoningScope((String)graphEntry.getValue());
                                        continue;
                                    }
                                    if (((String)path.get(8)).equals("reportCategory")) {
                                        asit.setReportCategory((String)graphEntry.getValue());
                                        continue;
                                    }
                                    CommonBaseEvent event12 = this.getEventFactory().createCommonBaseEvent();
                                    event12.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_ReportSituation_WARN_");
                                    event12.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(8)});
                                    event12.setSeverity((short)30);
                                    this.log(event12);
                                    continue;
                                }
                                if (((String)path.get(6)).equals("FeatureSituation")) {
                                    asit = null;
                                    sittype = sit.getSituationType();
                                    if (sittype == null) {
                                        asit = eventFactory.createFeatureSituation();
                                        sit.setSituationType((SituationType)asit);
                                    } else if (sittype instanceof FeatureSituation) {
                                        asit = (FeatureSituation)sittype;
                                    }
                                    if (asit == null) continue;
                                    if (((String)path.get(8)).equals("reasoningScope")) {
                                        asit.setReasoningScope((String)graphEntry.getValue());
                                        continue;
                                    }
                                    if (((String)path.get(8)).equals("featureDisposition")) {
                                        asit.setFeatureDisposition((String)graphEntry.getValue());
                                        continue;
                                    }
                                    CommonBaseEvent event13 = this.getEventFactory().createCommonBaseEvent();
                                    event13.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_FeatureSituation_WARN_");
                                    event13.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(8)});
                                    event13.setSeverity((short)30);
                                    this.log(event13);
                                    continue;
                                }
                                if (((String)path.get(6)).equals("DependencySituation")) {
                                    asit = null;
                                    sittype = sit.getSituationType();
                                    if (sittype == null) {
                                        asit = eventFactory.createDependencySituation();
                                        sit.setSituationType((SituationType)asit);
                                    } else if (sittype instanceof DependencySituation) {
                                        asit = (DependencySituation)sittype;
                                    }
                                    if (asit == null) continue;
                                    if (((String)path.get(8)).equals("reasoningScope")) {
                                        asit.setReasoningScope((String)graphEntry.getValue());
                                        continue;
                                    }
                                    if (((String)path.get(8)).equals("dependencyDisposition")) {
                                        asit.setDependencyDisposition((String)graphEntry.getValue());
                                        continue;
                                    }
                                    CommonBaseEvent event14 = this.getEventFactory().createCommonBaseEvent();
                                    event14.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_DependencySituation_WARN_");
                                    event14.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(8)});
                                    event14.setSeverity((short)30);
                                    this.log(event14);
                                    continue;
                                }
                                if (((String)path.get(6)).equals("OtherSituation")) {
                                    asit = null;
                                    sittype = sit.getSituationType();
                                    if (sittype == null) {
                                        asit = eventFactory.createOtherSituation();
                                        sit.setSituationType((SituationType)asit);
                                    } else if (sittype instanceof OtherSituation) {
                                        asit = (OtherSituation)sittype;
                                    }
                                    if (asit == null) continue;
                                    if (((String)path.get(8)).equals("reasoningScope")) {
                                        asit.setReasoningScope((String)graphEntry.getValue());
                                        continue;
                                    }
                                    if (((String)path.get(8)).equals("anyData")) {
                                        asit.setAny((String)graphEntry.getValue());
                                        continue;
                                    }
                                    CommonBaseEvent event15 = this.getEventFactory().createCommonBaseEvent();
                                    event15.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_DependencySituation_WARN_");
                                    event15.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(8)});
                                    event15.setSeverity((short)30);
                                    this.log(event15);
                                    continue;
                                }
                                event2 = this.getEventFactory().createCommonBaseEvent();
                                event2.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_SituationType_WARN_");
                                event2.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(6)});
                                event2.setSeverity((short)30);
                                this.log(event2);
                                continue;
                            }
                            event2 = this.getEventFactory().createCommonBaseEvent();
                            event2.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_Situation_WARN_");
                            event2.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(4)});
                            event2.setSeverity((short)30);
                            this.log(event2);
                            continue;
                        }
                        if (((String)path.get(2)).startsWith("associatedEvents")) {
                            key = (String)path.get(2) + (String)path.get(3);
                            AssociatedEvent ae = (AssociatedEvent)cache.get(key);
                            if (ae == null) {
                                ae = eventFactory.createAssociatedEvent();
                                cbe.addAssociatedEvent(ae);
                                cache.put(key, ae);
                            }
                            if (((String)path.get(4)).equals("associationEngine")) {
                                event = this.getEventFactory().createCommonBaseEvent();
                                event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_AssociatedEvent_WARN_");
                                event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(4)});
                                event.setSeverity((short)30);
                                this.log(event);
                                continue;
                            }
                            if (((String)path.get(4)).equals("associationEngineInfo")) {
                                AssociationEngine aei = ae.getAssociationEngineInfo();
                                if (aei == null) {
                                    aei = eventFactory.createAssociationEngine();
                                    aei.setId(Guid.generate());
                                    ae.setAssociationEngineInfo(aei);
                                }
                                if (((String)path.get(6)).equals("id")) {
                                    aei.setId((String)graphEntry.getValue());
                                    continue;
                                }
                                if (((String)path.get(6)).equals("name")) {
                                    aei.setName((String)graphEntry.getValue());
                                    continue;
                                }
                                if (((String)path.get(6)).equals("type")) {
                                    aei.setType((String)graphEntry.getValue());
                                    continue;
                                }
                                CommonBaseEvent event16 = this.getEventFactory().createCommonBaseEvent();
                                event16.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_AssociationEngine_WARN_");
                                event16.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(6)});
                                event16.setSeverity((short)30);
                                this.log(event16);
                                continue;
                            }
                            if (((String)path.get(4)).equals("resolvedEvents")) {
                                ae.addResolvedEvent((String)graphEntry.getValue());
                                continue;
                            }
                            event = this.getEventFactory().createCommonBaseEvent();
                            event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_AssociatedEvent_WARN_");
                            event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(4)});
                            event.setSeverity((short)30);
                            this.log(event);
                            continue;
                        }
                        if (((String)path.get(2)).startsWith("extendedDataElements")) {
                            key = (String)path.get(2) + (String)path.get(3);
                            ExtendedDataElement ede = (ExtendedDataElement)cache.get(key);
                            if (ede == null) {
                                ede = eventFactory.createExtendedDataElement();
                                cbe.addExtendedDataElement(ede);
                                cache.put(key, ede);
                            }
                            String property = (String)path.get(4);
                            int depth = 4;
                            while (property != null) {
                                CommonBaseEvent event17;
                                if (property.equals("name")) {
                                    ede.setName((String)graphEntry.getValue());
                                    property = null;
                                    continue;
                                }
                                if (property.equals("type")) {
                                    ede.setType((String)graphEntry.getValue());
                                    property = null;
                                    continue;
                                }
                                if (property.equals("values")) {
                                    String[] result = new String[]{(String)graphEntry.getValue()};
                                    ede.setValues(result);
                                    property = null;
                                    continue;
                                }
                                if (property.equals("hexValue")) {
                                    if (ede.getValues() != null) {
                                        event17 = this.getEventFactory().createCommonBaseEvent();
                                        event17.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Duplicate_ExtendedDataElement_WARN_");
                                        event17.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), property, "values"});
                                        event17.setSeverity((short)30);
                                        this.log(event17);
                                    } else {
                                        ede.setHexValueAsCharArray((char[])graphEntry.getValue());
                                    }
                                    property = null;
                                    continue;
                                }
                                if (property.equals("children")) {
                                    ExtendedDataElement edeTmp;
                                    String edeName = (String)path.get(++depth);
                                    EList edeArr = ede.getChildren();
                                    if (edeArr == null) {
                                        edeTmp = eventFactory.createExtendedDataElement();
                                        edeTmp.setName(edeName);
                                        ede.addChild(edeTmp);
                                        ede = edeTmp;
                                    } else {
                                        edeTmp = null;
                                        int j = 0;
                                        while (j < edeArr.size()) {
                                            if (((ExtendedDataElement)edeArr.get(j)).getName().equals(edeName)) {
                                                edeTmp = (ExtendedDataElement)edeArr.get(j);
                                            }
                                            ++j;
                                        }
                                        if (edeTmp == null) {
                                            edeTmp = eventFactory.createExtendedDataElement();
                                            edeTmp.setName(edeName);
                                            ede.addChild(edeTmp);
                                        }
                                        ede = edeTmp;
                                    }
                                    property = (String)path.get(depth += 2);
                                    continue;
                                }
                                event17 = this.getEventFactory().createCommonBaseEvent();
                                event17.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_ExtendedDataElement_WARN_");
                                event17.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), property});
                                event17.setSeverity((short)30);
                                this.log(event17);
                                property = null;
                            }
                            continue;
                        }
                        event3 = this.getEventFactory().createCommonBaseEvent();
                        event3.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_CommmonBaseEvent_WARN_");
                        event3.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(2)});
                        event3.setSeverity((short)30);
                        this.log(event3);
                        continue;
                    }
                    event3 = this.getEventFactory().createCommonBaseEvent();
                    event3.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_Property_WARN_");
                    event3.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(0)});
                    event3.setSeverity((short)30);
                    this.log(event3);
                }
                catch (NumberFormatException e) {
                    event2 = this.getEventFactory().createCommonBaseEvent();
                    event2.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Non_Numeric_Property_WARN_");
                    event2.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(2)});
                    event2.setSeverity((short)30);
                    this.log(event2);
                }
                catch (Exception e) {
                    event = this.getEventFactory().createCommonBaseEvent();
                    event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Exception_WARN_");
                    event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(2), e.getMessage()});
                    event.setSeverity((short)30);
                    this.log(event);
                }
            }
            cbes[k] = cbe;
            ++k;
        }
        return cbes;
    }

    public Object[] testProcessEventItems(Object[] msgs) throws AdapterInvalidConfig {
        return this.testProcessDirectedGraphs(msgs);
    }

    private CommonBaseEvent[] testProcessDirectedGraphs(Object[] elements) throws AdapterInvalidConfig {
        if (!(elements[0] instanceof List)) {
            throw new AdapterInvalidConfig("This formatter will only accept arrays of Lists");
        }
        CommonBaseEvent[] eventArray = new CommonBaseEvent[]{eventFactory.createCommonBaseEvent()};
        return eventArray;
    }

    public void update() throws AdapterInvalidConfig {
        super.update();
    }

    private void getLocalHostInfo() {
        block3: {
            try {
                this.localHostId = InetAddress.getLocalHost().getHostAddress();
                if (this.localHostId.indexOf(58) != -1) {
                    this.localHostIdFormat = HOST_ID_FORMAT_IPV6;
                    break block3;
                }
                this.localHostIdFormat = HOST_ID_FORMAT_IPV4;
            }
            catch (Exception e) {
                this.localHostId = UNKNOWN_HOST;
                this.localHostIdFormat = NONE;
            }
        }
    }

    private String getLocalHostId() {
        if (this.localHostId == null) {
            this.getLocalHostInfo();
        }
        return this.localHostId;
    }

    private String getLocalHostIdFormat() {
        if (this.localHostIdFormat == null) {
            this.getLocalHostInfo();
        }
        return this.localHostIdFormat;
    }
}

