/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.models.internal.probekit.DataItem;
import org.eclipse.hyades.models.internal.probekit.DataType;
import org.eclipse.hyades.models.internal.probekit.DocumentRoot;
import org.eclipse.hyades.models.internal.probekit.Fragment;
import org.eclipse.hyades.models.internal.probekit.FragmentType;
import org.eclipse.hyades.models.internal.probekit.Import;
import org.eclipse.hyades.models.internal.probekit.Label;
import org.eclipse.hyades.models.internal.probekit.Name;
import org.eclipse.hyades.models.internal.probekit.Probe;
import org.eclipse.hyades.models.internal.probekit.Probekit;
import org.eclipse.hyades.models.internal.probekit.StaticField;
import org.eclipse.hyades.models.internal.probekit.Target;
import org.eclipse.hyades.probekit.IProbeCompiler;
import org.eclipse.hyades.probekit.ProbekitCompileProblemException;
import org.eclipse.hyades.probekit.ProbekitException;
import org.eclipse.hyades.probekit.ProbekitPlugin;

public class Compiler
implements IProbeCompiler {
    private static final String EMPTY_STRING = "";
    private static final String SPACE_STRING = " ";
    static final String[] primitiveTypes = new String[]{"int", "long", "char", "short", "byte", "boolean", "float", "double"};
    private List probekits = new LinkedList();
    private int compilerState = 0;
    private static final int STATE_DIRTY = 0;
    private static final int STATE_CLEAN = 1;
    private static final int STATE_ERROR = 2;
    private StringBuffer generatedSource;
    private StringBuffer engScript;
    private static final String lineSeparator = System.getProperty("line.separator");
    private String classPrefix = "";
    private String packageName = null;
    private static FragmentDescriptor[] fragmentDescriptors = new FragmentDescriptor[]{new FragmentDescriptor("entry", "ONENTRY", new boolean[]{false, false, true, true, true, true, true, false, true, true, true, true, true, false}), new FragmentDescriptor("exit", "ONEXIT", new boolean[]{true, true, true, true, true, true, true, false, true, true, true, true, true, false}), new FragmentDescriptor("catch", "ONCATCH", new boolean[]{false, true, true, true, true, true, true, true, true, true, true, true, true, true}), new FragmentDescriptor("beforeCall", "BEFORECALL", new boolean[]{false, false, true, true, true, true, true, false, false, false, false, false, false, false}), new FragmentDescriptor("afterCall", "AFTERCALL", new boolean[]{true, true, true, true, true, true, true, false, false, false, false, false, false, false}), new FragmentDescriptor("staticInitializer", "STATICINITIALIZER", new boolean[]{false, false, true, true, true, false, false, false, true, true, true, true, true, false}), new FragmentDescriptor("executableUnit", "EXECUTABLEUNIT", new boolean[]{false, false, true, true, true, true, true, false, true, true, true, true, true, true})};
    private static DataItemDesc[] dataItemDescs = new DataItemDesc[]{new DataItemDesc("returnedObject", "Object", "Ljava/lang/Object;"), new DataItemDesc("exceptionObject", "Throwable", "Ljava/lang/Throwable;"), new DataItemDesc("className", "String", "Ljava/lang/String;"), new DataItemDesc("methodName", "String", "Ljava/lang/String;"), new DataItemDesc("methodSig", "String", "Ljava/lang/String;"), new DataItemDesc("thisObject", "Object", "Ljava/lang/Object;"), new DataItemDesc("args", "Object[]", "[Ljava/lang/Object;"), new DataItemDesc("isFinally", "boolean", "Z"), new DataItemDesc("staticField", "", ""), new DataItemDesc("classSourceFile", "String", "Ljava/lang/String;"), new DataItemDesc("methodNames", "String", "Ljava/lang/String;"), new DataItemDesc("methodLineTables", "String", "Ljava/lang/String;"), new DataItemDesc("methodNumber", "int", "I"), new DataItemDesc("executableUnitNumber", "int", "I")};
    static final String PROBE_INNER_CLASS_NAME_PREFIX = "Probe_";
    static final String INVOCATION_OBJECT_TYPE_SIGNATURE = "Ljava/lang/Object;";
    private Map probeDetailsMap;
    private int nextSerialNumber;

    public Compiler() {
    }

    public Compiler(Probekit probekit) {
        this.probekits.add(new ProbekitPair(probekit, (IResource)ProbekitPlugin.getWorkspace().getRoot()));
    }

    public Compiler(String string) throws ProbekitException {
        this.addFile(string);
    }

    public void addProbekit(Probekit probekit) throws ProbekitException {
        this.probekits.add(new ProbekitPair(probekit, (IResource)ProbekitPlugin.getWorkspace().getRoot()));
    }

    public void addFile(String string) throws ProbekitException {
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        URI uRI = URI.createFileURI((String)string);
        Resource resource = resourceSetImpl.getResource(uRI, true);
        if (resource == null) {
            throw new ProbekitException(ProbekitPlugin.getString("Compiler.CantReadSourceFile") + string);
        }
        this.addResource(resource);
    }

    public void addResource(Resource resource) throws ProbekitException {
        Iterator iterator = resource.getContents().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof DocumentRoot)) {
                throw new ProbekitException("Probe compiler internal error: resource doesn't contain a DocumentRoot");
            }
            DocumentRoot documentRoot = (DocumentRoot)e;
            Probekit probekit = documentRoot.getProbekit();
            if (probekit == null) continue;
            this.probekits.add(new ProbekitPair(probekit, (IResource)ProbekitPlugin.getWorkspace().getRoot()));
        }
        this.setDirtyState();
    }

    public String addResource(Resource resource, IResource iResource) throws ProbekitException {
        Iterator iterator = resource.getContents().iterator();
        String string = null;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof DocumentRoot)) {
                throw new ProbekitException(ProbekitPlugin.getString("Compiler.NoProbekitResource"));
            }
            DocumentRoot documentRoot = (DocumentRoot)e;
            Probekit probekit = documentRoot.getProbekit();
            if (probekit == null) {
                this.reportError(ProbekitPlugin.getString("Compiler.NoProbekitSource"), iResource);
                continue;
            }
            this.probekits.add(new ProbekitPair(probekit, iResource));
            string = probekit.getId();
        }
        this.setDirtyState();
        return string;
    }

    public String addIFile(IFile iFile) throws ProbekitException {
        Resource resource;
        this.removeProbekitMarkers((IResource)iFile);
        try {
            if (!iFile.exists()) {
                this.reportError(ProbekitPlugin.getString("Compiler.MissingFile"), (IResource)iFile);
                throw new ProbekitCompileProblemException(EMPTY_STRING);
            }
            IPath iPath = iFile.getLocation();
            if (iPath == null) {
                this.reportError(ProbekitPlugin.getString("Compiler.NoProbekitResource"), (IResource)iFile);
                throw new ProbekitCompileProblemException(EMPTY_STRING);
            }
            File file = iPath.toFile();
            if (file.length() == 0L) {
                this.reportError(ProbekitPlugin.getString("Compiler.EmptyFile"), (IResource)iFile);
                throw new ProbekitCompileProblemException(EMPTY_STRING);
            }
            ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
            URI uRI = URI.createFileURI((String)iPath.toOSString());
            resource = resourceSetImpl.getResource(uRI, true);
            if (resource == null) {
                this.reportError(ProbekitPlugin.getString("Compiler.NoProbekitResource"), (IResource)iFile);
                throw new ProbekitCompileProblemException(EMPTY_STRING);
            }
        }
        catch (ProbekitCompileProblemException probekitCompileProblemException) {
            throw probekitCompileProblemException;
        }
        catch (Exception exception) {
            this.reportError(ProbekitPlugin.getString("Compiler.CantReadSourceFile") + exception.getMessage(), (IResource)iFile);
            throw new ProbekitCompileProblemException(EMPTY_STRING);
        }
        return this.addResource(resource, (IResource)iFile);
    }

    public void setClassPrefix(String string) throws ProbekitException {
        if (!this.isValidJavaIdentifier(string, false)) {
            throw new ProbekitException(ProbekitPlugin.getString("Compiler.BadSetPrefixArg") + string);
        }
        this.classPrefix = string;
        this.setDirtyState();
    }

    public void setPackageName(String string) throws ProbekitException {
        if (!this.isValidJavaIdentifier(string, true)) {
            throw new ProbekitException("Probekit API error: bad argument to setPackageName: " + string);
        }
        this.packageName = string;
    }

    public String getClassSuffix() {
        return "_probe";
    }

    public String makeValidJavaIdentifier(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        if (n > 0) {
            char c = string.charAt(0);
            if (!Character.isJavaIdentifierStart(c)) {
                stringBuffer.append('_');
                stringBuffer.append(Integer.toString(c, 16).toUpperCase());
            } else {
                stringBuffer.append(c);
            }
            int n2 = 1;
            while (n2 < n) {
                c = string.charAt(n2);
                if (!Character.isJavaIdentifierPart(c)) {
                    stringBuffer.append('_');
                    stringBuffer.append(Integer.toString(c, 16).toUpperCase());
                } else {
                    stringBuffer.append(c);
                }
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    private void removeProbekitMarkers(IResource iResource) {
        try {
            iResource.deleteMarkers("org.eclipse.hyades.probekit.probekitProblem", true, 0);
        }
        catch (CoreException coreException) {}
    }

    private void reportError(String string, IResource iResource) {
        this.compilerState = 2;
        try {
            IMarker iMarker = iResource.createMarker("org.eclipse.hyades.probekit.probekitProblem");
            iMarker.setAttribute("message", (Object)string);
            iMarker.setAttribute("severity", 2);
        }
        catch (CoreException coreException) {
            Status status = new Status(4, "org.eclipse.hyades.probekit", 0, ProbekitPlugin.getString("Compiler.MarkerCreateError"), null);
            ProbekitPlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    public void verify() throws ProbekitException {
        if (this.probekits.size() == 0) {
            throw new ProbekitException(ProbekitPlugin.getString("Compiler.VerifyBeforeAdd"));
        }
        Iterator iterator = this.probekits.iterator();
        while (iterator.hasNext()) {
            Iterator iterator2;
            ProbekitPair probekitPair = (ProbekitPair)iterator.next();
            Probekit probekit = probekitPair.probekit;
            IResource iResource = probekitPair.iresource;
            if (probekit.getLabel() != null) {
                boolean bl = false;
                int n = 0;
                iterator2 = probekit.getLabel().iterator();
                while (iterator2.hasNext()) {
                    Object e = iterator2.next();
                    if (!(e instanceof Label)) {
                        this.reportError("Probekit internal error: a member of the Labels list is not a label", iResource);
                        continue;
                    }
                    Label label = (Label)e;
                    String string = label.getLang();
                    String string2 = label.getName();
                    String string3 = label.getDescription();
                    if (string == null || string.equals(EMPTY_STRING)) {
                        if (bl) {
                            this.reportError(ProbekitPlugin.getString("Compiler.MultipleDefaultLabels"), iResource);
                        }
                        bl = true;
                    } else {
                        ++n;
                    }
                    if (string2 != null && !string2.equals(EMPTY_STRING)) continue;
                    this.reportError(ProbekitPlugin.getString("Compiler.EmptyNameInLabel"), iResource);
                }
                if (!bl && n > 1) {
                    this.reportError(ProbekitPlugin.getString("Compiler.MultipleLabelsNoDefault"), iResource);
                }
            }
            if (probekit.getProbe() == null) {
                this.reportError("Probekit has a null probe list (internal error)", iResource);
                continue;
            }
            if (probekit.getProbe().size() == 0) {
                this.reportError(ProbekitPlugin.getString("Compiler.NoProbesInProbekit"), iResource);
            }
            Iterator iterator3 = probekit.getProbe().iterator();
            while (iterator3.hasNext()) {
                Object e = iterator3.next();
                if (!(e instanceof Probe)) {
                    this.reportError(ProbekitPlugin.getString("Compiler.NonProbeObject"), iResource);
                    continue;
                }
                iterator2 = (Probe)e;
                this.verifyOneProbe((Probe)iterator2, iResource);
            }
        }
        if (this.compilerState == 2) {
            throw new ProbekitCompileProblemException(EMPTY_STRING);
        }
    }

    private void verifyOneProbe(Probe probe, IResource iResource) {
        String string;
        DataType dataType;
        Iterator iterator;
        int n;
        Object object;
        Object object2;
        Object object3;
        if (probe.getImport() != null) {
            object3 = probe.getImport().iterator();
            while (object3.hasNext()) {
                object2 = (Import)object3.next();
                object = object2.getText();
                if (object != null && !((String)object).equals(EMPTY_STRING)) continue;
                this.reportError(ProbekitPlugin.getString("Compiler.EmptyPackageName"), iResource);
            }
        }
        if ((object3 = probe.getStaticField()) != null) {
            object2 = object3.getType();
            if (object2 == null || ((String)object2).equals(EMPTY_STRING)) {
                this.reportError(ProbekitPlugin.getString("Compiler.EmptyStaticFieldType"), iResource);
            } else {
                if (!this.isValidJavaIdentifier((String)object2, true)) {
                    this.reportError(ProbekitPlugin.getString("Compiler.BadStaticFieldType") + (String)object2, iResource);
                }
                int n2 = 0;
                while (n2 < primitiveTypes.length) {
                    if (((String)object2).equals(primitiveTypes[n2])) {
                        this.reportError(ProbekitPlugin.getString("Compiler.StaticFieldTypeIsPrimitive") + (String)object2, iResource);
                    }
                    ++n2;
                }
            }
        }
        if (probe.getFragment().size() != 0 || object3 == null) {
            // empty if block
        }
        object2 = new boolean[fragmentDescriptors.length];
        object = probe.getFragment().iterator();
        while (object.hasNext()) {
            Fragment fragment = (Fragment)object.next();
            FragmentType fragmentType = fragment.getType();
            if (fragmentType == null) {
                this.reportError("Probekit internal error: a fragment type is null", iResource);
                continue;
            }
            String string2 = fragmentType.getName();
            if (string2 == null || string2.equals(EMPTY_STRING)) {
                this.reportError("Probekit internal error: a fragment type string is null or empty", iResource);
                continue;
            }
            try {
                n = Compiler.FragTypeNameToNumber(string2);
                if (object2[n] != false) {
                    this.reportError(ProbekitPlugin.getString("Compiler.MultipleFragmentsSameType") + string2, iResource);
                }
                object2[n] = true;
            }
            catch (ProbekitException probekitException) {
                this.reportError(ProbekitPlugin.getString("Compiler.InvalidFragmentType") + string2, iResource);
                continue;
            }
            boolean[] blArray = new boolean[dataItemDescs.length];
            if (fragment.getData() != null) {
                Iterator iterator2 = fragment.getData().iterator();
                while (iterator2.hasNext()) {
                    iterator = (DataItem)iterator2.next();
                    dataType = iterator.getType();
                    if (dataType == null) {
                        this.reportError("Probekit internal error: a data item type enum is null", iResource);
                        continue;
                    }
                    string = dataType.getName();
                    if (string == null) {
                        this.reportError("Probekit internal error: a data item has null type string", iResource);
                        continue;
                    }
                    boolean bl = false;
                    int n3 = 0;
                    while (n3 < dataItemDescs.length) {
                        if (string.equals(Compiler.dataItemDescs[n3].typeName)) {
                            if (blArray[n3]) {
                                this.reportError(ProbekitPlugin.getString("Compiler.DuplicateDataItem1") + string2 + ProbekitPlugin.getString("Compiler.DuplicateDataItem2") + string, iResource);
                            }
                            blArray[n3] = true;
                            if (!Compiler.fragmentDescriptors[n].allowableDataItems[n3]) {
                                this.reportError(ProbekitPlugin.getString("Compiler.DataItemNotAllowed1") + " \"" + string + "\" " + ProbekitPlugin.getString("Compiler.DataItemNotAllowed2") + string2, iResource);
                            }
                            if (string.equals("staticField") && object3 == null) {
                                this.reportError(ProbekitPlugin.getString("Compiler.NoStaticFieldAvailable") + string2, iResource);
                            }
                            bl = true;
                            break;
                        }
                        ++n3;
                    }
                    if (!bl) {
                        this.reportError(ProbekitPlugin.getString("Compiler.BadDataItemType") + string, iResource);
                    }
                    if (iterator.getName() == null || iterator.getName().equals(EMPTY_STRING)) {
                        this.reportError(ProbekitPlugin.getString("Compiler.MissingDataItemName"), iResource);
                        continue;
                    }
                    if (this.isValidJavaIdentifier(iterator.getName(), false)) continue;
                    this.reportError(ProbekitPlugin.getString("Compiler.BadDataItemName") + iterator.getName(), iResource);
                }
            }
            if (fragment.getCode() != null && !fragment.getCode().equals(EMPTY_STRING)) continue;
            this.reportError(ProbekitPlugin.getString("Compiler.FragmentIsMissingCode"), iResource);
        }
        int n4 = object2[3] | object2[4];
        int n5 = object2[0] | object2[1] | object2[2] | object2[5] | object2[6];
        if (n4 != 0 && n5 != 0) {
            this.reportError(ProbekitPlugin.getString("Compiler.BadFragmentTypeCombo"), iResource);
        }
        if (n4 != 0 && object3 != null) {
            this.reportError(ProbekitPlugin.getString("Compiler.CallsiteCantUseStaticField"), iResource);
        }
        boolean bl = false;
        n = 0;
        int n6 = 0;
        boolean bl2 = false;
        iterator = probe.getTarget().iterator();
        while (iterator.hasNext()) {
            if (n6 == 1) {
                this.reportError(ProbekitPlugin.getString("Compiler.TargetsAfterStars"), iResource);
                n6 = 2;
            }
            if ((string = (dataType = (Target)iterator.next()).getType()) == null || string.equals(EMPTY_STRING)) {
                this.reportError(ProbekitPlugin.getString("Compiler.MissingTargetType"), iResource);
                continue;
            }
            if (string.equals("exclude")) {
                bl = true;
                bl2 = false;
            } else if (string.equals("include")) {
                bl2 = true;
            } else {
                n = 1;
                this.reportError(ProbekitPlugin.getString("Compiler.BadTargetType") + dataType.getType(), iResource);
            }
            if (this.hasWhitespace(dataType.getClassName()) || this.hasWhitespace(dataType.getMethod()) || this.hasWhitespace(dataType.getPackage()) || this.hasWhitespace(dataType.getSignature())) {
                this.reportError(ProbekitPlugin.getString("Compiler.BadTargetPattern"), iResource);
            }
            if (!Compiler.emptyNullOrStar(dataType.getClassName()) || !Compiler.emptyNullOrStar(dataType.getMethod()) || !Compiler.emptyNullOrStar(dataType.getPackage()) || !Compiler.emptyNullOrStar(dataType.getSignature())) continue;
            n6 = 1;
        }
        if (probe.getTarget().size() > 0 && n == 0) {
            if (!bl) {
                this.reportError(ProbekitPlugin.getString("Compiler.BadTargetAllInclude"), iResource);
            } else if (bl2) {
                this.reportError(ProbekitPlugin.getString("Compiler.LastTargetIsInclude"), iResource);
            }
        }
        if (probe.getControlKey() != null) {
            this.reportError(ProbekitPlugin.getString("Compiler.ControlKeyNotImpl"), iResource);
        }
        if (probe.getInvocationObject() != null) {
            this.reportError(ProbekitPlugin.getString("Compiler.InvocationObjectNotImpl"), iResource);
        }
    }

    boolean isValidJavaIdentifier(String string, boolean bl) {
        if (string.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        int n = 1;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!(bl && c == '.' || Character.isJavaIdentifierPart(c))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    boolean hasWhitespace(String string) {
        if (string == null) {
            return false;
        }
        int n = 0;
        while (n < string.length()) {
            if (Character.isWhitespace(string.charAt(n))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    static String dotsToSlashes(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < string.length()) {
            if (stringBuffer.charAt(n) == '.') {
                stringBuffer.setCharAt(n, '/');
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static boolean emptyNullOrStar(String string) {
        return string == null || string.length() == 0 || string.equals("*");
    }

    private void compile() throws ProbekitException {
        if (this.compilerState == 0) {
            Iterator iterator = this.probekits.iterator();
            while (iterator.hasNext()) {
                ProbekitPair probekitPair = (ProbekitPair)iterator.next();
                IResource iResource = probekitPair.iresource;
                if (iResource != iResource.getWorkspace().getRoot()) continue;
                this.removeProbekitMarkers(iResource);
                break;
            }
            this.verify();
        }
        if (this.compilerState == 2) {
            throw new ProbekitCompileProblemException(EMPTY_STRING);
        }
        this.generateSource();
        this.generateEngineScript();
    }

    public String getGeneratedSource() throws ProbekitException {
        this.compile();
        return this.generatedSource.toString();
    }

    public String getEngineScript() throws ProbekitException {
        this.compile();
        return this.engScript.toString();
    }

    void generateEngineScript() throws ProbekitException {
        this.engScript = new StringBuffer();
        Iterator iterator = this.probeDetailsMap.entrySet().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2;
            Iterator iterator2;
            Map.Entry entry = iterator.next();
            Probe probe = (Probe)entry.getKey();
            ProbeDetails probeDetails = (ProbeDetails)entry.getValue();
            this.engScript.append("REM " + probeDetails.commentName + lineSeparator);
            this.engScript.append("PROBE" + lineSeparator);
            Iterator iterator3 = probe.getTarget().iterator();
            while (iterator3.hasNext()) {
                String string3;
                String string4;
                iterator2 = (Target)iterator3.next();
                string2 = iterator2.getPackage();
                if (Compiler.emptyNullOrStar(string2)) {
                    string2 = "*";
                }
                if (!string2.equals(".")) {
                    string2 = Compiler.dotsToSlashes(string2);
                }
                if (Compiler.emptyNullOrStar(string = iterator2.getClassName())) {
                    string = "*";
                }
                if (Compiler.emptyNullOrStar(string4 = iterator2.getMethod())) {
                    string4 = "*";
                }
                if (Compiler.emptyNullOrStar(string3 = iterator2.getSignature())) {
                    string3 = "*";
                }
                this.engScript.append("RULE " + string2 + SPACE_STRING + string + SPACE_STRING + string4 + SPACE_STRING + string3 + SPACE_STRING + iterator2.getType() + lineSeparator);
            }
            iterator2 = probe.getFragment().iterator();
            while (iterator2.hasNext()) {
                string2 = (Fragment)iterator2.next();
                string = string2.getType().getName();
                int n = Compiler.FragTypeNameToNumber(string);
                this.engScript.append("REF ");
                this.engScript.append(Compiler.fragmentDescriptors[n].engineScriptOpcode);
                this.engScript.append(SPACE_STRING);
                this.engScript.append(this.getOuterClassName() + "$" + probeDetails.uniqueClassName + SPACE_STRING);
                this.engScript.append(probeDetails.fragmentDetails[n].functionName + SPACE_STRING);
                this.engScript.append(probeDetails.fragmentDetails[n].signature + SPACE_STRING);
                this.engScript.append(probeDetails.fragmentDetails[n].argumentList + lineSeparator);
            }
            if (probeDetails.staticFieldType == null) continue;
            this.engScript.append("STATICFIELD " + probeDetails.staticFieldTypeInternal + lineSeparator);
        }
    }

    private void generateSource() throws ProbekitException {
        ProbeDetails probeDetails;
        Object object;
        Iterator iterator;
        Object object2;
        Object object3;
        this.generatedSource = new StringBuffer();
        this.engScript = new StringBuffer();
        this.probeDetailsMap = new HashMap();
        this.nextSerialNumber = 0;
        this.compilerState = 0;
        this.emitln("// generated source from ProbeKit compiler");
        this.emitln("// List of probes in this probe set:");
        Iterator iterator2 = this.probekits.iterator();
        while (iterator2.hasNext()) {
            object3 = (ProbekitPair)iterator2.next();
            object2 = ((ProbekitPair)object3).probekit;
            iterator = object2.getProbe().iterator();
            while (iterator.hasNext()) {
                object = (Probe)iterator.next();
                probeDetails = new ProbeDetails((Probe)object);
                this.probeDetailsMap.put(object, probeDetails);
                this.emitln("//   " + probeDetails.commentName);
            }
        }
        if (this.packageName != null) {
            this.emitln("package " + this.packageName + ";");
        }
        this.emitln("// \"imports\" specifications for probes (if any):");
        this.emitImports();
        this.emitln("class " + this.getOuterClassName() + " {");
        object3 = this.probekits.iterator();
        while (object3.hasNext()) {
            object2 = (ProbekitPair)object3.next();
            iterator = object2.probekit;
            object = iterator.getProbe().iterator();
            while (object.hasNext()) {
                probeDetails = (Probe)object.next();
                this.emitOneProbeInnerClass((Probe)probeDetails);
            }
        }
        this.emitln("}");
        this.compilerState = 1;
    }

    private void setDirtyState() {
        this.generatedSource = null;
        this.engScript = null;
        this.compilerState = 0;
    }

    private void emit(String string) {
        this.generatedSource.append(string);
    }

    private void emitln(String string) {
        this.generatedSource.append(string);
        this.generatedSource.append(lineSeparator);
    }

    private String getOuterClassName() {
        return this.classPrefix + this.getClassSuffix();
    }

    private static int FragTypeNameToNumber(String string) throws ProbekitException {
        int n = 0;
        while (n < fragmentDescriptors.length) {
            if (string.equals(Compiler.fragmentDescriptors[n].typeName)) {
                return n;
            }
            ++n;
        }
        throw new ProbekitException("IWAT5008 Internal Probekit error, bad fragment type name: " + string);
    }

    private void emitImports() throws ProbekitException {
        Iterator iterator = this.probekits.iterator();
        while (iterator.hasNext()) {
            ProbekitPair probekitPair = (ProbekitPair)iterator.next();
            Probekit probekit = probekitPair.probekit;
            Iterator iterator2 = probekit.getProbe().iterator();
            while (iterator2.hasNext()) {
                Probe probe = (Probe)iterator2.next();
                if (probe.getImport() == null) continue;
                Object v = this.probeDetailsMap.get(probe);
                if (v == null) {
                    throw new ProbekitException("IWAT5009E Probekit internal error: failed to find details for probe");
                }
                ProbeDetails probeDetails = (ProbeDetails)v;
                Iterator iterator3 = probe.getImport().iterator();
                while (iterator3.hasNext()) {
                    Import import_ = (Import)iterator3.next();
                    this.emitln("import " + import_.getText() + "; // from " + probeDetails.commentName);
                }
            }
        }
    }

    private String getNextProbeClassName() {
        String string = PROBE_INNER_CLASS_NAME_PREFIX + this.nextSerialNumber;
        ++this.nextSerialNumber;
        return string;
    }

    private void emitOneProbeInnerClass(Probe probe) throws ProbekitException {
        Object v = this.probeDetailsMap.get(probe);
        if (v == null) {
            throw new ProbekitException("IWAT5010E Internal error: failed to find details for probe");
        }
        ProbeDetails probeDetails = (ProbeDetails)v;
        this.emitln("  // Class for probe " + probeDetails.commentName);
        probeDetails.uniqueClassName = this.getNextProbeClassName();
        this.emitln("  public static class " + probeDetails.uniqueClassName + " {");
        String string = probe.getFragmentAtClassScope();
        if (string != null && !string.equals(EMPTY_STRING)) {
            this.emitln("    // Fragment at class scope");
            this.emitln(string);
        }
        Iterator iterator = probe.getFragment().iterator();
        while (iterator.hasNext()) {
            Fragment fragment = (Fragment)iterator.next();
            String string2 = fragment.getType().getName();
            int n = Compiler.FragTypeNameToNumber(string2);
            String string3 = "_" + string2;
            probeDetails.fragmentDetails[n] = new ProbeDetails.FragmentDetails();
            probeDetails.fragmentDetails[n].functionName = string3;
            String string4 = "void";
            String string5 = "V";
            this.emitln("    public static " + string4 + SPACE_STRING + string3 + " (");
            boolean bl = true;
            probeDetails.fragmentDetails[n].signature = "(";
            probeDetails.fragmentDetails[n].argumentList = new String();
            int n2 = 0;
            while (n2 < dataItemDescs.length) {
                Iterator iterator2 = fragment.getData().iterator();
                while (iterator2.hasNext()) {
                    String string6;
                    String string7;
                    DataItem dataItem = (DataItem)iterator2.next();
                    if (!dataItem.getType().getName().equals(Compiler.dataItemDescs[n2].typeName)) continue;
                    if (Compiler.dataItemDescs[n2].typeType.equals(EMPTY_STRING)) {
                        string7 = probeDetails.staticFieldType;
                        string6 = "L" + probeDetails.staticFieldTypeInternal + ";";
                    } else {
                        string7 = Compiler.dataItemDescs[n2].typeType;
                        string6 = Compiler.dataItemDescs[n2].typeSignature;
                    }
                    String string8 = dataItem.getName();
                    if (!bl) {
                        this.emitln(",");
                    }
                    this.emit("      " + string7 + " /*" + Compiler.dataItemDescs[n2].typeName + "*/ " + string8);
                    probeDetails.fragmentDetails[n].signature = probeDetails.fragmentDetails[n].signature + string6;
                    if (!bl) {
                        probeDetails.fragmentDetails[n].argumentList = probeDetails.fragmentDetails[n].argumentList + ",";
                    }
                    probeDetails.fragmentDetails[n].argumentList = probeDetails.fragmentDetails[n].argumentList + Compiler.dataItemDescs[n2].typeName;
                    bl = false;
                }
                ++n2;
            }
            this.emitln("      ) {");
            probeDetails.fragmentDetails[n].signature = probeDetails.fragmentDetails[n].signature + ")" + string5;
            this.emitln("      // Internal signature for this method: " + probeDetails.fragmentDetails[n].signature);
            this.emitln("//------------------ begin user-written fragment code ----------------");
            this.emitln(fragment.getCode());
            this.emitln("//------------------- end user-written fragment code -----------------");
            this.emitln("    }");
        }
        this.emitln("  }");
    }

    static /* synthetic */ FragmentDescriptor[] access$000() {
        return fragmentDescriptors;
    }

    public static class ProbeDetails {
        public String commentName = "";
        public String uniqueClassName = "";
        public String staticFieldType;
        public String staticFieldTypeInternal;
        public FragmentDetails[] fragmentDetails = new FragmentDetails[Compiler.access$000().length];

        public ProbeDetails(Probe probe) {
            this.commentName = probe.getName() == null || probe.getName().size() == 0 ? "unnamed_probe" : ((Name)probe.getName().get(0)).getText();
            StaticField staticField = probe.getStaticField();
            if (staticField != null && !staticField.equals(Compiler.EMPTY_STRING)) {
                this.staticFieldType = staticField.getType();
                this.staticFieldTypeInternal = Compiler.dotsToSlashes(staticField.getType());
            }
        }

        static class FragmentDetails {
            public String functionName;
            public String signature;
            public String argumentList;

            FragmentDetails() {
            }
        }
    }

    private static class DataItemDesc {
        public String typeName;
        public String typeType;
        public String typeSignature;

        public DataItemDesc(String string, String string2, String string3) {
            this.typeName = string;
            this.typeType = string2;
            this.typeSignature = string3;
        }
    }

    private static class FragmentDescriptor {
        public String typeName;
        public String engineScriptOpcode;
        public boolean[] allowableDataItems;

        public FragmentDescriptor(String string, String string2, boolean[] blArray) {
            this.typeName = string;
            this.engineScriptOpcode = string2;
            this.allowableDataItems = blArray;
        }
    }

    static class ProbekitPair {
        public Probekit probekit;
        public IResource iresource;

        ProbekitPair(Probekit probekit, IResource iResource) {
            this.probekit = probekit;
            this.iresource = iResource;
        }
    }
}

