/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.probekit.Compiler;
import org.eclipse.hyades.probekit.IProbeCompiler;
import org.eclipse.hyades.probekit.ProbekitPlugin;

public class CompilerFactory {
    private static final String extensionPointID = "org.eclipse.hyades.probekit.probeCompiler";
    public static CompilerFactory INSTANCE = new CompilerFactory();
    private boolean alreadyReportedErrors;

    private CompilerFactory() {
    }

    public IProbeCompiler createCompiler() {
        IPluginRegistry iPluginRegistry = Platform.getPluginRegistry();
        IExtensionPoint iExtensionPoint = iPluginRegistry.getExtensionPoint(extensionPointID);
        if (iExtensionPoint != null) {
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            int n = 0;
            while (n < iExtensionArray.length) {
                IConfigurationElement iConfigurationElement;
                IExtension iExtension = iExtensionArray[n];
                IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                boolean bl = false;
                int n2 = 0;
                while (n2 < iConfigurationElementArray.length) {
                    iConfigurationElement = iConfigurationElementArray[n2];
                    if (iConfigurationElement.getName().equals("compiler")) {
                        Object object;
                        bl = true;
                        try {
                            object = iConfigurationElement.createExecutableExtension("class");
                        }
                        catch (CoreException coreException) {
                            object = null;
                        }
                        if (object != null) {
                            if (object instanceof IProbeCompiler) {
                                this.alreadyReportedErrors = true;
                                return (IProbeCompiler)object;
                            }
                            if (!this.alreadyReportedErrors) {
                                Status status = new Status(4, "org.eclipse.hyades.probekit", 0, ProbekitPlugin.getString("CompilerFactory.ExtenderError") + this.getPrintableExtenderName(iExtension) + ProbekitPlugin.getString("CompilerFactory.DoesNotImplementIProbeCompiler"), null);
                                ProbekitPlugin.getDefault().getLog().log((IStatus)status);
                            }
                        }
                    }
                    ++n2;
                }
                if (!bl && !this.alreadyReportedErrors) {
                    iConfigurationElement = new Status(4, "org.eclipse.hyades.probekit", 0, ProbekitPlugin.getString("CompilerFactory.ExtenderError") + this.getPrintableExtenderName(iExtension) + ProbekitPlugin.getString("CompilerFactory.NoCompilerElements"), null);
                    ProbekitPlugin.getDefault().getLog().log((IStatus)iConfigurationElement);
                }
                ++n;
            }
            this.alreadyReportedErrors = true;
        }
        return this.createDefaultCompiler();
    }

    private String getPrintableExtenderName(IExtension iExtension) {
        String string = iExtension.getDeclaringPluginDescriptor().getLabel();
        String string2 = iExtension.getDeclaringPluginDescriptor().getUniqueIdentifier();
        String string3 = "\"" + string + "\" (" + string2 + ")";
        return string3;
    }

    public IProbeCompiler createDefaultCompiler() {
        return new Compiler();
    }
}

