/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.trace.loaders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCTraceObject;
import org.eclipse.hyades.uml2sd.trace.TraceSDPlugin;
import org.eclipse.hyades.uml2sd.trace.loaders.BaseTraceInteractions;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.FoundInPage;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceCallStack;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceCollapsableSyncMessage;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceCollapsableSyncMessageReturn;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceCollapsedLifelines;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceCollapsedSyncMessage;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceCollapsedSyncMessageReturn;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceInteractionUpdate;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceInteractionUtils;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceLifeline;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceLifelineDraft;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceMessageAndCallAssociation;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TracePage;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceProcess;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceSyncMessage;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceSyncMessageReturn;
import org.eclipse.hyades.uml2sd.trace.preferences.ITraceInteractionPreferenceListener;
import org.eclipse.hyades.uml2sd.trace.selection.IDateSelection;
import org.eclipse.hyades.uml2sd.trace.selection.IEObjectSelection;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDAdvancedPagingProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDFilterProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDInternalMesFilterProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDPagingProvider;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.Criteria;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.FilterCriteria;
import org.eclipse.hyades.uml2sd.ui.core.BaseMessage;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.core.ITimeRange;
import org.eclipse.hyades.uml2sd.ui.core.LifelineCategories;
import org.eclipse.hyades.uml2sd.ui.drawings.IImage;
import org.eclipse.hyades.uml2sd.ui.drawings.impl.ImageImpl;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;

public abstract class TraceInteractions
extends BaseTraceInteractions
implements ISDFilterProvider,
ISDAdvancedPagingProvider,
ISDInternalMesFilterProvider,
ITraceInteractionPreferenceListener {
    public static final int CATEGORY_CLASSES = 0;
    public static final int CATEGORY_OBJECTS = 1;
    public static final int CATEGORY_NODE = 2;
    public static final int CATEGORY_AGENT = 3;
    public static final int CATEGORY_PROCESS = 4;
    public static final int CATEGORY_THREAD = 5;
    public static final int CATEGORY_COLLAPSED = 6;
    public static final int CATEGORY_CARD = 7;
    protected static LifelineCategories[] traceCategories = new LifelineCategories[7];
    private boolean internalMessagesFiltered = false;
    private int maximumMessagesByPage = (int)TraceSDPlugin.getDefault().getPreferenceStore().getLong("page_size");
    private int nbMessages;
    private int nbMessagesInThisPage;
    private int pageNumber = 0;
    private boolean hasNextPage = false;
    private int totalNbMessages;
    private int pages;
    private ArrayList tracePages;
    private HashMap instancesMap;
    private double lastValidTime;
    private int currentMethodInvocationIndex;
    protected Timer subscribeSelectionTimer;
    private ArrayList selectedThreadList;
    private ArrayList currentFilters;
    private HashMap collapsedLifelines;
    private HashMap collapsedMessages;

    public void onSetViewer() {
        this.view.setSDFilterProvider((ISDFilterProvider)this);
        this.view.setSDPagingProvider((ISDPagingProvider)this);
        this.view.setInternalMessageFilterProvider((ISDInternalMesFilterProvider)this);
    }

    public void clearInternals() {
        super.clearInternals();
        this.pageNumber = 0;
        this.tracePages = null;
        this.collapsedLifelines = null;
        this.collapsedMessages = null;
        this.currentFilters = null;
        this.selectedThreadList = null;
    }

    protected TraceInteractionUpdate createTraceInteractionUpdate() {
        TraceInteractionUpdate ret = new TraceInteractionUpdate();
        if (this.selectedThreadList != null) {
            ret.setSelectedThreadList(this.selectedThreadList);
        }
        return ret;
    }

    protected synchronized void updateSD(TraceInteractionUpdate update) {
        Frame oldFrame = this.frame;
        if (!(this.frame == null || update.isDateSelectionChanged() || update.isPageChanged() || update.isFindRequired())) {
            double visibleDate = 0.0;
            this.currentProcesses.init();
            TraceSyncMessage firstSM = (TraceSyncMessage)this.frame.getSyncMessage(this.frame.getFirstVisibleSyncMessage());
            if (firstSM != null) {
                visibleDate = firstSM.getStartDate() + this.currentProcesses.getStartTime();
            } else {
                TraceSyncMessageReturn firstSMR = (TraceSyncMessageReturn)this.frame.getSyncMessageReturn(this.frame.getFirstVisibleSyncMessageReturn());
                if (firstSMR != null) {
                    visibleDate = firstSMR.getStartDate() + this.currentProcesses.getStartTime();
                }
            }
            if (visibleDate != 0.0) {
                update.setDateSelectionChanged(true);
                update.setDateToShow(visibleDate);
            }
            if (TraceSDPlugin.debugLoader) {
                TraceSDPlugin.debugTraceLoader("visibleDate=" + visibleDate + " " + update.isPageChanged() + " " + update.isDateSelectionChanged());
            }
        }
        this.createFrame();
        if (this.currentProcesses == null) {
            return;
        }
        if (!update.isPageChanged() && (update.isInternalMessageFilteringChanged() || update.isMaxMessagesByPageChanged() || update.isFilteringChanged() || update.isThreadSelectionChanged() || update.isHorizontalCollapsingChanged() || update.isVerticalCollapsingChanged())) {
            this.computeModel();
        }
        try {
            this.fillPage(update);
        }
        catch (FoundInPage foundInPage) {
            if (TraceSDPlugin.debugLoader) {
                foundInPage.printStackTrace(System.out);
            }
            if (update.isDateSelectionChanged() || update.isFindRequired()) {
                update.setPageChanged(true);
                this.pageNumber = foundInPage.getPage();
                this.updateSD(update);
                return;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (!update.isPageChanged()) {
            if (update.isDateSelectionChanged() && this.frame.lifeLinesCount() > 0 && update.getVisibleGraphNode() == null) {
                update.setPageChanged(true);
                this.pageNumber = this.pages - 1;
                this.createFrame();
                try {
                    this.fillPage(update);
                }
                catch (FoundInPage foundInPage) {
                    // empty catch block
                }
                update.setPreviousVisibleGraphNode(null);
                update.setVisibleGraphNode((GraphNode)this.frame.getSyncMessageReturn(this.frame.syncMessageReturnCount() - 1));
            } else if (update.isFindRequired() && (update.getFindResults() == null || update.getFindResults().size() == 0)) {
                this.frame = oldFrame;
                return;
            }
        }
        if (update.getVisibleGraphNode() != null) {
            if (update.getPreviousVisibleGraphNode() != null && update.getPreviousVisibleGraphNode() instanceof BaseMessage && update.getVisibleGraphNode() instanceof BaseMessage) {
                if (this.view != null && !this.view.getSDWidget().isDisposed() && !this.isCurrentLoadCanceled()) {
                    this.setFrameName();
                    this.view.setFrameAndEnsureVisibleSync(this.frame, update.getPreviousVisibleGraphNode());
                    this.view.getTimeCompressionBar().highlightRegionSync((BaseMessage)update.getPreviousVisibleGraphNode(), (BaseMessage)update.getVisibleGraphNode());
                    return;
                }
            } else if (this.view != null && !this.view.getSDWidget().isDisposed() && !this.isCurrentLoadCanceled()) {
                this.setFrameName();
                this.view.setFrameAndEnsureVisibleSync(this.frame, update.getVisibleGraphNode());
                return;
            }
        }
        if (this.view != null && !this.view.getSDWidget().isDisposed() && !this.isCurrentLoadCanceled()) {
            this.setFrameName();
            this.view.setFrameSync(this.frame);
            return;
        }
    }

    protected void createFrame() {
        super.createFrame();
        this.frame.setLifelineCategories(traceCategories);
        if (TraceSDPlugin.debugLoader) {
            TraceSDPlugin.debugTraceLoader("TraceInteractions.createFrame()");
        }
    }

    public void setFrameName() {
        if (this.frame == null) {
            return;
        }
        if (this.currentProcesses != null && this.currentProcesses.size() >= 1) {
            if (this.currentProcesses.size() == 1) {
                TRCProcess process = ((TraceProcess)this.currentProcesses.get(0)).getProcess();
                this.frame.setName(process.getAgent().getAgentProxy().getProcessProxy().getName() + " [Pid " + process.getPid() + "]" + this.pageMessage());
            } else {
                this.frame.setName(TraceSDPlugin.getResourceString("STR_SEVERAL_PROCESSES") + this.pageMessage());
            }
        } else {
            this.frame.setName(TraceSDPlugin.getResourceString("STR_NO_DATA_AVAILABLE"));
        }
        if (TraceSDPlugin.debugLoader) {
            TraceSDPlugin.debugTraceLoader("setFrameName() " + this.frame.getName());
        }
    }

    public String getTitleString() {
        String ret = this.getFinalTitleString();
        if (this.pages <= 1) {
            return ret;
        }
        return ret + this.pageMessage();
    }

    public abstract String getFinalTitleString();

    protected String pageMessage() {
        String m = "";
        if (this.pages <= 1) {
            return m;
        }
        m = " [" + (1 + this.pageNumber) + "/" + this.pages + " " + TraceSDPlugin.getResourceString("STR_PAGES") + "]";
        return m;
    }

    protected void computeModel() {
        if (TraceSDPlugin.debugLoader) {
            TraceSDPlugin.debugTraceLoader("computeModel() " + this.maximumMessagesByPage);
        }
        this.totalNbMessages = 0;
        this.instancesMap = new HashMap();
        this.currentProcesses.init();
        TRCFullMethodInvocation methodInvocation = this.currentProcesses.consumeMethodInvocation();
        while (methodInvocation != null && !this.isCurrentLoadCanceled()) {
            block11: {
                TRCFullMethodInvocation invokedBy;
                block12: {
                    invokedBy = (TRCFullMethodInvocation)methodInvocation.getInvokedBy();
                    if (this.isMessageCollapsed(invokedBy)) break block11;
                    EObject instanceFrom = null;
                    EObject instanceTo = null;
                    if (invokedBy == null) break block12;
                    instanceFrom = this.getLifelineEObjectFromMethodInvocation(invokedBy);
                    instanceTo = this.getLifelineEObjectFromMethodInvocation(methodInvocation);
                    if (this.internalMessagesFiltered && instanceFrom == instanceTo) break block11;
                }
                TraceLifelineDraft traceLifelineTo = this.getTraceLifelineDraftForMethodInvocation(null, methodInvocation);
                TraceLifelineDraft traceLifelineFrom = null;
                if (invokedBy != null) {
                    traceLifelineFrom = this.getTraceLifelineDraftForMethodInvocation(null, invokedBy);
                }
                if (!(traceLifelineTo.isFiltered() || traceLifelineFrom != null && traceLifelineFrom.isFiltered())) {
                    String name = methodInvocation.getMethod().getName();
                    if (this.isSyncMessageFiltered(name)) {
                        this.collapseCalledMessage(methodInvocation, this.instancesMap);
                    } else {
                        this.totalNbMessages += 2;
                    }
                }
            }
            methodInvocation = this.currentProcesses.consumeMethodInvocation();
        }
        this.pages = this.totalNbMessages / this.maximumMessagesByPage;
        if (this.totalNbMessages % this.maximumMessagesByPage > 0) {
            ++this.pages;
        }
        this.cleanCollapsedMessage(this.instancesMap);
        this.instancesMap = null;
        if (TraceSDPlugin.debugLoader) {
            TraceSDPlugin.debugTraceLoader("computeModel() interrupted(" + this.isCurrentLoadCanceled() + ") has counted " + this.pages + " pages");
        }
    }

    public void fillPage(TraceInteractionUpdate update) {
        if (!update.isThreadSelectionChanged()) {
            update.setSelectedThreadList(this.selectedThreadList);
        }
        this.tracePages = new ArrayList();
        this.instancesMap = new HashMap();
        this.traceThreadMap = new HashMap();
        this.traceThreadList = new ArrayList();
        this.lastValidTime = 0.0;
        this.nbMessages = 0;
        this.nbMessagesInThisPage = 0;
        this.hasNextPage = false;
        this.currentMethodInvocationIndex = 0;
        this.currentProcesses.init();
        TRCFullMethodInvocation methodInvocation = this.currentProcesses.consumeMethodInvocation();
        while (methodInvocation != null && !this.isCurrentLoadCanceled() && this.nbMessagesInThisPage < this.maximumMessagesByPage) {
            if (TraceSDPlugin.debugLoader) {
                TraceSDPlugin.debugTraceLoader(this.nbMessages + ":" + this.nbMessages / this.maximumMessagesByPage + " " + methodInvocation);
            }
            if (!this.isThreadFiltered(update, methodInvocation.getThread())) {
                this.finishPendingReturns(update, TraceInteractionUtils.getAbsoluteEntryTime(methodInvocation));
                TraceSyncMessage syncMessage = this.createSyncMessage(methodInvocation, update);
                TraceCallStack callStack = this.getTraceCallStack(methodInvocation.getThread());
                callStack.pushCall(syncMessage, methodInvocation);
            }
            methodInvocation = this.currentProcesses.consumeMethodInvocation();
        }
        this.finishPendingReturns(update, Double.MAX_VALUE);
        Set c = this.instancesMap.entrySet();
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Map.Entry e = (Map.Entry)i.next();
            TraceLifelineDraft draft = (TraceLifelineDraft)e.getValue();
            if (TraceSDPlugin.debugLoader) {
                TraceSDPlugin.debugTraceLoader(draft.getLifeline() + ":" + draft.getNbUser());
            }
            if (draft.getNbUser() <= 0) continue;
            draft.setEnd(this.nbMessagesInThisPage + 1);
            if (draft.getStart() == Integer.MAX_VALUE) {
                draft.setStart(0);
            }
            this.setExecutionOccurence(draft);
        }
        this.instancesMap = null;
        this.traceThreadMap = null;
        this.traceThreadList = null;
        this.cleanCollapsedMessage(this.frame);
    }

    protected void finishPendingReturns(TraceInteractionUpdate update, double uptodate) {
        while (this.getTraceThreadListFirstTime() < uptodate) {
            TraceCallStack callStack = (TraceCallStack)this.traceThreadList.get(0);
            TraceMessageAndCallAssociation tmaca = callStack.popCall();
            TraceSyncMessageReturn syncMessageReturn = this.createSyncMessageReturn(tmaca.getMethodInvocation(), update);
            if (tmaca.getMessage() == null || syncMessageReturn == null) continue;
            syncMessageReturn.setMessage(tmaca.getMessage());
        }
    }

    private TraceSyncMessage createSyncMessage(TRCFullMethodInvocation methodInvocation, TraceInteractionUpdate update) {
        TRCFullMethodInvocation invokedBy = (TRCFullMethodInvocation)methodInvocation.getInvokedBy();
        if (this.isMessageCollapsed(invokedBy)) {
            return null;
        }
        TraceLifelineDraft traceLifelineTo = this.getTraceLifelineDraftForMethodInvocation(this.frame, methodInvocation);
        TraceLifelineDraft traceLifelineFrom = null;
        if (invokedBy != null) {
            traceLifelineFrom = this.getTraceLifelineDraftForMethodInvocation(this.frame, invokedBy);
        }
        if (traceLifelineTo.isFiltered() || traceLifelineFrom != null && traceLifelineFrom.isFiltered()) {
            return null;
        }
        if (this.internalMessagesFiltered && traceLifelineFrom == traceLifelineTo) {
            return null;
        }
        if (this.isSyncMessageFiltered(methodInvocation.getMethod().getName())) {
            this.collapseCalledMessage(methodInvocation, this.frame);
            return null;
        }
        ++this.nbMessages;
        String name = this.getMessageName(methodInvocation, traceLifelineFrom == null);
        if (TraceSDPlugin.debugLoader) {
            TraceSDPlugin.debugTraceLoader("in:" + this.nbMessages + ":" + this.nbMessages / this.maximumMessagesByPage + " " + name + " " + TraceInteractionUtils.getAbsoluteEntryTime(methodInvocation));
        }
        if (this.nbMessagesInThisPage == this.maximumMessagesByPage) {
            this.hasNextPage = true;
            return null;
        }
        if (traceLifelineFrom != null && traceLifelineFrom != traceLifelineTo) {
            traceLifelineFrom.addAUser();
        }
        traceLifelineTo.addAUser();
        if ((this.nbMessages - 1) % this.maximumMessagesByPage == 0) {
            this.tracePages.add(new TracePage(TraceInteractionUtils.getAbsoluteEntryTime(methodInvocation)));
        } else if ((this.nbMessages - 1) % this.maximumMessagesByPage == this.maximumMessagesByPage - 1) {
            ((TracePage)this.tracePages.get(this.tracePages.size() - 1)).setLastTime(TraceInteractionUtils.getAbsoluteExitTime(methodInvocation));
        }
        if (update.isPageChanged() && this.nbMessages - 1 < this.pageNumber * this.maximumMessagesByPage) {
            return null;
        }
        if (!update.isPageChanged()) {
            if (update.isDateSelectionChanged()) {
                if (TraceInteractionUtils.getAbsoluteEntryTime(methodInvocation) < update.getDateToShow()) {
                    return null;
                }
                throw new FoundInPage(this.tracePages.size() - 1);
            }
            if (update.isFindRequired() && update.getFindCriteria().isSyncMessageSelected()) {
                if (update.getFindStartingPage() <= this.tracePages.size() - 1 && TraceInteractionUtils.matchCriteria(name, update.getFindCriteria())) {
                    throw new FoundInPage(this.tracePages.size() - 1);
                }
                return null;
            }
        }
        if (traceLifelineFrom != null && traceLifelineFrom != traceLifelineTo && traceLifelineFrom.getNbUser() == 1) {
            traceLifelineFrom.setStart(this.nbMessagesInThisPage + 1);
        }
        if (traceLifelineTo.getNbUser() == 1) {
            traceLifelineTo.setStart(this.nbMessagesInThisPage + 1);
        }
        TraceSyncMessage syncMessage = this.isMessageCollapsed(methodInvocation) ? new TraceCollapsedSyncMessage() : (methodInvocation.getInvokes() != null && methodInvocation.getInvokes().size() > 0 ? new TraceCollapsableSyncMessage() : new TraceSyncMessage());
        if (update.isPageChanged()) {
            if (update.isDateSelectionChanged()) {
                if (TraceInteractionUtils.getAbsoluteEntryTime(methodInvocation) < update.getDateToShow()) {
                    update.setPreviousVisibleGraphNode((GraphNode)syncMessage);
                } else if (update.getVisibleGraphNode() == null) {
                    update.setVisibleGraphNode((GraphNode)syncMessage);
                }
            }
            if (update.isFindRequired() && update.getFindCriteria().isSyncMessageSelected() && TraceInteractionUtils.matchCriteria(name, update.getFindCriteria())) {
                update.addFindResult((GraphNode)syncMessage);
            }
        }
        syncMessage.model = methodInvocation;
        if (traceLifelineFrom != null) {
            traceLifelineFrom.getLifeline().setCurrentEventOccurrence(this.nbMessagesInThisPage + 1);
            syncMessage.setStartLifeline(traceLifelineFrom.getLifeline());
        } else {
            traceLifelineTo.getLifeline().setCurrentEventOccurrence(this.nbMessagesInThisPage + 1);
        }
        syncMessage.setName(name);
        syncMessage.setEndLifeline(traceLifelineTo.getLifeline());
        syncMessage.setTime(TraceInteractionUtils.getAbsoluteEntryTime(methodInvocation));
        this.lastValidTime = TraceInteractionUtils.getAbsoluteEntryTime(methodInvocation);
        if (this.isCurrentLoadCanceled()) {
            return null;
        }
        this.frame.addMessage((BaseMessage)syncMessage);
        ++this.nbMessagesInThisPage;
        return syncMessage;
    }

    private TraceSyncMessageReturn createSyncMessageReturn(TRCFullMethodInvocation methodInvocation, TraceInteractionUpdate update) {
        TRCFullMethodInvocation invokedBy = (TRCFullMethodInvocation)methodInvocation.getInvokedBy();
        if (this.isMessageCollapsed(invokedBy)) {
            return null;
        }
        TraceLifelineDraft traceLifelineTo = this.getTraceLifelineDraftForMethodInvocation(this.frame, methodInvocation);
        TraceLifelineDraft traceLifelineFrom = null;
        if (invokedBy != null) {
            traceLifelineFrom = this.getTraceLifelineDraftForMethodInvocation(this.frame, invokedBy);
        }
        if (traceLifelineTo.isFiltered() || traceLifelineFrom != null && traceLifelineFrom.isFiltered()) {
            return null;
        }
        if (this.internalMessagesFiltered && traceLifelineFrom == traceLifelineTo) {
            return null;
        }
        if (this.isSyncMessageFiltered(methodInvocation.getMethod().getName())) {
            this.collapseCalledMessage(methodInvocation, this.frame);
            return null;
        }
        ++this.nbMessages;
        String name = this.getMessageName(methodInvocation, traceLifelineFrom == null);
        if (TraceSDPlugin.debugLoader) {
            TraceSDPlugin.debugTraceLoader("out:" + this.nbMessages + ":" + this.nbMessages / this.maximumMessagesByPage + " " + name + " " + TraceInteractionUtils.getAbsoluteExitTime(methodInvocation));
        }
        if (this.nbMessagesInThisPage == this.maximumMessagesByPage) {
            this.hasNextPage = true;
            return null;
        }
        if (traceLifelineFrom != null && traceLifelineFrom != traceLifelineTo) {
            traceLifelineFrom.removeAUser();
        }
        traceLifelineTo.removeAUser();
        if ((this.nbMessages - 1) % this.maximumMessagesByPage == 0) {
            this.tracePages.add(new TracePage(TraceInteractionUtils.getAbsoluteExitTime(methodInvocation)));
        } else if ((this.nbMessages - 1) % this.maximumMessagesByPage == this.maximumMessagesByPage - 1) {
            ((TracePage)this.tracePages.get(this.tracePages.size() - 1)).setLastTime(TraceInteractionUtils.getAbsoluteExitTime(methodInvocation));
        }
        if (update.isPageChanged() && this.nbMessages - 1 < this.pageNumber * this.maximumMessagesByPage) {
            return null;
        }
        if (!update.isPageChanged()) {
            if (update.isDateSelectionChanged()) {
                if (TraceInteractionUtils.getAbsoluteExitTime(methodInvocation) < update.getDateToShow()) {
                    return null;
                }
                throw new FoundInPage(this.tracePages.size() - 1);
            }
            if (update.isFindRequired() && update.getFindCriteria().isSyncMessageSelected()) {
                if (update.getFindStartingPage() <= this.tracePages.size() - 1 && TraceInteractionUtils.matchCriteria(name, update.getFindCriteria())) {
                    throw new FoundInPage(this.tracePages.size() - 1);
                }
                return null;
            }
        }
        if (traceLifelineFrom != null && traceLifelineFrom != traceLifelineTo && traceLifelineFrom.getNbUser() == 0) {
            traceLifelineFrom.setEnd(this.nbMessagesInThisPage + 1);
            this.setExecutionOccurence(traceLifelineFrom);
        }
        if (traceLifelineTo.getNbUser() == 0) {
            traceLifelineTo.setEnd(this.nbMessagesInThisPage + 1);
            this.setExecutionOccurence(traceLifelineTo);
        }
        TraceSyncMessageReturn syncMessageReturn = this.isMessageCollapsed(methodInvocation) ? new TraceCollapsedSyncMessageReturn() : (methodInvocation.getInvokes() != null && methodInvocation.getInvokes().size() > 0 ? new TraceCollapsableSyncMessageReturn() : new TraceSyncMessageReturn());
        if (update.isPageChanged()) {
            if (update.isDateSelectionChanged()) {
                if (TraceInteractionUtils.getAbsoluteExitTime(methodInvocation) < update.getDateToShow()) {
                    update.setPreviousVisibleGraphNode((GraphNode)syncMessageReturn);
                } else if (update.getVisibleGraphNode() == null) {
                    update.setVisibleGraphNode((GraphNode)syncMessageReturn);
                }
            }
            if (update.isDateSelectionChanged() && TraceInteractionUtils.getAbsoluteExitTime(methodInvocation) >= update.getDateToShow() && update.getVisibleGraphNode() == null) {
                update.setVisibleGraphNode((GraphNode)syncMessageReturn);
            }
            if (update.isFindRequired() && update.getFindCriteria().isSyncMessageSelected() && TraceInteractionUtils.matchCriteria(name, update.getFindCriteria())) {
                update.addFindResult((GraphNode)syncMessageReturn);
            }
        }
        syncMessageReturn.model = methodInvocation;
        if (traceLifelineFrom != null) {
            traceLifelineFrom.getLifeline().setCurrentEventOccurrence(this.nbMessagesInThisPage + 1);
            syncMessageReturn.setEndLifeline(traceLifelineFrom.getLifeline());
        } else {
            traceLifelineTo.getLifeline().setCurrentEventOccurrence(this.nbMessagesInThisPage + 1);
        }
        syncMessageReturn.setName(name);
        syncMessageReturn.setStartLifeline(traceLifelineTo.getLifeline());
        if (methodInvocation.getExitTime() > 0.0) {
            syncMessageReturn.setTime(TraceInteractionUtils.getAbsoluteExitTime(methodInvocation));
            this.lastValidTime = TraceInteractionUtils.getAbsoluteExitTime(methodInvocation);
        } else {
            syncMessageReturn.setTime(this.lastValidTime);
        }
        if (this.isCurrentLoadCanceled()) {
            return null;
        }
        this.frame.addMessage((BaseMessage)syncMessageReturn);
        ++this.nbMessagesInThisPage;
        return syncMessageReturn;
    }

    private String getMessageName(TRCFullMethodInvocation methodInvocation, boolean withThread) {
        if (withThread) {
            return methodInvocation.getMethod().getName() + " (" + methodInvocation.getThread().getName() + ")";
        }
        return methodInvocation.getMethod().getName().intern();
    }

    protected TraceLifelineDraft getTraceLifelineDraftForMethodInvocation(Frame f, TRCFullMethodInvocation mi) {
        EObject obj = this.getLifelineEObjectFromMethodInvocation(mi);
        TRCTraceObject o = mi.getOwningObject();
        TraceLifelineDraft draft = (TraceLifelineDraft)this.instancesMap.get(obj);
        if (draft == null) {
            ArrayList list;
            draft = new TraceLifelineDraft();
            String name = this.getLifeLineTitle(obj, true);
            if (this.isLifelineFiltered(name)) {
                draft.setFiltered(true);
                return draft;
            }
            ArrayList arrayList = list = this.collapsedLifelines != null ? (ArrayList)this.collapsedLifelines.get(obj) : null;
            if (list != null) {
                ArrayList l = (ArrayList)this.collapsedLifelines.get(list);
                while (l != null) {
                    list = l;
                    l = (ArrayList)this.collapsedLifelines.get(l);
                }
                name = this.getCollapsedLifelineName(list, "");
                if (name.length() > 80) {
                    name = name.substring(0, 77) + "...";
                }
                if (this.isLifelineFiltered(name)) {
                    draft.setFiltered(true);
                    return draft;
                }
                if (f == null) {
                    return draft;
                }
                TraceCollapsedLifelines traceCollapsedLifelines = new TraceCollapsedLifelines();
                draft.setLifeline(traceCollapsedLifelines);
                traceCollapsedLifelines.setCollapsedLifelines(list);
                traceCollapsedLifelines.setName(name);
                this.putInstancesMap(list, draft);
                traceCollapsedLifelines.setCategory(6);
            } else {
                if (f == null) {
                    return draft;
                }
                TraceLifeline traceLifeline = new TraceLifeline();
                draft.setLifeline(traceLifeline);
                traceLifeline.setEObject(obj);
                this.instancesMap.put(obj, draft);
                if (o.getIsA() != null) {
                    traceLifeline.setName(name);
                    traceLifeline.setCategory(this.getLifeLineCategory(obj));
                }
            }
            f.addLifeLine(draft.getLifeline());
            draft.setStart(Integer.MAX_VALUE);
            draft.setEnd(0);
        }
        return draft;
    }

    private void putInstancesMap(ArrayList list, TraceLifelineDraft draft) {
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Object oo = i.next();
            if (oo instanceof EObject) {
                this.instancesMap.put(oo, draft);
                continue;
            }
            if (!(oo instanceof ArrayList)) continue;
            this.putInstancesMap((ArrayList)oo, draft);
        }
    }

    private String getCollapsedLifelineName(ArrayList list, String indent) {
        String ret = "[";
        int j = 0;
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Object oo = i.next();
            if (oo instanceof EObject) {
                if (j > 0) {
                    ret = ret + "," + indent;
                }
                ret = ret + this.getLifeLineTitle((EObject)oo, false);
            } else if (oo instanceof ArrayList) {
                if (j > 0) {
                    ret = ret + "," + indent;
                }
                ret = ret + this.getCollapsedLifelineName((ArrayList)oo, indent + " ");
            }
            ++j;
        }
        return ret + "]";
    }

    private void externalDateSelectionChanged(IDateSelection selection, TraceInteractionUpdate update) {
        double absoluteEntryTime;
        if (this.frame == null) {
            return;
        }
        if (TraceSDPlugin.debugEvents) {
            TraceSDPlugin.debugTraceEvents("External Date selection is " + selection);
        }
        IDateSelection ids = selection;
        EObject eo = selection.getEObject();
        if (!(eo instanceof TRCProcess) || this.currentProcesses == null || !this.currentProcesses.contains((TRCProcess)eo)) {
            return;
        }
        TRCProcess process = (TRCProcess)eo;
        double dateSelection = ids.getStartDate();
        double absoluteDateSelection = dateSelection;
        if (absoluteDateSelection < (absoluteEntryTime = TraceInteractionUtils.getAbsoluteEntryTime(process.getAgent()))) {
            absoluteDateSelection += absoluteEntryTime;
        } else {
            dateSelection -= absoluteEntryTime;
        }
        if (ids.getMeaning() == 0) {
            ITimeRange[] bounds;
            if (TraceSDPlugin.debugEvents) {
                TraceSDPlugin.debugTraceEvents("dateSelection=" + dateSelection + "; absoluteDateSelection=" + absoluteDateSelection + "; getAbsoluteEntryTime(process)=" + TraceInteractionUtils.getAbsoluteEntryTime(process));
            }
            if (this.frame.findDateBounds(absoluteDateSelection, bounds = new ITimeRange[2])) {
                if (bounds[0] instanceof GraphNode) {
                    this.view.getSDWidget().ensureVisible((GraphNode)bounds[0]);
                    this.view.getTimeCompressionBar().highlightRegion((BaseMessage)bounds[0], (BaseMessage)bounds[1]);
                    if (TraceSDPlugin.debugEvents) {
                        TraceSDPlugin.debugTraceEvents("Found a graph node");
                    }
                    return;
                }
                if (TraceSDPlugin.debugEvents) {
                    TraceSDPlugin.debugTraceEvents("Found something else than a graph node: ignored");
                }
                this.frame.resetTimeCompression();
                return;
            }
            this.frame.resetTimeCompression();
            if (this.pages == 1) {
                ITimeRange sm;
                ITimeRange iTimeRange = sm = bounds[0] != null ? bounds[0] : bounds[1];
                if (sm != null && sm instanceof GraphNode) {
                    this.view.getSDWidget().ensureVisible((GraphNode)sm);
                    if (TraceSDPlugin.debugEvents) {
                        TraceSDPlugin.debugTraceEvents(bounds[0] == null ? "Before any graph node" : "After any graph node");
                    }
                    return;
                }
                if (TraceSDPlugin.debugEvents) {
                    TraceSDPlugin.debugTraceEvents("Found something else than a graph node (#2): ignored");
                }
                return;
            }
            if (this.tracePages != null && this.tracePages.size() > 0 && dateSelection <= ((TracePage)this.tracePages.get(this.tracePages.size() - 1)).getLastTime()) {
                int i = 0;
                while (i < this.tracePages.size()) {
                    TracePage tp = (TracePage)this.tracePages.get(i);
                    if (dateSelection >= tp.getFirstTime() && dateSelection <= tp.getLastTime()) {
                        update.setDateSelectionChanged(true);
                        update.setDateToShow(absoluteDateSelection);
                        update.setPageChanged(true);
                        this.pageNumber = i;
                        if (TraceSDPlugin.debugEvents) {
                            TraceSDPlugin.debugTraceEvents("Found in a previous page");
                        }
                        return;
                    }
                    ++i;
                }
            }
            update.setDateSelectionChanged(true);
            update.setDateToShow(absoluteDateSelection);
            if (TraceSDPlugin.debugEvents) {
                TraceSDPlugin.debugTraceEvents("Looking in all pages");
            }
        }
    }

    private void subscribeForDateSelectionChanged(final IDateSelection selection) {
        if (this.subscribeSelectionTimer != null) {
            this.subscribeSelectionTimer.cancel();
        }
        this.subscribeSelectionTimer = new Timer();
        this.subscribeSelectionTimer.schedule(new TimerTask(){

            public void run() {
                Display.getDefault().syncExec(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        TraceInteractionUpdate update = new TraceInteractionUpdate();
                        TraceInteractions.access$200(1.access$100(this.this$1), 1.access$000(this.this$1), update);
                        if (update.needsUpdate()) {
                            1.access$100(this.this$1).updateSDBackground(update);
                        }
                    }
                });
                TraceInteractions.this.subscribeSelectionTimer = null;
            }

            static /* synthetic */ IDateSelection access$000(1 x0) {
                return x0.selection;
            }

            static /* synthetic */ TraceInteractions access$100(1 x0) {
                return x0.TraceInteractions.this;
            }
        }, 50L);
    }

    private boolean isThreadFiltered(TraceInteractionUpdate update, TRCThread thread) {
        if (update.getSelectedThreadList() != null) {
            return !update.getSelectedThreadList().contains(thread);
        }
        return false;
    }

    protected void finishExternalExtendedSelection(TraceInteractionUpdate update) {
        if (update.isThreadSelectionChanged()) {
            this.selectedThreadList = update.getSelectedThreadList();
        }
    }

    protected boolean externalExtendedSelectionChanged(IWorkbenchPart part, Object selection, TraceInteractionUpdate update) {
        if (TraceSDPlugin.debugEvents) {
            TraceSDPlugin.debugTraceEvents("TraceInteractions: External extended selection from " + part + " is " + selection);
        }
        if (selection instanceof IDateSelection) {
            if (TraceSDPlugin.debugEvents) {
                TraceSDPlugin.debugTraceEvents("TraceInteractions: IDateSelection: " + ((IDateSelection)selection).getStartDate());
            }
            this.subscribeForDateSelectionChanged((IDateSelection)selection);
            return true;
        }
        if (selection instanceof IEObjectSelection) {
            EObject eObject = ((IEObjectSelection)selection).getEObject();
            if (TraceSDPlugin.debugEvents) {
                TraceSDPlugin.debugTraceEvents("TraceInteractions: IEObjectSelection: " + eObject);
            }
            if (eObject instanceof TRCThread) {
                update.setThreadSelectionChanged(true);
                update.addSelectedThread((TRCThread)eObject);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean isSyncMessageSupported() {
        return true;
    }

    public boolean hasNextPage() {
        return this.hasNextPage;
    }

    public boolean hasPrevPage() {
        return this.pageNumber > 0;
    }

    public void nextPage() {
        ++this.pageNumber;
        TraceInteractionUpdate update = new TraceInteractionUpdate();
        update.setPageChanged(true);
        this.updateSDBackground(update);
    }

    public void prevPage() {
        --this.pageNumber;
        TraceInteractionUpdate update = new TraceInteractionUpdate();
        update.setPageChanged(true);
        this.updateSDBackground(update);
    }

    public int maxItemsByPageCount() {
        return this.maximumMessagesByPage;
    }

    public int itemsTotalCount() {
        return this.totalNbMessages;
    }

    public String noItemsText() {
        return TraceSDPlugin.getResourceString("PAGES_COUNT_NO_ITEMS");
    }

    public String oneItemText() {
        return TraceSDPlugin.getResourceString("PAGES_COUNT_ONE_ITEM");
    }

    public String itemsText() {
        return TraceSDPlugin.getResourceString("PAGES_COUNT_SEVERAL_ITEMS");
    }

    public int currentPage() {
        return this.pageNumber;
    }

    public int pagesCount() {
        return this.pages;
    }

    public void pageSettingsChanged(int maxItemsByPage_, int pageNumber_) {
        TraceInteractionUpdate update = new TraceInteractionUpdate();
        update.setMaxMessagesByPageChanged(this.maximumMessagesByPage != maxItemsByPage_);
        this.maximumMessagesByPage = maxItemsByPage_;
        update.setPageChanged(this.pageNumber != pageNumber_);
        this.pageNumber = pageNumber_;
        if (update.isMaxMessagesByPageChanged() || update.isPageChanged()) {
            this.updateSDBackground(update);
        }
    }

    public void pageNumberChanged(int pageNumber_) {
        TraceInteractionUpdate update = new TraceInteractionUpdate();
        update.setPageChanged(this.pageNumber != pageNumber_);
        this.pageNumber = pageNumber_;
        if (update.isPageChanged()) {
            this.updateSDBackground(update);
        }
    }

    public boolean notFoundYet(Criteria toSearch) {
        if (this.pages > 1 && this.pageNumber + 1 < this.pages) {
            TraceInteractionUpdate update = new TraceInteractionUpdate();
            update.setFindRequired(true);
            update.setFindCriteria(toSearch);
            update.setFindStartingPage(this.pageNumber + 1);
            this.updateSD(update);
            ArrayList findResults_ = update.getFindResults();
            if (findResults_ != null && !findResults_.isEmpty()) {
                this.findResults = findResults_;
                this.currentFindIndex = 0;
                GraphNode current = (GraphNode)this.findResults.get(this.currentFindIndex);
                this.view.getSDWidget().moveTo(current);
                return true;
            }
        }
        return false;
    }

    public void setFiltered(boolean value) {
        if (this.internalMessagesFiltered != value) {
            this.internalMessagesFiltered = value;
            TraceInteractionUpdate update = new TraceInteractionUpdate();
            update.setInternalMessageFilteringChanged(true);
            this.updateSDBackground(update);
        }
    }

    public ArrayList getCurrentFilters() {
        return this.currentFilters;
    }

    private boolean isLifelineFiltered(String name) {
        if (this.currentFilters != null) {
            Iterator i = this.currentFilters.iterator();
            while (i.hasNext()) {
                FilterCriteria tf = (FilterCriteria)i.next();
                if (!tf.isActive() || !tf.getCriteria().isLifeLineSelected() || !TraceInteractionUtils.matchCriteria(name, tf.getCriteria())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSyncMessageFiltered(String name) {
        if (this.currentFilters != null) {
            Iterator i = this.currentFilters.iterator();
            while (i.hasNext()) {
                FilterCriteria tf = (FilterCriteria)i.next();
                if (!tf.isActive() || !tf.getCriteria().isSyncMessageSelected() || !TraceInteractionUtils.matchCriteria(name, tf.getCriteria())) continue;
                return true;
            }
        }
        return false;
    }

    public void filterSelectedGraphNodes(ArrayList graphNodes) {
        if (TraceSDPlugin.debugEvents) {
            TraceSDPlugin.debugTraceEvents("filterGraphNodes(" + (graphNodes != null ? graphNodes.size() : 0) + " selected graph nodes)");
        }
        if (this.currentFilters == null) {
            this.currentFilters = new ArrayList();
        }
        Iterator i = graphNodes.iterator();
        while (i.hasNext()) {
            EObject eo;
            GraphNode gn = (GraphNode)i.next();
            Criteria c = new Criteria();
            if (gn instanceof IEObjectSelection && (eo = ((IEObjectSelection)gn).getEObject()) instanceof TRCFullMethodInvocation) {
                c.setExpression(((TRCFullMethodInvocation)eo).getMethod().getName());
            }
            c.setCaseSenstiveSelected(true);
            if (gn instanceof TraceLifeline) {
                c.setExpression(gn.getName());
                c.setLifeLineSelected(true);
            } else if (gn instanceof TraceSyncMessage) {
                c.setExpression(((TRCFullMethodInvocation)((TraceSyncMessage)gn).getEObject()).getMethod().getName());
                c.setSyncMessageSelected(true);
            } else if (gn instanceof TraceSyncMessageReturn) {
                c.setExpression(((TRCFullMethodInvocation)((TraceSyncMessageReturn)gn).getEObject()).getMethod().getName());
                c.setSyncMessageSelected(true);
            }
            this.currentFilters.add(new FilterCriteria(c, true));
        }
        TraceInteractionUpdate update = new TraceInteractionUpdate();
        update.setFilteringChanged(true);
        this.updateSDBackground(update);
    }

    public boolean filter(ArrayList filters) {
        if (TraceSDPlugin.debugEvents) {
            TraceSDPlugin.debugTraceEvents("filter(" + (filters != null ? filters.size() : 0) + " filters)");
        }
        this.currentFilters = filters;
        TraceInteractionUpdate update = new TraceInteractionUpdate();
        update.setFilteringChanged(true);
        this.updateSDBackground(update);
        return true;
    }

    public void collapseLifelines(ArrayList graphNodes) {
        if (TraceSDPlugin.debugEvents) {
            TraceSDPlugin.debugTraceEvents("collapseLifelines(" + (graphNodes != null ? graphNodes.size() : 0) + ")");
        }
        if (this.collapsedLifelines == null) {
            this.collapsedLifelines = new HashMap();
        }
        ArrayList<ArrayList> list = new ArrayList<ArrayList>();
        Iterator i = graphNodes.iterator();
        while (i.hasNext()) {
            GraphNode gn = (GraphNode)i.next();
            ArrayList key = null;
            if (gn instanceof TraceCollapsedLifelines) {
                key = ((TraceCollapsedLifelines)gn).getCollapsedLifelines();
            } else {
                if (!(gn instanceof TraceLifeline)) continue;
                key = ((TraceLifeline)gn).getEObject();
            }
            list.add(key);
            this.collapsedLifelines.put(key, list);
        }
        TraceInteractionUpdate update = new TraceInteractionUpdate();
        update.setHorizontalCollapsingChanged(true);
        this.updateSDBackground(update);
    }

    public void expandLifelines(ArrayList graphNodes) {
        if (TraceSDPlugin.debugEvents) {
            TraceSDPlugin.debugTraceEvents("expandLifelines(" + (graphNodes != null ? graphNodes.size() : 0) + ")");
        }
        Iterator i = graphNodes.iterator();
        while (i.hasNext()) {
            GraphNode gn = (GraphNode)i.next();
            if (!(gn instanceof TraceCollapsedLifelines)) continue;
            ArrayList sublist = ((TraceCollapsedLifelines)gn).getCollapsedLifelines();
            Iterator j = sublist.iterator();
            while (j.hasNext()) {
                Object key = j.next();
                this.collapsedLifelines.put(key, null);
            }
        }
        TraceInteractionUpdate update = new TraceInteractionUpdate();
        update.setHorizontalCollapsingChanged(true);
        this.updateSDBackground(update);
    }

    private boolean isMessageCollapsed(TRCFullMethodInvocation methodInvocation) {
        if (methodInvocation == null || this.collapsedMessages == null) {
            return false;
        }
        if (this.collapsedMessages.get(methodInvocation) != null) {
            return true;
        }
        TRCFullMethodInvocation invokedBy = (TRCFullMethodInvocation)methodInvocation.getInvokedBy();
        while (invokedBy != null) {
            if (this.collapsedMessages.get(invokedBy) != null) {
                return true;
            }
            invokedBy = (TRCFullMethodInvocation)invokedBy.getInvokedBy();
        }
        return false;
    }

    public void collapseCalledMessages(ArrayList graphNodes) {
        if (TraceSDPlugin.debugEvents) {
            TraceSDPlugin.debugTraceEvents("collapseCalledMessages(" + (graphNodes != null ? graphNodes.size() : 0) + ")");
        }
        Iterator i = graphNodes.iterator();
        while (i.hasNext()) {
            Object gn = i.next();
            TRCFullMethodInvocation methodInvocation = null;
            if (gn instanceof TraceSyncMessage) {
                TraceSyncMessage sm = (TraceSyncMessage)gn;
                methodInvocation = (TRCFullMethodInvocation)sm.getEObject();
            } else if (gn instanceof TraceSyncMessageReturn) {
                TraceSyncMessageReturn smr = (TraceSyncMessageReturn)gn;
                methodInvocation = (TRCFullMethodInvocation)smr.getEObject();
            }
            this.collapseCalledMessage(methodInvocation, this.currentMofObjectFromPDProjectExplorer);
        }
        TraceInteractionUpdate update = new TraceInteractionUpdate();
        update.setVerticalCollapsingChanged(true);
        this.updateSDBackground(update);
    }

    private void collapseCalledMessage(TRCFullMethodInvocation methodInvocation, Object marker) {
        if (methodInvocation != null) {
            if (this.collapsedMessages == null) {
                this.collapsedMessages = new HashMap();
            }
            this.collapsedMessages.put(methodInvocation, marker);
        }
    }

    private void cleanCollapsedMessage(Object marker) {
        if (this.collapsedMessages == null) {
            return;
        }
        Set s = this.collapsedMessages.entrySet();
        Iterator i = s.iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            if (e.getValue() != marker) continue;
            i.remove();
        }
    }

    public void expandCalledMessages(ArrayList graphNodes) {
        if (TraceSDPlugin.debugEvents) {
            TraceSDPlugin.debugTraceEvents("expandCalledMessages(" + (graphNodes != null ? graphNodes.size() : 0) + ")");
        }
        Iterator i = graphNodes.iterator();
        while (i.hasNext()) {
            Object gn = i.next();
            TRCFullMethodInvocation methodInvocation = null;
            if (gn instanceof TraceSyncMessage) {
                TraceSyncMessage sm = (TraceSyncMessage)gn;
                methodInvocation = (TRCFullMethodInvocation)sm.getEObject();
            } else if (gn instanceof TraceSyncMessageReturn) {
                TraceSyncMessageReturn smr = (TraceSyncMessageReturn)gn;
                methodInvocation = (TRCFullMethodInvocation)smr.getEObject();
            }
            if (methodInvocation == null) continue;
            this.collapsedMessages.put(methodInvocation, null);
        }
        TraceInteractionUpdate update = new TraceInteractionUpdate();
        update.setVerticalCollapsingChanged(true);
        this.updateSDBackground(update);
    }

    public void applyPreferences() {
        int max = (int)TraceSDPlugin.getDefault().getPreferenceStore().getLong("page_size");
        if (this.maximumMessagesByPage == max) {
            return;
        }
        TraceInteractionUpdate update = new TraceInteractionUpdate();
        update.setMaxMessagesByPageChanged(true);
        this.maximumMessagesByPage = max;
        this.updateSDBackground(update);
    }

    static /* synthetic */ void access$200(TraceInteractions x0, IDateSelection x1, TraceInteractionUpdate x2) {
        x0.externalDateSelectionChanged(x1, x2);
    }

    static {
        TraceInteractions.traceCategories[0] = new LifelineCategories();
        traceCategories[0].setName(TraceSDPlugin.getResourceString("STR_CLASS"));
        traceCategories[0].setImage((IImage)new ImageImpl(TraceSDPlugin.getResourceImage("class.gif")));
        TraceInteractions.traceCategories[1] = new LifelineCategories();
        traceCategories[1].setName(TraceSDPlugin.getResourceString("STR_OBJECT"));
        traceCategories[1].setImage((IImage)new ImageImpl(TraceSDPlugin.getResourceImage("classobject_obj.gif")));
        TraceInteractions.traceCategories[2] = new LifelineCategories();
        traceCategories[2].setName(TraceSDPlugin.getResourceString("STR_NODE"));
        traceCategories[2].setImage((IImage)new ImageImpl(TraceSDPlugin.getResourceImage("node_obj.gif")));
        TraceInteractions.traceCategories[3] = new LifelineCategories();
        traceCategories[3].setName(TraceSDPlugin.getResourceString("STR_AGENT"));
        traceCategories[3].setImage((IImage)new ImageImpl(TraceSDPlugin.getResourceImage("agent_run_obj.gif")));
        TraceInteractions.traceCategories[4] = new LifelineCategories();
        traceCategories[4].setName(TraceSDPlugin.getResourceString("STR_PROCESS"));
        traceCategories[4].setImage((IImage)new ImageImpl(TraceSDPlugin.getResourceImage("process_obj.gif")));
        TraceInteractions.traceCategories[5] = new LifelineCategories();
        traceCategories[5].setName(TraceSDPlugin.getResourceString("STR_THREAD"));
        traceCategories[5].setImage((IImage)new ImageImpl(TraceSDPlugin.getResourceImage("thread_obj.gif")));
        TraceInteractions.traceCategories[6] = new LifelineCategories();
        traceCategories[6].setName(TraceSDPlugin.getResourceString("STR_COLLAPSED_LIFELINE"));
        traceCategories[6].setImage((IImage)new ImageImpl(TraceSDPlugin.getResourceImage("collapsed_obj.gif")));
    }
}

