/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.sample.svg.generator;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class DOMDataRetriever
implements Serializable {
    private final String EMPTY_STRING = "";

    DOMDataRetriever() {
    }

    Vector getAttributeFromElements(Document document, String tagName, String theAttribute) {
        NodeList list = document.getElementsByTagName(tagName);
        int length = list.getLength();
        if (length <= 0) {
            return null;
        }
        Vector<String> result = new Vector<String>();
        int i = 0;
        while (i < length) {
            Element element = (Element)list.item(i);
            String attribute = element.getAttribute(theAttribute).trim();
            if (!attribute.equals("")) {
                result.add(attribute);
            }
            ++i;
        }
        if (result.isEmpty()) {
            return null;
        }
        result.trimToSize();
        return result;
    }

    String getAttributeFromSingleElement(Document document, String tagName, String theAttribute) {
        String attribute;
        String result = null;
        NodeList list = document.getElementsByTagName(tagName);
        if (list.getLength() == 1 && !(attribute = ((Element)list.item(0)).getAttribute(theAttribute).trim()).equals("")) {
            result = attribute;
        }
        return result;
    }

    int getNumberOfElements(Document document, String tagName) {
        NodeList list = document.getElementsByTagName(tagName);
        return list.getLength();
    }

    Hashtable getAttributesFromSingleElement(Document document, String tagName) {
        Hashtable<String, String> result = null;
        NodeList list = document.getElementsByTagName(tagName);
        if (list.getLength() != 1) {
            return result;
        }
        NamedNodeMap attrs = list.item(0).getAttributes();
        int number = attrs.getLength();
        if (number > 0) {
            result = new Hashtable<String, String>(number);
            int i = 0;
            while (i < number) {
                String name = ((Attr)attrs.item(i)).getName().trim();
                String value = ((Attr)attrs.item(i)).getValue().trim();
                if (!name.equals("") && !value.equals("")) {
                    result.put(name, value);
                }
                ++i;
            }
            if (result.isEmpty()) {
                return null;
            }
        }
        return result;
    }

    Vector getAttributeValuesFromSingleElementChildren(Document document, String tagName, String childElementName, String theAttribute) {
        int length;
        Element element;
        Vector<String> result = null;
        NodeList list = document.getElementsByTagName(tagName);
        if (list.getLength() > 0 && (element = (Element)list.item(0)).getTagName().equals(tagName) && (length = (list = element.getElementsByTagName(childElementName)).getLength()) > 0) {
            result = new Vector<String>();
            int i = 0;
            while (i < length) {
                Element e = (Element)list.item(i);
                String attribute = e.getAttribute(theAttribute).trim();
                if (!attribute.equals("")) {
                    result.add(attribute);
                }
                ++i;
            }
            if (result.isEmpty()) {
                return null;
            }
            result.trimToSize();
        }
        return result;
    }

    Hashtable getMapInChildElements(Element parent, String childElementName, String keyAttribute, String valueAttribute) {
        NodeList list;
        int length;
        Hashtable<String, String> result = null;
        if (parent != null && (length = (list = parent.getElementsByTagName(childElementName)).getLength()) > 0) {
            result = new Hashtable<String, String>(length);
            int i = 0;
            while (i < length) {
                Element e = (Element)list.item(i);
                String key = e.getAttribute(keyAttribute).trim();
                String value = e.getAttribute(valueAttribute).trim();
                if (!key.equals("") && !value.equals("")) {
                    result.put(key, value);
                }
                ++i;
            }
            if (result.isEmpty()) {
                return null;
            }
        }
        return result;
    }

    Element getFirstElement(Document document, String tagName) {
        Element result = null;
        NodeList list = document.getElementsByTagName(tagName);
        if (list.getLength() > 0) {
            result = (Element)list.item(0);
        }
        return result;
    }

    NodeList getChildrenOfFirstElement(Document document, String tagName, String childElementName) {
        NodeList result = null;
        Element theElement = this.getFirstElement(document, tagName);
        if (theElement != null) {
            result = theElement.getElementsByTagName(childElementName);
        }
        return result;
    }

    Hashtable getAttributeValuesFromChildrenOfFirstElement(Document document, String tagName, String childElementName, String childAttributeKey, String childAttributeValue) {
        Element parent = this.getFirstElement(document, tagName);
        return this.getMapInChildElements(parent, childElementName, childAttributeKey, childAttributeValue);
    }

    Element getElementWithDocOrderOrdinal(Document document, String tagName, String ordinal) {
        Element result = null;
        int position = Integer.parseInt(ordinal);
        NodeList list = document.getElementsByTagName(tagName);
        int parentLength = list.getLength();
        if (parentLength > position) {
            result = (Element)list.item(position);
        }
        return result;
    }

    Hashtable getAttributeValuesFromChildrenOfElementWithDocOrderOrdinal(Document document, String tagName, String childElementName, String childAttributeKey, String childAttributeValue, String ordinal) {
        Element parent = this.getElementWithDocOrderOrdinal(document, tagName, ordinal);
        return this.getMapInChildElements(parent, childElementName, childAttributeKey, childAttributeValue);
    }

    Element getElementWithAttribute(Document document, String tagName, String elementAttribute, String elementAttributeValue) {
        Element result = null;
        NodeList list = document.getElementsByTagName(tagName);
        if (list.getLength() > 0) {
            int i = 0;
            int length = list.getLength();
            while (i < length) {
                String attr = ((Element)list.item(i)).getAttribute(elementAttribute);
                if (attr.equals(elementAttributeValue)) {
                    result = (Element)list.item(i);
                } else if (attr.equals("") && length == 1) {
                    result = (Element)list.item(i);
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    Hashtable getChildAttributesFromElementWithAttribute(Document document, String tagName, String elementAttribute, String elementAttributeValue, String childElementName, String childAttributeKey, String childAttributeValue) {
        Element parent = this.getElementWithAttribute(document, tagName, elementAttribute, elementAttributeValue);
        return this.getMapInChildElements(parent, childElementName, childAttributeKey, childAttributeValue);
    }

    String getAttributeValueFromFirstChildOfFirstElement(Document document, String tagName, String childElementName, String childAttributeName) {
        String value;
        Element childElement;
        int length;
        Element theElement;
        String result = null;
        NodeList list = document.getElementsByTagName(tagName);
        if (list.getLength() > 0 && (theElement = (Element)list.item(0)) != null && (length = (list = theElement.getElementsByTagName(childElementName)).getLength()) > 0 && (childElement = (Element)list.item(0)) != null && !(value = childElement.getAttribute(childAttributeName).trim()).equals("")) {
            result = value;
        }
        return result;
    }
}

