/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.sample.svg.generator;

import java.io.Serializable;
import java.util.Date;
import org.eclipse.hyades.ui.sample.svg.generator.DataInputProcessingException;
import org.eclipse.hyades.ui.sample.svg.generator.DataPoint;
import org.eclipse.hyades.ui.sample.svg.generator.DataRange;
import org.eclipse.hyades.ui.sample.svg.generator.DataSet;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicAttributes;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicDocumentProperties;
import org.eclipse.hyades.ui.sample.svg.generator.IDataInputProcessingExceptionCodes;
import org.eclipse.hyades.ui.sample.svg.generator.IGraphicDocumentStyle;
import org.eclipse.hyades.ui.sample.svg.generator.SVGXYChart;
import org.eclipse.hyades.ui.sample.svg.generator.SegmentMarker;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGBarChart
extends SVGXYChart
implements IGraphicDocumentStyle,
IDataInputProcessingExceptionCodes,
Serializable {
    public SVGBarChart() {
        this.graphicType = "bar";
    }

    public Document generateGraphicDocument(GraphicDocumentProperties input) throws DataInputProcessingException {
        GraphicAttributes graphicAttrs = this.createGraphicAttributes(input);
        Document newDataDocument = graphicAttrs.getDataDocument();
        String rangeMaxValue = null;
        int gridXOffset = 60;
        int gridYOffset = 50;
        DataRange xAxis = null;
        DataRange yAxis = null;
        SegmentMarker[] xMarkers = null;
        SegmentMarker[] yMarkers = null;
        try {
            xAxis = this.dataRetriever.getDataRange(newDataDocument, "S");
        }
        catch (DataInputProcessingException e) {
            e.setWidgetType(this.getGraphicType());
            throw e;
        }
        try {
            yAxis = this.dataRetriever.getDataRange(newDataDocument, "W");
        }
        catch (DataInputProcessingException e) {
            e.setWidgetType(this.getGraphicType());
            throw e;
        }
        if (xAxis == null || yAxis == null) {
            throw new DataInputProcessingException("", 126, "dataRange", this.getGraphicType());
        }
        if (xAxis.getType() != 1 || yAxis.getType() != 0) {
            throw new DataInputProcessingException("", 129, "dataRange", this.getGraphicType());
        }
        xMarkers = xAxis.getSegmentMarkers();
        yMarkers = yAxis.getSegmentMarkers();
        if (yMarkers != null && yMarkers.length > 0) {
            rangeMaxValue = yMarkers[yMarkers.length - 1].getValueString();
        }
        DataSet dataSet = this.dataRetriever.getDatasetWithPosition(newDataDocument, "0");
        int xAxisLength = (int)((double)graphicAttrs.getGraphicWidth() - (double)gridXOffset * 2.25);
        int xLabelRowCount = this.getNumberOfAxisLabels(graphicAttrs, xAxisLength, xAxis);
        int yAxisLength = (int)((double)graphicAttrs.getGraphicHeight() - (double)gridYOffset * 2.5 - (double)(xLabelRowCount * 10));
        Document generatedDocument = this.createSvgDocument(newDataDocument.getImplementation(), Short.toString(graphicAttrs.getGraphicWidth()), Short.toString(graphicAttrs.getGraphicHeight()));
        Element svgRoot = generatedDocument.getDocumentElement();
        this.addDefinitions(generatedDocument, graphicAttrs, dataSet.getDataPoints().length);
        this.registerEventHandler(generatedDocument.getDocumentElement(), "onload", "init(evt)");
        this.addJavaScriptFunctions(generatedDocument, graphicAttrs, dataSet.getDataPoints().length, gridXOffset, gridYOffset, xAxisLength, yAxisLength);
        if (!graphicAttrs.isOutlineSuppressed()) {
            this.addOutline(generatedDocument, graphicAttrs);
        }
        if (!graphicAttrs.isTimestampSuppressed()) {
            try {
                String timestamp = this.dataRetriever.getTimestamp(newDataDocument);
                Date date = GraphicAttributes.parseISO8601Date(timestamp);
                this.addTimeStamp(generatedDocument, graphicAttrs, date == null ? timestamp : graphicAttrs.formatDate(date));
            }
            catch (DataInputProcessingException e) {
                e.setWidgetType(this.graphicType);
                throw e;
            }
        }
        if (!graphicAttrs.isTitlebarSuppressed()) {
            this.addTitleBar(generatedDocument, graphicAttrs);
        } else {
            gridYOffset = super.resetGridOffsetForCenter(graphicAttrs.getGraphicHeight(), yAxisLength, 3.0);
        }
        if (!graphicAttrs.isUserPreferencesSuppressed() && graphicAttrs.getSvgFormatOnly()) {
            this.addPreferenceIcon(generatedDocument, graphicAttrs);
        }
        gridXOffset = super.resetGridOffsetForCenter(graphicAttrs.getGraphicWidth(), xAxisLength, 2.0);
        if (rangeMaxValue != null && rangeMaxValue.length() > 2) {
            gridXOffset = (int)((double)gridXOffset + (double)(rangeMaxValue.length() - 2) * 7.5);
        }
        this.evenlyDistributeSegmentMarkers(xAxis);
        this.addGrid(generatedDocument, svgRoot, xAxisLength, yAxisLength, gridXOffset, gridYOffset, xAxis, yAxis);
        this.addAxisLabels(generatedDocument, graphicAttrs, svgRoot, xAxisLength, yAxisLength, gridXOffset, gridYOffset, xAxis, yAxis);
        this.addTitles(generatedDocument, graphicAttrs, svgRoot, xAxisLength, yAxisLength, gridXOffset, gridYOffset, xAxis, yAxis, xLabelRowCount, rangeMaxValue);
        this.addDataSet(generatedDocument, graphicAttrs, svgRoot, xAxisLength, yAxisLength, gridXOffset, gridYOffset, xAxis, yAxis, dataSet);
        return generatedDocument;
    }

    private void addDefinitions(Document generatedDocument, GraphicAttributes attrs, int numberOfDatasets) {
        Element defsElement = super.addDefinitions(generatedDocument, attrs);
        this.addDefaultInternalStylesheet(generatedDocument, attrs, defsElement, numberOfDatasets);
    }

    private void addDefaultInternalStylesheet(Document generatedDocument, GraphicAttributes attrs, Element parent, int sets) {
        StringBuffer styleRules = new StringBuffer(" .st1{fill-rule:nonzero;clip-rule:nonzero;stroke:#000000;stroke-miterlimit:4;} .outline{stroke-width:0.75pt; stroke:#666666; fill:#ffffff;} .keyline{stroke-width:0.75pt; stroke:#666666;} .graphTitle {font-weight:bold; font-style:normal; font-size:11pt; fill:#000000; stroke-width:0.75pt;} .labelsValues {font-weight:normal; font-style:normal; font-size:10pt; fill:#000000;} .dataValues {font-weight:normal; font-style:normal; font-size:8pt; fill:#000000;} .timeStamp {font-weight:normal; font-style:normal; font-size:8pt; fill:#000000; text-anchor:end; opacity:0.5} .legendTitle {font-weight:normal; font-style:normal; font-size:10pt; fill:#000000; text-anchor:start; opacity:0.6} .legendData {font-weight:normal; font-style:normal; font-size:9pt; text-anchor:start; fill:#000000;} .anchorAtEnd {text-anchor: end;} .anchorAtStart {text-anchor: start;} .anchorAtMiddle {text-anchor: middle;}");
        styleRules.append(" ");
        styleRules.append(" .grid{stroke-width:0.75pt; stroke:#000000;} .gridline{stroke-width:0.75pt; stroke:#cccccc;} .griddashline{stroke-width:0.75pt; stroke:#cccccc; stroke-dasharray:2; fill:none;} .axisLines{fill:none;} .axisTicks{fill:none;} .solidLine{fill:none;stroke:#CCCCCC;stroke-width:1;} .dashLine{fill:none;stroke:#CCCCCC;stroke-width:1;stroke-dasharray:2;} .catOutline{fill:none;} .catColor{fill:#003399;stroke:none;} .exactValuesBox{fill:#FFFFCC;stroke:#999999;stroke-width:1;} .xyTitleLabels {font-weight:normal; font-style:normal; font-size:10pt; fill:#000000; opacity:0.6}");
        String[] palette = (String[])attrs.getGraphicColorPalette().get(attrs.getGraphicColorPaletteName());
        int paletteLength = palette.length;
        int i = 0;
        int j = 0;
        while (i < sets) {
            j = (i + 1) % paletteLength;
            j = j == 0 ? paletteLength - 1 : j - 1;
            styleRules.append(" .dataset" + i + "{stroke-width:0.75pt; stroke:" + palette[j] + ";}");
            styleRules.append(" .shape" + i + "{stroke:none; fill:" + palette[j] + ";}");
            ++i;
        }
        CDATASection newCDATASection = generatedDocument.createCDATASection(styleRules.toString());
        Element newElement = generatedDocument.createElement("style");
        newElement.setAttribute("id", "defaultStyleRules");
        newElement.setAttribute("type", "text/css");
        newElement.appendChild(newCDATASection);
        parent.appendChild(newElement);
    }

    private void addDataSet(Document generatedDocument, GraphicAttributes attrs, Element parent, int xAxisLength, int yAxisLength, int gridXOffset, int gridYOffset, DataRange xAxis, DataRange yAxis, DataSet dataSet) throws DataInputProcessingException {
        int numberOfSegments = xAxis.getSegmentMarkers().length;
        double barWidth = numberOfSegments > 0 ? (double)(xAxisLength / numberOfSegments / 2) : 0.0;
        Element gToggleElement = generatedDocument.createElement("g");
        String stylesheetClass = "dataValues anchorAtMiddle";
        gToggleElement.setAttribute("id", "exactValues");
        gToggleElement.setAttribute("class", stylesheetClass);
        gToggleElement.setAttribute("transform", "translate(" + gridXOffset + "," + gridYOffset + ")");
        gToggleElement.setAttribute("visibility", "hidden");
        gToggleElement.setAttribute("onclick", "toggleVisibility(\"exactValues\")");
        parent.appendChild(gToggleElement);
        Element gDataSetElement = generatedDocument.createElement("g");
        gDataSetElement.setAttribute("id", "dataset");
        gDataSetElement.setAttribute("onclick", "toggleVisibility(\"exactValues\")");
        gDataSetElement.setAttribute("transform", "translate(" + gridXOffset + "," + gridYOffset + ")");
        parent.appendChild(gDataSetElement);
        this.addBars(generatedDocument, attrs, gDataSetElement, gToggleElement, xAxisLength, yAxisLength, xAxis, yAxis, barWidth, dataSet);
    }

    private void addBars(Document generatedDocument, GraphicAttributes attrs, Element parent, Element toggleParent, int xAxisLength, int yAxisLength, DataRange xAxis, DataRange yAxis, double barWidth, DataSet dataSet) throws DataInputProcessingException {
        SegmentMarker[] xsms = xAxis.getSegmentMarkers();
        double yMax = yAxis.getMaxValue();
        double yMin = yAxis.getMinValue();
        int i = 0;
        while (i < xsms.length) {
            SegmentMarker sm = xsms[i];
            DataPoint dp = dataSet.findDataPoint(sm.getValue());
            if (dp != null && dp.getType() != 1) {
                double x = sm.getPosition() * (double)xAxisLength - barWidth / 2.0;
                double yValue = dp.getValue2();
                if (yValue < yMin) {
                    yValue = yMin;
                }
                if (yValue > yMax) {
                    yValue = yMax;
                }
                double y = (double)yAxisLength * (yMax - yValue) / (yMax - yMin);
                Element newElement = generatedDocument.createElement("rect");
                newElement.setAttribute("id", "dataColour" + i);
                newElement.setAttribute("class", "shape" + i);
                newElement.setAttribute("x", Double.toString(x));
                newElement.setAttribute("y", Double.toString(y));
                newElement.setAttribute("width", Double.toString(barWidth));
                newElement.setAttribute("height", Double.toString((double)yAxisLength - y - 0.9));
                newElement.setAttribute("stroke-width", "0.75pt");
                newElement.setAttribute("stroke", "#666666");
                parent.appendChild(newElement);
                double textX = x + barWidth / 2.0;
                double textY = y - 5.0;
                String label = dp.getLabel();
                if (label == null) {
                    label = attrs.formatNumber(dp.getValue2());
                }
                this.addExactValue(generatedDocument, attrs, toggleParent, textX, textY, label);
            }
            ++i;
        }
    }

    private void addExactValue(Document generatedDocument, GraphicAttributes attrs, Element parent, double x, double y, String value) {
        Element gElement = generatedDocument.createElement("g");
        gElement.setAttribute("id", "text1");
        this.addLabel(generatedDocument, attrs, gElement, value, "dataValues anchorAtMiddle", x, y, 0);
        parent.appendChild(gElement);
    }

    private GraphicAttributes createGraphicAttributes(GraphicDocumentProperties input) throws DataInputProcessingException {
        GraphicAttributes graphicAttrs = new GraphicAttributes();
        graphicAttrs.setPreferencesPage("prefs_bar.htm");
        graphicAttrs.setPreferencesPageWidth("430");
        graphicAttrs.setPreferencesPageHeight("435");
        graphicAttrs.setConfigDocument(input.getConfigDocument());
        graphicAttrs.setDataDocument(input.getDataDocument());
        this.getConfigAttributes(graphicAttrs);
        graphicAttrs.setAttributesFrom(input);
        return graphicAttrs;
    }
}

