/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.harness;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.execution.core.INode;
import org.eclipse.hyades.execution.core.file.IFileManager;
import org.eclipse.hyades.execution.harness.IExecutionDeploymentAdapter;
import org.eclipse.hyades.execution.local.NodeImpl;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGArtifactLocationPair;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.CFGComparableProperty;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.CFGMachineConstraint;
import org.eclipse.hyades.models.common.configuration.CFGPropertyGroup;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.configuration.util.ConfigurationUtil;
import org.eclipse.hyades.models.common.interactions.BVRProperty;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;

public class JavaExecutionDeploymentAdapter
implements IExecutionDeploymentAdapter {
    private HashMap hostFileManagerMap = new HashMap();

    public void deployTestAssets(INode node, TPFDeployment deployment, boolean isStandalone) {
        if (node == null || deployment == null) {
            return;
        }
        CFGArtifactLocationPair[] pairs = this.collectPairsByNode(deployment, node);
        if (pairs == null || pairs.length == 0) {
            return;
        }
        HashMap deployableFiles = this.collectDeployableFiles(pairs, isStandalone);
        StringBuffer bufError = new StringBuffer();
        HashMap deployed = this.deployToNode(node, deployableFiles, bufError);
    }

    public void cleanUpTestAssets(INode node, TPFDeployment deployment, boolean isStandalone) {
        if (node == null || deployment == null) {
            return;
        }
        CFGArtifactLocationPair[] pairs = this.collectPairsByNode(deployment, node);
        if (pairs == null || pairs.length == 0) {
            return;
        }
        HashMap deployableFiles = this.collectDeployableFiles(pairs, isStandalone);
        if (deployableFiles != null && deployableFiles.size() > 0) {
            String[] deleteFiles = (String[])deployableFiles.values().toArray();
            StringBuffer bufError = new StringBuffer();
            this.cleanFromNode(node, deleteFiles, bufError);
        }
    }

    protected CFGArtifactLocationPair[] collectPairsByNode(TPFDeployment deployment, INode node) {
        CFGArtifactLocationPair[] sameNodePairs = new CFGArtifactLocationPair[]{};
        String nodeName = node.getName();
        if (nodeName == null || nodeName.length() < 1) {
            return sameNodePairs;
        }
        EList pairs = deployment.getArtifactLocations();
        if (pairs == null || pairs.isEmpty()) {
            return sameNodePairs;
        }
        CFGArtifactLocationPair pair = null;
        String hostname = null;
        Iterator it = pairs.iterator();
        while (it.hasNext()) {
            CFGLocation location;
            pair = (CFGArtifactLocationPair)it.next();
            if (!this.isValidPair(pair) || (hostname = (location = pair.getLocation()) instanceof CFGMachineConstraint ? ((CFGMachineConstraint)pair.getLocation()).getHostname() : pair.getLocation().getName()) == null || hostname.length() < 1 || !nodeName.equals(hostname)) continue;
            if (sameNodePairs.length == 0) {
                sameNodePairs = new CFGArtifactLocationPair[]{pair};
                continue;
            }
            CFGArtifactLocationPair[] temp = sameNodePairs;
            sameNodePairs = new CFGArtifactLocationPair[temp.length + 1];
            System.arraycopy(temp, 0, sameNodePairs, 0, temp.length);
            sameNodePairs[temp.length] = pair;
        }
        return sameNodePairs;
    }

    protected boolean isValidPair(CFGArtifactLocationPair pair) {
        CFGLocation location = pair.getLocation();
        CFGArtifact artifact = pair.getArtifact();
        return location != null && artifact != null;
    }

    protected HashMap collectDeployableFiles(CFGArtifactLocationPair[] pairs, boolean isStandalone) {
        HashMap<String, String> deployableFiles = new HashMap<String, String>();
        CFGArtifactLocationPair pair = null;
        CFGArtifact artifact = null;
        CFGLocation location = null;
        String deployRootDir = null;
        CFGClass deployable = null;
        Object path = null;
        String srcAbsolutePath = null;
        String destAbsolutePath = null;
        int i = 0;
        while (i < pairs.length) {
            pair = pairs[i];
            location = pair.getLocation();
            artifact = pair.getArtifact();
            if (artifact != null && location != null && location instanceof CFGMachineConstraint) {
                deployRootDir = this.getDeployRootDir(location, null);
                CFGPropertyGroup propertyGroup = ConfigurationUtil.searchPropertyGroupById((List)artifact.getPropertyGroups(), (String)"org.eclipse.hyades.test.configuration.artifact.attributes");
                if (propertyGroup != null) {
                    Vector<String> targetClasspaths = new Vector<String>();
                    BVRProperty[] properties = ConfigurationUtil.searchPropertiesByName((List)propertyGroup.getProperties(), (String)"CLASSPATH", (boolean)false);
                    int j = 0;
                    while (j < properties.length) {
                        StringTokenizer tokenizer = new StringTokenizer(properties[j].getValue(), File.pathSeparator);
                        while (tokenizer.hasMoreTokens()) {
                            srcAbsolutePath = tokenizer.nextToken();
                            destAbsolutePath = this.getDeployFilePath(srcAbsolutePath, deployRootDir, isStandalone);
                            targetClasspaths.add(destAbsolutePath);
                            if (this.isSourceDestinationSame((CFGMachineConstraint)location, srcAbsolutePath, destAbsolutePath)) continue;
                            File file = new File(srcAbsolutePath);
                            if (file != null && file.isDirectory()) {
                                String[] files = this.getClasspathFiles(file);
                                int indx = 0;
                                while (indx < files.length) {
                                    srcAbsolutePath = files[indx];
                                    destAbsolutePath = this.getDeployFilePath(srcAbsolutePath, deployRootDir, isStandalone);
                                    deployableFiles.put(srcAbsolutePath, destAbsolutePath);
                                    ++indx;
                                }
                                continue;
                            }
                            deployableFiles.put(srcAbsolutePath, destAbsolutePath);
                        }
                        ++j;
                    }
                    this.setLocationClasspath(location, targetClasspaths);
                }
                EList deployables = artifact.getDeployableInstances();
                Iterator it = deployables.iterator();
                while (it.hasNext()) {
                    deployable = (CFGClass)it.next();
                    if (deployable instanceof TPFTestSuite || (srcAbsolutePath = this.getDeployableFilePath(deployable, isStandalone)) == null || this.isSourceDestinationSame((CFGMachineConstraint)location, srcAbsolutePath, destAbsolutePath = this.getDeployFilePath(srcAbsolutePath, deployRootDir, isStandalone))) continue;
                    deployableFiles.put(srcAbsolutePath, destAbsolutePath);
                }
            }
            ++i;
        }
        return deployableFiles;
    }

    protected String getDeployFilePath(String sourceFile, String deployRootDir, boolean isStandalone) {
        String sourceRootDir = this.getSourceRootDir(new File(sourceFile), isStandalone);
        deployRootDir = deployRootDir == null || deployRootDir.length() < 1 ? sourceRootDir : deployRootDir;
        String deployFile = deployRootDir + sourceFile.substring(sourceRootDir.length() - 1, sourceFile.length());
        return deployFile;
    }

    protected String getDeployableFilePath(CFGClass deployable, boolean isStandalone) {
        Resource resource = deployable.eResource();
        if (resource == null) {
            return null;
        }
        URI uri = resource.getURI();
        if (isStandalone) {
            return uri.toFileString();
        }
        String path = uri.toString();
        if (path.startsWith("platform:/resource/")) {
            path = this.getWorkspaceRoot() + path.substring("platform:/resource/".length());
        }
        return path;
    }

    protected boolean isSourceDestinationSame(CFGMachineConstraint location, String source, String destination) {
        String hostname = location.getHostname();
        try {
            if (!InetAddress.getLocalHost().equals(InetAddress.getByName(hostname)) && !InetAddress.getByName(hostname).isLoopbackAddress()) {
                return false;
            }
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        File src = new File(source);
        File des = new File(destination);
        return src.compareTo(des) == 0;
    }

    protected String[] getClasspathFiles(File clspathDirectory) {
        Vector clsFiles = new Vector();
        this.collectClassFiles(clspathDirectory, clsFiles);
        String[] files = new String[clsFiles.size()];
        int i = 0;
        while (i < clsFiles.size()) {
            files[i] = (String)clsFiles.get(i);
            ++i;
        }
        return files;
    }

    protected void collectClassFiles(File dir, Vector clsFilePaths) {
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isFile()) {
                if (files[i].getName().endsWith(".class")) {
                    clsFilePaths.add(files[i].getAbsolutePath());
                }
            } else {
                this.collectClassFiles(files[i], clsFilePaths);
            }
            ++i;
        }
    }

    protected HashMap deployToNode(INode node, HashMap deployableFiles, StringBuffer bufError) {
        HashMap<String, String> deployedFiles = new HashMap<String, String>();
        if (!(node instanceof NodeImpl)) {
            return deployedFiles;
        }
        IFileManager fileManager = ((NodeImpl)node).getFileManager();
        if (fileManager == null) {
            return deployedFiles;
        }
        Iterator i = deployableFiles.keySet().iterator();
        while (i.hasNext()) {
            String dest;
            String src = (String)i.next();
            if (!this.deployFile(fileManager, src, dest = (String)deployableFiles.get(src), bufError)) continue;
            deployedFiles.put(src, dest);
        }
        return deployedFiles;
    }

    protected boolean deployFile(IFileManager fileManager, String srcAbsolutePath, String destAbsolutePath, StringBuffer bufError) {
        try {
            fileManager.putFile(srcAbsolutePath, destAbsolutePath);
            return true;
        }
        catch (IOException e) {
            bufError.append(e.getMessage());
            return false;
        }
    }

    protected void cleanFromNode(INode node, String[] files, StringBuffer bufError) {
        if (!(node instanceof NodeImpl)) {
            return;
        }
        IFileManager fileManager = ((NodeImpl)node).getFileManager();
        if (fileManager == null) {
            return;
        }
        Vector deployedFiles = new Vector();
        int i = 0;
        while (i < files.length) {
            try {
                fileManager.deleteFile(files[i]);
            }
            catch (IOException e) {
                bufError.append(e.getMessage());
            }
            ++i;
        }
    }

    protected String getSourceRootDir(File source, boolean isStandalone) {
        String workspaceRoot;
        if (!isStandalone && (workspaceRoot = this.getWorkspaceRoot()) != null && source.getAbsolutePath().indexOf(workspaceRoot) > -1) {
            return workspaceRoot;
        }
        return URI.createFileURI((String)source.getAbsolutePath()).device() + File.separator;
    }

    protected String getWorkspaceRoot() {
        if (ResourcesPlugin.getWorkspace() != null) {
            String workspaceRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
            File rootdir = new File(workspaceRoot);
            if (!(workspaceRoot = rootdir.getAbsolutePath()).endsWith(File.separator)) {
                workspaceRoot = workspaceRoot + File.separator;
            }
            return workspaceRoot;
        }
        return "";
    }

    protected String getDeployRootDir(CFGLocation location, String defaultDir) {
        BVRProperty[] props;
        String deployRootDir = null;
        CFGPropertyGroup propGroup = ConfigurationUtil.searchPropertyGroupById((List)location.getPropertyGroups(), (String)"org.eclipse.hyades.test.configuration.location.attributes");
        if (propGroup == null) {
            propGroup = Common_ConfigurationFactory.eINSTANCE.createCFGPropertyGroup();
            propGroup.setPropertyGroupID("org.eclipse.hyades.test.configuration.location.attributes");
            location.getPropertyGroups().add((Object)propGroup);
        }
        if ((props = ConfigurationUtil.searchPropertiesByName((List)propGroup.getProperties(), (String)"ROOTDIR", (boolean)false)) == null || props.length == 0) {
            deployRootDir = defaultDir;
            CFGComparableProperty property = Common_ConfigurationFactory.eINSTANCE.createCFGComparableProperty();
            property.setName("ROOTDIR");
            property.setOperator("=");
            property.setValue(deployRootDir);
            propGroup.getProperties().add((Object)property);
        } else {
            deployRootDir = props[0].getValue();
        }
        if (deployRootDir != null) {
            // empty if block
        }
        return deployRootDir;
    }

    protected void setLocationClasspath(CFGLocation location, Vector classpaths) {
        if (classpaths == null || classpaths.size() < 1) {
            return;
        }
        String classpath = "";
        int i = 0;
        while (i < classpaths.size()) {
            if (i > 0) {
                classpath = classpath + File.pathSeparator;
            }
            classpath = classpath + (String)classpaths.get(i);
            ++i;
        }
        CFGPropertyGroup propGroup = ConfigurationUtil.searchPropertyGroupById((List)location.getPropertyGroups(), (String)"org.eclipse.hyades.test.configuration.location.attributes");
        if (propGroup == null) {
            propGroup = Common_ConfigurationFactory.eINSTANCE.createCFGPropertyGroup();
            propGroup.setPropertyGroupID("org.eclipse.hyades.test.configuration.location.attributes");
            location.getPropertyGroups().add((Object)propGroup);
        }
        BVRProperty[] existingProps = ConfigurationUtil.searchPropertiesByName((List)propGroup.getProperties(), (String)"CLASSPATH", (boolean)false);
        boolean existed = false;
        int propIndex = 0;
        while (propIndex < existingProps.length) {
            if (classpath.equals(existingProps[propIndex].getValue())) {
                existed = true;
                break;
            }
            ++propIndex;
        }
        if (!existed) {
            CFGComparableProperty property = Common_ConfigurationFactory.eINSTANCE.createCFGComparableProperty();
            property.setName("CLASSPATH");
            property.setOperator("=");
            property.setValue(classpath);
            propGroup.getProperties().add((Object)property);
        }
    }
}

