/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.ui.core.AsyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.AsyncMessageReturn;
import org.eclipse.hyades.uml2sd.ui.core.BaseMessage;
import org.eclipse.hyades.uml2sd.ui.core.BasicExecutionOccurrence;
import org.eclipse.hyades.uml2sd.ui.core.ExecutionOccurrence;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.core.ITimeRange;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;
import org.eclipse.hyades.uml2sd.ui.core.LifelineCategories;
import org.eclipse.hyades.uml2sd.ui.core.Metrics;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessageReturn;
import org.eclipse.hyades.uml2sd.ui.core.TimeEvent;
import org.eclipse.hyades.uml2sd.ui.drawings.IColor;
import org.eclipse.hyades.uml2sd.ui.drawings.IGC;
import org.eclipse.hyades.uml2sd.ui.drawings.ISDPreferences;
import org.eclipse.hyades.uml2sd.util.SortAsyncForBackward;
import org.eclipse.hyades.uml2sd.util.SortAsyncMessageComparator;
import org.eclipse.hyades.uml2sd.util.SortSyncMessageComparator;
import org.eclipse.hyades.uml2sd.util.TimeEventComparator;

public class Frame
extends GraphNode {
    protected double maxTime = -50.0;
    protected double minTime = -50.0;
    private boolean computeMinMax = true;
    protected List lifeLines = new ArrayList();
    protected List syncMessages = new ArrayList();
    protected List syncMessagesReturn = new ArrayList();
    protected List asyncMessages;
    protected List asyncMessagesReturn;
    protected List asyncMessagesRetForBackward;
    protected List asyncMessagesRetForForward;
    protected List asyncMessagesForBackward = new ArrayList();
    protected List asyncMessagesForForward = new ArrayList();
    protected int verticalIndex = 0;
    protected int horizontalIndex = 0;
    private int lifeLineDrawIndex = 0;
    private int messageDrawIndex = 0;
    private int messageReturnDrawIndex = 0;
    private int asyncMessageDrawIndex = 0;
    private int asyncMessageReturnDrawIndex = 0;
    protected LifelineCategories[] lifelineCategories = null;
    protected boolean sortSyncMessage = false;
    protected boolean sortSyncMessageReturn = false;
    protected boolean sortAsyncMessage = false;
    protected boolean sortAsyncMessageReturn = false;
    protected boolean sortBackwardAsyncList = false;
    protected boolean sortBackwardAsyncRetList = false;
    protected Lifeline highlightLifeline = null;
    protected int startEvent = 0;
    protected int nbEvent = 0;
    protected IColor highlightColor = null;
    protected boolean timeInfo = false;
    protected List executionOccurrencesWithTime;
    private int visibleAreaX;
    private int visibleAreaY;
    private int visibleAreaWidth;
    private int visibleAreaHeight;
    protected static ISDPreferences userPref = null;
    protected GraphNode focusNode = null;
    protected String unitName = null;
    protected int forceEventOccurrenceSpacing = -1;

    public Frame() {
        this.asyncMessages = this.asyncMessagesForForward;
        this.asyncMessagesRetForBackward = new ArrayList();
        this.asyncMessagesRetForForward = new ArrayList();
        this.asyncMessagesReturn = this.asyncMessagesRetForForward;
        Metrics.forcedEventSpacing = this.forceEventOccurrenceSpacing;
    }

    protected List getLifelines() {
        return this.lifeLines;
    }

    public Object[] getLifelinesArray() {
        return this.lifeLines.toArray();
    }

    public int lifeLinesCount() {
        if (this.lifeLines != null) {
            return this.lifeLines.size();
        }
        return 0;
    }

    public Lifeline getLifeline(int index) {
        if (this.lifeLines != null && index >= 0 && index < this.lifeLines.size()) {
            return (Lifeline)this.lifeLines.get(index);
        }
        return null;
    }

    protected List getSyncMessages() {
        return this.syncMessages;
    }

    public Object[] getSyncMessagesArray() {
        return this.syncMessages.toArray();
    }

    public int syncMessageCount() {
        if (this.syncMessages != null) {
            return this.syncMessages.size();
        }
        return 0;
    }

    public SyncMessage getSyncMessage(int index) {
        if (this.syncMessages != null && index >= 0 && index < this.syncMessages.size()) {
            return (SyncMessage)this.syncMessages.get(index);
        }
        return null;
    }

    public int asyncMessageCount() {
        if (this.asyncMessages != null) {
            return this.asyncMessages.size();
        }
        return 0;
    }

    public AsyncMessage getAsyncMessage(int index) {
        if (this.asyncMessages != null && index >= 0 && index < this.asyncMessages.size()) {
            return (AsyncMessage)this.asyncMessages.get(index);
        }
        return null;
    }

    public void resetIndex() {
        this.lifeLineDrawIndex = 0;
        this.messageDrawIndex = 0;
        this.messageReturnDrawIndex = 0;
    }

    public void setLifelineCategories(LifelineCategories[] categories) {
        this.lifelineCategories = categories;
    }

    public LifelineCategories[] getLifelineCategories() {
        return this.lifelineCategories;
    }

    protected List getSyncMessagesReturn() {
        return this.syncMessagesReturn;
    }

    public Object[] getSyncMessagesReturnArray() {
        return this.syncMessagesReturn.toArray();
    }

    public int syncMessageReturnCount() {
        if (this.syncMessagesReturn != null) {
            return this.syncMessagesReturn.size();
        }
        return 0;
    }

    public SyncMessageReturn getSyncMessageReturn(int index) {
        if (this.syncMessagesReturn != null && index >= 0 && index < this.syncMessagesReturn.size()) {
            return (SyncMessageReturn)this.syncMessagesReturn.get(index);
        }
        return null;
    }

    public int asyncMessageReturnCount() {
        if (this.asyncMessagesReturn != null) {
            return this.asyncMessagesReturn.size();
        }
        return 0;
    }

    public AsyncMessageReturn getAsyncMessageReturn(int index) {
        if (this.asyncMessagesReturn != null && index >= 0 && index < this.asyncMessagesReturn.size()) {
            return (AsyncMessageReturn)this.asyncMessagesReturn.get(index);
        }
        return null;
    }

    protected int getMaxEventOccurrence() {
        return this.verticalIndex;
    }

    protected void setMaxEventOccurrence(int eventOccurrence) {
        this.verticalIndex = eventOccurrence;
    }

    protected int getNewHorizontalIndex() {
        return ++this.horizontalIndex;
    }

    protected int getHorizontalIndex() {
        return this.horizontalIndex;
    }

    public void addLifeLine(Lifeline lifeLine) {
        this.computeMinMax = true;
        if (lifeLine == null) {
            return;
        }
        lifeLine.setFrame(this);
        lifeLine.setIndex(this.getNewHorizontalIndex());
        if (lifeLine.hasTimeInfo()) {
            this.timeInfo = true;
        }
        this.lifeLines.add(lifeLine);
    }

    public void addMessage(BaseMessage message) {
        this.computeMinMax = true;
        if (message == null) {
            return;
        }
        if (message instanceof SyncMessageReturn) {
            BaseMessage lastMessage;
            if (this.syncMessagesReturn.size() > 0 && (lastMessage = (BaseMessage)this.syncMessagesReturn.get(this.syncMessagesReturn.size() - 1)).getEventOccurrence() > message.getEventOccurrence()) {
                this.sortSyncMessageReturn = true;
            }
            this.syncMessagesReturn.add(message);
        } else if (message instanceof SyncMessage) {
            BaseMessage lastMessage;
            if (this.syncMessages.size() > 0 && (lastMessage = (BaseMessage)this.syncMessages.get(this.syncMessages.size() - 1)).getEventOccurrence() > message.getEventOccurrence()) {
                this.sortSyncMessage = true;
            }
            this.syncMessages.add(message);
        } else if (message instanceof AsyncMessageReturn) {
            if (this.asyncMessagesReturn.size() > 0) {
                AsyncMessage m1 = (AsyncMessage)this.asyncMessagesReturn.get(this.asyncMessagesReturn.size() - 1);
                AsyncMessage m2 = (AsyncMessage)message;
                SortAsyncMessageComparator comp = new SortAsyncMessageComparator();
                SortAsyncForBackward backComp = new SortAsyncForBackward();
                if (comp.compare(m1, m2) == 1) {
                    this.sortAsyncMessageReturn = true;
                }
                if (backComp.compare(m1, m2) == 1) {
                    this.sortBackwardAsyncRetList = true;
                }
            }
            this.asyncMessagesRetForForward.add(message);
            this.asyncMessagesRetForBackward.add(message);
            this.asyncMessagesReturn = this.asyncMessagesRetForForward;
        } else if (message instanceof AsyncMessage) {
            if (this.asyncMessages.size() > 0) {
                AsyncMessage m1 = (AsyncMessage)this.asyncMessages.get(this.asyncMessages.size() - 1);
                AsyncMessage m2 = (AsyncMessage)message;
                SortAsyncMessageComparator comp = new SortAsyncMessageComparator();
                SortAsyncForBackward backComp = new SortAsyncForBackward();
                if (comp.compare(m1, m2) == 1) {
                    this.sortAsyncMessage = true;
                }
                if (backComp.compare(m1, m2) == 1) {
                    this.sortBackwardAsyncList = true;
                }
            }
            this.asyncMessagesForForward.add(message);
            this.asyncMessagesForBackward.add(message);
            this.asyncMessages = this.asyncMessagesForForward;
        }
    }

    public void updateIndex(int x, int y, int width, int height) {
        AsyncMessage next;
        AsyncMessage toDraw;
        int i;
        AsyncMessage prev;
        int mY;
        SyncMessage next2;
        GraphNode toDraw2;
        int i2;
        this.visibleAreaX = x;
        this.visibleAreaY = y;
        this.visibleAreaWidth = width;
        this.visibleAreaHeight = height;
        SortSyncMessageComparator syncComp = new SortSyncMessageComparator();
        SortAsyncMessageComparator asyncComp = new SortAsyncMessageComparator();
        SortAsyncForBackward backComp = new SortAsyncForBackward();
        int countLi = 0;
        int countM = 0;
        int countAM = 0;
        int countMR = 0;
        int countAMR = 0;
        boolean countEO = false;
        int directionX = 1;
        if (x == 0) {
            this.lifeLineDrawIndex = 0;
        }
        if (this.lifeLines == null || this.lifeLines.size() < 1) {
            return;
        }
        if (((Lifeline)this.lifeLines.get(this.lifeLineDrawIndex)).getX() > x) {
            directionX = -1;
        }
        int i3 = this.lifeLineDrawIndex;
        while (i3 < this.lifeLines.size() && i3 >= 0) {
            ++countLi;
            this.lifeLineDrawIndex = i3;
            if (directionX == 1 ? ((Lifeline)this.lifeLines.get(i3)).getX() > x - Metrics.swimmingLaneWidth() : ((Lifeline)this.lifeLines.get(i3)).getX() < x) break;
            i3 += directionX;
        }
        int directionY = 1;
        if (y == 0) {
            this.messageDrawIndex = 0;
            this.messageReturnDrawIndex = 0;
            this.asyncMessageDrawIndex = 0;
            this.asyncMessageReturnDrawIndex = 0;
        }
        if (this.syncMessages != null && this.syncMessages.size() > 0) {
            if (((BaseMessage)this.syncMessages.get(this.messageDrawIndex)).getY() > y) {
                directionY = -1;
            }
            i2 = this.messageDrawIndex;
            while (i2 < this.syncMessages.size() && i2 >= 0) {
                ++countM;
                this.messageDrawIndex = i2;
                toDraw2 = (SyncMessage)this.syncMessages.get(i2);
                if (i2 < this.syncMessages.size() - 1 && syncComp.compare(toDraw2, next2 = (SyncMessage)this.syncMessages.get(i2 + 1)) == 1) {
                    this.sortSyncMessage = true;
                }
                if (directionY == 1 ? ((BaseMessage)this.syncMessages.get(i2)).getY() > y : ((BaseMessage)this.syncMessages.get(i2)).getY() < y) break;
                i2 += directionY;
            }
        }
        if (this.asyncMessagesReturn != null && this.asyncMessagesReturn.size() > 0) {
            mY = ((BaseMessage)this.asyncMessagesReturn.get(this.asyncMessageReturnDrawIndex)).getY();
            int mH = ((BaseMessage)this.asyncMessagesReturn.get(this.asyncMessageReturnDrawIndex)).getHeight();
            if (mY > y || mY + mH > y) {
                directionY = -1;
            }
            if (this.asyncMessageReturnDrawIndex == 0) {
                directionY = 1;
            }
            if (directionY == -1) {
                this.asyncMessageReturnDrawIndex = Arrays.binarySearch(this.asyncMessagesRetForBackward.toArray(), this.asyncMessagesReturn.get(this.asyncMessageReturnDrawIndex), new SortAsyncForBackward());
                this.asyncMessagesReturn = this.asyncMessagesRetForBackward;
            }
            prev = null;
            i = this.asyncMessageReturnDrawIndex;
            while (i < this.asyncMessagesReturn.size() && i >= 0) {
                this.asyncMessageReturnDrawIndex = i;
                ++countAMR;
                toDraw = (AsyncMessage)this.asyncMessagesReturn.get(i);
                if (prev == null) {
                    prev = toDraw;
                }
                if (directionY == 1) {
                    if (i < this.asyncMessagesReturn.size() - 1 && asyncComp.compare(toDraw, next = (AsyncMessage)this.asyncMessagesReturn.get(i + 1)) == 1) {
                        this.sortAsyncMessageReturn = true;
                    }
                    if (toDraw.getY() >= y || toDraw.getY() + toDraw.getHeight() >= y) {
                        break;
                    }
                } else {
                    if (i < this.asyncMessagesReturn.size() - 1 && backComp.compare(toDraw, next = (AsyncMessage)this.asyncMessagesReturn.get(i + 1)) == 1) {
                        this.sortBackwardAsyncRetList = true;
                    }
                    if (toDraw.getY() <= y && toDraw.getY() + toDraw.getHeight() <= y) {
                        if (asyncComp.compare(toDraw, prev) <= 0) {
                            break;
                        }
                    } else if (asyncComp.compare(toDraw, prev) <= 0) {
                        prev = toDraw;
                    }
                }
                i += directionY;
            }
            this.asyncMessagesReturn = this.asyncMessagesRetForForward;
            if (directionY == -1 && this.asyncMessageReturnDrawIndex > 0) {
                this.asyncMessageReturnDrawIndex = Arrays.binarySearch(this.asyncMessagesReturn.toArray(), this.asyncMessagesRetForBackward.get(this.asyncMessageReturnDrawIndex), new SortAsyncMessageComparator());
            }
        }
        if (this.asyncMessages != null && this.asyncMessages.size() > 0) {
            mY = ((BaseMessage)this.asyncMessages.get(this.asyncMessageDrawIndex)).getY();
            int mH = ((BaseMessage)this.asyncMessages.get(this.asyncMessageDrawIndex)).getHeight();
            if (mY > y || mY + mH > y) {
                directionY = -1;
            }
            if (this.asyncMessageDrawIndex == 0) {
                directionY = 1;
            }
            if (directionY == -1) {
                this.asyncMessages = this.asyncMessagesForForward;
                this.asyncMessageDrawIndex = Arrays.binarySearch(this.asyncMessagesForBackward.toArray(), this.asyncMessagesForForward.get(this.asyncMessageDrawIndex), new SortAsyncForBackward());
                this.asyncMessages = this.asyncMessagesForBackward;
            }
            prev = null;
            i = this.asyncMessageDrawIndex;
            while (i < this.asyncMessages.size() && i >= 0) {
                if (SDViewerPlugin.debugIndex()) {
                    System.out.print("Direction = " + directionY + "\n");
                }
                ++countAM;
                this.asyncMessageDrawIndex = i;
                toDraw = (AsyncMessage)this.asyncMessages.get(i);
                if (prev == null) {
                    prev = toDraw;
                }
                if (directionY == 1) {
                    next = null;
                    if (i < this.asyncMessages.size() - 1 && asyncComp.compare(toDraw, next = (AsyncMessage)this.asyncMessages.get(i + 1)) == 1) {
                        this.sortAsyncMessage = true;
                    }
                    if (toDraw.getY() >= y || toDraw.getY() + toDraw.getHeight() >= y) {
                        break;
                    }
                } else {
                    if (i < this.asyncMessages.size() - 1 && backComp.compare(toDraw, next = (AsyncMessage)this.asyncMessages.get(i + 1)) == 1) {
                        this.sortBackwardAsyncList = true;
                    }
                    if (toDraw.getY() <= y && toDraw.getY() + toDraw.getHeight() <= y) {
                        if (asyncComp.compare(toDraw, prev) <= 0) {
                            break;
                        }
                    } else if (asyncComp.compare(toDraw, prev) <= 0) {
                        prev = toDraw;
                    }
                }
                i += directionY;
            }
            this.asyncMessages = this.asyncMessagesForForward;
            if (directionY == -1 && this.asyncMessageDrawIndex > 0) {
                this.asyncMessageDrawIndex = Arrays.binarySearch(this.asyncMessages.toArray(), this.asyncMessagesForBackward.get(this.asyncMessageDrawIndex), new SortAsyncMessageComparator());
            }
        }
        if (this.syncMessagesReturn != null && this.syncMessagesReturn.size() > 0) {
            if (((BaseMessage)this.syncMessagesReturn.get(this.messageReturnDrawIndex)).getY() > y) {
                directionY = -1;
            }
            i2 = this.messageReturnDrawIndex;
            while (i2 < this.syncMessagesReturn.size() && i2 >= 0) {
                ++countMR;
                this.messageReturnDrawIndex = i2;
                toDraw2 = (SyncMessage)this.syncMessagesReturn.get(i2);
                if (i2 < this.syncMessagesReturn.size() - 1 && syncComp.compare(toDraw2, next2 = (SyncMessage)this.syncMessagesReturn.get(i2 + 1)) == 1) {
                    this.sortSyncMessageReturn = true;
                }
                if (directionY == 1 ? ((BaseMessage)this.syncMessagesReturn.get(i2)).getY() > y : ((BaseMessage)this.syncMessagesReturn.get(i2)).getY() < y) break;
                i2 += directionY;
            }
        }
        i2 = this.lifeLineDrawIndex;
        while (i2 < this.lifeLines.size()) {
            toDraw2 = (Lifeline)this.lifeLines.get(i2);
            toDraw2.updateIndex(x, y);
            if (toDraw2.getX() > x + width) break;
            ++i2;
        }
        if (SDViewerPlugin.debugIndex()) {
            System.out.print("*****************************\n");
            System.out.print("Visible area position in virtual screen (x,y)= " + x + " " + y + "\n\n");
            System.out.print("First drawn lifeline index = " + this.lifeLineDrawIndex + "\n");
            System.out.print("First drawn sync message index = " + this.messageDrawIndex + "\n");
            System.out.print("First drawn sync message return index = " + this.messageReturnDrawIndex + "\n");
            System.out.print("First drawn async message index = " + this.asyncMessageDrawIndex + "\n");
            System.out.print("First drawn async return message index = " + this.asyncMessageReturnDrawIndex + "\n\n");
            System.out.print("Lifeline index found in = " + countLi + " iterations\n");
            System.out.print("Sync Message index found in = " + countM + " iterations\n");
            System.out.print("Sync Message Return index found in " + countMR + " iterations\n");
            System.out.print("Async Message found in " + countAM + " iterations\n");
            System.out.print("Async Message Return found in " + countAMR + " iterations\n");
            System.out.print("*****************************\n");
        }
    }

    public int getFirstVisibleLifeline() {
        return this.lifeLineDrawIndex;
    }

    public int getFirstVisibleSyncMessage() {
        return this.messageDrawIndex;
    }

    public int getFirstVisibleSyncMessageReturn() {
        return this.messageReturnDrawIndex;
    }

    public int getFirstVisibleAsyncMessage() {
        return this.asyncMessageDrawIndex;
    }

    public int getFirstVisibleAsyncMessageReturn() {
        return this.asyncMessageReturnDrawIndex;
    }

    public int getX() {
        return 10;
    }

    public int getY() {
        return 10;
    }

    public int getWidth() {
        if (this.horizontalIndex == 0) {
            return Metrics.swimmingLaneWidth() + 46 - 10 - 22;
        }
        return this.horizontalIndex * Metrics.swimmingLaneWidth() + 46 - 45;
    }

    public int getHeight() {
        if (this.forceEventOccurrenceSpacing >= 0) {
            Metrics.forcedEventSpacing = this.forceEventOccurrenceSpacing;
        }
        return this.verticalIndex * (Metrics.getMessagesSpacing() + Metrics.getMessageFontHeigth()) + 14 + 4 + Metrics.getLifelineFontHeigth() + 30 + 20 + 14 + 4 + Metrics.getLifelineFontHeigth() * 2;
    }

    protected GraphNode getNodeFromListAt(int x, int y, List list, int fromIndex) {
        if (list == null) {
            return null;
        }
        int i = fromIndex;
        while (i < list.size()) {
            GraphNode node = (GraphNode)list.get(i);
            if (node instanceof Lifeline && node.getX() > this.visibleAreaX + this.visibleAreaWidth || (node.getHeight() >= 0 ? node.getY() > this.visibleAreaY + this.visibleAreaHeight : node.getY() + node.getHeight() > this.visibleAreaY + this.visibleAreaHeight)) break;
            if (node.contains(x, y)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    protected GraphNode getCloserLeavingMessage(Lifeline lifeline, BaseMessage message, List list, boolean smallerEvent) {
        if (list == null) {
            return null;
        }
        if (!smallerEvent) {
            int event = 0;
            if (message != null) {
                event = message.getEventOccurrence();
            }
            int i = 0;
            while (i < list.size()) {
                GraphNode node = (GraphNode)list.get(i);
                if (node instanceof SyncMessage ? ((SyncMessage)node).getEventOccurrence() >= event && ((SyncMessage)node).getStartLifeline() == lifeline && node != message : node instanceof AsyncMessage && ((AsyncMessage)node).getStartOccurrence() >= event && ((AsyncMessage)node).getStartLifeline() == lifeline && node != message) {
                    return node;
                }
                ++i;
            }
        } else {
            int event = this.getMaxEventOccurrence();
            if (message != null) {
                event = message.getEventOccurrence();
            }
            int i = list.size() - 1;
            while (i >= 0) {
                GraphNode node = (GraphNode)list.get(i);
                if (node instanceof SyncMessage ? ((SyncMessage)node).getEventOccurrence() < event && ((SyncMessage)node).getStartLifeline() == lifeline && node != message : node instanceof AsyncMessage && ((AsyncMessage)node).getStartOccurrence() < event && ((AsyncMessage)node).getStartLifeline() == lifeline && node != message) {
                    return node;
                }
                --i;
            }
        }
        return null;
    }

    protected GraphNode getCloserEnteringMessage(Lifeline lifeline, BaseMessage message, List list, boolean smallerEvent) {
        if (list == null) {
            return null;
        }
        if (!smallerEvent) {
            int event = 0;
            if (message != null) {
                event = message.getEventOccurrence();
            }
            int i = 0;
            while (i < list.size()) {
                GraphNode node = (GraphNode)list.get(i);
                if (node instanceof SyncMessage ? ((SyncMessage)node).getEventOccurrence() < event && ((SyncMessage)node).getEndLifeline() == lifeline && node != message : node instanceof AsyncMessage && ((AsyncMessage)node).getStartOccurrence() < event && ((AsyncMessage)node).getEndLifeline() == lifeline && node != message) {
                    return node;
                }
                ++i;
            }
        } else {
            int event = this.getMaxEventOccurrence();
            if (message != null) {
                event = message.getEventOccurrence();
            }
            int i = list.size() - 1;
            while (i >= 0) {
                GraphNode node = (GraphNode)list.get(i);
                if (node instanceof SyncMessage ? ((SyncMessage)node).getEventOccurrence() < event && ((SyncMessage)node).getEndLifeline() == lifeline && node != message : node instanceof AsyncMessage && ((AsyncMessage)node).getStartOccurrence() < event && ((AsyncMessage)node).getEndLifeline() == lifeline && node != message) {
                    return node;
                }
                --i;
            }
        }
        return null;
    }

    private int distanceFromEvent(GraphNode node, int event) {
        int distance = 0;
        if (node instanceof SyncMessage) {
            distance = ((SyncMessage)node).getEventOccurrence() - event;
        } else if (node instanceof AsyncMessage) {
            int end;
            int start = ((AsyncMessage)node).getStartOccurrence();
            distance = start - event < (end = ((AsyncMessage)node).getEndOccurrence()) - event ? start - event : start - event;
        }
        return Math.abs(distance);
    }

    private GraphNode getCloserToEvent(GraphNode node1, GraphNode node2, int event) {
        if (node1 != null && node2 != null) {
            if (this.distanceFromEvent(node1, event) < this.distanceFromEvent(node2, event)) {
                return node1;
            }
            return node2;
        }
        if (node1 != null) {
            return node1;
        }
        if (node2 != null) {
            return node2;
        }
        return null;
    }

    public GraphNode getCalledMessage(BaseMessage StartMessage) {
        int event = 0;
        GraphNode result = null;
        Lifeline lifeline = null;
        if (StartMessage != null) {
            event = StartMessage.getEventOccurrence();
            lifeline = StartMessage.getEndLifeline();
            if (lifeline == null) {
                lifeline = StartMessage.getStartLifeline();
            }
        }
        if (lifeline == null) {
            return null;
        }
        GraphNode message = this.getCloserLeavingMessage(lifeline, StartMessage, this.syncMessages, false);
        GraphNode messageReturn = this.getCloserLeavingMessage(lifeline, StartMessage, this.syncMessagesReturn, false);
        result = this.getCloserToEvent(message, messageReturn, event);
        message = this.getCloserLeavingMessage(lifeline, StartMessage, this.asyncMessages, false);
        result = this.getCloserToEvent(result, message, event);
        messageReturn = this.getCloserLeavingMessage(lifeline, StartMessage, this.asyncMessagesReturn, false);
        result = this.getCloserToEvent(result, messageReturn, event);
        return result;
    }

    public GraphNode getCallerMessage(BaseMessage StartMessage) {
        int event = this.getMaxEventOccurrence();
        GraphNode result = null;
        Lifeline lifeline = null;
        if (StartMessage != null) {
            event = StartMessage.getEventOccurrence();
            lifeline = StartMessage.getStartLifeline();
            if (lifeline == null) {
                lifeline = StartMessage.getEndLifeline();
            }
        }
        if (lifeline == null) {
            return null;
        }
        GraphNode message = this.getCloserEnteringMessage(lifeline, StartMessage, this.syncMessages, true);
        GraphNode messageReturn = this.getCloserEnteringMessage(lifeline, StartMessage, this.syncMessagesReturn, true);
        result = this.getCloserToEvent(message, messageReturn, event);
        message = this.getCloserEnteringMessage(lifeline, StartMessage, this.asyncMessages, true);
        result = this.getCloserToEvent(result, message, event);
        messageReturn = this.getCloserEnteringMessage(lifeline, StartMessage, this.asyncMessagesReturn, true);
        result = this.getCloserToEvent(result, messageReturn, event);
        return result;
    }

    public GraphNode getNextLifelineMessage(Lifeline lifeline, BaseMessage StartMessage) {
        int event = 0;
        if (StartMessage != null) {
            event = StartMessage.getEventOccurrence();
        }
        if (lifeline == null) {
            return null;
        }
        GraphNode message = this.getCloserLeavingMessage(lifeline, StartMessage, this.syncMessages, false);
        GraphNode messageReturn = this.getCloserLeavingMessage(lifeline, StartMessage, this.syncMessagesReturn, false);
        GraphNode result = this.getCloserToEvent(message, messageReturn, event);
        message = this.getCloserLeavingMessage(lifeline, StartMessage, this.asyncMessages, false);
        result = this.getCloserToEvent(result, message, event);
        messageReturn = this.getCloserLeavingMessage(lifeline, StartMessage, this.asyncMessagesReturn, false);
        result = this.getCloserToEvent(result, messageReturn, event);
        return result;
    }

    public GraphNode getPrevLifelineMessage(Lifeline lifeline, BaseMessage StartMessage) {
        int event = this.getMaxEventOccurrence();
        if (StartMessage != null) {
            event = StartMessage.getEventOccurrence();
        }
        if (lifeline == null) {
            return null;
        }
        GraphNode message = this.getCloserLeavingMessage(lifeline, StartMessage, this.syncMessages, true);
        GraphNode messageReturn = this.getCloserLeavingMessage(lifeline, StartMessage, this.syncMessagesReturn, true);
        GraphNode result = this.getCloserToEvent(message, messageReturn, event);
        message = this.getCloserLeavingMessage(lifeline, StartMessage, this.asyncMessages, true);
        result = this.getCloserToEvent(result, message, event);
        messageReturn = this.getCloserLeavingMessage(lifeline, StartMessage, this.asyncMessagesReturn, true);
        result = this.getCloserToEvent(result, messageReturn, event);
        return result;
    }

    public GraphNode getNodeAt(int x, int y) {
        GraphNode node = this.getNodeFromListAt(x, y, this.lifeLines, this.lifeLineDrawIndex);
        if (node != null) {
            GraphNode exec = this.getNodeFromListAt(x, y, ((Lifeline)node).executionOccurrences, 0);
            if (exec != null) {
                return exec;
            }
            return node;
        }
        node = this.getNodeFromListAt(x, y, this.syncMessages, this.messageDrawIndex);
        if (node != null) {
            return node;
        }
        node = this.getNodeFromListAt(x, y, this.syncMessagesReturn, this.messageReturnDrawIndex);
        if (node != null) {
            return node;
        }
        node = this.getNodeFromListAt(x, y, this.asyncMessages, 0);
        if (node != null) {
            return node;
        }
        node = this.getNodeFromListAt(x, y, this.asyncMessagesReturn, 0);
        if (node != null) {
            return node;
        }
        return null;
    }

    public void draw(IGC context) {
        int toDrawHeight;
        BaseMessage toDraw;
        int i;
        Object[] temp;
        this.visibleAreaHeight = context.getVisibleHeight();
        this.visibleAreaWidth = context.getVisibleWidth();
        this.visibleAreaX = context.getContentsX();
        this.visibleAreaY = context.getContentsY();
        if (this.forceEventOccurrenceSpacing >= 0) {
            Metrics.forcedEventSpacing = this.forceEventOccurrenceSpacing;
        }
        if (userPref == null) {
            return;
        }
        if (this.sortSyncMessage) {
            temp = this.syncMessages.toArray();
            Arrays.sort(temp, new SortSyncMessageComparator());
            this.sortSyncMessage = false;
            this.syncMessages = Arrays.asList(temp);
            if (SDViewerPlugin.debugSorting()) {
                System.out.print("Syn messages array sorted\n");
            }
        }
        if (this.sortSyncMessageReturn) {
            temp = this.syncMessagesReturn.toArray();
            Arrays.sort(temp, new SortSyncMessageComparator());
            this.sortSyncMessageReturn = false;
            this.syncMessagesReturn = Arrays.asList(temp);
            if (SDViewerPlugin.debugSorting()) {
                System.out.print("Syn messages return array sorted\n");
            }
        }
        if (this.sortAsyncMessage) {
            temp = this.asyncMessagesForForward.toArray();
            Arrays.sort(temp, new SortAsyncMessageComparator());
            this.sortAsyncMessage = false;
            this.asyncMessagesForForward = Arrays.asList(temp);
            this.asyncMessages = this.asyncMessagesForForward;
            if (SDViewerPlugin.debugSorting()) {
                System.out.print("Asyn messages array sorted\n");
            }
        }
        if (this.sortBackwardAsyncList) {
            temp = this.asyncMessagesForBackward.toArray();
            Arrays.sort(temp, new SortAsyncForBackward());
            this.sortBackwardAsyncList = false;
            this.asyncMessagesForBackward = Arrays.asList(temp);
            if (SDViewerPlugin.debugSorting()) {
                System.out.print("Backward asyn messages array sorted\n");
            }
        }
        if (this.sortAsyncMessageReturn) {
            temp = this.asyncMessagesRetForForward.toArray();
            Arrays.sort(temp, new SortAsyncMessageComparator());
            this.sortAsyncMessageReturn = false;
            this.asyncMessagesRetForForward = Arrays.asList(temp);
            this.asyncMessagesReturn = this.asyncMessagesRetForForward;
            if (SDViewerPlugin.debugSorting()) {
                System.out.print("Asyn messages return array sorted\n");
            }
        }
        if (this.sortBackwardAsyncRetList) {
            temp = this.asyncMessagesRetForBackward.toArray();
            Arrays.sort(temp, new SortAsyncForBackward());
            this.sortBackwardAsyncRetList = false;
            this.asyncMessagesRetForBackward = Arrays.asList(temp);
            if (SDViewerPlugin.debugSorting()) {
                System.out.print("Backward asyn messages return array sorted\n");
            }
        }
        context.setBackground(Frame.getUserPref().getBackGroundColor("PREF_FRAME"));
        context.setForeground(Frame.getUserPref().getForeGroundColor("PREF_FRAME"));
        int x = this.getX();
        int y = this.getY();
        int w = this.getWidth();
        int h = this.getHeight();
        context.fillRectangle(x, y, w, h);
        context.drawRectangle(x, y, w, h);
        context.setBackground(Frame.getUserPref().getBackGroundColor("PREF_FRAME_NAME"));
        context.setForeground(Frame.getUserPref().getForeGroundColor("PREF_FRAME_NAME"));
        context.setFont(Frame.getUserPref().getFont("PREF_FRAME_NAME"));
        int nameWidth = context.textExtent(this.getName()) + 16;
        int nameHeight = Metrics.getLifelineFontHeigth() + 8;
        if (nameWidth > w) {
            nameWidth = w;
        }
        int[] points = new int[]{x, y, x + nameWidth, y, x + nameWidth, y - 11 + nameHeight, x - 11 + nameWidth, y + nameHeight, x, y + nameHeight, x, y + nameHeight};
        context.fillPolygon(points);
        context.drawPolygon(points);
        context.drawLine(x, y, x, y + nameHeight);
        context.setForeground(Frame.getUserPref().getFontColor("PREF_FRAME_NAME"));
        context.drawTextTruncatedCentred(this.getName(), x, y, nameWidth - 11, nameHeight, false);
        context.setBackground(Frame.getUserPref().getBackGroundColor("PREF_FRAME"));
        context.setForeground(Frame.getUserPref().getForeGroundColor("PREF_FRAME"));
        int lifeLineCount = 0;
        int lifelineArryStep = 1;
        int messageArrayStep = 1;
        if ((float)Metrics.swimmingLaneWidth() * context.getZoom() < 10.0f) {
            lifelineArryStep = Math.round(10.0f / ((float)Metrics.swimmingLaneWidth() * context.getZoom()));
        }
        if ((float)(Metrics.getMessageFontHeigth() + 20) * context.getZoom() < 1.0f) {
            messageArrayStep = Math.round(1.0f / ((float)(Metrics.getMessageFontHeigth() + 20) * context.getZoom()));
        }
        if (this.lifeLines == null || this.lifeLines.size() < 1) {
            return;
        }
        if (this.highlightLifeline != null) {
            IColor backupColor = context.getBackground();
            context.setBackground(Frame.getUserPref().getTimeCompressionSelectionColor());
            int gy = this.highlightLifeline.getY() + this.highlightLifeline.getHeight() + (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * this.startEvent;
            context.fillRectangle(11, gy, this.highlightLifeline.getX() + Metrics.getLifelineWidth() / 2 - 10, (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * this.nbEvent);
            context.setBackground(backupColor);
        }
        context.setFont(Frame.getUserPref().getFont("PREF_LIFELINE"));
        int i2 = this.lifeLineDrawIndex;
        while (i2 < this.lifeLines.size()) {
            Lifeline toDraw2 = (Lifeline)this.lifeLines.get(i2);
            if (toDraw2.getX() > context.getContentsX() + context.getVisibleWidth()) break;
            toDraw2.draw(context);
            if (this.highlightLifeline != null) {
                if (toDraw2 == this.highlightLifeline) {
                    toDraw2.highlightExecOccurrenceRegion(context, this.startEvent, this.nbEvent, this.highlightColor);
                } else if (toDraw2.getIndex() < this.highlightLifeline.getIndex() || toDraw2.getIndex() < this.highlightLifeline.getIndex()) {
                    int acIndex;
                    int index = acIndex = toDraw2.getExecOccurrenceDrawIndex();
                    while (h < toDraw2.getExecutions().size()) {
                        BasicExecutionOccurrence exec = (BasicExecutionOccurrence)toDraw2.getExecutions().get(index);
                        int tempEvent = this.startEvent;
                        int j = 0;
                        while (j < this.nbEvent) {
                            if (tempEvent >= exec.startOccurrence && tempEvent <= exec.endOccurrence && tempEvent + 1 >= exec.startOccurrence && tempEvent + 1 <= exec.endOccurrence) {
                                toDraw2.highlightExecOccurrenceRegion(context, tempEvent, 1, Frame.getUserPref().getTimeCompressionSelectionColor());
                            }
                            ++tempEvent;
                            ++j;
                        }
                        if (exec.getY() > this.getY()) break;
                        ++index;
                    }
                }
            }
            ++lifeLineCount;
            i2 += lifelineArryStep;
        }
        if (SDViewerPlugin.debugDisplay()) {
            System.out.print("\n");
            System.out.print(lifeLineCount + " Lifeline drawn, starting from index " + this.lifeLineDrawIndex + "\n");
        }
        int messageCount = 0;
        if (this.syncMessages != null && this.syncMessages.size() > 0) {
            SortSyncMessageComparator comparator = new SortSyncMessageComparator();
            context.setFont(Frame.getUserPref().getFont("PREF_SYNC_MESS"));
            i = this.messageDrawIndex;
            while (i < this.syncMessages.size()) {
                SyncMessage next;
                toDraw = (SyncMessage)this.syncMessages.get(i);
                if (i < this.syncMessages.size() - 1 && comparator.compare(toDraw, next = (SyncMessage)this.syncMessages.get(i + 1)) == 1) {
                    this.sortSyncMessage = true;
                }
                if (toDraw.getY() > context.getContentsY() + context.getVisibleHeight() + 10 + Metrics.getMessageFontHeigth()) break;
                if (((SyncMessage)toDraw).endLifeline == null && ((SyncMessage)toDraw).startLifeline != null) {
                    if (context.getContentsX() + context.getVisibleWidth() > toDraw.getX() + toDraw.getWidth() && context.getContentsX() < toDraw.getX() + toDraw.getWidth()) {
                        toDraw.draw(context);
                        ++messageCount;
                    }
                } else if (((SyncMessage)toDraw).endLifeline != null && ((SyncMessage)toDraw).startLifeline == null && context.getContentsX() + context.getVisibleWidth() > toDraw.getX() + toDraw.getWidth() && context.getContentsX() < toDraw.getX() + toDraw.getWidth()) {
                    toDraw.draw(context);
                    ++messageCount;
                }
                if (this.lifelineDependantDrawing(context, toDraw)) {
                    ++messageCount;
                }
                i += messageArrayStep;
            }
        }
        if (SDViewerPlugin.debugDisplay()) {
            System.out.print(messageCount + " Message drawn, starting from index " + this.messageDrawIndex + "\n");
        }
        messageCount = 0;
        if (this.syncMessagesReturn != null && this.syncMessagesReturn.size() > 0) {
            SortSyncMessageComparator comparator = new SortSyncMessageComparator();
            context.setFont(Frame.getUserPref().getFont("PREF_SYNC_MESS_RET"));
            i = this.messageReturnDrawIndex;
            while (i < this.syncMessagesReturn.size()) {
                SyncMessage next;
                toDraw = (SyncMessage)this.syncMessagesReturn.get(i);
                if (i < this.syncMessagesReturn.size() - 1 && comparator.compare(toDraw, next = (SyncMessage)this.syncMessagesReturn.get(i + 1)) == 1) {
                    this.sortSyncMessageReturn = true;
                }
                if (toDraw.getY() > context.getContentsY() + context.getVisibleHeight() + 10 + Metrics.getMessageFontHeigth()) break;
                if (this.lifelineDependantDrawing(context, toDraw)) {
                    ++messageCount;
                }
                i += messageArrayStep;
            }
        }
        if (SDViewerPlugin.debugDisplay()) {
            System.out.print(messageCount + " Message return drawn, starting from index " + this.messageReturnDrawIndex + "\n");
        }
        messageCount = 0;
        if (this.asyncMessages != null && this.asyncMessages.size() > 0) {
            SortAsyncMessageComparator comparator = new SortAsyncMessageComparator();
            context.setFont(Frame.getUserPref().getFont("PREF_ASYNC_MESS"));
            i = this.asyncMessageDrawIndex;
            while (i < this.asyncMessages.size()) {
                AsyncMessage next;
                toDraw = (AsyncMessage)this.asyncMessages.get(i);
                if (i < this.asyncMessages.size() - 1 && comparator.compare(toDraw, next = (AsyncMessage)this.asyncMessages.get(i + 1)) == 1) {
                    this.sortAsyncMessage = true;
                }
                int toDrawY = ((AsyncMessage)toDraw).getY();
                toDrawHeight = ((AsyncMessage)toDraw).getHeight();
                if (toDrawY > context.getContentsY() + context.getVisibleHeight() + 10 + Metrics.getMessageFontHeigth() && toDrawY + toDrawHeight > context.getContentsY() + context.getVisibleHeight() + 10 + Metrics.getMessageFontHeigth()) break;
                if (this.lifelineDependantDrawing(context, toDraw)) {
                    ++messageCount;
                }
                i += messageArrayStep;
            }
        }
        if (SDViewerPlugin.debugDisplay()) {
            System.out.print(messageCount + " Async message drawn, starting from index " + this.asyncMessageDrawIndex + "\n");
        }
        messageCount = 0;
        if (this.asyncMessagesReturn != null && this.asyncMessagesReturn.size() > 0) {
            SortAsyncMessageComparator comparator = new SortAsyncMessageComparator();
            context.setFont(Frame.getUserPref().getFont("PREF_ASYNC_MESS_RET"));
            i = this.asyncMessageReturnDrawIndex;
            while (i < this.asyncMessagesReturn.size()) {
                AsyncMessage next;
                toDraw = (AsyncMessage)this.asyncMessagesReturn.get(i);
                if (i < this.asyncMessagesReturn.size() - 1 && comparator.compare(toDraw, next = (AsyncMessage)this.asyncMessagesReturn.get(i + 1)) == 1) {
                    this.sortAsyncMessageReturn = true;
                }
                int toDrawY = ((AsyncMessage)toDraw).getY();
                toDrawHeight = ((AsyncMessage)toDraw).getHeight();
                if (toDrawY > context.getContentsY() + context.getVisibleHeight() + 10 + Metrics.getMessageFontHeigth() && toDrawY + toDrawHeight > context.getContentsY() + context.getVisibleHeight() + 10 + Metrics.getMessageFontHeigth()) break;
                if (this.lifelineDependantDrawing(context, toDraw)) {
                    ++messageCount;
                }
                i += messageArrayStep;
            }
        }
        if (SDViewerPlugin.debugDisplay()) {
            System.out.print(messageCount + " Async message return drawn, starting from index " + this.asyncMessageReturnDrawIndex + "\n\n");
        }
        int i3 = this.lifeLineDrawIndex;
        while (i3 < this.lifeLines.size()) {
            Lifeline toDraw3 = (Lifeline)this.lifeLines.get(i3);
            if (toDraw3.getX() - 22 > context.getContentsX() + context.getVisibleWidth()) break;
            toDraw3.drawName(context);
            i3 += lifelineArryStep;
        }
    }

    public void setFocusNode(GraphNode node) {
        this.focusNode = node;
    }

    public GraphNode getFocusNode() {
        return this.focusNode;
    }

    private boolean lifelineDependantDrawing(IGC context, BaseMessage toDraw) {
        if (toDraw.endLifeline != null && toDraw.endLifeline.isVisible(context.getContentsX(), 0, context.getVisibleWidth(), 0) || toDraw.startLifeline != null && toDraw.startLifeline.isVisible(context.getContentsX(), 0, context.getVisibleWidth(), 0)) {
            toDraw.draw(context);
            return true;
        }
        if (toDraw.endLifeline != null && !toDraw.endLifeline.isVisible(context.getContentsX(), 0, context.getVisibleWidth(), 0) && toDraw.startLifeline != null && !toDraw.startLifeline.isVisible(context.getContentsX(), 0, context.getVisibleWidth(), 0)) {
            if (toDraw.endLifeline.getX() > context.getContentsX() + context.getVisibleWidth() && toDraw.startLifeline.getX() < context.getContentsX()) {
                toDraw.draw(context);
                return true;
            }
            if (toDraw.startLifeline.getX() > context.getContentsX() + context.getVisibleWidth() && toDraw.endLifeline.getX() < context.getContentsX()) {
                toDraw.draw(context);
                return true;
            }
        }
        return false;
    }

    public void highlightTimeCompression(Lifeline lifeline, int startEvent, int nbEvent, IColor color) {
        this.highlightLifeline = lifeline;
        this.startEvent = startEvent;
        this.nbEvent = nbEvent;
        this.highlightColor = color;
    }

    public void resetTimeCompression() {
        this.highlightLifeline = null;
        this.startEvent = 0;
        this.nbEvent = 0;
        this.highlightColor = null;
    }

    public double getMinTime() {
        if (this.computeMinMax) {
            this.computeMinMax();
            this.computeMinMax = false;
        }
        return this.minTime;
    }

    public double getMaxTime() {
        if (this.computeMinMax) {
            this.computeMinMax();
            this.computeMinMax = false;
        }
        return this.maxTime;
    }

    private List buildTimeArray() {
        Object[] temp;
        List<Object> timeArray = new ArrayList<TimeEvent>();
        int i = 0;
        while (i < this.syncMessages.size()) {
            if (((ITimeRange)this.syncMessages.get(i)).hasTimeInfo()) {
                int event = ((BaseMessage)this.syncMessages.get(i)).getEventOccurrence();
                double time = ((ITimeRange)this.syncMessages.get(i)).getFirstTime();
                TimeEvent f = new TimeEvent(time, event, (ITimeRange)this.syncMessages.get(i));
                timeArray.add(f);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.syncMessagesReturn.size()) {
            if (((ITimeRange)this.syncMessagesReturn.get(i2)).hasTimeInfo()) {
                int event = ((BaseMessage)this.syncMessagesReturn.get(i2)).getEventOccurrence();
                double time = ((ITimeRange)this.syncMessagesReturn.get(i2)).getFirstTime();
                TimeEvent f = new TimeEvent(time, event, (ITimeRange)this.syncMessagesReturn.get(i2));
                timeArray.add(f);
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.asyncMessages.size()) {
            if (((ITimeRange)this.asyncMessages.get(i3)).hasTimeInfo()) {
                int event = ((AsyncMessage)this.asyncMessages.get(i3)).getStartOccurrence();
                double time = ((ITimeRange)this.asyncMessages.get(i3)).getFirstTime();
                TimeEvent f = new TimeEvent(time, event, (ITimeRange)this.asyncMessages.get(i3));
                timeArray.add(f);
                event = ((AsyncMessage)this.asyncMessages.get(i3)).getEndOccurrence();
                time = ((ITimeRange)this.asyncMessages.get(i3)).getLastTime();
                f = new TimeEvent(time, event, (ITimeRange)this.asyncMessages.get(i3));
                timeArray.add(f);
            }
            ++i3;
        }
        int i4 = 0;
        while (i4 < this.asyncMessagesReturn.size()) {
            if (((ITimeRange)this.asyncMessagesReturn.get(i4)).hasTimeInfo()) {
                int event = ((AsyncMessage)this.asyncMessagesReturn.get(i4)).getStartOccurrence();
                double time = ((ITimeRange)this.asyncMessagesReturn.get(i4)).getFirstTime();
                TimeEvent f = new TimeEvent(time, event, (ITimeRange)this.asyncMessagesReturn.get(i4));
                timeArray.add(f);
                event = ((AsyncMessage)this.asyncMessagesReturn.get(i4)).getEndOccurrence();
                time = ((ITimeRange)this.asyncMessagesReturn.get(i4)).getLastTime();
                f = new TimeEvent(time, event, (ITimeRange)this.asyncMessagesReturn.get(i4));
                timeArray.add(f);
            }
            ++i4;
        }
        this.executionOccurrencesWithTime = null;
        int i5 = 0;
        while (i5 < this.lifeLines.size()) {
            Lifeline l = this.getLifeline(i5);
            if (l.hasTimeInfo()) {
                Iterator j = l.executionOccurrences.iterator();
                while (j.hasNext()) {
                    ExecutionOccurrence eo;
                    Object o = j.next();
                    if (!(o instanceof ExecutionOccurrence) || !(eo = (ExecutionOccurrence)o).hasTimeInfo()) continue;
                    int event = eo.getStartOccurrence();
                    double time = eo.getFirstTime();
                    TimeEvent f = new TimeEvent(time, event, eo);
                    timeArray.add(f);
                    if (this.executionOccurrencesWithTime == null) {
                        this.executionOccurrencesWithTime = new ArrayList();
                    }
                    this.executionOccurrencesWithTime.add(f);
                    event = eo.getEndOccurrence();
                    time = eo.getLastTime();
                    f = new TimeEvent(time, event, eo);
                    timeArray.add(f);
                    this.executionOccurrencesWithTime.add(f);
                }
            }
            ++i5;
        }
        if (this.executionOccurrencesWithTime != null) {
            temp = this.executionOccurrencesWithTime.toArray();
            Arrays.sort(temp, new TimeEventComparator());
            this.executionOccurrencesWithTime = Arrays.asList(temp);
        }
        temp = timeArray.toArray();
        Arrays.sort(temp, new TimeEventComparator());
        timeArray = Arrays.asList(temp);
        return timeArray;
    }

    private void computeMinMax() {
        List timeArray = this.buildTimeArray();
        int i = 0;
        while (i < timeArray.size() - 1) {
            TimeEvent m1 = (TimeEvent)timeArray.get(i);
            TimeEvent m2 = (TimeEvent)timeArray.get(i + 1);
            if (this.computeMinMax) {
                this.minTime = m2.getTime() - m1.getTime();
                this.computeMinMax = false;
            }
            if (m2.getTime() - m1.getTime() < this.minTime) {
                this.minTime = m2.getTime() - m1.getTime();
            }
            if (m2.getTime() - m1.getTime() > this.maxTime) {
                this.maxTime = m2.getTime() - m1.getTime();
            }
            ++i;
        }
    }

    public boolean findDateBounds(double dateToFind, ITimeRange[] bounds) {
        if (this.hasTimeInfo()) {
            List timeArray = this.buildTimeArray();
            bounds[0] = null;
            bounds[1] = null;
            int i = 0;
            while (i < timeArray.size()) {
                TimeEvent m = (TimeEvent)timeArray.get(i);
                if (m.getTime() > dateToFind) {
                    bounds[1] = m.getGraphNode();
                    if (i > 0) {
                        bounds[0] = ((TimeEvent)timeArray.get(i - 1)).getGraphNode();
                        return true;
                    }
                    return false;
                }
                ++i;
            }
            bounds[0] = ((TimeEvent)timeArray.get(timeArray.size() - 1)).getGraphNode();
        }
        return false;
    }

    public List getExecutionOccurrencesWithTime() {
        return this.executionOccurrencesWithTime;
    }

    protected void setHasTimeInfo(boolean value) {
        this.timeInfo = value;
    }

    public boolean hasTimeInfo() {
        return this.timeInfo;
    }

    public static boolean contains(int x, int y, int width, int height, int px, int py) {
        int locX = x;
        int locY = y;
        int locWidth = width;
        int locHeight = height;
        if (width < 0) {
            locX += width;
            locWidth = -locWidth;
        }
        if (height < 0) {
            locY += height;
            locHeight = -locHeight;
        }
        return px >= locX && py >= locY && px - locX < locWidth && py - locY < locHeight;
    }

    public static void setUserPref(ISDPreferences pref) {
        userPref = pref;
    }

    public static ISDPreferences getUserPref() {
        return userPref;
    }

    public void setTimeUnitName(String name) {
        this.unitName = name;
    }

    public String getTimeUnitName() {
        return this.unitName;
    }

    public void forceEventOccurrenceSpacing(int space) {
        this.forceEventOccurrenceSpacing = space;
    }

    protected int getVisibleAreaX() {
        return this.visibleAreaX;
    }

    protected int getVisibleAreaY() {
        return this.visibleAreaY;
    }
}

