/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logc.internal.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.logc.LogCorrelatorPlugin;
import org.eclipse.hyades.logc.extensions.ILogRecordCorrelationEngine;
import org.eclipse.hyades.logc.extensions.ILogRecordFilter;
import org.eclipse.hyades.logc.internal.extensions.ProgressMonitorAdapter;
import org.eclipse.hyades.logs.correlators.RecordList;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.CorrelationEngine;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;

public class CorrelationHelper {
    private static CorrelationHelper instance;
    private List agentsList = new ArrayList();

    protected CorrelationHelper() {
    }

    public static CorrelationHelper getInstance() {
        if (instance == null) {
            instance = new CorrelationHelper();
        }
        return instance;
    }

    public IExtension[] getCorrelationExtensions() {
        IPluginRegistry registry = Platform.getPluginRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.hyades.logc.logInteractionView");
        IExtension[] extensions = null;
        if (point != null) {
            extensions = point.getExtensions();
        }
        return extensions;
    }

    public IConfigurationElement getCorrelationByName(String name) {
        IExtension[] extensions = this.getCorrelationExtensions();
        if (extensions != null) {
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement elem = elements[j];
                    if ("view".equals(elements[j].getName()) && elements[j].getAttribute("name").equals(name)) {
                        return elem;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    public CorrelationContainerProxy createCorrelationContainer(IConfigurationElement correlation, Object inputObject, String name) {
        this.agentsList.clear();
        if (correlation == null) {
            return null;
        }
        this.loadLogAgents(inputObject);
        BasicEList recordListToCorrelate = new BasicEList();
        String correlationType = null;
        CorrelationContainerProxy correlationContainerProxy = null;
        ILogRecordCorrelationEngine recordCorrelator = null;
        IConfigurationElement[] filters_correlators = this.addNodes(correlation, recordListToCorrelate);
        int k = 0;
        while (k < filters_correlators.length) {
            if (filters_correlators[k].getName().equals("LogRecordCorrelationEngine")) {
                try {
                    recordCorrelator = (ILogRecordCorrelationEngine)filters_correlators[k].createExecutableExtension("class");
                    correlationType = correlation.getAttribute("name");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            ++k;
        }
        if (recordCorrelator != null && this.agentsList.size() > 0) {
            correlationContainerProxy = LoadersUtils.getCorrelationContainerProxy((TRCAgentProxy)((TRCAgentProxy)this.agentsList.get(0)), correlationType, (String)name);
            correlationContainerProxy.setName(name);
            CorrelationEngine correlationEngine = HierarchyFactory.eINSTANCE.createCorrelationEngine();
            correlationEngine.setId(correlationType);
            correlationEngine.setType(correlation.getAttribute("log_types"));
            correlationEngine.setName(correlation.getAttribute("name"));
            correlationContainerProxy.setCorrelationEngine(correlationEngine);
            int i = 1;
            while (i < this.agentsList.size()) {
                if (this.agentsList.get(i) != null) {
                    correlationContainerProxy.getCorrelatedAgents().add(this.agentsList.get(i));
                }
                ++i;
            }
            CorrelationJob correlationJob = new CorrelationJob(LogCorrelatorPlugin.getResourceString("STR_JOB_LBL"), recordCorrelator, correlationContainerProxy, (EList)recordListToCorrelate);
            correlationJob.schedule();
        }
        return correlationContainerProxy;
    }

    private IConfigurationElement[] addNodes(IConfigurationElement correlation, BasicEList recordListToCorrelate) {
        IConfigurationElement[] filters_correlators = correlation.getChildren();
        ILogRecordFilter logFilter = null;
        boolean notAdded = true;
        int i = 0;
        while (i < this.agentsList.size()) {
            if (this.agentsList.get(i) != null) {
                int k = 0;
                while (k < filters_correlators.length) {
                    if (filters_correlators[k].getName().equals("LogRecordFilter") && ((TRCAgentProxy)this.agentsList.get(i)).getName().equals(filters_correlators[k].getAttribute("log_type"))) {
                        try {
                            logFilter = (ILogRecordFilter)filters_correlators[k].createExecutableExtension("class");
                            recordListToCorrelate.add((Object)this.loadLog((TRCAgentProxy)this.agentsList.get(i), logFilter));
                            notAdded = false;
                        }
                        catch (Exception e) {
                            recordListToCorrelate.add((Object)this.loadLog((TRCAgentProxy)this.agentsList.get(i), null));
                            notAdded = false;
                        }
                    } else if (((TRCAgentProxy)this.agentsList.get(i)).getName().equals(filters_correlators[k].getAttribute("log_type"))) {
                        recordListToCorrelate.add((Object)this.loadLog((TRCAgentProxy)this.agentsList.get(i), null));
                        notAdded = false;
                    }
                    ++k;
                }
                if (notAdded) {
                    recordListToCorrelate.add((Object)this.loadLog((TRCAgentProxy)this.agentsList.get(i), null));
                }
            }
            notAdded = true;
            ++i;
        }
        return filters_correlators;
    }

    private RecordList loadLog(TRCAgentProxy agent, ILogRecordFilter logFilter) {
        RecordList recList = null;
        recList = logFilter != null ? new RecordList(this.cbeEventFilter(logFilter.filter(agent.getAgent().getDefaultEvents())), agent.getName()) : new RecordList(this.cbeEventFilter(agent.getAgent().getDefaultEvents()), agent.getName());
        return recList;
    }

    private EList cbeEventFilter(EList list) {
        BasicEList filteredList = new BasicEList();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Object event = it.next();
            if (!(event instanceof CBECommonBaseEvent)) continue;
            filteredList.add(event);
        }
        return filteredList;
    }

    private void loadLogAgents(Object object) {
        if (object instanceof List) {
            Object element = null;
            Iterator iter = ((List)object).iterator();
            while (iter.hasNext()) {
                element = iter.next();
                if (!(element instanceof TRCAgentProxy) || !((TRCAgentProxy)element).getType().equals("Logging")) continue;
                this.agentsList.add(element);
            }
        } else if (object instanceof CorrelationContainerProxy) {
            Iterator iter = ((CorrelationContainerProxy)object).getCorrelatedAgents().iterator();
            while (iter.hasNext()) {
                TRCAgentProxy trcAgentProxy = (TRCAgentProxy)iter.next();
                if (trcAgentProxy == null || trcAgentProxy.eIsProxy()) continue;
                this.agentsList.add(trcAgentProxy);
            }
            IConfigurationElement correlation = this.getCorrelation(((CorrelationContainerProxy)object).getCorrelationEngine());
            if (correlation != null) {
                this.addNodes(correlation, new BasicEList());
            } else if (this.isInternalCorrelation((CorrelationContainerProxy)object)) {
                this.addAllNodes();
            }
        } else if (object instanceof TRCMonitor) {
            this.loadAllAgents((TRCMonitor)object);
        } else if (object instanceof TRCNode) {
            this.loadAllAgents((TRCNode)object);
        } else if (object instanceof TRCProcessProxy) {
            this.loadAllAgents((TRCProcessProxy)object);
        } else if (object instanceof TRCAgentProxy && ((TRCAgentProxy)object).getType().equals("Logging")) {
            this.agentsList.add((TRCAgentProxy)object);
        }
    }

    private boolean isInternalCorrelation(CorrelationContainerProxy correlationContainerProxy) {
        Iterator iter = correlationContainerProxy.getCorrelatedAgents().iterator();
        while (iter.hasNext()) {
            TRCAgentProxy agentProxy = (TRCAgentProxy)iter.next();
            if (!agentProxy.getInternalCorrelations().contains((Object)correlationContainerProxy)) continue;
            return true;
        }
        return false;
    }

    private void addAllNodes() {
        int i = 0;
        while (i < this.agentsList.size()) {
            if (this.agentsList.get(i) != null) {
                this.loadLog((TRCAgentProxy)this.agentsList.get(i), null);
            }
            ++i;
        }
    }

    public IConfigurationElement getCorrelation(CorrelationEngine engine) {
        String name = engine.getName();
        IPluginRegistry registry = Platform.getPluginRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.hyades.logc.logInteractionView");
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement elem = elements[j];
                    if ("view".equals(elements[j].getName()) && elements[j].getAttribute("name").equals(name)) {
                        return elem;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    private void loadAllAgents(TRCMonitor monitor) {
        if (monitor != null) {
            Iterator nodes = monitor.getNodes().iterator();
            while (nodes.hasNext()) {
                TRCNode node = (TRCNode)nodes.next();
                if (node == null) continue;
                this.loadAllAgents(node);
            }
        }
    }

    private void loadAllAgents(TRCNode node) {
        Iterator processProxies = node.getProcessProxies().iterator();
        while (processProxies.hasNext()) {
            TRCProcessProxy processProxy = (TRCProcessProxy)processProxies.next();
            if (processProxy == null) continue;
            this.loadAllAgents(processProxy);
        }
    }

    private void loadAllAgents(TRCProcessProxy processProxy) {
        Iterator agents = processProxy.getAgentProxies().iterator();
        while (agents.hasNext()) {
            TRCAgentProxy trcAgent = (TRCAgentProxy)agents.next();
            if (trcAgent == null || trcAgent.eIsProxy() || !trcAgent.getType().equals("Logging")) continue;
            this.agentsList.add(trcAgent);
        }
    }

    class CorrelationJob
    extends Job {
        private ILogRecordCorrelationEngine recordCorrelator;
        private EList recordListToCorrelate;
        private CorrelationContainerProxy container;

        CorrelationJob(String name, ILogRecordCorrelationEngine recordCorrelator, CorrelationContainerProxy container, EList recordListToCorrelate) {
            super(name);
            this.recordCorrelator = recordCorrelator;
            this.container = container;
            this.recordListToCorrelate = recordListToCorrelate;
        }

        protected IStatus run(IProgressMonitor monitor) {
            ProgressMonitorAdapter correlationMonitor = new ProgressMonitorAdapter(monitor);
            this.recordCorrelator.correlate(this.container, this.recordListToCorrelate, correlationMonitor);
            return new Status(0, LogCorrelatorPlugin.getPluginId(), 0, "", null);
        }
    }
}

