/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.util;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.ui.internal.util.ResourceUtil;
import org.eclipse.hyades.ui.internal.util.StringUtil;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class JavaUtil {
    public static void setVariableValue(final String variable, final String value, IProgressMonitor progressMonitor) throws JavaModelException, InterruptedException, InvocationTargetException {
        if (variable == null || value == null) {
            return;
        }
        String currentValue = JavaUtil.getVariableValue(variable);
        if (currentValue != null) {
            if (value.equals(currentValue)) {
                return;
            }
            if (new File(value).equals(new File(currentValue))) {
                return;
            }
        }
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                JavaCore.setClasspathVariable((String)variable, (IPath)new Path(value), (IProgressMonitor)monitor);
            }
        };
        operation.run(progressMonitor);
    }

    public static String getVariableValue(String variable) {
        String value;
        IPath path = JavaCore.getClasspathVariable((String)variable);
        if (path != null && !(value = path.makeAbsolute().toString()).equals("")) {
            return value;
        }
        return null;
    }

    public static void addResourcePatternToNotCopyList(String resourcePattern) {
        String value = JavaCore.getOption((String)"org.eclipse.jdt.core.builder.resourceCopyExclusionFilter");
        if (value == null) {
            value = "";
        }
        if (value.indexOf(resourcePattern) >= 0) {
            return;
        }
        if (!"".equals(value)) {
            value = value + ",";
        }
        value = value + resourcePattern;
        Hashtable<String, String> options = new Hashtable<String, String>(3);
        options.put("org.eclipse.jdt.core.builder.resourceCopyExclusionFilter", value);
        JavaCore.setOptions(options);
    }

    public static void removeResourcePatternToNotCopyList(String resourcePattern) {
        String value = JavaCore.getOption((String)"org.eclipse.jdt.core.builder.resourceCopyExclusionFilter");
        if (value == null) {
            value = "";
        }
        if (value.indexOf(resourcePattern) < 0) {
            return;
        }
        value = StringUtil.replace(value, resourcePattern, "");
        value = StringUtil.replace(value, ",,", "");
        try {
            if (value.startsWith(",")) {
                value = value.substring(",".length());
            }
            if (value.endsWith(",")) {
                value = value.substring(0, value.length() - 1);
            }
        }
        catch (RuntimeException re) {
            // empty catch block
        }
        Hashtable<String, String> options = new Hashtable<String, String>(3);
        options.put("org.eclipse.jdt.core.builder.resourceCopyExclusionFilter", value);
        JavaCore.setOptions(options);
    }

    public static String[] getProjectClasspath(IProject project, boolean exportedOnly) {
        if (project == null) {
            return new String[0];
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null) {
            return new String[0];
        }
        ArrayList<IClasspathEntry> cpEntries = null;
        try {
            cpEntries = new ArrayList<IClasspathEntry>(Arrays.asList(javaProject.getRawClasspath()));
        }
        catch (JavaModelException e) {
            // empty catch block
        }
        if (cpEntries == null || cpEntries.isEmpty()) {
            return new String[0];
        }
        HashSet<String> classpath = new HashSet<String>(cpEntries.size());
        try {
            IPath path = javaProject.getOutputLocation();
            if (path != null) {
                classpath.add(ResourceUtil.getFullPath(path));
            }
        }
        catch (JavaModelException e) {
            // empty catch block
        }
        Iterator i = cpEntries.iterator();
        while (i.hasNext()) {
            IClasspathEntry entry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)((IClasspathEntry)i.next()));
            if (exportedOnly && !entry.isExported()) continue;
            String strcp = null;
            switch (entry.getEntryKind()) {
                case 1: 
                case 4: {
                    strcp = ResourceUtil.getFullPath(entry.getPath());
                    if (strcp == null) break;
                    classpath.add(strcp);
                    break;
                }
                case 2: {
                    IPath projectPath = entry.getPath().makeAbsolute();
                    IProject parentProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectPath.toString());
                    classpath.addAll(Arrays.asList(JavaUtil.getProjectClasspath(parentProject, true)));
                    break;
                }
                case 5: {
                    break;
                }
                case 3: {
                    strcp = ResourceUtil.getFullPath(entry.getOutputLocation());
                    if (strcp == null) break;
                    classpath.add(strcp);
                }
            }
        }
        return classpath.toArray(new String[classpath.size()]);
    }

    public static String getValidClassName(String name, boolean generate) {
        if (name == null) {
            return null;
        }
        name = name.trim();
        if (!generate && JavaConventions.validateIdentifier((String)name).isOK()) {
            return name;
        }
        name = StringUtil.toProperCase(name.trim());
        if (!Character.isLetter((name = StringUtil.replace(name, " ", "")).charAt(0))) {
            name = "C" + name;
        }
        if (!JavaConventions.validateIdentifier((String)name).isOK()) {
            return null;
        }
        return name;
    }

    public static String getValidIdentifierName(String name) {
        String auxName;
        if (name == null) {
            return null;
        }
        if (Character.isLetter((name = name.trim()).charAt(0))) {
            auxName = name.substring(0, 1).toLowerCase();
            if (name.length() > 1) {
                auxName = auxName + name.substring(1);
            }
            name = auxName;
        }
        if (JavaConventions.validateIdentifier((String)name).isOK()) {
            return name;
        }
        name = StringUtil.toProperCase(name.trim());
        if (Character.isLetter((name = StringUtil.replace(name, " ", "")).charAt(0))) {
            auxName = name.substring(0, 1).toLowerCase();
            if (name.length() > 1) {
                auxName = auxName + name.substring(1);
            }
            name = auxName;
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            name = "c" + name;
        }
        if (!JavaConventions.validateIdentifier((String)name).isOK()) {
            StringBuffer sb = new StringBuffer(name);
            int length = name.length();
            int i = 0;
            while (i < length) {
                if (!Character.isJavaIdentifierPart(sb.charAt(i))) {
                    sb.replace(i, i + 1, "_");
                }
                ++i;
            }
            return sb.toString();
        }
        return name;
    }
}

