/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.CoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class UIUtil {
    public static ImageDescriptor getImageDescriptorFromPlugin(IPluginDescriptor pluginDescriptor, String subdirectoryAndFilename) {
        URL path = pluginDescriptor.getInstallURL();
        URL fullPathString = null;
        try {
            fullPathString = new URL(path, subdirectoryAndFilename);
            return ImageDescriptor.createFromURL((URL)fullPathString);
        }
        catch (MalformedURLException e) {
            HyadesUIPlugin.logError(e);
            return null;
        }
    }

    public static boolean fireCurrentSelection(StructuredViewer structuredViewer) {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)structuredViewer, structuredViewer.getSelection());
        try {
            CoreUtil.invokeObjectMethod(structuredViewer, "fireSelectionChanged", new Object[]{event}, true);
        }
        catch (RuntimeException e) {
            HyadesUIPlugin.logError(e);
            return false;
        }
        return true;
    }

    public static int availableRows(Composite parent) {
        int fontHeight = parent.getFont().getFontData()[0].getHeight();
        int displayHeight = parent.getDisplay().getClientArea().height;
        return displayHeight / fontHeight;
    }

    public static IEditorPart getOpenEditor(IFile inputFile) {
        IWorkbenchPage activePage = UIUtil.getActiveWorkbenchPage();
        if (activePage == null) {
            return null;
        }
        IEditorReference[] editorReferences = activePage.getEditorReferences();
        int i = 0;
        int length = editorReferences.length;
        while (i < length) {
            IEditorInput input;
            IEditorPart editorPart = editorReferences[i].getEditor(false);
            if (editorPart != null && (input = editorPart.getEditorInput()) != null && input instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)input).getFile();
                if (file != null && inputFile != null && file.equals((Object)inputFile)) {
                    return editorPart;
                }
                if (file == null && inputFile == null) {
                    return editorPart;
                }
            }
            ++i;
        }
        return null;
    }

    public static IWorkbenchPage getActiveWorkbenchPage() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchPage activePage = null;
        if (workbench.getActiveWorkbenchWindow() != null) {
            activePage = workbench.getActiveWorkbenchWindow().getActivePage();
        } else if (workbench.getWorkbenchWindows().length > 0) {
            activePage = workbench.getWorkbenchWindows()[0].getActivePage();
        }
        return activePage;
    }

    public static IEditorPart openEditor(IFile file, String editorId, boolean substring) {
        block8: {
            if (file == null) {
                return null;
            }
            IWorkbenchPage activePage = UIUtil.getActiveWorkbenchPage();
            if (activePage == null) {
                return null;
            }
            if ("".equals(editorId)) {
                editorId = null;
            }
            try {
                if (editorId == null) {
                    return IDE.openEditor((IWorkbenchPage)activePage, (IFile)file, (boolean)true);
                }
                IWorkbench workbench = PlatformUI.getWorkbench();
                IEditorDescriptor[] editors = workbench.getEditorRegistry().getEditors(file.getName());
                if (editors == null) break block8;
                boolean found = false;
                int i = 0;
                int length = editors.length;
                while (i < length) {
                    found = substring ? editors[i].getId().startsWith(editorId) : editorId.equals(editors[i].getId());
                    if (found) {
                        return activePage.openEditor((IEditorInput)new FileEditorInput(file), editors[i].getId());
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                HyadesUIPlugin.logError(e);
            }
        }
        return null;
    }

    public static void openSaveFileErrorDialog(Shell shell, String filePath, Throwable throwable) {
        if (filePath == null) {
            filePath = "";
        }
        String error = "";
        if (throwable != null) {
            if (throwable.getLocalizedMessage() != null) {
                error = throwable.getLocalizedMessage();
            } else if (throwable.getMessage() != null) {
                error = throwable.getMessage();
            }
        }
        String message = HyadesUIPlugin.getString("_ERROR_SAVING", new String[]{filePath, error});
        MessageDialog.openError((Shell)shell, (String)HyadesUIPlugin.getString("W_ERROR"), (String)message);
    }

    public static Object[] applyFilters(StructuredViewer structuredViewer, Object parent, Object[] elements) {
        if (elements.length == 0) {
            return elements;
        }
        ViewerFilter[] filters = structuredViewer.getFilters();
        int i = 0;
        int maxi = filters.length;
        while (i < maxi) {
            if ((elements = filters[i].filter((Viewer)structuredViewer, parent, elements)).length == 0) {
                return elements;
            }
            ++i;
        }
        return elements;
    }

    public static boolean areEquals(ISelection selection1, ISelection selection2) {
        if (selection1 == selection2) {
            return true;
        }
        if (selection1 instanceof IStructuredSelection && selection2 instanceof IStructuredSelection) {
            ArrayList list1 = new ArrayList(((IStructuredSelection)selection1).toList());
            ArrayList list2 = new ArrayList(((IStructuredSelection)selection2).toList());
            if (list1.size() == list2.size()) {
                list1.removeAll(list2);
                return list1.isEmpty();
            }
        }
        return false;
    }

    public static void integerStyledTextVerifyKey(VerifyEvent event) {
        if (event.doit) {
            switch (event.keyCode) {
                case 0x1000001: 
                case 0x1000002: 
                case 0x1000003: 
                case 0x1000004: 
                case 0x1000007: 
                case 0x1000008: {
                    return;
                }
            }
            switch (event.character) {
                case '\b': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case '\u007f': {
                    return;
                }
            }
            event.doit = false;
            return;
        }
    }
}

