/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.sample.svg.generator;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.hyades.ui.sample.svg.generator.CommonDataRetriever;
import org.eclipse.hyades.ui.sample.svg.generator.DataInputProcessingException;
import org.w3c.dom.Document;

public class PieChartDataRetriever
extends CommonDataRetriever {
    PieChartDataRetriever() {
    }

    public Hashtable getTitles(Document dataDocument) throws DataInputProcessingException {
        if (dataDocument == null) {
            this.throwException((short)114, "");
        }
        Hashtable<String, String> titles = new Hashtable<String, String>(2);
        String label = this.getAttributeFromSingleElement(dataDocument, "dataRange", "label");
        titles.put("valueTitle", label != null ? label : "");
        String summary = this.getAttributeFromSingleElement(dataDocument, "dataUpdate", "summary");
        titles.put("totalTitle", summary != null ? summary : "");
        return titles;
    }

    public String[] getDatasetTotals(Document dataDocument) throws DataInputProcessingException {
        Vector labels;
        if (dataDocument == null) {
            this.throwException((short)114, "");
        }
        if ((labels = this.getAttributeFromElements(dataDocument, "dataSet", "total")) == null) {
            this.throwException((short)122, "dataSet");
        }
        int labelsSize = labels.size();
        for (int i = 0; i < labelsSize; ++i) {
            double j = 0.0;
            try {
                j = Double.parseDouble((String)labels.get(i));
            }
            catch (Exception exc) {
                this.throwException((short)102, "dataSet");
            }
            if (!(j < 0.0)) continue;
            this.throwException((short)102, "segmentMarker");
        }
        String[] result = new String[labelsSize];
        Vector positions = this.getAttributeFromElements(dataDocument, "dataSet", "position");
        if (positions == null) {
            for (int i = 0; i < labelsSize; ++i) {
                result[i] = (String)labels.get(i);
            }
            return result;
        }
        if (positions.size() != labelsSize) {
            this.throwException((short)111, "dataSet");
        }
        for (int i = 0; i < labelsSize; ++i) {
            short position = 0;
            try {
                position = Short.parseShort((String)positions.get(i));
            }
            catch (Exception exc) {
                this.throwException((short)102, "dataSet");
            }
            if (position > labelsSize - 1 || position < 0) {
                this.throwException((short)125, "dataSet");
            }
            String test = null;
            try {
                test = result[position];
            }
            catch (Exception e) {
                // empty catch block
            }
            if (test != null) {
                this.throwException((short)101, "dataSet");
            }
            result[position] = (String)labels.get(i);
        }
        return result;
    }
}

