/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.sample.svg.generator;

import java.io.Serializable;
import org.eclipse.hyades.ui.sample.svg.generator.DataSet;
import org.eclipse.hyades.ui.sample.svg.generator.ECMAScriptGenerator;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicAttributes;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicDocumentGenerator;
import org.eclipse.hyades.ui.sample.svg.generator.IGraphicDocumentDefaults;
import org.eclipse.hyades.ui.sample.svg.generator.IGraphicDocumentStyle;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public abstract class SVGDocumentGenerator
extends GraphicDocumentGenerator
implements IGraphicDocumentStyle,
IGraphicDocumentDefaults,
Serializable {
    static final String SVG_VERSION = "-//W3C//DTD SVG 1.0//EN";
    static final String SVG_DTD = "http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd";
    static final String SVG_XMLNS = "http://www.w3.org/1999/xlink";
    static final String JAVASCRIPT_VERSION = "text/ecmascript";
    protected final int TITLE_FONTSIZE_DELTA = 3;
    protected final int LABEL_FONTSIZE_DELTA = 2;

    protected Element addDefinitions(Document generatedDocument, GraphicAttributes attrs) {
        Element parent = generatedDocument.getDocumentElement();
        Element defsElement = generatedDocument.createElement("defs");
        parent.appendChild(defsElement);
        if (!attrs.isUserPreferencesSuppressed()) {
            this.definePreferenceIcon(generatedDocument, defsElement);
        }
        if (!attrs.isLegendSuppressed()) {
            this.defineLegendGraphic(generatedDocument, defsElement);
        }
        return defsElement;
    }

    protected void addOutline(Document generatedDocument, GraphicAttributes attrs) {
        Element parent = generatedDocument.getDocumentElement();
        boolean offset = true;
        Element newElement = generatedDocument.createElement("rect");
        newElement.setAttribute("class", "st1, outline");
        newElement.setAttribute("width", Integer.toString(attrs.getGraphicWidth() - 1));
        newElement.setAttribute("height", Integer.toString(attrs.getGraphicHeight() - 1));
        parent.appendChild(newElement);
    }

    protected void addTitleBar(Document generatedDocument, GraphicAttributes attrs) {
        Element parent = generatedDocument.getDocumentElement();
        boolean titleBarLineAdded = false;
        int yValue = 28;
        if (attrs.getGraphicTitle() != null) {
            this.addTitle(generatedDocument, attrs, parent);
            if (!titleBarLineAdded) {
                this.addTitleBarLine(generatedDocument, attrs, parent, 28);
                titleBarLineAdded = true;
            }
        }
    }

    protected void addPreferenceIcon(Document generatedDocument, GraphicAttributes attrs) {
        Element parent = generatedDocument.getDocumentElement();
        if (!attrs.isUserPreferencesSuppressed() && attrs.getSvgFormatOnly()) {
            this.addPreferenceIcon(generatedDocument, attrs, parent);
        }
    }

    protected void addTimeStamp(Document generatedDocument, GraphicAttributes attrs, String timestamp) {
        if (timestamp == null) {
            return;
        }
        Element parent = generatedDocument.getDocumentElement();
        Element gElement = generatedDocument.createElement("g");
        String prefix = attrs.getGraphicTimestampPrefix();
        if (prefix != null) {
            timestamp = prefix + " " + timestamp;
        }
        gElement.setAttribute("id", "timeStamp");
        gElement.setAttribute("class", "timeStamp");
        this.addLabel(generatedDocument, attrs, gElement, timestamp, null, attrs.getGraphicWidth() - 5, attrs.getGraphicHeight() - 8, 0);
        parent.appendChild(gElement);
    }

    protected void addLegend(Document generatedDocument, GraphicAttributes attrs, Element gTextBoxElement, String[] labels, String[] flyOverLabels, int xOffset, int yOffset) {
        Element gElement;
        Element parent = generatedDocument.getDocumentElement();
        int numberOfLabels = labels.length;
        int legendTitleFontSize = 10;
        int legendLabelFontSize = 9;
        int shapeWidth = 11;
        int legendMargin = 15;
        int legendLabelMargin = shapeWidth + 6;
        int delta = 16;
        int rotation = 0;
        int x = xOffset + legendMargin;
        int y = yOffset + legendTitleFontSize;
        int legendLabelStartY = yOffset - legendLabelFontSize + 8;
        String title = attrs.getGraphicLegendTitle();
        if (title != null) {
            gElement = generatedDocument.createElement("g");
            gElement.setAttribute("id", "legendTitle");
            gElement.setAttribute("class", "legendTitle");
            parent.appendChild(gElement);
            this.addLabel(generatedDocument, attrs, gElement, title, null, x, y, rotation);
            legendLabelStartY = yOffset + legendTitleFontSize + 7;
        }
        gElement = generatedDocument.createElement("g");
        gElement.setAttribute("id", "legendData");
        gElement.setAttribute("class", "legendData");
        parent.appendChild(gElement);
        int yPrevious = legendLabelStartY;
        for (int i = 0; i < numberOfLabels; ++i) {
            Element gColourElement = this.addLegendItemGraphic(generatedDocument, parent, i, legendLabelFontSize, x, yPrevious);
            if (this.graphicType.equals("line") || this.graphicType.equals("area") || this.graphicType.equals("scatter")) {
                parent.appendChild(gColourElement);
            }
            this.addHoverText(generatedDocument, attrs, i, gTextBoxElement, labels[i], flyOverLabels[i], x + legendLabelMargin, (yPrevious += delta) - 7, rotation);
        }
    }

    protected Element addLegendItemGraphic(Document generatedDocument, Element parent, int index, int fontSize, int x, int y) {
        Element newElement = generatedDocument.createElement("use");
        newElement.setAttribute("xlink:href", "#legendsquareshapeWithoutLine");
        newElement.setAttribute("x", Integer.toString(x));
        newElement.setAttribute("y", Integer.toString(y + fontSize - 9));
        Element gColourElement = generatedDocument.createElement("g");
        gColourElement.setAttribute("id", "legendsquareshapeWithoutLine" + index);
        gColourElement.setAttribute("class", "shape" + index);
        if (this.graphicType.equals("line") || this.graphicType.equals("area") || this.graphicType.equals("scatter")) {
            gColourElement.setAttribute("onclick", "toggleVisibility('dataColour" + index + "');");
            if (this.graphicType.equals("scatter")) {
                String[] flyOverShapeType = new String[]{"flyoverCircleshape", "flyoverSquareshape", "flyoverHorizontalrectshape", "flyoverVerticalrectshape", "flyoverTriangleshape", "flyoverDiamondshape"};
                gColourElement.setAttribute("onmouseover", "setVisibility('" + flyOverShapeType[index % flyOverShapeType.length] + "' , 'visible');");
                gColourElement.setAttribute("onmouseout", "setVisibility('" + flyOverShapeType[index % flyOverShapeType.length] + "' , 'hidden');");
            }
        }
        gColourElement.appendChild(newElement);
        parent.appendChild(gColourElement);
        return gColourElement;
    }

    protected void addJavaScriptFunctions(Document generatedDocument, GraphicAttributes attrs, int numberOfDataSets, int gridXOffset, int gridYOffset, int xAxisLength, int yAxisLength) {
        boolean hasLegend = !attrs.isLegendSuppressed();
        String cookieName = attrs.getBrowserCookieName();
        Element parent = generatedDocument.getDocumentElement();
        Element newElement = generatedDocument.createElement("script");
        newElement.setAttribute("type", JAVASCRIPT_VERSION);
        parent.appendChild(newElement);
        ECMAScriptGenerator jscript = new ECMAScriptGenerator();
        StringBuffer functions = new StringBuffer(jscript.generateGlobalVariables());
        if (attrs.getSvgFormatOnly()) {
            functions.append(jscript.generateClientSnifferVariables());
        } else {
            functions.append(jscript.generateNullClientSnifferVariables());
        }
        if (cookieName != null) {
            functions.append(jscript.generateCookieFunctions());
            functions.append(jscript.generateStorePreferencesFunction(cookieName));
            functions.append(jscript.generateGetPreferencesFunction(cookieName));
        }
        functions.append(jscript.generateInitFunction(attrs.getUserPreferences(), attrs.getGraphicColorPalette(), attrs.getGraphicColorPaletteName(), attrs.getGraphicFont(), cookieName, this.graphicType, numberOfDataSets, gridXOffset, gridYOffset, xAxisLength, yAxisLength));
        functions.append(jscript.generateToggleVisibilityFunction(numberOfDataSets, this.graphicType));
        functions.append(jscript.generateUpdateStylesFunction(numberOfDataSets, cookieName, this.graphicType, hasLegend, attrs.getUserPreferencesUpdateVariableName(), gridXOffset, gridYOffset, xAxisLength, yAxisLength));
        if (hasLegend) {
            functions.append(jscript.generateUpdateLegendStylesFunction(numberOfDataSets, this.graphicType));
            functions.append(jscript.generateFunctionFlyOver());
        }
        functions.append(jscript.generateFunctionPrefFlyOver());
        functions.append(jscript.generateGetCurrentValuesFunction());
        functions.append(jscript.generateGetUserPreferencesFunction());
        functions.append(jscript.generateResetStylesFunction());
        functions.append(jscript.generateGetPalettesFunction());
        functions.append(jscript.generateChangeOpacity());
        String preferencesPage = attrs.getPreferencesPage();
        if (preferencesPage != null) {
            functions.append(jscript.generateOpenPreferencePageFunction(attrs.getResourcesFolder(), preferencesPage, this.graphicType, attrs.getPreferencesPageWidth(), attrs.getPreferencesPageHeight()));
            if (preferencesPage.indexOf("prefs_") == 0) {
                functions.append(jscript.generateUseNetscapePreferencePage(attrs.getResourcesFolder(), preferencesPage, this.graphicType, attrs.getPreferencesPageWidth(), attrs.getPreferencesPageHeight()));
            }
        }
        functions.append(jscript.generateInspectFunction());
        CDATASection newCDATASection = generatedDocument.createCDATASection(functions.toString());
        newElement.appendChild(newCDATASection);
    }

    protected Element addLabel(Document generatedDocument, GraphicAttributes attrs, Element parent, String title, String stylesheetClass, double x, double y, int rotation) {
        Element newElement = this.createDOMTextElement(generatedDocument, attrs.getGraphicFont(), title, stylesheetClass, Double.toString(x), Double.toString(y), rotation);
        parent.appendChild(newElement);
        return newElement;
    }

    protected Element createDOMTextElement(Document generatedDocument, String font, String text, String styleClass, String x, String y, int rotation) {
        Element newElement = generatedDocument.createElement("text");
        if (styleClass != null) {
            newElement.setAttribute("class", styleClass);
        }
        newElement.setAttribute("font", font);
        newElement.setAttribute("x", x);
        newElement.setAttribute("y", y);
        if (rotation > 0 && rotation < 360) {
            newElement.setAttribute("transform", "rotate(" + rotation + "," + x + "," + y + ")");
        }
        newElement.appendChild(generatedDocument.createTextNode(text));
        return newElement;
    }

    protected Document createSvgDocument(DOMImplementation dImplement, String width, String height) {
        DocumentType dType = dImplement.createDocumentType("svg", SVG_VERSION, SVG_DTD);
        Document svgDocument = dImplement.createDocument(null, "svg", dType);
        Element svgRoot = svgDocument.getDocumentElement();
        svgRoot.setAttribute("xmlns:xlink", SVG_XMLNS);
        svgRoot.setAttribute("width", width);
        svgRoot.setAttribute("height", height);
        svgRoot.setAttribute("viewbox", "0 0 " + (Integer.parseInt(width) - 1) + " " + (Integer.parseInt(height) - 1));
        return svgDocument;
    }

    protected void defineLegendGraphic(Document generatedDocument, Element defs) {
        Element gElement_legendsquareWithoutLine = generatedDocument.createElement("g");
        Element legendsquareElementWithoutLine = generatedDocument.createElement("rect");
        gElement_legendsquareWithoutLine.setAttribute("id", "legendsquareshapeWithoutLine");
        defs.appendChild(gElement_legendsquareWithoutLine);
        legendsquareElementWithoutLine.setAttribute("width", "8");
        legendsquareElementWithoutLine.setAttribute("height", "8");
        legendsquareElementWithoutLine.setAttribute("transform", "translate(3,2)");
        gElement_legendsquareWithoutLine.appendChild(legendsquareElementWithoutLine);
    }

    protected void definePreferenceIcon(Document generatedDocument, Element defs) {
        Element gElement_preferences = generatedDocument.createElement("g");
        Element gElement = generatedDocument.createElement("g");
        Element newElement = generatedDocument.createElement("path");
        gElement_preferences.setAttribute("id", "preferences");
        defs.appendChild(gElement_preferences);
        gElement.setAttribute("id", "graph");
        gElement.setAttribute("style", "fill-rule:nonzero;clip-rule:nonzero;fill:none;stroke:#999999;stroke-miterlimit:4;");
        gElement_preferences.appendChild(gElement);
        newElement.setAttribute("d", "M2.042,4.811H0.5v18h21v-6.542");
        gElement.appendChild(newElement);
        newElement = generatedDocument.createElement("path");
        newElement.setAttribute("d", "M2.042,4.811H0.5");
        gElement.appendChild(newElement);
        newElement = generatedDocument.createElement("path");
        newElement.setAttribute("d", "M2.042,10.801H0.5");
        gElement.appendChild(newElement);
        newElement = generatedDocument.createElement("path");
        newElement.setAttribute("d", "M2.042,16.8H0.5");
        gElement.appendChild(newElement);
        newElement = generatedDocument.createElement("path");
        newElement.setAttribute("d", "M6.51,22.81v-18H3.521v18H6.51z");
        newElement.setAttribute("style", "fill:#000099;");
        gElement.appendChild(newElement);
        newElement = generatedDocument.createElement("path");
        newElement.setAttribute("d", "M12.51,22.81v-11H9.521v11h2.989z");
        newElement.setAttribute("style", "fill:#0066CC;");
        gElement.appendChild(newElement);
        newElement = generatedDocument.createElement("path");
        newElement.setAttribute("d", "M18.51,22.81v-5h-2.989v5h2.989z");
        newElement.setAttribute("style", "fill:#99CCFF;");
        gElement.appendChild(newElement);
        newElement = generatedDocument.createElement("path");
        newElement.setAttribute("d", "M21.532,7.842l-5.145-5.248c-1.295,1.295-2.096,3.083-2.096,5.06c0,3.953,3.286,7.156,7.238,7.156l0.002-6.968z");
        newElement.setAttribute("style", "fill:#0066CC;");
        gElement.appendChild(newElement);
        newElement = generatedDocument.createElement("path");
        newElement.setAttribute("d", "M21.557,14.81c3.952,0,7.047-3.11,7.047-7.063h-7.047v7.063z");
        newElement.setAttribute("style", "fill:#0066CC;");
        gElement.appendChild(newElement);
        newElement = generatedDocument.createElement("path");
        newElement.setAttribute("d", "M28.604,7.654c0-3.953-3.204-7.156-7.156-7.156c-1.977,0-3.766,0.801-5.061,2.097l5.092,5.278h7.125");
        newElement.setAttribute("style", "fill:#99CCFF;");
        gElement.appendChild(newElement);
    }

    protected void registerEventHandler(Element target, String event, String script) {
        if (target != null) {
            target.setAttribute(event, script);
        }
    }

    private void addTitleBarLine(Document generatedDocument, GraphicAttributes attrs, Element parent, int yValue) {
        StringBuffer points = new StringBuffer();
        Element newElement = generatedDocument.createElement("polyline");
        newElement.setAttribute("class", "st1, keyline");
        points.append("0 ");
        points.append(yValue);
        points.append(" ");
        points.append(attrs.getGraphicWidth() - 1);
        points.append(" ");
        points.append(yValue);
        newElement.setAttribute("points", points.toString());
        parent.appendChild(newElement);
    }

    private void addPreferenceIcon(Document generatedDocument, GraphicAttributes attrs, Element parent) {
        int iconXOffset = attrs.getGraphicWidth() - 33;
        int iconYOffset = 2;
        Element newElement = generatedDocument.createElement("use");
        newElement.setAttribute("xlink:href", "#preferences");
        newElement.setAttribute("x", Integer.toString(iconXOffset));
        newElement.setAttribute("y", Integer.toString(2));
        newElement.setAttribute("id", "preferencesIconHoverBox");
        this.registerEventHandler(newElement, "onclick", "openPreferencePage()");
        String preferencesIconText = attrs.getPreferencesIconText();
        if (preferencesIconText != null) {
            newElement.setAttribute("onmouseover", "PrefFlyOver();");
            newElement.setAttribute("onmouseout", "PrefFlyOut();");
        }
        parent.appendChild(newElement);
        if (preferencesIconText != null) {
            Element gElement = generatedDocument.createElement("g");
            gElement.setAttribute("id", "preferencesHoverText");
            gElement.setAttribute("pointer-events", "none");
            newElement = generatedDocument.createElement("rect");
            newElement.setAttribute("id", "hoverBox");
            newElement.setAttribute("width", "1");
            newElement.setAttribute("height", "1");
            newElement.setAttribute("fill", "#FFFFCC");
            newElement.setAttribute("stroke", "black");
            newElement.setAttribute("stroke-width", "1");
            gElement.appendChild(newElement);
            newElement = generatedDocument.createElement("text");
            newElement.setAttribute("id", "hoverBoxText");
            newElement.setAttribute("x", Integer.toString(iconXOffset + 15));
            newElement.setAttribute("y", Integer.toString(32));
            newElement.setAttribute("class", "timeStamp");
            newElement.setAttribute("visibility", "hidden");
            newElement.appendChild(generatedDocument.createTextNode(preferencesIconText));
            gElement.appendChild(newElement);
            parent.appendChild(gElement);
        }
    }

    private void addTitle(Document generatedDocument, GraphicAttributes attrs, Element parent) {
        int fontSize = 11;
        String title = attrs.getGraphicTitle();
        if (title != null) {
            String stylesheetClass = "graphTitle anchorAtStart";
            Element gElement = generatedDocument.createElement("g");
            gElement.setAttribute("id", "graphTitle");
            gElement.setAttribute("class", stylesheetClass);
            parent.appendChild(gElement);
            this.addLabel(generatedDocument, attrs, gElement, title, null, 10.0, fontSize + 8, 0);
        }
    }

    protected Element addHoverText(Document generatedDocument, GraphicAttributes attrs, int index, Element parent, String title, String flyOverText, double x, double y, int rotation) {
        Element newElement = this.createDOMTextElement(generatedDocument, attrs.getGraphicFont(), title, null, Double.toString(x), Double.toString(y), rotation);
        int xValue = attrs.getGraphicWidth() - 15;
        newElement.setAttribute("id", "legent" + index);
        newElement.setAttribute("onmouseover", "FlyOver(" + index + ");");
        newElement.setAttribute("onmouseout", "FlyOut(" + index + ");");
        parent.appendChild(newElement);
        if (flyOverText != null) {
            Element gElement = generatedDocument.createElement("g");
            gElement.setAttribute("id", "flyOverGroup" + index);
            gElement.setAttribute("pointer-events", "none");
            newElement = generatedDocument.createElement("rect");
            newElement.setAttribute("id", "flyOverBox" + index);
            newElement.setAttribute("width", "1");
            newElement.setAttribute("height", "1");
            newElement.setAttribute("fill", "#FFFFCC");
            newElement.setAttribute("stroke", "gray");
            newElement.setAttribute("stroke-width", "1");
            gElement.appendChild(newElement);
            newElement = generatedDocument.createElement("text");
            newElement.setAttribute("id", "flyOverText" + index);
            newElement.setAttribute("x", Double.toString(xValue));
            newElement.setAttribute("y", Double.toString(y));
            newElement.setAttribute("class", "dataValues anchorAtEnd");
            newElement.setAttribute("visibility", "hidden");
            newElement.appendChild(generatedDocument.createTextNode(flyOverText));
            gElement.appendChild(newElement);
            parent.appendChild(gElement);
        }
        return newElement;
    }

    public String[] getLegendFlyOverLabels(DataSet[] dataSets) {
        String[] legendFlyOverLabels = null;
        legendFlyOverLabels = new String[dataSets.length];
        for (int i = 0; i < dataSets.length; ++i) {
            legendFlyOverLabels[i] = dataSets[i].getFlyoverLabel();
            if (legendFlyOverLabels[i] != null) continue;
            legendFlyOverLabels[i] = "";
        }
        return legendFlyOverLabels;
    }

    protected double getMaxLengthOfLegendLabel(GraphicAttributes graphicAttrs, DataSet[] dataSets) {
        int maxLengthOfLegendLable = 0;
        String legendTitle = graphicAttrs.getGraphicLegendTitle();
        if (legendTitle != null && (maxLengthOfLegendLable = legendTitle.length() - 2) < 0) {
            maxLengthOfLegendLable = 0;
        }
        for (int i = 0; i < dataSets.length; ++i) {
            int length;
            DataSet dataset = dataSets[i];
            String label = dataset.getLabel();
            if (label == null || maxLengthOfLegendLable >= (length = label.length())) continue;
            maxLengthOfLegendLable = length;
        }
        return 16.0 + (double)maxLengthOfLegendLable * 7.0;
    }
}

