/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.adapter.internal;

import java.util.Enumeration;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.views.adapter.internal.SinglePatternPage;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.GraphColorDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.part.IPage;

public class SinglePatternViewer
extends TraceViewer {
    protected Action _next;
    protected Action _previous;
    protected Action _update;
    protected Action _caller;
    protected Action _callee;
    protected Action _openSource;
    protected Action _showRawTime;
    private Action _zoomInAction;
    private Action _zoomOutAction;
    private Action _stdSelectAction;
    protected Action _showCompensatedTime;
    private boolean _stdSelect = true;
    private boolean _zoomIn = false;
    private boolean _zoomOut = false;

    public Action callee() {
        return this._callee;
    }

    public Action caller() {
        return this._caller;
    }

    public TraceViewerPage createPage(EObject mofObject) {
        return new SinglePatternPage(mofObject, this);
    }

    public void dispose() {
        Enumeration pages = this._pages.elements();
        while (pages.hasMoreElements()) {
            IPage page = (IPage)pages.nextElement();
            if (!(page instanceof SinglePatternPage)) continue;
            ((SinglePatternPage)page).dispose();
        }
        this._openSource = null;
        this._showCompensatedTime = null;
        this._showRawTime = null;
        this._stdSelectAction = null;
        this._zoomInAction = null;
        this._zoomOutAction = null;
        this._previous = null;
        this._next = null;
        this._callee = null;
        this._caller = null;
        super.dispose();
    }

    public void makeActions() {
        if (this.isInitializedMenu()) {
            return;
        }
        this.initializedMenu(true);
        String compTime = TraceUIPlugin.getString("STR_COMPENSATED_TIME");
        this._showCompensatedTime = new Action(compTime){

            public void run() {
                TraceUIPlugin.getDefault().getPreferenceStore().setValue("time_display", 0);
                TraceUIPlugin.getDefault().notifyTimeChangedEventListener();
            }
        };
        this._showCompensatedTime.setText(compTime);
        this._showCompensatedTime.setDescription(compTime);
        this._showCompensatedTime.setToolTipText(compTime);
        int ref = TraceUIPlugin.getDefault().getPreferenceStore().getInt("time_display");
        this._showCompensatedTime.setChecked(ref == 0);
        String rawTime = TraceUIPlugin.getString("STR_RAW_TIME");
        this._showRawTime = new Action(rawTime){

            public void run() {
                TraceUIPlugin.getDefault().getPreferenceStore().setValue("time_display", 1);
                TraceUIPlugin.getDefault().notifyTimeChangedEventListener();
            }
        };
        this._showRawTime.setText(rawTime);
        this._showRawTime.setDescription(rawTime);
        this._showRawTime.setToolTipText(rawTime);
        ref = TraceUIPlugin.getDefault().getPreferenceStore().getInt("time_display");
        this._showRawTime.setChecked(ref == 1);
        String strPrev = TraceUIPlugin.getString("STR_PREVIOUS");
        this._previous = new Action(strPrev){

            public void run() {
                SinglePatternPage page = (SinglePatternPage)SinglePatternViewer.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                page.getView().previous();
            }
        };
        this._previous.setText(strPrev);
        TracePluginImages.setImageDescriptors((IAction)this._previous, "lcl16", "prev_nav.gif");
        this._previous.setDescription(strPrev);
        this._previous.setToolTipText(TraceUIPlugin.getString("STR_PREV_TEXT"));
        String strNext = TraceUIPlugin.getString("STR_NEXT");
        this._next = new Action(strNext){

            public void run() {
                SinglePatternPage page = (SinglePatternPage)SinglePatternViewer.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                page.getView().next();
            }
        };
        this._next.setText(strNext);
        TracePluginImages.setImageDescriptors((IAction)this._next, "lcl16", "next_nav.gif");
        this._next.setDescription(strNext);
        this._next.setToolTipText(TraceUIPlugin.getString("STR_NEXT_TEXT"));
        String strHome = TraceUIPlugin.getString("STR_HOME");
        this._update = new Action(strHome){

            public void run() {
                SinglePatternPage page = (SinglePatternPage)SinglePatternViewer.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                page.getView().updateUI();
                page.getView().updateButtons();
            }
        };
        this._update.setText(strHome);
        TracePluginImages.setImageDescriptors((IAction)this._update, "tool16", "home_nav.gif");
        this._update.setDescription(strHome);
        this._update.setToolTipText(strHome);
        String strStdSelect = TraceUIPlugin.getString("STR_STD_SELECT");
        this._stdSelectAction = new Action(strStdSelect){

            public void run() {
                SinglePatternPage page = (SinglePatternPage)SinglePatternViewer.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                SinglePatternViewer.this._stdSelect = true;
                SinglePatternViewer.this._zoomIn = !SinglePatternViewer.this._stdSelect;
                SinglePatternViewer.this._zoomOut = !SinglePatternViewer.this._stdSelect;
                SinglePatternViewer.this._stdSelectAction.setChecked(true);
                SinglePatternViewer.this._zoomInAction.setChecked(false);
                SinglePatternViewer.this._zoomOutAction.setChecked(false);
                page.getView().zoomIn(SinglePatternViewer.this._zoomIn);
                page.getView().zoomOut(SinglePatternViewer.this._zoomOut);
            }

            public int getStyle() {
                return 2;
            }
        };
        this._stdSelectAction.setText(strStdSelect);
        TracePluginImages.setImageDescriptors((IAction)this._stdSelectAction, "lcl16", "select_zoomin.gif");
        this._stdSelectAction.setDescription(strStdSelect);
        this._stdSelectAction.setToolTipText(strStdSelect);
        String strZoomIn = TraceUIPlugin.getString("STR_ZOOM_IN");
        this._zoomInAction = new Action(strZoomIn){

            public void run() {
                SinglePatternPage page = (SinglePatternPage)SinglePatternViewer.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                SinglePatternViewer.this._zoomIn = this.isChecked();
                if (!SinglePatternViewer.this._zoomIn) {
                    SinglePatternViewer.this._stdSelect = true;
                } else {
                    SinglePatternViewer.this._stdSelect = !SinglePatternViewer.this._zoomIn;
                    SinglePatternViewer.this._zoomOut = !SinglePatternViewer.this._zoomIn;
                }
                if (SinglePatternViewer.this._zoomIn) {
                    SinglePatternViewer.this._stdSelectAction.setChecked(false);
                    SinglePatternViewer.this._zoomOutAction.setChecked(false);
                } else {
                    SinglePatternViewer.this._stdSelectAction.setChecked(true);
                }
                page.getView().zoomIn(SinglePatternViewer.this._zoomIn);
            }

            public int getStyle() {
                return 2;
            }
        };
        this._zoomInAction.setText(strZoomIn);
        TracePluginImages.setImageDescriptors((IAction)this._zoomInAction, "lcl16", "zoomin_nav.gif");
        this._zoomInAction.setDescription(strZoomIn);
        this._zoomInAction.setToolTipText(strZoomIn);
        String strZoomOut = TraceUIPlugin.getString("STR_ZOOM_OUT");
        this._zoomOutAction = new Action(strZoomOut){

            public void run() {
                SinglePatternPage page = (SinglePatternPage)SinglePatternViewer.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                SinglePatternViewer.this._zoomOut = this.isChecked();
                if (!SinglePatternViewer.this._zoomOut) {
                    SinglePatternViewer.this._stdSelect = true;
                } else {
                    SinglePatternViewer.this._stdSelect = !SinglePatternViewer.this._zoomOut;
                    SinglePatternViewer.this._zoomIn = !SinglePatternViewer.this._zoomOut;
                }
                if (SinglePatternViewer.this._zoomOut) {
                    SinglePatternViewer.this._stdSelectAction.setChecked(false);
                    SinglePatternViewer.this._zoomInAction.setChecked(false);
                } else {
                    SinglePatternViewer.this._stdSelectAction.setChecked(true);
                }
                page.getView().zoomOut(SinglePatternViewer.this._zoomOut);
            }

            public int getStyle() {
                return 2;
            }
        };
        this._zoomOutAction.setText(strZoomOut);
        TracePluginImages.setImageDescriptors((IAction)this._zoomOutAction, "lcl16", "zoomout_nav.gif");
        this._zoomOutAction.setDescription(strZoomOut);
        this._zoomOutAction.setToolTipText(strZoomOut);
        String strCaller = TraceUIPlugin.getString("STR_CALLER");
        this._caller = new Action(strCaller){

            public void run() {
                SinglePatternPage page = (SinglePatternPage)SinglePatternViewer.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                page.getView().showCaller();
            }
        };
        this._caller.setText(strCaller);
        TracePluginImages.setImageDescriptors((IAction)this._caller, "lcl16", "showcaller_co.gif");
        this._caller.setDescription(strCaller);
        this._caller.setToolTipText(strCaller);
        String strCalee = TraceUIPlugin.getString("STR_CALLEE");
        this._callee = new Action(strCalee){

            public void run() {
                SinglePatternPage page = (SinglePatternPage)SinglePatternViewer.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                page.getView().showCallee();
            }
        };
        this._callee.setText(strCalee);
        TracePluginImages.setImageDescriptors((IAction)this._callee, "lcl16", "caller_co.gif");
        this._callee.setDescription(strCalee);
        this._callee.setToolTipText(strCalee);
        String openSourceStr = TraceUIPlugin.getString("STR_SOURCE");
        this._openSource = new Action(openSourceStr){

            public void run() {
                SinglePatternPage page = (SinglePatternPage)SinglePatternViewer.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                page.getView().openSource();
            }
        };
        this._openSource.setText(openSourceStr);
        TracePluginImages.setImageDescriptors((IAction)this._openSource, "tool16", "opensource_co.gif");
        this._openSource.setDescription(openSourceStr);
        this._openSource.setToolTipText(openSourceStr);
        Action openColorDialog = new Action(TraceUIPlugin.getString("OPEN_COLOR_DLG_TEXT")){

            public void run() {
                GraphColorDialog dialog = new GraphColorDialog(SinglePatternViewer.this.getViewSite().getShell(), TraceUIPlugin.getString("STR_GRAPH_COLOR_DLG"), null);
                dialog.open();
            }
        };
        openColorDialog.setText(TraceUIPlugin.getString("OPEN_COLOR_DLG_TEXT"));
        TracePluginImages.setImageDescriptors((IAction)openColorDialog, "tool16", "opengraphcolor_co.gif");
        openColorDialog.setDescription(TraceUIPlugin.getString("OPEN_COLOR_DLG_TEXT"));
        openColorDialog.setToolTipText(TraceUIPlugin.getString("OPEN_COLOR_DLG_TEXT"));
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        IMenuManager menu = this.getViewSite().getActionBars().getMenuManager();
        MenuManager submenu = new MenuManager(TraceUIPlugin.getString("STR_SHOW_TIME"));
        menu.add((IContributionItem)submenu);
        submenu.add((IAction)this._showCompensatedTime);
        submenu.add((IAction)this._showRawTime);
        tbm.removeAll();
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this._openSource);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this._caller);
        tbm.add((IAction)this._callee);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this._previous);
        tbm.add((IAction)this._next);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this._stdSelectAction);
        tbm.add((IAction)this._zoomInAction);
        tbm.add((IAction)this._zoomOutAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this._update);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)openColorDialog);
        this.getViewSite().getActionBars().updateActionBars();
    }

    public Action next() {
        return this._next;
    }

    public Action openSource() {
        return this._openSource;
    }

    public Action previous() {
        return this._previous;
    }

    public void setFocus() {
        if (this.getCurrentPage() != null) {
            ((SinglePatternPage)this.getCurrentPage()).setFocus();
        }
    }

    public Action updateBtn() {
        return this._update;
    }

    public Action baseTime() {
        return this._showCompensatedTime;
    }

    public Action rawTime() {
        return this._showRawTime;
    }

    public boolean isValidObject(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof TRCMonitor || object instanceof TRCNode) {
            return true;
        }
        if (object instanceof TRCAgentProxy && ((TRCAgentProxy)object).getType().equals("Profiler")) {
            return true;
        }
        if (object instanceof TRCProcessProxy) {
            EList agents = ((TRCProcessProxy)object).getAgentProxies();
            for (int idx = 0; idx < agents.size(); ++idx) {
                TRCAgentProxy agent = (TRCAgentProxy)agents.get(idx);
                if (agent == null || agent.eIsProxy() || !agent.getType().equals("Profiler")) continue;
                return true;
            }
        }
        return false;
    }

    public EObject getObjectToView(EObject selObject) {
        if (selObject == null) {
            return selObject;
        }
        if (selObject instanceof TRCProcessProxy) {
            int nbOfAgents = 0;
            TRCAgentProxy a = null;
            EList agents = ((TRCProcessProxy)selObject).getAgentProxies();
            for (int idx = 0; idx < agents.size(); ++idx) {
                TRCAgentProxy agent = (TRCAgentProxy)agents.get(idx);
                if (agent == null || agent.eIsProxy() || !agent.getType().equals("Profiler")) continue;
                ++nbOfAgents;
                a = agent;
            }
            if (nbOfAgents == 1) {
                return a;
            }
        }
        return selObject;
    }

    public String getViewTitle() {
        return TraceUIPlugin.getString("STR_METH_INVOC_TITLE");
    }

    public void initializeActionBar() {
        this._stdSelectAction.setChecked(true);
    }
}

